/*----------------------------------------------------------------------------/
/ TJpgDec - Tiny JPEG Decompressor R0.03 include file         (C)ChaN, 2021
/----------------------------------------------------------------------------*/
#ifndef DEF_TJPGDEC
#define DEF_TJPGDEC

#ifdef __cplusplus
extern "C" {
#endif

#include "tjpgdcnf.h"
#include <string.h>

#if defined(_WIN32) /* VC++ or some compiler without stdint.h */
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef short int16_t;
typedef unsigned long uint32_t;
typedef long int32_t;
#else /* Embedded platform */
#include <stdint.h>
#endif

struct JDEC;

#if JD_FASTDECODE >= 1
typedef int16_t jd_yuv_t;
#else
typedef uint8_t jd_yuv_t;
#endif

/* Error code */
typedef enum {
  JDR_OK = 0, /* 0: Succeeded */
  JDR_INTR,   /* 1: Interrupted by output function */
  JDR_INP,    /* 2: Device error or wrong termination of input stream */
  JDR_MEM1,   /* 3: Insufficient memory pool for the image */
  JDR_MEM2,   /* 4: Insufficient stream input buffer */
  JDR_PAR,    /* 5: Parameter error */
  JDR_FMT1,   /* 6: Data format error (may be broken data) */
  JDR_FMT2,   /* 7: Right format but not supported */
  JDR_FMT3    /* 8: Not supported JPEG standard */
} JRESULT;

/**
 * @struct JRECT
 * @brief Rectangular region in the output image.
 */
typedef struct {
  uint16_t left;   /**< Left end of the rectangle */
  uint16_t right;  /**< Right end of the rectangle */
  uint16_t top;    /**< Top end of the rectangle */
  uint16_t bottom; /**< Bottom end of the rectangle */
} JRECT;

/**
 * @struct JDEC
 * @brief Decompressor object structure.
 *
 * This structure holds all the state information for the JPEG decompression
 * process.
 */
typedef struct JDEC {
  size_t dctr;     /**< Number of bytes available in the input buffer */
  uint8_t *dptr;   /**< Current data read pointer */
  uint8_t *inbuf;  /**< Bit stream input buffer */
  uint8_t dbit;    /**< Number of bits available in wreg or reading bit mask */
  uint8_t scale;   /**< Output scaling ratio */
  uint8_t msx;     /**< MCU size in units of blocks (width) */
  uint8_t msy;     /**< MCU size in units of blocks (height) */
  uint8_t qtid[3]; /**< Quantization table ID of each component, Y, Cb, Cr */
  uint8_t ncomp;   /**< Number of color components 1:grayscale, 3:color */
  int16_t dcv[3];  /**< Previous DC element of each component */
  uint16_t nrst;   /**< Restart interval */
  uint16_t width;  /**< Width of the input image in pixels */
  uint16_t height; /**< Height of the input image in pixels */
  uint8_t *huffbits[2][2];  /**< Huffman bit distribution tables [id][dcac] */
  uint16_t *huffcode[2][2]; /**< Huffman code word tables [id][dcac] */
  uint8_t *huffdata[2][2];  /**< Huffman decoded data tables [id][dcac] */
  int32_t *qttbl[4];        /**< Dequantizer tables [id] */
#if JD_FASTDECODE >= 1
  uint32_t wreg;  /**< Working shift register */
  uint8_t marker; /**< Detected marker (0:None) */
#if JD_FASTDECODE == 2
  uint8_t longofs[2][2]; /**< Table offset of long code [id][dcac] */
  uint16_t
      *hufflut_ac[2]; /**< Fast huffman decode tables for AC short code [id] */
  uint8_t
      *hufflut_dc[2]; /**< Fast huffman decode tables for DC short code [id] */
#endif
#endif
  void *workbuf;    /**< Working buffer for IDCT and RGB output */
  jd_yuv_t *mcubuf; /**< Working buffer for the MCU */
  void *pool;       /**< Pointer to available memory pool */
  size_t sz_pool;   /**< Size of memory pool (bytes available) */
  size_t (*infunc)(struct JDEC *, uint8_t *,
                   size_t); /**< Pointer to jpeg stream input function */
  void *device; /**< Pointer to I/O device identifier for the session */
  uint8_t swap; /**< Byte swap flag added by Bodmer to control byte swapping */
} JDEC;

/* TJpgDec API functions */
JRESULT jd_prepare(JDEC *jd, size_t (*infunc)(JDEC *, uint8_t *, size_t),
                   void *pool, size_t sz_pool, void *dev);
JRESULT jd_decomp(JDEC *jd, int (*outfunc)(JDEC *, void *, JRECT *),
                  uint8_t scale);

#ifdef __cplusplus
}
#endif

#endif /* _TJPGDEC */
