//
//  Definitions for all the intellikeys universal codes
//

#define UNIVERSAL_F1 0x01
#define UNIVERSAL_F2 0x02
#define UNIVERSAL_F3 0x03
#define UNIVERSAL_F4 0x04
#define UNIVERSAL_F5 0x05
#define UNIVERSAL_F6 0x06
#define UNIVERSAL_F7 0x07
#define UNIVERSAL_F8 0x08
#define UNIVERSAL_F9 0x09
#define UNIVERSAL_F10 0x0a
#define UNIVERSAL_F11 0x0b
#define UNIVERSAL_F12 0x0c

#define UNIVERSAL_F13 0x0d
#define UNIVERSAL_PRINT_SCREEN 0x0d

#define UNIVERSAL_F14 0x0e
#define UNIVERSAL_SCROLL_LOCK 0x0e

#define UNIVERSAL_F15 0x0f
#define UNIVERSAL_PAUSE 0x0f

#define UNIVERSAL_SPACE 0x20

#define UNIVERSAL_NUMPAD_0 0x10
#define UNIVERSAL_NUMPAD_1 0x11
#define UNIVERSAL_NUMPAD_2 0x12
#define UNIVERSAL_NUMPAD_3 0x13
#define UNIVERSAL_NUMPAD_4 0x14
#define UNIVERSAL_NUMPAD_5 0x15
#define UNIVERSAL_NUMPAD_6 0x16
#define UNIVERSAL_NUMPAD_7 0x17
#define UNIVERSAL_NUMPAD_8 0x18
#define UNIVERSAL_NUMPAD_9 0x19
#define UNIVERSAL_NUMPAD_ADD 0x1a
#define UNIVERSAL_NUMPAD_SUBTRACT 0x1b
#define UNIVERSAL_NUMPAD_MULTIPLY 0x1c
#define UNIVERSAL_NUMPAD_DIVIDE 0x1d
#define UNIVERSAL_NUMPAD_EQUAL 0x1e
#define UNIVERSAL_NUMPAD_ENTER 0x1f
#define UNIVERSAL_NUMPAD_DECIMAL 0x21

#define UNIVERSAL_INSERT 0x22
#define UNIVERSAL_DELETE 0x23
#define UNIVERSAL_UP_ARROW 0x24
#define UNIVERSAL_DOWN_ARROW 0x25
#define UNIVERSAL_LEFT_ARROW 0x26
#define UNIVERSAL_RIGHT_ARROW 0x27
#define UNIVERSAL_HOME 0x28
#define UNIVERSAL_END 0x29
#define UNIVERSAL_PAGE_UP 0x2a
#define UNIVERSAL_PAGE_DOWN 0x2b
#define UNIVERSAL_COMMA 0x2c
#define UNIVERSAL_MINUS 0x2d
#define UNIVERSAL_PERIOD 0x2e
#define UNIVERSAL_SLASH 0x2f

#define UNIVERSAL_0 0x30
#define UNIVERSAL_1 0x31
#define UNIVERSAL_2 0x32
#define UNIVERSAL_3 0x33
#define UNIVERSAL_4 0x34
#define UNIVERSAL_5 0x35
#define UNIVERSAL_6 0x36
#define UNIVERSAL_7 0x37
#define UNIVERSAL_8 0x38
#define UNIVERSAL_9 0x39

// #define UNIVERSAL_ 0x3a

#define UNIVERSAL_SEMICOLON 0x3b

// #define UNIVERSAL_ 0x3c

#define UNIVERSAL_EQUALS 0x3d
#define UNIVERSAL_TILDE 0x3e
#define UNIVERSAL_QUOTE 0x3f

// #define UNIVERSAL_ 0x40

#define UNIVERSAL_A 0x41
#define UNIVERSAL_B 0x42
#define UNIVERSAL_C 0x43
#define UNIVERSAL_D 0x44
#define UNIVERSAL_E 0x45
#define UNIVERSAL_F 0x46
#define UNIVERSAL_G 0x47
#define UNIVERSAL_H 0x48
#define UNIVERSAL_I 0x49
#define UNIVERSAL_J 0x4a
#define UNIVERSAL_K 0x4b
#define UNIVERSAL_L 0x4c
#define UNIVERSAL_M 0x4d
#define UNIVERSAL_N 0x4e
#define UNIVERSAL_O 0x4f
#define UNIVERSAL_P 0x50
#define UNIVERSAL_Q 0x51
#define UNIVERSAL_R 0x52
#define UNIVERSAL_S 0x53
#define UNIVERSAL_T 0x54
#define UNIVERSAL_U 0x55
#define UNIVERSAL_V 0x56
#define UNIVERSAL_W 0x57
#define UNIVERSAL_X 0x58
#define UNIVERSAL_Y 0x59
#define UNIVERSAL_Z 0x5a

#define UNIVERSAL_LEFT_BRACKET 0x5b
#define UNIVERSAL_BACKSLASH 0x5c
#define UNIVERSAL_RIGHT_BRACKET 0x5d

// #define UNIVERSAL_ 0x5e
// #define UNIVERSAL_ 0x5f

#define UNIVERSAL_ENTER 0x60
#define UNIVERSAL_RETURN 0x60

#define UNIVERSAL_ESCAPE 0x61
#define UNIVERSAL_TAB 0x62
#define UNIVERSAL_BACKSPACE 0x63
#define UNIVERSAL_CAPS_LOCK 0x64
#define UNIVERSAL_NUM_LOCK 0x65

// #define UNIVERSAL_ 0x66

#define UNIVERSAL_UNICODE 0x67

// #define UNIVERSAL_ 0x68
// #define UNIVERSAL_ 0x69
// #define UNIVERSAL_ 0x6a
// #define UNIVERSAL_ 0x6b
// #define UNIVERSAL_ 0x6c
// #define UNIVERSAL_ 0x6d
// #define UNIVERSAL_ 0x6e
// #define UNIVERSAL_ 0x6f

#define UNIVERSAL_SHIFT 0x70

#define UNIVERSAL_RIGHT_SHIFT 0x71

#define UNIVERSAL_CONTROL 0x72

#define UNIVERSAL_RIGHT_CONTROL 0x73

#define UNIVERSAL_MENU 0x74
#define UNIVERSAL_ALT 0x74
#define UNIVERSAL_OPTION 0x74
#define UNIVERSAL_ALTGR 0x75

#define UNIVERSAL_RIGHT_OPTION 0x75

#define UNIVERSAL_COMMAND 0x76

// #define UNIVERSAL_ 0x77
// #define UNIVERSAL_ 0x78
// #define UNIVERSAL_ 0x79
// #define UNIVERSAL_ 0x7a
// #define UNIVERSAL_ 0x7b
// #define UNIVERSAL_ 0x7c
// #define UNIVERSAL_ 0x7d
// #define UNIVERSAL_ 0x7e
// #define UNIVERSAL_ 0x7f

#define UNIVERSAL_MOUSE_UP 0x80
#define UNIVERSAL_MOUSE_UP_RIGHT 0x81
#define UNIVERSAL_MOUSE_RIGHT 0x82
#define UNIVERSAL_MOUSE_DOWN_RIGHT 0x83
#define UNIVERSAL_MOUSE_DOWN 0x84
#define UNIVERSAL_MOUSE_DOWN_LEFT 0x85
#define UNIVERSAL_MOUSE_LEFT 0x86
#define UNIVERSAL_MOUSE_UP_LEFT 0x87
#define UNIVERSAL_MOUSE_BUTTON_CLICK 0x88
#define UNIVERSAL_MOUSE_BUTTON_DOUBLECLICK 0x89
#define UNIVERSAL_MOUSE_BUTTON_DOWN 0x8a
#define UNIVERSAL_MOUSE_BUTTON_UP 0x8b
#define UNIVERSAL_MOUSE_ON_CODE 0x8c
#define UNIVERSAL_MOUSE_OFF_CODE 0x8d
#define UNIVERSAL_MOUSE_BUTTON_TOGGLE 0x8e

//  commandeered by fred for the right mouse button
#define UNIVERSAL_MOUSE_RBUTTON_CLICK 0x8f
#define UNIVERSAL_MOUSE_RBUTTON_DOUBLECLICK 0x90
#define UNIVERSAL_MOUSE_RBUTTON_DOWN 0x91
#define UNIVERSAL_MOUSE_RBUTTON_UP 0x92
#define UNIVERSAL_MOUSE_RBUTTON_TOGGLE 0x93

//  commandeered by fred for the middle mouse button
#define UNIVERSAL_MOUSE_MBUTTON_CLICK 0x94
#define UNIVERSAL_MOUSE_MBUTTON_DOUBLECLICK 0x95
#define UNIVERSAL_MOUSE_MBUTTON_DOWN 0x96
#define UNIVERSAL_MOUSE_MBUTTON_UP 0x97
#define UNIVERSAL_MOUSE_MBUTTON_TOGGLE 0x98

//  commandeered by fred for the mouse button 4
#define UNIVERSAL_MOUSE_BUTTON4_CLICK 0x99
#define UNIVERSAL_MOUSE_BUTTON4_DOUBLECLICK 0x9a
#define UNIVERSAL_MOUSE_BUTTON4_DOWN 0x9b
#define UNIVERSAL_MOUSE_BUTTON4_UP 0x9c
#define UNIVERSAL_MOUSE_BUTTON4_TOGGLE 0x9d

//  commandeered by fred for the mouse button 5
#define UNIVERSAL_MOUSE_BUTTON5_CLICK 0x9e
#define UNIVERSAL_MOUSE_BUTTON5_DOUBLECLICK 0x9f
#define UNIVERSAL_MOUSE_BUTTON5_DOWN 0xa0
#define UNIVERSAL_MOUSE_BUTTON5_UP 0xa1
#define UNIVERSAL_MOUSE_BUTTON5_TOGGLE 0xa2

//  commandeered by fred for the mouse button 6
#define UNIVERSAL_MOUSE_BUTTON6_CLICK 0xa3
#define UNIVERSAL_MOUSE_BUTTON6_DOUBLECLICK 0xa4
#define UNIVERSAL_MOUSE_BUTTON6_DOWN 0xa5
#define UNIVERSAL_MOUSE_BUTTON6_UP 0xa6
#define UNIVERSAL_MOUSE_BUTTON6_TOGGLE 0xa7

//  commandeered by fred for the mouse button 7
#define UNIVERSAL_MOUSE_BUTTON7_CLICK 0xa8
#define UNIVERSAL_MOUSE_BUTTON7_DOUBLECLICK 0xa9
#define UNIVERSAL_MOUSE_BUTTON7_DOWN 0xaa
#define UNIVERSAL_MOUSE_BUTTON7_UP 0xab
#define UNIVERSAL_MOUSE_BUTTON7_TOGGLE 0xac

//  commandeered by fred for the mouse button 8
#define UNIVERSAL_MOUSE_BUTTON8_CLICK 0xad
#define UNIVERSAL_MOUSE_BUTTON8_DOUBLECLICK 0xae
#define UNIVERSAL_MOUSE_BUTTON8_DOWN 0xaf
#define UNIVERSAL_MOUSE_BUTTON8_UP 0xb0
#define UNIVERSAL_MOUSE_BUTTON8_TOGGLE 0xb1

//  commandeered by fred for Wait
#define UNIVERSAL_WAIT 0xb2

// #define UNIVERSAL_ 0xb3
// #define UNIVERSAL_ 0xb4
// #define UNIVERSAL_ 0xb5
// #define UNIVERSAL_ 0xb6
// #define UNIVERSAL_ 0xb7
// #define UNIVERSAL_ 0xb8
// #define UNIVERSAL_ 0xb9
// #define UNIVERSAL_ 0xba
// #define UNIVERSAL_ 0xbb
// #define UNIVERSAL_ 0xbc
// #define UNIVERSAL_ 0xbd
// #define UNIVERSAL_ 0xbe
// #define UNIVERSAL_ 0xbf

#define UNIVERSAL_GOTO_LEVEL 0xc0

#define UNIVERSAL_GOTO_LEVEL_1 0xc1
#define UNIVERSAL_GOTO_LEVEL_2 0xc2
#define UNIVERSAL_GOTO_LEVEL_3 0xc3
#define UNIVERSAL_GOTO_LEVEL_4 0xc4
#define UNIVERSAL_GOTO_LEVEL_5 0xc5
#define UNIVERSAL_GOTO_LEVEL_6 0xc6
#define UNIVERSAL_GOTO_LEVEL_7 0xc7
#define UNIVERSAL_GOTO_LEVEL_8 0xc8
#define UNIVERSAL_GOTO_LEVEL_9 0xc9
#define UNIVERSAL_GOTO_LEVEL_10 0xca
#define UNIVERSAL_GOTO_LEVEL_11 0xcb
#define UNIVERSAL_GOTO_LEVEL_12 0xcc
#define UNIVERSAL_GOTO_LEVEL_13 0xcd
#define UNIVERSAL_GOTO_LEVEL_14 0xce
#define UNIVERSAL_GOTO_LEVEL_15 0xcf

#define UNIVERSAL_NON_REPEATING 0xd0
#define UNIVERSAL_SEPARATE_REPEAT_KEY 0xd1
#define UNIVERSAL_NON_SMART_TYPING 0xd2

// #define UNIVERSAL_ 0xd3
// #define UNIVERSAL_ 0xd4
// #define UNIVERSAL_ 0xd5
// #define UNIVERSAL_ 0xd6
// #define UNIVERSAL_ 0xd7
// #define UNIVERSAL_ 0xd8
// #define UNIVERSAL_ 0xd9
// #define UNIVERSAL_ 0xda
// #define UNIVERSAL_ 0xdb
// #define UNIVERSAL_ 0xdc
// #define UNIVERSAL_ 0xdd
// #define UNIVERSAL_ 0xde
// #define UNIVERSAL_ 0xdf

#define UNIVERSAL_SETUP1 0xe0
#define UNIVERSAL_SETUP2 0xe1

//  these are sub-codes for setup functions

#define UNIVERSAL_SETUP1_RESPONSE_RATE 0x41 // plus rate
#define UNIVERSAL_SETUP1_LIFT_OFF_ON 0x42
#define UNIVERSAL_SETUP1_LIFT_OFF_OFF 0x43
#define UNIVERSAL_SETUP1_REPEAT_LATCHING_ON 0x4A
#define UNIVERSAL_SETUP1_REPEAT_LATCHING_OFF 0x4B
#define UNIVERSAL_SETUP1_SHIFT_NO_LATCHING 0x4E
#define UNIVERSAL_SETUP1_3LIGHTS 0x51
#define UNIVERSAL_SETUP1_6LIGHTS 0x52
#define UNIVERSAL_SETUP1_MOUSE_SPEED 0x55          // plus speed
#define UNIVERSAL_SETUP1_CUSTOM_OVERLAY_LEVEL 0x58 // plus level
#define UNIVERSAL_SETUP1_DATA_SEND_RATE 0x32       // plus rate
#define UNIVERSAL_SETUP1_REPEAT_RATE 0x49          // plus rate
#define UNIVERSAL_SETUP1_KEYSOUND_ON 0x45
#define UNIVERSAL_SETUP1_KEYSOUND_OFF 0x44
#define UNIVERSAL_SETUP1_SHIFT_LATCHING 0x4C
#define UNIVERSAL_SETUP1_LIST_FEATURES 0x33
#define UNIVERSAL_SETUP1_SHIFT_LOCKING 0x4D
#define UNIVERSAL_SETUP1_MOUSE_ARROWS_ON 0x56
#define UNIVERSAL_SETUP1_MOUSE_ARROWS_OFF 0x57
#define UNIVERSAL_SETUP1_SMART_TYPING_ON 0x53
#define UNIVERSAL_SETUP1_SMART_TYPING_OFF 0x54
#define UNIVERSAL_SETUP1_REPEAT_ON 0x47
#define UNIVERSAL_SETUP1_REPEAT_OFF 0x48
#define UNIVERSAL_SETUP1_LIST_FEATURES 0x33

#define UNIVERSAL_SETUP2_FEATURE_RESET 0x45

// #define UNIVERSAL_ 0xe2
// #define UNIVERSAL_ 0xe3
// #define UNIVERSAL_ 0xe4
// #define UNIVERSAL_ 0xe5
// #define UNIVERSAL_ 0xe6
// #define UNIVERSAL_ 0xe7
// #define UNIVERSAL_ 0xe8
// #define UNIVERSAL_ 0xe9
// #define UNIVERSAL_ 0xea
// #define UNIVERSAL_ 0xeb
// #define UNIVERSAL_ 0xec
// #define UNIVERSAL_ 0xed
// #define UNIVERSAL_ 0xee
// #define UNIVERSAL_ 0xef
// #define UNIVERSAL_ 0xf0
// #define UNIVERSAL_ 0xf1
// #define UNIVERSAL_ 0xf2
// #define UNIVERSAL_ 0xf3
// #define UNIVERSAL_ 0xf4
// #define UNIVERSAL_ 0xf5
// #define UNIVERSAL_ 0xf6
// #define UNIVERSAL_ 0xf7
// #define UNIVERSAL_ 0xf8
// #define UNIVERSAL_ 0xf9
// #define UNIVERSAL_ 0xfa
// #define UNIVERSAL_ 0xfb
// #define UNIVERSAL_ 0xfc
// #define UNIVERSAL_ 0xfd
// #define UNIVERSAL_ 0xfe
// #define UNIVERSAL_ 0xff
