// Adafruit EyeLights font - a 15-pixel-tall font designed specifically
// for scrolling messages on the EyeLights canvas, then scaled 1:3 for
// the LED matrix. Upper & lower case are the same. If you need a small
// font to use directly on the matrix (without scaling), use the TomThumb
// font that's included with Adafruit_GFX.

const uint8_t PROGMEM EyeLightsCanvasFontBitmaps[] = {
    0x00, 0x00, 0x39, 0xCE, 0x73, 0xB9, 0xCE, 0x70, 0x00, 0x0E, 0x73, 0x80,
    0xE7, 0xE7, 0xE7, 0xC6, 0xC6, 0x0E, 0x38, 0x1C, 0x70, 0xFF, 0xF9, 0xFF,
    0xF7, 0xFF, 0xC3, 0x8E, 0x07, 0x1C, 0x0E, 0x38, 0x7F, 0xFD, 0xFF, 0xF3,
    0xFF, 0xE1, 0xC7, 0x03, 0x8E, 0x00, 0x06, 0x07, 0xF8, 0xFF, 0xBB, 0x77,
    0x6E, 0xEC, 0x1F, 0x81, 0xFC, 0x0F, 0xC1, 0xBB, 0xB7, 0x76, 0xEF, 0xF8,
    0xFF, 0x03, 0x00, 0x1C, 0x00, 0xF8, 0x63, 0x63, 0xCF, 0x9E, 0x1C, 0xF0,
    0x07, 0x80, 0x3C, 0x01, 0xE0, 0x0F, 0x00, 0x78, 0x03, 0xCE, 0x1E, 0x7C,
    0xF1, 0xB1, 0x87, 0xC0, 0x0E, 0x00, 0x0F, 0xE1, 0xFF, 0x3F, 0xF3, 0x87,
    0x38, 0x03, 0x80, 0x1C, 0x03, 0xEE, 0x7F, 0xE7, 0x7E, 0xE3, 0xCE, 0x1C,
    0xFF, 0xEF, 0xFF, 0x7F, 0x70, 0xFF, 0xEC, 0x1C, 0xE3, 0x9C, 0x71, 0xCE,
    0x38, 0xE3, 0x8E, 0x1C, 0x71, 0xC3, 0x80, 0x70, 0xE3, 0x8E, 0x1C, 0x71,
    0xC7, 0x1C, 0xE3, 0x8E, 0x71, 0xCE, 0x00, 0x18, 0x23, 0x87, 0x1C, 0xF1,
    0xDE, 0x0F, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x07, 0xB8, 0xF3, 0x8E,
    0x1C, 0x41, 0x80, 0x07, 0x00, 0xE0, 0x1C, 0x07, 0x0F, 0xFF, 0xFF, 0xFF,
    0xF8, 0x70, 0x1C, 0x03, 0x80, 0x70, 0x00, 0x77, 0x76, 0xC0, 0xFF, 0xFF,
    0xFF, 0xFF, 0x80, 0xFF, 0x80, 0x0E, 0x1C, 0x38, 0xE1, 0xC3, 0x8E, 0x1C,
    0x38, 0xE1, 0xC3, 0x8E, 0x1C, 0x38, 0x00, 0x0F, 0xE1, 0xFF, 0x3F, 0xF3,
    0x87, 0x38, 0xF7, 0x1E, 0x73, 0xE7, 0x6E, 0x7C, 0xE7, 0x8E, 0xF1, 0xCE,
    0x1C, 0xFF, 0xCF, 0xF8, 0x7F, 0x00, 0x1C, 0xF7, 0xFF, 0xFF, 0xE3, 0x8E,
    0x38, 0xE7, 0x1C, 0x71, 0xC7, 0x00, 0x0F, 0xE1, 0xFF, 0x3F, 0xF3, 0x87,
    0x38, 0x70, 0x0E, 0x07, 0xE1, 0xFC, 0x3F, 0x87, 0x80, 0x70, 0x0E, 0x00,
    0xFF, 0xCF, 0xFC, 0xFF, 0xC0, 0x0F, 0xE1, 0xFF, 0x3F, 0xF3, 0x87, 0x00,
    0x70, 0x0E, 0x07, 0xE0, 0xFC, 0x0F, 0xE0, 0x0E, 0x00, 0xEE, 0x1C, 0xFF,
    0xCF, 0xF8, 0x7F, 0x00, 0x00, 0xE0, 0x1E, 0x03, 0xE0, 0x7E, 0x0F, 0xE0,
    0xFC, 0x1D, 0xC3, 0x9C, 0x79, 0xCF, 0xFF, 0xFF, 0xEF, 0xFE, 0x03, 0x80,
    0x38, 0x03, 0x80, 0x3F, 0xF3, 0xFF, 0x3F, 0xF3, 0x80, 0x38, 0x07, 0x00,
    0x7F, 0xC7, 0xFE, 0x7F, 0xE0, 0x0E, 0x00, 0xEE, 0x1C, 0xFF, 0xCF, 0xFC,
    0x7F, 0x80, 0x0F, 0xE1, 0xFF, 0x3F, 0xF3, 0x87, 0x38, 0x07, 0x00, 0x7F,
    0xC7, 0xFE, 0x7F, 0xEE, 0x0E, 0xE0, 0xEE, 0x1C, 0xFF, 0xCF, 0xFC, 0x7F,
    0x80, 0xFF, 0xFF, 0xFF, 0xFC, 0x0E, 0x03, 0x80, 0xE0, 0x70, 0x1C, 0x07,
    0x03, 0x80, 0xE0, 0x38, 0x1C, 0x07, 0x01, 0xC0, 0x0F, 0xE1, 0xFF, 0x3F,
    0xF3, 0x87, 0x70, 0x77, 0x0E, 0x7F, 0xE3, 0xFC, 0x7F, 0xE7, 0x0E, 0xE0,
    0xEE, 0x1C, 0xFF, 0xCF, 0xF8, 0x7F, 0x00, 0x3F, 0xCF, 0xFD, 0xFF, 0xB8,
    0x7E, 0x0F, 0xC1, 0xFF, 0xF7, 0xFE, 0x7F, 0xC0, 0x38, 0x0E, 0x03, 0xCF,
    0xF1, 0xFC, 0x3F, 0x00, 0x3B, 0xDC, 0x00, 0x01, 0xDE, 0xE0, 0x3B, 0xDC,
    0x00, 0x01, 0xDE, 0xE6, 0x20, 0x01, 0x03, 0x07, 0x1E, 0x3C, 0x78, 0xF0,
    0x70, 0x38, 0x3C, 0x1C, 0x0C, 0x04, 0x3F, 0xF7, 0xFF, 0x7F, 0xE0, 0x00,
    0x00, 0x00, 0x00, 0x7F, 0xEF, 0xFE, 0xFF, 0xC0, 0x20, 0x30, 0x38, 0x3C,
    0x1C, 0x0E, 0x0F, 0x1E, 0x3C, 0x78, 0xE0, 0xC0, 0x80, 0x3F, 0x9F, 0xFF,
    0xFF, 0x87, 0x01, 0xC0, 0xE0, 0x78, 0x3C, 0x1E, 0x07, 0x00, 0x00, 0x00,
    0x38, 0x0E, 0x03, 0x80, 0x0F, 0xF8, 0x7F, 0xF3, 0xFF, 0xCE, 0x07, 0x38,
    0x1D, 0xC7, 0xE7, 0x3F, 0x9C, 0xCE, 0x73, 0x39, 0xCF, 0xEE, 0x1F, 0x38,
    0x00, 0xFF, 0xE3, 0xFF, 0x87, 0xFC, 0x00, 0x01, 0xC0, 0x1C, 0x03, 0xC0,
    0x3C, 0x07, 0xE0, 0x7E, 0x0E, 0xE0, 0xEE, 0x1C, 0xE1, 0xFE, 0x3F, 0xE3,
    0xFF, 0x70, 0x77, 0x07, 0xE0, 0x70, 0x3F, 0xE3, 0xFF, 0x3F, 0xF3, 0x87,
    0x38, 0x77, 0x0F, 0x7F, 0xE7, 0xFC, 0x7F, 0xE7, 0x0E, 0xE1, 0xEE, 0x1E,
    0xFF, 0xCF, 0xFC, 0xFF, 0x00, 0x0F, 0xE1, 0xFF, 0x3F, 0xF3, 0x87, 0x38,
    0x77, 0x00, 0x70, 0x07, 0x00, 0x70, 0x07, 0x00, 0xE1, 0xCE, 0x1C, 0xFF,
    0xCF, 0xF8, 0x7F, 0x00, 0x3F, 0xC3, 0xFE, 0x3F, 0xF3, 0x87, 0x38, 0x77,
    0x0E, 0x70, 0xE7, 0x0E, 0x70, 0xE7, 0x0E, 0xE1, 0xCE, 0x1C, 0xFF, 0xCF,
    0xF8, 0xFF, 0x00, 0x3F, 0xF3, 0xFF, 0x3F, 0xF3, 0x80, 0x38, 0x07, 0x00,
    0x7F, 0x87, 0xF8, 0x7F, 0x87, 0x00, 0xE0, 0x0E, 0x00, 0xFF, 0xCF, 0xFC,
    0xFF, 0xC0, 0x3F, 0xF3, 0xFF, 0x3F, 0xF3, 0x80, 0x38, 0x07, 0x00, 0x7F,
    0x87, 0xF8, 0x7F, 0x87, 0x00, 0xE0, 0x0E, 0x00, 0xE0, 0x0E, 0x00, 0xE0,
    0x00, 0x0F, 0xE1, 0xFF, 0x3F, 0xF3, 0x87, 0x38, 0x07, 0x00, 0x73, 0xE7,
    0x3E, 0x73, 0xE7, 0x0E, 0xE1, 0xCE, 0x1C, 0xFF, 0xCF, 0xF8, 0x7F, 0x00,
    0x38, 0x73, 0x87, 0x38, 0x73, 0x87, 0x38, 0x77, 0x0E, 0x7F, 0xE7, 0xFE,
    0x7F, 0xE7, 0x0E, 0xE1, 0xCE, 0x1C, 0xE1, 0xCE, 0x1C, 0xE1, 0xC0, 0x39,
    0xCE, 0x73, 0xB9, 0xCE, 0x73, 0xB9, 0xCE, 0x73, 0x80, 0x00, 0xE0, 0x1C,
    0x03, 0x80, 0x70, 0x0E, 0x03, 0x80, 0x70, 0x0E, 0x01, 0xC0, 0x3B, 0x8E,
    0x71, 0xCF, 0xF9, 0xFF, 0x1F, 0xC0, 0x38, 0x73, 0x8E, 0x39, 0xC3, 0x9C,
    0x3B, 0x87, 0x70, 0x7F, 0x07, 0xE0, 0x7C, 0x07, 0xE0, 0xEE, 0x0E, 0x70,
    0xE3, 0x8E, 0x38, 0xE1, 0xC0, 0x38, 0x1C, 0x0E, 0x07, 0x03, 0x83, 0x81,
    0xC0, 0xE0, 0x70, 0x38, 0x38, 0x1C, 0x0F, 0xFF, 0xFF, 0xFE, 0x38, 0x07,
    0x38, 0x0F, 0x38, 0x0F, 0x3C, 0x1F, 0x3C, 0x1F, 0x7C, 0x3E, 0x7E, 0x7E,
    0x7E, 0x7E, 0x7E, 0xEE, 0x77, 0xEE, 0xE7, 0xDC, 0xE7, 0xDC, 0xE7, 0x9C,
    0xE3, 0x9C, 0xE3, 0x1C, 0x38, 0x73, 0x87, 0x3C, 0x73, 0xC7, 0x3C, 0x77,
    0xEE, 0x7E, 0xE7, 0xFE, 0x77, 0xE7, 0x7E, 0xE7, 0xCE, 0x3C, 0xE3, 0xCE,
    0x1C, 0xE1, 0xC0, 0x07, 0xE0, 0xFF, 0x87, 0xFC, 0x78, 0xF3, 0x83, 0xB8,
    0x1D, 0xC1, 0xCE, 0x0E, 0x70, 0x77, 0x03, 0xB8, 0x39, 0xE3, 0xC7, 0xFC,
    0x3F, 0xE0, 0xFC, 0x00, 0x3F, 0xE3, 0xFF, 0x3F, 0xF3, 0x87, 0x38, 0x77,
    0x0E, 0x7F, 0xE7, 0xFE, 0x7F, 0xC7, 0x00, 0xE0, 0x0E, 0x00, 0xE0, 0x0E,
    0x00, 0xE0, 0x00, 0x0F, 0xE0, 0xFF, 0x8F, 0xFC, 0x70, 0xE3, 0x87, 0x38,
    0x71, 0xC3, 0x8E, 0x1C, 0x70, 0xE3, 0x8F, 0x38, 0xF1, 0xC3, 0xCF, 0xFF,
    0x7F, 0xFD, 0xFC, 0xC0, 0x3F, 0xE3, 0xFF, 0x3F, 0xF3, 0x87, 0x38, 0x77,
    0x0E, 0x7F, 0xE7, 0xFE, 0x7F, 0xC7, 0x70, 0xE7, 0x0E, 0x38, 0xE3, 0x8E,
    0x1C, 0xE1, 0xC0, 0x1F, 0xC7, 0xFC, 0xFF, 0xBC, 0x77, 0x0E, 0xE0, 0x1F,
    0xE1, 0xFE, 0x1F, 0xC0, 0x3B, 0x87, 0x71, 0xEF, 0xF9, 0xFF, 0x1F, 0xC0,
    0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0x00, 0xE0, 0x38, 0x07, 0x00, 0xE0, 0x1C,
    0x03, 0x80, 0xE0, 0x1C, 0x03, 0x80, 0x70, 0x0E, 0x00, 0x38, 0x73, 0x87,
    0x38, 0x73, 0x87, 0x70, 0x77, 0x0E, 0x70, 0xE7, 0x0E, 0x70, 0xEE, 0x0E,
    0xE1, 0xCE, 0x1C, 0xFF, 0xCF, 0xF8, 0x7F, 0x00, 0xE0, 0xFC, 0x1F, 0x87,
    0x70, 0xEE, 0x39, 0xC7, 0x39, 0xC7, 0x38, 0x7E, 0x0F, 0xC1, 0xF0, 0x3E,
    0x07, 0x80, 0xF0, 0x1C, 0x00, 0xE0, 0x03, 0xF0, 0x01, 0xF8, 0x01, 0xDC,
    0x30, 0xEE, 0x38, 0xE7, 0x1C, 0x73, 0x9E, 0x71, 0xCF, 0x38, 0x7F, 0xF8,
    0x3F, 0xFC, 0x1F, 0x7C, 0x0F, 0x3E, 0x07, 0x9E, 0x03, 0x8F, 0x01, 0xC7,
    0x00, 0x38, 0x39, 0xC3, 0x87, 0x1C, 0x39, 0xC0, 0xFC, 0x07, 0xC0, 0x1E,
    0x00, 0xE0, 0x0F, 0x00, 0x7C, 0x07, 0xE0, 0x73, 0x87, 0x1C, 0x38, 0x73,
    0x83, 0x80, 0xE0, 0xFC, 0x1F, 0xC7, 0x39, 0xE7, 0x38, 0x7E, 0x0F, 0xC0,
    0xF0, 0x1C, 0x03, 0x80, 0xE0, 0x1C, 0x03, 0x80, 0x70, 0x0E, 0x00, 0x3F,
    0xF3, 0xFF, 0x3F, 0xE0, 0x1C, 0x03, 0xC0, 0x38, 0x07, 0x00, 0xF0, 0x0E,
    0x01, 0xC0, 0x3C, 0x03, 0x80, 0x7F, 0xCF, 0xFC, 0xFF, 0xC0, 0x3E, 0x7C,
    0xF9, 0xC3, 0x8E, 0x1C, 0x38, 0x70, 0xE3, 0x87, 0x0F, 0x9F, 0x3E, 0x00,
    0xE0, 0xE0, 0x70, 0x70, 0x70, 0x38, 0x38, 0x3C, 0x1C, 0x1C, 0x0E, 0x0E,
    0x0E, 0x07, 0x07, 0x3E, 0x7C, 0xF8, 0x70, 0xE3, 0x87, 0x0E, 0x1C, 0x38,
    0xE1, 0xCF, 0x9F, 0x3E, 0x00, 0x0E, 0x0F, 0x0F, 0xCE, 0x7E, 0x38, 0xFF,
    0xFF, 0xFF, 0xFC, 0xE7, 0x1C, 0x73, 0x80, 0x0F, 0x1F, 0x1F, 0x1C, 0x38,
    0x38, 0xF0, 0xE0, 0xF0, 0x30, 0x70, 0x70, 0x7C, 0x7C, 0x3C, 0x39, 0xCE,
    0x77, 0x39, 0xCE, 0x77, 0x39, 0xCE, 0x00, 0x3C, 0x3E, 0x3E, 0x0E, 0x0E,
    0x0C, 0x0F, 0x07, 0x0F, 0x1C, 0x1C, 0x38, 0xF8, 0xF8, 0xF0, 0x38, 0x0F,
    0x8F, 0xFB, 0xF7, 0xFC, 0x7C, 0x07, 0x00,
};

// {offset, width, height, advance cursor, x offset, y offset}
const GFXglyph PROGMEM EyeLightsCanvasFontGlyphs[] = {
    {0, 0, 0, 6, 0, 0},         // 0x20 (space)
    {2, 5, 15, 7, 1, -15},      // 0x21 !
    {12, 8, 5, 10, 1, -15},     // 0x22 "
    {17, 15, 13, 17, 1, -14},   // 0x23 #
    {42, 11, 15, 13, 1, -15},   // 0x24 $
    {63, 14, 15, 16, 0, -15},   // 0x25 %
    {90, 12, 15, 14, 1, -15},   // 0x26 &
    {113, 3, 5, 5, 1, -15},     // 0x27 '
    {115, 6, 15, 8, 1, -15},    // 0x28 (
    {127, 6, 15, 8, 1, -15},    // 0x29 )
    {139, 12, 13, 14, 1, -14},  // 0x2A *
    {159, 11, 11, 13, 1, -13},  // 0x2B +
    {175, 4, 5, 6, 1, -5},      // 0x2C ,
    {178, 11, 3, 13, 1, -9},    // 0x2D -
    {183, 3, 3, 5, 1, -3},      // 0x2E .
    {185, 7, 15, 9, 1, -15},    // 0x2F /
    {199, 12, 15, 14, 1, -15},  // 0x30 0
    {222, 6, 15, 8, 1, -15},    // 0x31 1
    {234, 12, 15, 14, 1, -15},  // 0x32 2
    {257, 12, 15, 14, 1, -15},  // 0x33 3
    {280, 12, 15, 14, 1, -15},  // 0x34 4
    {303, 12, 15, 14, 1, -15},  // 0x35 5
    {326, 12, 15, 14, 1, -15},  // 0x36 6
    {349, 10, 15, 12, 1, -15},  // 0x37 7
    {368, 12, 15, 14, 1, -15},  // 0x38 8
    {391, 11, 15, 13, 1, -15},  // 0x39 9
    {412, 5, 9, 7, 1, -12},     // 0x3A :
    {418, 5, 11, 7, 1, -12},    // 0x3B ;
    {425, 8, 13, 10, 1, -14},   // 0x3C <
    {438, 12, 9, 14, 1, -12},   // 0x3D =
    {452, 8, 13, 10, 1, -14},   // 0x3E >
    {465, 10, 15, 12, 1, -15},  // 0x3F ?
    {484, 14, 15, 16, 1, -15},  // 0x40 @
    {511, 12, 15, 14, 0, -15},  // 0x41 A
    {534, 12, 15, 14, 1, -15},  // 0x42 B
    {557, 12, 15, 14, 1, -15},  // 0x43 C
    {580, 12, 15, 14, 1, -15},  // 0x44 D
    {603, 12, 15, 14, 1, -15},  // 0x45 E
    {626, 12, 15, 14, 1, -15},  // 0x46 F
    {649, 12, 15, 14, 1, -15},  // 0x47 G
    {672, 12, 15, 14, 1, -15},  // 0x48 H
    {695, 5, 15, 7, 1, -15},    // 0x49 I
    {705, 11, 15, 13, 1, -15},  // 0x4A J
    {726, 12, 15, 14, 1, -15},  // 0x4B K
    {749, 9, 15, 11, 1, -15},   // 0x4C L
    {766, 16, 15, 18, 1, -15},  // 0x4D M
    {796, 12, 15, 14, 1, -15},  // 0x4E N
    {819, 13, 15, 15, 1, -15},  // 0x4F O
    {844, 12, 15, 14, 1, -15},  // 0x50 P
    {867, 13, 15, 15, 2, -15},  // 0x51 Q
    {892, 12, 15, 14, 1, -15},  // 0x52 R
    {915, 11, 15, 13, 1, -15},  // 0x53 S
    {936, 11, 15, 13, 1, -15},  // 0x54 T
    {957, 12, 15, 14, 1, -15},  // 0x55 U
    {980, 11, 15, 13, 1, -15},  // 0x56 V
    {1001, 17, 15, 19, 1, -15}, // 0x57 W
    {1033, 13, 15, 15, 0, -15}, // 0x58 X
    {1058, 11, 15, 13, 1, -15}, // 0x59 Y
    {1079, 12, 15, 14, 1, -15}, // 0x5A Z
    {1102, 7, 15, 9, 1, -15},   // 0x5B [
    {1116, 8, 15, 10, 1, -15},  // 0x5C (backslash)
    {1131, 7, 15, 9, 1, -15},   // 0x5D ]
    {1145, 9, 5, 11, 1, -15},   // 0x5E ^
    {1151, 10, 3, 12, 1, -3},   // 0x5F _
    {1155, 5, 5, 7, 1, -15},    // 0x60 `
    // Lowercase chars point at the existing uppercase bitmaps
    {511, 12, 15, 14, 0, -15},  // 0x41 a
    {534, 12, 15, 14, 1, -15},  // 0x42 b
    {557, 12, 15, 14, 1, -15},  // 0x43 c
    {580, 12, 15, 14, 1, -15},  // 0x44 d
    {603, 12, 15, 14, 1, -15},  // 0x45 e
    {626, 12, 15, 14, 1, -15},  // 0x46 f
    {649, 12, 15, 14, 1, -15},  // 0x47 g
    {672, 12, 15, 14, 1, -15},  // 0x48 h
    {695, 5, 15, 7, 1, -15},    // 0x49 i
    {705, 11, 15, 13, 1, -15},  // 0x4A j
    {726, 12, 15, 14, 1, -15},  // 0x4B k
    {749, 9, 15, 11, 1, -15},   // 0x4C l
    {766, 16, 15, 18, 1, -15},  // 0x4D m
    {796, 12, 15, 14, 1, -15},  // 0x4E n
    {819, 13, 15, 15, 1, -15},  // 0x4F o
    {844, 12, 15, 14, 1, -15},  // 0x50 p
    {867, 13, 15, 15, 2, -15},  // 0x51 q
    {892, 12, 15, 14, 1, -15},  // 0x52 r
    {915, 11, 15, 13, 1, -15},  // 0x53 s
    {936, 11, 15, 13, 1, -15},  // 0x54 t
    {957, 12, 15, 14, 1, -15},  // 0x55 u
    {980, 11, 15, 13, 1, -15},  // 0x56 v
    {1001, 17, 15, 19, 1, -15}, // 0x57 w
    {1033, 13, 15, 15, 0, -15}, // 0x58 x
    {1058, 11, 15, 13, 1, -15}, // 0x59 y
    {1079, 12, 15, 14, 1, -15}, // 0x5A z
    {1159, 8, 15, 10, 1, -15},  // 0x7B {
    {1174, 5, 13, 7, 1, -14},   // 0x7C |
    {1183, 8, 15, 10, 1, -15},  // 0x7D }
    {1198, 11, 6, 13, 1, -12},  // 0x7E ~
};

const GFXfont PROGMEM EyeLightsCanvasFont = {
    (uint8_t *)EyeLightsCanvasFontBitmaps,
    (GFXglyph *)EyeLightsCanvasFontGlyphs, 0x20, 0x7E, 18};
