/*******************************************************************************
 * Size: 22 px
 * Bpp: 2
 * Opts: --bpp 2 --size 22 --no-compress --font IntelOneMono-Medium.ttf --range
 *32-127 --format lvgl -o intel_one_mono.c
 ******************************************************************************/

// The Intel One Mono font is licensed under the SIL Open Font License,
// Version 1.1: https://github.com/intel/intel-one-mono/blob/main/OFL.txt

// This file is created using https://lvgl.io/tools/fontconverter

#include "font.h"

#ifndef INTEL_ONE_MONO
#define INTEL_ONE_MONO 1
#endif

#if INTEL_ONE_MONO

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0x7f, 0xc7, 0xfc, 0x3f, 0x83, 0xf8, 0x3f, 0x42, 0xf4, 0x2f, 0x1, 0xf0, 0x1f,
    0x0, 0xe0, 0x0, 0x0, 0x0, 0x5, 0x3, 0xf8, 0x7f, 0xc3, 0xf4,

    /* U+0022 "\"" */
    0xbd, 0xb, 0xd7, 0xd0, 0xbd, 0x7d, 0xb, 0xc7, 0xd0, 0x7c, 0x7d, 0x7, 0xc3,
    0xc0, 0x7c, 0x3c, 0x7, 0xc1, 0x40, 0x14,

    /* U+0023 "#" */
    0x0, 0x3c, 0x3c, 0x0, 0xe, 0xe, 0x0, 0x3, 0x43, 0x80, 0x16, 0xe6, 0xe5,
    0x1f, 0xff, 0xff, 0x87, 0xf8, 0x2f, 0xe0, 0xd, 0xb, 0x0, 0x3, 0x43, 0x80,
    0x16, 0xc0, 0xe5, 0xf, 0xfa, 0xbf, 0xc3, 0xff, 0xff, 0xf0, 0xf, 0xf, 0x0,
    0x3, 0x83, 0x80, 0x0, 0xd0, 0xe0, 0x0, 0x74, 0x74, 0x0,

    /* U+0024 "$" */
    0x0, 0x3c, 0x0, 0x0, 0xf0, 0x0, 0x3, 0xc0, 0x0, 0xbf, 0xf8, 0xf, 0xff, 0xf4,
    0xfe, 0x56, 0xc3, 0xd0, 0x0, 0xf, 0x40, 0x0, 0x3f, 0x40, 0x0, 0x7f, 0xe4,
    0x0, 0x7f, 0xfd, 0x0, 0xb, 0xfd, 0x0, 0x1, 0xf8, 0x0, 0x2, 0xf0, 0x0, 0xb,
    0xde, 0x40, 0x7e, 0xbf, 0xff, 0xf0, 0x6f, 0xfd, 0x0, 0x3, 0xc0, 0x0, 0xf,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x50, 0x0,

    /* U+0025 "%" */
    0xb, 0xe0, 0xb, 0xc2, 0xeb, 0xc0, 0xf0, 0x38, 0x1c, 0x2d, 0x3, 0x81, 0xd3,
    0x80, 0x38, 0x1d, 0x70, 0x3, 0xc2, 0xcd, 0x0, 0xf, 0xf4, 0x0, 0x0, 0x14,
    0x1f, 0xc0, 0x0, 0x57, 0xef, 0x0, 0xc, 0xb0, 0x74, 0x2, 0xcf, 0x3, 0x80,
    0x74, 0xf0, 0x38, 0xf, 0xb, 0x7, 0x42, 0xe0, 0x7e, 0xf0, 0x7c, 0x1, 0xfc,
    0x0,

    /* U+0026 "&" */
    0x0, 0xbf, 0xd0, 0x3, 0xff, 0xd0, 0xb, 0xc0, 0x0, 0xb, 0x80, 0x0, 0xb, 0xc0,
    0x0, 0x3, 0xd0, 0x10, 0x2, 0xf0, 0x3c, 0xb, 0xfc, 0x78, 0x3f, 0x7d, 0xf0,
    0xbc, 0x2f, 0xe0, 0xf4, 0xf, 0xd0, 0xf4, 0x7, 0xe0, 0xbc, 0xf, 0xf0, 0x3f,
    0xfd, 0xbc, 0x1f, 0xf4, 0x3e,

    /* U+0027 "'" */
    0xfd, 0xfd, 0xfd, 0xbc, 0xbc, 0xbc, 0xbc, 0x14,

    /* U+0028 "(" */
    0x0, 0x0, 0x0, 0x0, 0x2c, 0x0, 0x1f, 0xd0, 0x7, 0xf0, 0x2, 0xf8, 0x0, 0x7e,
    0x0, 0xf, 0x80, 0x2, 0xf0, 0x0, 0x3e, 0x0, 0x7, 0xc0, 0x0, 0xbc, 0x0, 0xb,
    0xc0, 0x0, 0xbc, 0x0, 0x7, 0xc0, 0x0, 0x3d, 0x0, 0x2, 0xf0, 0x0, 0xf, 0x80,
    0x0, 0x7d, 0x0, 0x2, 0xf8, 0x0, 0xb, 0xe0, 0x0, 0x1f, 0xd0, 0x0, 0x2c, 0x0,
    0x0, 0x0,

    /* U+0029 ")" */
    0x0, 0x0, 0x0, 0xb4, 0x0, 0x3, 0xf8, 0x0, 0x1, 0xfc, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0xfc, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xf0, 0x0, 0x3, 0xe0, 0x0, 0xb, 0xc0,
    0x0, 0x1f, 0x0, 0x0, 0x7c, 0x0, 0x1, 0xf0, 0x0, 0xb, 0xc0, 0x0, 0x3e, 0x0,
    0x1, 0xf0, 0x0, 0xf, 0x80, 0x0, 0xfc, 0x0, 0xf, 0xc0, 0x1, 0xfc, 0x0, 0x3f,
    0x80, 0x0, 0xb4, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+002A "*" */
    0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x38, 0x0, 0x38, 0x34, 0x78, 0xbf,
    0x66, 0xfc, 0x16, 0xbe, 0x50, 0x0, 0xbc, 0x0, 0x3, 0xcb, 0x40, 0xf, 0x83,
    0xe0, 0xf, 0x1, 0xe0, 0x1, 0x0, 0x40,

    /* U+002B "+" */
    0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c,
    0x0, 0xbf, 0xff, 0xfc, 0xbf, 0xff, 0xfc, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0,

    /* U+002C "," */
    0x3, 0xfc, 0x3, 0xf8, 0x3, 0xf4, 0x7, 0xf0, 0xf, 0xd0, 0x2f, 0x40, 0x3d,
    0x0,

    /* U+002D "-" */
    0x15, 0x55, 0x5f, 0xff, 0xf7, 0xff, 0xfc,

    /* U+002E "." */
    0x0, 0x3, 0xf8, 0x7f, 0xc7, 0xfc, 0x2f, 0x40,

    /* U+002F "/" */
    0x0, 0x0, 0x6, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x2, 0xe0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0xb8, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x2e, 0x0, 0x0, 0xf, 0x40, 0x0, 0xb,
    0xc0, 0x0, 0x3, 0xd0, 0x0, 0x2, 0xf0, 0x0, 0x0, 0xf4, 0x0, 0x0, 0xbc, 0x0,
    0x0, 0x3d, 0x0, 0x0, 0x1f, 0x0, 0x0, 0xf, 0x40, 0x0, 0x7, 0xc0, 0x0, 0x3,
    0xd0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x0,

    /* U+0030 "0" */
    0x1, 0xfe, 0x0, 0xb, 0xff, 0xd0, 0x1f, 0x87, 0xf0, 0x3e, 0x0, 0xf4, 0x3c,
    0x0, 0xfc, 0x7c, 0x3, 0xfc, 0x7c, 0x1f, 0xbc, 0xbc, 0x7c, 0x7c, 0xbe, 0xe0,
    0x7c, 0x7f, 0x80, 0x7c, 0x3d, 0x0, 0xb8, 0x3e, 0x0, 0xf4, 0x2f, 0x87, 0xf0,
    0xf, 0xff, 0xd0, 0x2, 0xfe, 0x0,

    /* U+0031 "1" */
    0x0, 0x74, 0x0, 0x7f, 0x40, 0x7f, 0xf4, 0xb, 0xef, 0x40, 0xa0, 0xf4, 0x0,
    0xf, 0x40, 0x0, 0xf4, 0x0, 0xf, 0x40, 0x0, 0xf4, 0x0, 0xf, 0x40, 0x0, 0xf4,
    0x0, 0xf, 0x40, 0x0, 0xf4, 0xb, 0xff, 0xfe, 0xbf, 0xff, 0xe0,

    /* U+0032 "2" */
    0x1, 0xbf, 0x40, 0xb, 0xff, 0xf0, 0x3f, 0x96, 0xf4, 0x7d, 0x0, 0xf8, 0x10,
    0x0, 0xf8, 0x0, 0x0, 0xf4, 0x0, 0x3, 0xf0, 0x0, 0xb, 0xc0, 0x0, 0x2f, 0x40,
    0x0, 0xbd, 0x0, 0x2, 0xf4, 0x0, 0xb, 0xd0, 0x0, 0x2f, 0x40, 0x0, 0x7f, 0xff,
    0xfc, 0x7f, 0xff, 0xfc,

    /* U+0033 "3" */
    0x7f, 0xff, 0xf5, 0xff, 0xff, 0xc0, 0x0, 0x7e, 0x0, 0x3, 0xe0, 0x0, 0x3e,
    0x0, 0x3, 0xf0, 0x0, 0x3f, 0xf8, 0x0, 0xff, 0xfc, 0x0, 0x2, 0xf8, 0x0, 0x2,
    0xf0, 0x0, 0xb, 0xc0, 0x0, 0x7e, 0x5, 0x6f, 0xf4, 0xff, 0xff, 0x43, 0xff,
    0x90, 0x0,

    /* U+0034 "4" */
    0x0, 0x1f, 0xc0, 0x0, 0x3f, 0xc0, 0x0, 0xb7, 0xc0, 0x1, 0xf3, 0xc0, 0x3,
    0xc3, 0xc0, 0xb, 0x83, 0xc0, 0xf, 0x3, 0xc0, 0x3c, 0x3, 0xc0, 0x78, 0x3,
    0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xc0,
    0x0, 0x3, 0xc0, 0x0, 0x3, 0xc0,

    /* U+0035 "5" */
    0x1f, 0xff, 0xf0, 0x7f, 0xff, 0xc2, 0xe0, 0x0, 0xb, 0x80, 0x0, 0x2e, 0x0,
    0x0, 0xba, 0xfe, 0x3, 0xff, 0xff, 0xb, 0x90, 0xbe, 0x0, 0x0, 0xfc, 0x0, 0x2,
    0xf0, 0x0, 0xf, 0x80, 0x1, 0xfd, 0x1a, 0xff, 0xe0, 0xff, 0xf9, 0x3, 0xa5,
    0x0, 0x0,

    /* U+0036 "6" */
    0x0, 0x1f, 0xc0, 0x0, 0x7f, 0x0, 0x1, 0xfc, 0x0, 0x3, 0xf0, 0x0, 0xf, 0xc0,
    0x0, 0x1f, 0xff, 0x80, 0x3f, 0xff, 0xf0, 0x3d, 0x1, 0xf8, 0x7c, 0x0, 0xfc,
    0x7c, 0x0, 0xbc, 0x7c, 0x0, 0xbc, 0x3e, 0x0, 0xfc, 0x3f, 0x43, 0xf4, 0xf,
    0xff, 0xe0, 0x2, 0xfe, 0x40,

    /* U+0037 "7" */
    0xbf, 0xff, 0xfe, 0xff, 0xff, 0xf0, 0x0, 0xf, 0x80, 0x0, 0x7c, 0x0, 0x3,
    0xe0, 0x0, 0x1f, 0x0, 0x0, 0xfc, 0x0, 0x7, 0xd0, 0x0, 0x3f, 0x0, 0x1, 0xf4,
    0x0, 0xf, 0xc0, 0x0, 0x7d, 0x0, 0x3, 0xf0, 0x0, 0x1f, 0x80, 0x0, 0xfc, 0x0,
    0x0,

    /* U+0038 "8" */
    0x2, 0xff, 0x40, 0x3f, 0xff, 0x83, 0xf4, 0x2f, 0x4f, 0x40, 0x3e, 0x3d, 0x0,
    0xf4, 0x7c, 0x7, 0xc0, 0x7f, 0xf8, 0x1, 0xff, 0xe0, 0x2f, 0x42, 0xf0, 0xf0,
    0x2, 0xe7, 0xc0, 0x7, 0xdf, 0x0, 0x2f, 0x3f, 0x2, 0xf8, 0x7f, 0xff, 0xc0,
    0x2f, 0xf4, 0x0,

    /* U+0039 "9" */
    0x2, 0xff, 0x40, 0xf, 0xff, 0xe0, 0x3f, 0x43, 0xf4, 0x3d, 0x0, 0xf8, 0x7c,
    0x0, 0xbc, 0x7c, 0x0, 0xbc, 0x7d, 0x0, 0xbc, 0x3f, 0x0, 0xf8, 0x1f, 0xff,
    0xf4, 0x6, 0xff, 0xf0, 0x0, 0x7, 0xd0, 0x0, 0x1f, 0x80, 0x0, 0x7e, 0x0, 0x1,
    0xf8, 0x0, 0xb, 0xe0, 0x0,

    /* U+003A ":" */
    0x2f, 0x47, 0xfc, 0x7f, 0xc2, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf4, 0x7f,
    0xc7, 0xfc, 0x2f, 0x40,

    /* U+003B ";" */
    0x1, 0xf8, 0x3, 0xfc, 0x3, 0xfc, 0x1, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x54, 0x3, 0xf8, 0x3, 0xf4, 0x7, 0xf0, 0xf, 0xe0, 0x1f, 0x80, 0x3e,
    0x0, 0x14, 0x0,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 0x0, 0x2f, 0xc0, 0xb, 0xfd, 0x7, 0xff, 0x41,
    0xff, 0x80, 0xb, 0xd0, 0x0, 0x2f, 0xe0, 0x0, 0x1f, 0xf9, 0x0, 0x2, 0xff,
    0x40, 0x0, 0xbf, 0xc0, 0x0, 0x1f, 0x0, 0x0, 0x4,

    /* U+003D "=" */
    0x3f, 0xff, 0xf8, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xe3, 0xff, 0xff, 0x80,

    /* U+003E ">" */
    0x0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x7f, 0x40, 0x0, 0x2f, 0xf4, 0x0, 0x2, 0xff,
    0x80, 0x0, 0x1f, 0xf8, 0x0, 0x0, 0xbc, 0x0, 0x6, 0xfc, 0x0, 0x7f, 0xe0, 0xb,
    0xfd, 0x0, 0x7f, 0xd0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+003F "?" */
    0xa, 0xff, 0x81, 0xff, 0xff, 0xd7, 0x94, 0x1f, 0xc0, 0x0, 0x2f, 0x0, 0x0,
    0xfc, 0x0, 0xf, 0xd0, 0x7, 0xfd, 0x0, 0x7f, 0x80, 0x1, 0xf0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x50, 0x0, 0x1f, 0xd0, 0x0, 0xbf, 0x80,
    0x0, 0xfc, 0x0,

    /* U+0040 "@" */
    0x1, 0xbf, 0x80, 0xb, 0x41, 0xb0, 0x1c, 0x0, 0x34, 0x34, 0x0, 0x1c, 0x30,
    0x0, 0xc, 0x70, 0x2f, 0xfc, 0xa0, 0xbe, 0xad, 0xa0, 0xf0, 0xd, 0xa1, 0xd0,
    0xd, 0xa1, 0xd0, 0xd, 0xa1, 0xe0, 0xc, 0xa0, 0xf0, 0x3c, 0x70, 0x7f, 0xf4,
    0x70, 0xa, 0x40, 0x34, 0x0, 0x0, 0x2c, 0x0, 0x0, 0xf, 0x40, 0x0, 0x2, 0xff,
    0xe0, 0x0, 0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x3f, 0x40, 0x0, 0xf, 0xe0, 0x0, 0xb, 0xfc, 0x0, 0x3, 0xdf, 0x40, 0x0,
    0xf2, 0xe0, 0x0, 0x7c, 0x7c, 0x0, 0x2e, 0xf, 0x0, 0xf, 0x3, 0xe0, 0x7, 0xc0,
    0xbc, 0x2, 0xff, 0xff, 0x0, 0xff, 0xff, 0xd0, 0x3c, 0x0, 0xf8, 0x1f, 0x0,
    0x2f, 0xf, 0x80, 0x7, 0xd3, 0xd0, 0x0, 0xf8,

    /* U+0042 "B" */
    0x3f, 0xff, 0x80, 0x3f, 0xff, 0xf0, 0x3d, 0x1, 0xf8, 0x3d, 0x0, 0xbc, 0x3d,
    0x0, 0xbc, 0x3d, 0x0, 0xf4, 0x3d, 0x2, 0xe0, 0x3f, 0xff, 0x40, 0x3f, 0xff,
    0xe0, 0x3d, 0x1, 0xfc, 0x3d, 0x0, 0x3d, 0x3d, 0x0, 0x3d, 0x3d, 0x0, 0xbd,
    0x3f, 0xff, 0xfc, 0x3f, 0xff, 0xe0,

    /* U+0043 "C" */
    0x0, 0xbf, 0x90, 0x7, 0xff, 0xf8, 0x1f, 0xd0, 0xbc, 0x3f, 0x0, 0x4, 0x7d,
    0x0, 0x0, 0xbc, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xfc, 0x0, 0x0,
    0xbc, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3f, 0x0, 0x4, 0x2f, 0xd1, 0xbd, 0xb, 0xff,
    0xf8, 0x1, 0xff, 0x80,

    /* U+0044 "D" */
    0x3f, 0xf8, 0x0, 0x3f, 0xff, 0x80, 0x3d, 0x1b, 0xf0, 0x3d, 0x1, 0xf8, 0x3d,
    0x0, 0xbc, 0x3d, 0x0, 0x7c, 0x3d, 0x0, 0x3d, 0x3d, 0x0, 0x3d, 0x3d, 0x0,
    0x3d, 0x3d, 0x0, 0x7c, 0x3d, 0x0, 0xfc, 0x3d, 0x2, 0xf4, 0x3d, 0x5f, 0xe0,
    0x3f, 0xff, 0x80, 0x3f, 0xe4, 0x0,

    /* U+0045 "E" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xf, 0x80, 0x0, 0xf8, 0x0, 0xf,
    0x80, 0x0, 0xf8, 0x0, 0xf, 0xff, 0xfc, 0xff, 0xff, 0xcf, 0x80, 0x0, 0xf8,
    0x0, 0xf, 0x80, 0x0, 0xf8, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+0046 "F" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xf, 0x80, 0x0, 0xf8, 0x0, 0xf,
    0x80, 0x0, 0xf8, 0x0, 0xf, 0xff, 0xfc, 0xff, 0xff, 0xcf, 0x80, 0x0, 0xf8,
    0x0, 0xf, 0x80, 0x0, 0xf8, 0x0, 0xf, 0x80, 0x0, 0xf8, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x6f, 0xf0, 0x7, 0xff, 0xf0, 0x1f, 0xe4, 0x0, 0x3f, 0x0, 0x0, 0x7d,
    0x0, 0x0, 0xbc, 0x0, 0x0, 0xfc, 0xf, 0xfc, 0xf8, 0xf, 0xfc, 0xfc, 0x0, 0x3c,
    0xbc, 0x0, 0x3c, 0x7c, 0x0, 0x3c, 0x3f, 0x0, 0x3c, 0x2f, 0xd0, 0x7c, 0xb,
    0xff, 0xfc, 0x1, 0xbf, 0xf8,

    /* U+0048 "H" */
    0x3d, 0x0, 0xf8, 0xf4, 0x3, 0xe3, 0xd0, 0xf, 0x8f, 0x40, 0x3e, 0x3d, 0x0,
    0xf8, 0xf4, 0x3, 0xe3, 0xd0, 0xf, 0x8f, 0xff, 0xfe, 0x3f, 0xff, 0xf8, 0xf4,
    0x3, 0xe3, 0xd0, 0xf, 0x8f, 0x40, 0x3e, 0x3d, 0x0, 0xf8, 0xf4, 0x3, 0xe3,
    0xd0, 0xf, 0x80,

    /* U+0049 "I" */
    0x7f, 0xff, 0xca, 0xff, 0x90, 0x1f, 0x0, 0x7, 0xc0, 0x1, 0xf0, 0x0, 0x7c,
    0x0, 0x1f, 0x0, 0x7, 0xc0, 0x1, 0xf0, 0x0, 0x7c, 0x0, 0x1f, 0x0, 0x7, 0xc0,
    0x1, 0xf0, 0xa, 0xff, 0x97, 0xff, 0xfc,

    /* U+004A "J" */
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x3e, 0xc, 0x0, 0x3e, 0x3f, 0x40, 0x3e, 0x1f, 0xe5, 0xfc, 0x3, 0xff,
    0xf8, 0x0, 0x7f, 0xd0,

    /* U+004B "K" */
    0x3d, 0x0, 0x7e, 0xf, 0x40, 0x3f, 0x3, 0xd0, 0x3f, 0x0, 0xf4, 0x2f, 0x0,
    0x3d, 0x1f, 0x40, 0xf, 0x5f, 0x80, 0x3, 0xef, 0xc0, 0x0, 0xff, 0xd0, 0x0,
    0x3e, 0xfc, 0x0, 0xf, 0x4f, 0xc0, 0x3, 0xd1, 0xf8, 0x0, 0xf4, 0x2f, 0x40,
    0x3d, 0x3, 0xf0, 0xf, 0x40, 0x3f, 0x3, 0xd0, 0x7, 0xe0,

    /* U+004C "L" */
    0xf8, 0x0, 0x3, 0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3,
    0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xe0, 0x0, 0xf,
    0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xff, 0xff, 0xcf, 0xff, 0xff,
    0x0,

    /* U+004D "M" */
    0x3e, 0x0, 0xf8, 0x3f, 0x1, 0xf8, 0x3f, 0x42, 0xf8, 0x7f, 0x83, 0xfc, 0x7e,
    0xc7, 0xbc, 0x7d, 0xdf, 0x7c, 0x7c, 0xfd, 0x7c, 0x7c, 0xbc, 0x7c, 0x78,
    0x7c, 0x7c, 0x78, 0x34, 0x3c, 0xb8, 0x20, 0x3c, 0xb8, 0x0, 0x3c, 0xb8, 0x0,
    0x3c, 0xb8, 0x0, 0x3c, 0xb8, 0x0, 0x3c,

    /* U+004E "N" */
    0x3f, 0x0, 0xb8, 0xfc, 0x2, 0xe3, 0xf8, 0xb, 0x8f, 0xf0, 0x2e, 0x3f, 0xe0,
    0xb8, 0xf7, 0xc2, 0xe3, 0xcf, 0x8b, 0x8f, 0x1f, 0x2e, 0x3c, 0x3d, 0xb8,
    0xf0, 0x7e, 0xe3, 0xc0, 0xff, 0x8f, 0x2, 0xfe, 0x3c, 0x3, 0xf8, 0xf0, 0xb,
    0xe3, 0xc0, 0xf, 0x80,

    /* U+004F "O" */
    0x2, 0xfe, 0x40, 0xf, 0xff, 0xd0, 0x2f, 0x47, 0xf0, 0x3d, 0x0, 0xf8, 0x7c,
    0x0, 0xbc, 0xbc, 0x0, 0x7c, 0xf8, 0x0, 0x3d, 0xf8, 0x0, 0x3d, 0xf8, 0x0,
    0x3d, 0xbc, 0x0, 0x7c, 0xbc, 0x0, 0xbc, 0x3d, 0x0, 0xf8, 0x2f, 0x43, 0xf0,
    0xf, 0xff, 0xd0, 0x2, 0xfe, 0x40,

    /* U+0050 "P" */
    0x3f, 0xff, 0x80, 0x3f, 0xff, 0xf4, 0x3d, 0x1, 0xfc, 0x3d, 0x0, 0x7d, 0x3d,
    0x0, 0x3e, 0x3d, 0x0, 0x3e, 0x3d, 0x0, 0x7d, 0x3d, 0x1, 0xfc, 0x3f, 0xff,
    0xf0, 0x3f, 0xff, 0x80, 0x3d, 0x0, 0x0, 0x3d, 0x0, 0x0, 0x3d, 0x0, 0x0,
    0x3d, 0x0, 0x0, 0x3d, 0x0, 0x0,

    /* U+0051 "Q" */
    0x2, 0xfe, 0x40, 0x3, 0xff, 0xf4, 0x2, 0xf4, 0x7f, 0x0, 0xf4, 0x3, 0xe0,
    0x7c, 0x0, 0xbc, 0x2f, 0x0, 0x1f, 0xf, 0x80, 0x3, 0xd3, 0xe0, 0x0, 0xf4,
    0xf8, 0x0, 0x3d, 0x2f, 0x0, 0x1f, 0xb, 0xc0, 0x7, 0xc0, 0xf4, 0x3, 0xe0,
    0x2f, 0x42, 0xf0, 0x3, 0xff, 0xf8, 0x0, 0x2f, 0xef, 0x40, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0x40,

    /* U+0052 "R" */
    0x3f, 0xff, 0x80, 0x3f, 0xff, 0xf0, 0x3d, 0x1, 0xf8, 0x3d, 0x0, 0xbc, 0x3d,
    0x0, 0xbc, 0x3d, 0x0, 0xbc, 0x3d, 0x2, 0xf4, 0x3e, 0xbf, 0xd0, 0x3f, 0xf9,
    0x0, 0x3e, 0xbd, 0x0, 0x3d, 0x1f, 0x40, 0x3d, 0xb, 0xd0, 0x3d, 0x3, 0xf0,
    0x3d, 0x0, 0xfc, 0x3d, 0x0, 0x7e,

    /* U+0053 "S" */
    0x2, 0xff, 0xe0, 0x3f, 0xff, 0xd2, 0xf4, 0x16, 0xf, 0x80, 0x0, 0x3e, 0x0,
    0x0, 0xfd, 0x0, 0x0, 0xff, 0x90, 0x0, 0xbf, 0xf4, 0x0, 0x1f, 0xf4, 0x0, 0x3,
    0xf0, 0x0, 0xb, 0xc0, 0x0, 0x2f, 0x39, 0x2, 0xf9, 0xff, 0xff, 0xc1, 0xbf,
    0xf4, 0x0,

    /* U+0054 "T" */
    0x3f, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xe0, 0x2, 0xf0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0,

    /* U+0055 "U" */
    0x7c, 0x0, 0xbd, 0xf0, 0x2, 0xf7, 0xc0, 0xb, 0xdf, 0x0, 0x2f, 0x7c, 0x0,
    0xbd, 0xf0, 0x2, 0xf7, 0xc0, 0xb, 0xdf, 0x0, 0x2f, 0x7c, 0x0, 0xbd, 0xf0,
    0x2, 0xf7, 0xc0, 0xb, 0xcf, 0x80, 0x3e, 0x3f, 0x97, 0xf4, 0x3f, 0xff, 0x80,
    0x2f, 0xf4, 0x0,

    /* U+0056 "V" */
    0x3d, 0x0, 0xf, 0x8f, 0xc0, 0x3, 0xd1, 0xf0, 0x1, 0xf0, 0x3d, 0x0, 0xb8,
    0xf, 0x80, 0x3d, 0x2, 0xf0, 0x1f, 0x0, 0x7c, 0xb, 0xc0, 0xf, 0x43, 0xd0,
    0x2, 0xf0, 0xf0, 0x0, 0x7c, 0x7c, 0x0, 0xf, 0x6e, 0x0, 0x3, 0xef, 0x40, 0x0,
    0x7f, 0xc0, 0x0, 0xf, 0xe0, 0x0, 0x3, 0xf4, 0x0,

    /* U+0057 "W" */
    0x3d, 0x0, 0xf, 0x8f, 0x40, 0x3, 0xd3, 0xe0, 0x0, 0xf4, 0xb8, 0x20, 0x3c,
    0x2e, 0xd, 0xf, 0x7, 0xc3, 0x87, 0xc1, 0xf1, 0xf1, 0xf0, 0x3c, 0xbc, 0xb8,
    0xf, 0x3b, 0x6e, 0x3, 0xdc, 0xeb, 0x40, 0xff, 0x2f, 0xd0, 0x2f, 0xc7, 0xf0,
    0xb, 0xe0, 0xfc, 0x1, 0xf4, 0x3f, 0x0, 0x7c, 0xb, 0xc0,

    /* U+0058 "X" */
    0x2f, 0x0, 0x2f, 0x3, 0xe0, 0xf, 0x40, 0x7c, 0xb, 0xc0, 0xf, 0xc7, 0xd0,
    0x1, 0xf7, 0xe0, 0x0, 0x2f, 0xf0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0xfd, 0x0, 0x0,
    0x7f, 0xc0, 0x0, 0x3e, 0xf4, 0x0, 0x2f, 0x2f, 0x0, 0xf, 0x43, 0xe0, 0xb,
    0xc0, 0x7c, 0x7, 0xd0, 0xf, 0xc3, 0xe0, 0x1, 0xf4,

    /* U+0059 "Y" */
    0x3e, 0x0, 0xf, 0x8b, 0xd0, 0xb, 0xc0, 0xfc, 0x3, 0xd0, 0x1f, 0x42, 0xf0,
    0x3, 0xf1, 0xf4, 0x0, 0x7d, 0xf8, 0x0, 0xb, 0xfc, 0x0, 0x0, 0xfe, 0x0, 0x0,
    0x2f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0,

    /* U+005A "Z" */
    0x7f, 0xff, 0xfc, 0x7f, 0xff, 0xfc, 0x15, 0x56, 0xf4, 0x0, 0x3, 0xe0, 0x0,
    0xf, 0xc0, 0x0, 0x2f, 0x40, 0x0, 0x3e, 0x0, 0x0, 0xfc, 0x0, 0x2, 0xf4, 0x0,
    0x3, 0xe0, 0x0, 0xf, 0xc0, 0x0, 0x1f, 0x40, 0x0, 0x3f, 0x0, 0x0, 0xbf, 0xff,
    0xfc, 0xbf, 0xff, 0xfc,

    /* U+005B "[" */
    0x0, 0x0, 0xf, 0xff, 0xe3, 0xff, 0xf8, 0xf4, 0x0, 0x3d, 0x0, 0xf, 0x40, 0x3,
    0xd0, 0x0, 0xf4, 0x0, 0x3d, 0x0, 0xf, 0x40, 0x3, 0xd0, 0x0, 0xf4, 0x0, 0x3d,
    0x0, 0xf, 0x40, 0x3, 0xd0, 0x0, 0xf4, 0x0, 0x3d, 0x0, 0xf, 0x40, 0x3, 0xd0,
    0x0, 0xf4, 0x0, 0x3f, 0xff, 0x8f, 0xff, 0xe0,

    /* U+005C "\\" */
    0x18, 0x0, 0x0, 0xb, 0xc0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x2e, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0xf, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0xf4, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x3, 0xd0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0xf, 0x40, 0x0, 0x2, 0xf0, 0x0, 0x0, 0x3d,

    /* U+005D "]" */
    0x0, 0x0, 0xf, 0xff, 0xe3, 0xff, 0xf8, 0x0, 0x3e, 0x0, 0xf, 0x80, 0x3, 0xe0,
    0x0, 0xf8, 0x0, 0x3e, 0x0, 0xf, 0x80, 0x3, 0xe0, 0x0, 0xf8, 0x0, 0x3e, 0x0,
    0xf, 0x80, 0x3, 0xe0, 0x0, 0xf8, 0x0, 0x3e, 0x0, 0xf, 0x80, 0x3, 0xe0, 0x0,
    0xf8, 0x0, 0x3e, 0x3f, 0xff, 0x8f, 0xff, 0xe0,

    /* U+005E "^" */
    0x0, 0x1a, 0x0, 0x0, 0xf, 0xe0, 0x0, 0xf, 0xbd, 0x0, 0x7, 0xcb, 0xc0, 0x3,
    0xe0, 0xf4, 0x1, 0xf0, 0x2f, 0x0, 0xf8, 0x3, 0xd0, 0x7c, 0x0, 0xbc, 0x3e,
    0x0, 0xf, 0x40,

    /* U+005F "_" */
    0x15, 0x55, 0x55, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xc0,

    /* U+0060 "`" */
    0x1a, 0x40, 0x1f, 0xc0, 0xf, 0xd0, 0x3, 0xf0, 0x2, 0xf4, 0x0, 0xf8, 0x0,
    0x7c, 0x0, 0x3e,

    /* U+0061 "a" */
    0x1f, 0xff, 0x40, 0x2f, 0xff, 0xe0, 0x4, 0x2, 0xf0, 0x0, 0x1, 0xf0, 0x1,
    0x6b, 0xf0, 0x2f, 0xff, 0xf0, 0x7e, 0x41, 0xf0, 0xb8, 0x1, 0xf0, 0xbc, 0xb,
    0xf0, 0x7f, 0xff, 0xfe, 0x1f, 0xe4, 0xbe,

    /* U+0062 "b" */
    0x3d, 0x0, 0x0, 0x3d, 0x0, 0x0, 0x3d, 0x0, 0x0, 0x3d, 0x0, 0x0, 0x3d, 0x0,
    0x0, 0x3d, 0x7f, 0x80, 0x3f, 0xff, 0xf0, 0x3f, 0x82, 0xf8, 0x3d, 0x0, 0xbc,
    0x3d, 0x0, 0x7d, 0x3d, 0x0, 0x3d, 0x3d, 0x0, 0x7c, 0x3d, 0x0, 0xfc, 0x3e,
    0x47, 0xf4, 0x3f, 0xff, 0xe0, 0x36, 0xfe, 0x40,

    /* U+0063 "c" */
    0x1, 0xff, 0x80, 0xb, 0xff, 0xf8, 0x2f, 0x91, 0xb8, 0x3e, 0x0, 0x0, 0xbc,
    0x0, 0x0, 0xbc, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x3f, 0x81, 0xb8,
    0xf, 0xff, 0xf8, 0x2, 0xff, 0x80,

    /* U+0064 "d" */
    0x0, 0x0, 0xf8, 0x0, 0x3, 0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8,
    0xb, 0xf7, 0xe1, 0xff, 0xff, 0x8f, 0xd0, 0xbe, 0x7d, 0x0, 0xfb, 0xf0, 0x3,
    0xef, 0x80, 0xf, 0xbf, 0x0, 0x3e, 0xbc, 0x0, 0xf8, 0xfd, 0x1f, 0xe2, 0xff,
    0xff, 0x81, 0xfe, 0x2e,

    /* U+0065 "e" */
    0x1, 0xff, 0x40, 0xf, 0xff, 0xf0, 0x2f, 0x41, 0xf8, 0x3c, 0x0, 0xbc, 0x7f,
    0xff, 0xfc, 0xbf, 0xff, 0xfc, 0x7c, 0x0, 0x0, 0x7d, 0x0, 0x0, 0x3f, 0x40,
    0x0, 0x1f, 0xff, 0xc0, 0x2, 0xff, 0xc0,

    /* U+0066 "f" */
    0x0, 0x1b, 0xfc, 0x0, 0x7f, 0xfc, 0x0, 0xfd, 0x0, 0x0, 0xf4, 0x0, 0x0, 0xf4,
    0x0, 0x7f, 0xff, 0xf4, 0x7f, 0xff, 0xf4, 0x0, 0xf4, 0x0, 0x0, 0xf4, 0x0,
    0x0, 0xf4, 0x0, 0x0, 0xf4, 0x0, 0x0, 0xf4, 0x0, 0x0, 0xf4, 0x0, 0x0, 0xf4,
    0x0, 0x0, 0xf4, 0x0, 0x0, 0xf4, 0x0,

    /* U+0067 "g" */
    0x2, 0xff, 0x68, 0x3f, 0xff, 0xe3, 0xf9, 0x1f, 0x9f, 0x40, 0x3e, 0xbc, 0x0,
    0xfb, 0xe0, 0x3, 0xef, 0xc0, 0xf, 0xaf, 0x0, 0x3e, 0x3f, 0x47, 0xf8, 0xbf,
    0xff, 0xe0, 0x7f, 0x8f, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x1f, 0xd0,
    0xff, 0xfe, 0x3, 0xff, 0xd0,

    /* U+0068 "h" */
    0x3d, 0x0, 0x0, 0xf4, 0x0, 0x3, 0xd0, 0x0, 0xf, 0x40, 0x0, 0x3d, 0x0, 0x0,
    0xf4, 0x7f, 0x43, 0xdb, 0xff, 0xf, 0xfd, 0xbe, 0x3f, 0x40, 0xf8, 0xf8, 0x3,
    0xe3, 0xd0, 0xf, 0x8f, 0x40, 0x3e, 0x3d, 0x0, 0xf8, 0xf4, 0x3, 0xe3, 0xd0,
    0xf, 0x8f, 0x40, 0x3e,

    /* U+0069 "i" */
    0x0, 0x50, 0x0, 0x3f, 0x80, 0x3, 0xfc, 0x0, 0x1f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xf4, 0x7, 0xff, 0x40, 0x1, 0xf4, 0x0, 0xf, 0x40, 0x0, 0xf4, 0x0,
    0xf, 0x40, 0x0, 0xf4, 0x0, 0xf, 0x40, 0x1, 0xf4, 0xb, 0xff, 0xff, 0xbf,
    0xff, 0xf0,

    /* U+006A "j" */
    0x0, 0x14, 0x0, 0x1f, 0xc0, 0xb, 0xf0, 0x0, 0xa4, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xe2, 0xff, 0xf8, 0x0, 0x3e, 0x0, 0xf, 0x80, 0x3, 0xe0, 0x0, 0xf8,
    0x0, 0x3e, 0x0, 0xf, 0x80, 0x3, 0xe0, 0x0, 0xf8, 0x0, 0x3e, 0x0, 0xf, 0x80,
    0x3, 0xe0, 0x2, 0xf4, 0xff, 0xfc, 0x2f, 0xf8, 0x0,

    /* U+006B "k" */
    0xf8, 0x0, 0x3, 0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3,
    0xe0, 0xf, 0xcf, 0x80, 0xfc, 0x3e, 0xf, 0xc0, 0xf8, 0xfc, 0x3, 0xef, 0xc0,
    0xf, 0xfd, 0x0, 0x3e, 0xbd, 0x0, 0xf8, 0xfd, 0x3, 0xe0, 0xfc, 0xf, 0x80,
    0xfc, 0x3e, 0x0, 0xfc,

    /* U+006C "l" */
    0xbf, 0xf8, 0x2, 0xff, 0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0,
    0x3, 0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xe0, 0x0,
    0xf, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xf4, 0x0, 0x7, 0xff, 0xc0,
    0xb, 0xfe,

    /* U+006D "m" */
    0xf0, 0xf4, 0x7c, 0xf3, 0xf8, 0xfd, 0xfb, 0xff, 0xfe, 0xfc, 0x7e, 0x2e,
    0xf0, 0x3c, 0x2e, 0xf0, 0x3c, 0x2e, 0xf0, 0x3c, 0x2e, 0xf0, 0x3c, 0x2e,
    0xf0, 0x3c, 0x2e, 0xf0, 0x3c, 0x2e, 0xf0, 0x3c, 0x2e,

    /* U+006E "n" */
    0x3c, 0x1f, 0xd0, 0xf7, 0xff, 0xc3, 0xfe, 0x5f, 0x8f, 0xd0, 0x3e, 0x3d, 0x0,
    0xf8, 0xf4, 0x3, 0xe3, 0xd0, 0xf, 0x8f, 0x40, 0x3e, 0x3d, 0x0, 0xf8, 0xf4,
    0x3, 0xe3, 0xd0, 0xf, 0x80,

    /* U+006F "o" */
    0x2, 0xfe, 0x40, 0xf, 0xff, 0xe0, 0x3f, 0x46, 0xf4, 0x7d, 0x0, 0xfc, 0xbc,
    0x0, 0x7c, 0xbc, 0x0, 0x7d, 0xbc, 0x0, 0x7c, 0x7d, 0x0, 0xfc, 0x3f, 0x42,
    0xf4, 0xf, 0xff, 0xe0, 0x2, 0xfe, 0x40,

    /* U+0070 "p" */
    0x3c, 0x7f, 0x80, 0x3e, 0xff, 0xf0, 0x3f, 0x41, 0xf8, 0x3d, 0x0, 0xbc, 0x3d,
    0x0, 0x7d, 0x3d, 0x0, 0x3d, 0x3d, 0x0, 0x7c, 0x3d, 0x0, 0xfc, 0x3f, 0x42,
    0xf8, 0x3f, 0xff, 0xf0, 0x3d, 0xbf, 0x40, 0x3d, 0x0, 0x0, 0x3d, 0x0, 0x0,
    0x3d, 0x0, 0x0, 0x3d, 0x0, 0x0, 0x3d, 0x0, 0x0,

    /* U+0071 "q" */
    0x2, 0xff, 0x68, 0x3f, 0xff, 0xe3, 0xf8, 0x1f, 0x9f, 0x40, 0x3e, 0xbc, 0x0,
    0xfb, 0xe0, 0x3, 0xef, 0xc0, 0xf, 0xaf, 0x0, 0x3e, 0x3f, 0x47, 0xf8, 0xbf,
    0xff, 0xe0, 0x7f, 0x8f, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xe0,
    0x0, 0xf, 0x80, 0x0, 0x3e,

    /* U+0072 "r" */
    0x0, 0x0, 0x0, 0x7f, 0xc1, 0xfd, 0x7f, 0xcb, 0xfd, 0x7, 0xdf, 0xe8, 0x7,
    0xfc, 0x0, 0x7, 0xf0, 0x0, 0x7, 0xd0, 0x0, 0x7, 0xc0, 0x0, 0x7, 0xc0, 0x0,
    0x7, 0xc0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0,

    /* U+0073 "s" */
    0x2, 0xff, 0xe0, 0x7f, 0xff, 0xc3, 0xf0, 0x1, 0xf, 0xc0, 0x0, 0x2f, 0xf9,
    0x0, 0x1f, 0xff, 0x80, 0x1, 0xbf, 0x40, 0x0, 0x3e, 0x14, 0x1, 0xf8, 0xff,
    0xff, 0xc2, 0xff, 0xf4, 0x0,

    /* U+0074 "t" */
    0x1, 0xf0, 0x0, 0x7, 0xc0, 0x0, 0x1f, 0x0, 0x0, 0x7c, 0x0, 0xff, 0xff, 0xf7,
    0xff, 0xff, 0xd0, 0x1f, 0x0, 0x0, 0x7c, 0x0, 0x1, 0xf0, 0x0, 0x7, 0xc0, 0x0,
    0x1f, 0x0, 0x0, 0x7c, 0x0, 0x1, 0xf8, 0x0, 0x3, 0xff, 0xf0, 0x2, 0xff, 0xc0,

    /* U+0075 "u" */
    0x3d, 0x0, 0xf8, 0xf4, 0x3, 0xe3, 0xd0, 0xf, 0x8f, 0x40, 0x3e, 0x3d, 0x0,
    0xf8, 0xf4, 0x3, 0xe3, 0xd0, 0xf, 0x8f, 0x40, 0xbe, 0x3f, 0x1f, 0xf8, 0xbf,
    0xf6, 0xe0, 0xbe, 0xb, 0x80,

    /* U+0076 "v" */
    0xfc, 0x0, 0x7d, 0x7d, 0x0, 0xbc, 0x3e, 0x0, 0xf8, 0x2f, 0x1, 0xf0, 0xf,
    0x42, 0xf0, 0xf, 0x83, 0xd0, 0x7, 0xc7, 0xc0, 0x3, 0xdf, 0x80, 0x2, 0xff,
    0x0, 0x1, 0xff, 0x0, 0x0, 0xfd, 0x0,

    /* U+0077 "w" */
    0x3c, 0x0, 0xb, 0x8f, 0x41, 0x3, 0xd2, 0xe0, 0xd0, 0xf4, 0xb8, 0x38, 0x3c,
    0x1f, 0x1f, 0x1f, 0x3, 0xcf, 0xdb, 0x80, 0xf7, 0xba, 0xe0, 0x3e, 0xcf, 0xf4,
    0xb, 0xf1, 0xfc, 0x1, 0xf8, 0x3f, 0x0, 0x7c, 0xf, 0xc0,

    /* U+0078 "x" */
    0x7e, 0x0, 0xf8, 0x2f, 0x43, 0xf0, 0xf, 0xc7, 0xd0, 0x3, 0xef, 0x80, 0x1,
    0xff, 0x0, 0x0, 0xfd, 0x0, 0x2, 0xff, 0x0, 0x7, 0xdf, 0xc0, 0xf, 0x83, 0xe0,
    0x3f, 0x2, 0xf4, 0xbd, 0x0, 0xfc,

    /* U+0079 "y" */
    0x3f, 0x0, 0x1f, 0x47, 0xd0, 0xb, 0xc0, 0xf8, 0x3, 0xe0, 0x2f, 0x1, 0xf0,
    0x3, 0xd0, 0xbc, 0x0, 0xfc, 0x3d, 0x0, 0x1f, 0x1f, 0x0, 0x3, 0xef, 0x80,
    0x0, 0xbf, 0xc0, 0x0, 0xf, 0xf0, 0x0, 0x3, 0xf4, 0x0, 0x0, 0xbc, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x2f, 0x0, 0x3, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0,

    /* U+007A "z" */
    0x3f, 0xff, 0xf8, 0xff, 0xff, 0xd0, 0x0, 0x7f, 0x0, 0x3, 0xf0, 0x0, 0x3f,
    0x0, 0x3, 0xf4, 0x0, 0x2f, 0x40, 0x2, 0xf4, 0x0, 0x2f, 0x80, 0x0, 0xff,
    0xff, 0xf3, 0xff, 0xff, 0xc0,

    /* U+007B "{" */
    0x0, 0x0, 0x0, 0x0, 0x1a, 0xfc, 0x1, 0xff, 0xfd, 0x3, 0xf9, 0x40, 0x3, 0xf0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x1f, 0x40, 0x0, 0x1f, 0x80, 0x1,
    0xbf, 0x0, 0x7f, 0xe4, 0x0, 0xbd, 0x0, 0x0, 0x7f, 0xe4, 0x0, 0x1, 0xff, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x1f, 0x40, 0x0, 0x7e, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xf0,
    0x0, 0x3, 0xf9, 0x40, 0x1, 0xff, 0xfd, 0x0, 0x1a, 0xfc, 0x0, 0x0, 0x0,

    /* U+007C "|" */
    0x15, 0xf7, 0xdf, 0x7d, 0xf7, 0xdf, 0x7d, 0xf7, 0xdf, 0x7d, 0xf7, 0xdf,
    0x7d, 0xf7, 0xdf,

    /* U+007D "}" */
    0x0, 0x0, 0x0, 0xbf, 0x90, 0x0, 0xff, 0xff, 0x0, 0x5, 0xbf, 0x40, 0x0, 0x1f,
    0x40, 0x0, 0x7e, 0x0, 0x0, 0xfc, 0x0, 0x3, 0xf0, 0x0, 0x3, 0xe0, 0x0, 0x2,
    0xfe, 0x40, 0x0, 0x1f, 0xf8, 0x0, 0x0, 0xbc, 0x0, 0x1f, 0xf8, 0x2, 0xfe,
    0x40, 0x3, 0xf0, 0x0, 0x3, 0xf0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x1f, 0x40, 0x1, 0xbf, 0x40, 0xff, 0xff, 0x0, 0xbf, 0x94, 0x0, 0x0, 0x0,
    0x0,

    /* U+007E "~" */
    0x0, 0x40, 0x1, 0x1, 0xfc, 0x2, 0xe0, 0xff, 0xd0, 0xf0, 0xbc, 0xbe, 0xbc,
    0x3d, 0x7, 0xfd, 0xf, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0};

/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0,
     .adv_w = 0,
     .box_w = 0,
     .box_h = 0,
     .ofs_x = 0,
     .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0,
     .adv_w = 216,
     .box_w = 0,
     .box_h = 0,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 0,
     .adv_w = 216,
     .box_w = 6,
     .box_h = 16,
     .ofs_x = 4,
     .ofs_y = 0},
    {.bitmap_index = 24,
     .adv_w = 216,
     .box_w = 10,
     .box_h = 8,
     .ofs_x = 2,
     .ofs_y = 8},
    {.bitmap_index = 44,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 15,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 93,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 22,
     .ofs_x = 1,
     .ofs_y = -4},
    {.bitmap_index = 154,
     .adv_w = 216,
     .box_w = 14,
     .box_h = 15,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 207,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 252,
     .adv_w = 216,
     .box_w = 4,
     .box_h = 8,
     .ofs_x = 5,
     .ofs_y = 8},
    {.bitmap_index = 260,
     .adv_w = 216,
     .box_w = 10,
     .box_h = 23,
     .ofs_x = 2,
     .ofs_y = -4},
    {.bitmap_index = 318,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 23,
     .ofs_x = 1,
     .ofs_y = -4},
    {.bitmap_index = 382,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 3},
    {.bitmap_index = 415,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 12,
     .ofs_x = 1,
     .ofs_y = 2},
    {.bitmap_index = 451,
     .adv_w = 216,
     .box_w = 8,
     .box_h = 7,
     .ofs_x = 2,
     .ofs_y = -4},
    {.bitmap_index = 465,
     .adv_w = 216,
     .box_w = 9,
     .box_h = 3,
     .ofs_x = 2,
     .ofs_y = 6},
    {.bitmap_index = 472,
     .adv_w = 216,
     .box_w = 6,
     .box_h = 5,
     .ofs_x = 4,
     .ofs_y = 0},
    {.bitmap_index = 480,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 20,
     .ofs_x = 0,
     .ofs_y = -2},
    {.bitmap_index = 545,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 590,
     .adv_w = 216,
     .box_w = 10,
     .box_h = 15,
     .ofs_x = 2,
     .ofs_y = 0},
    {.bitmap_index = 628,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 673,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 715,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 760,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 802,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 847,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 889,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 931,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 976,
     .adv_w = 216,
     .box_w = 6,
     .box_h = 11,
     .ofs_x = 4,
     .ofs_y = 0},
    {.bitmap_index = 993,
     .adv_w = 216,
     .box_w = 8,
     .box_h = 15,
     .ofs_x = 2,
     .ofs_y = -4},
    {.bitmap_index = 1023,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 13,
     .ofs_x = 1,
     .ofs_y = 1},
    {.bitmap_index = 1059,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 7,
     .ofs_x = 1,
     .ofs_y = 4},
    {.bitmap_index = 1079,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 13,
     .ofs_x = 1,
     .ofs_y = 1},
    {.bitmap_index = 1118,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 16,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1162,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 19,
     .ofs_x = 1,
     .ofs_y = -3},
    {.bitmap_index = 1219,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 15,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 1268,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1313,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1358,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1403,
     .adv_w = 216,
     .box_w = 10,
     .box_h = 15,
     .ofs_x = 2,
     .ofs_y = 0},
    {.bitmap_index = 1441,
     .adv_w = 216,
     .box_w = 10,
     .box_h = 15,
     .ofs_x = 2,
     .ofs_y = 0},
    {.bitmap_index = 1479,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1524,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1566,
     .adv_w = 216,
     .box_w = 9,
     .box_h = 15,
     .ofs_x = 2,
     .ofs_y = 0},
    {.bitmap_index = 1600,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 1645,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1694,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 15,
     .ofs_x = 2,
     .ofs_y = 0},
    {.bitmap_index = 1736,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1781,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1823,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1868,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 1913,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 19,
     .ofs_x = 1,
     .ofs_y = -4},
    {.bitmap_index = 1975,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2020,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2062,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 15,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 2111,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2153,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 15,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 2202,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 15,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 2251,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 15,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 2300,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 15,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 2349,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2394,
     .adv_w = 216,
     .box_w = 9,
     .box_h = 22,
     .ofs_x = 3,
     .ofs_y = -3},
    {.bitmap_index = 2444,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 20,
     .ofs_x = 0,
     .ofs_y = -2},
    {.bitmap_index = 2509,
     .adv_w = 216,
     .box_w = 9,
     .box_h = 22,
     .ofs_x = 1,
     .ofs_y = -3},
    {.bitmap_index = 2559,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 9,
     .ofs_x = 0,
     .ofs_y = 6},
    {.bitmap_index = 2589,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 3,
     .ofs_x = 1,
     .ofs_y = -3},
    {.bitmap_index = 2598,
     .adv_w = 216,
     .box_w = 8,
     .box_h = 8,
     .ofs_x = 2,
     .ofs_y = 9},
    {.bitmap_index = 2614,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2647,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 16,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2695,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2728,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 16,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2772,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2805,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 16,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2853,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 16,
     .ofs_x = 1,
     .ofs_y = -5},
    {.bitmap_index = 2897,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 16,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 2941,
     .adv_w = 216,
     .box_w = 10,
     .box_h = 17,
     .ofs_x = 2,
     .ofs_y = 0},
    {.bitmap_index = 2984,
     .adv_w = 216,
     .box_w = 9,
     .box_h = 22,
     .ofs_x = 2,
     .ofs_y = -5},
    {.bitmap_index = 3034,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 16,
     .ofs_x = 2,
     .ofs_y = 0},
    {.bitmap_index = 3078,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 16,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3122,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3155,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3186,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3219,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 16,
     .ofs_x = 1,
     .ofs_y = -5},
    {.bitmap_index = 3267,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 16,
     .ofs_x = 1,
     .ofs_y = -5},
    {.bitmap_index = 3311,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 12,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3347,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3378,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 15,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3420,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3451,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3484,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 11,
     .ofs_x = 0,
     .ofs_y = 0},
    {.bitmap_index = 3520,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3553,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 16,
     .ofs_x = 0,
     .ofs_y = -5},
    {.bitmap_index = 3605,
     .adv_w = 216,
     .box_w = 11,
     .box_h = 11,
     .ofs_x = 1,
     .ofs_y = 0},
    {.bitmap_index = 3636,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 23,
     .ofs_x = 1,
     .ofs_y = -4},
    {.bitmap_index = 3705,
     .adv_w = 216,
     .box_w = 3,
     .box_h = 20,
     .ofs_x = 5,
     .ofs_y = -2},
    {.bitmap_index = 3720,
     .adv_w = 216,
     .box_w = 12,
     .box_h = 23,
     .ofs_x = 1,
     .ofs_y = -4},
    {.bitmap_index = 3789,
     .adv_w = 216,
     .box_w = 13,
     .box_h = 7,
     .ofs_x = 0,
     .ofs_y = 4}};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] = {
    {.range_start = 32,
     .range_length = 95,
     .glyph_id_start = 1,
     .unicode_list = NULL,
     .glyph_id_ofs_list = NULL,
     .list_length = 0,
     .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY}};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 1,
    .bpp = 2,
    .kern_classes = 0,
};

/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
const lv_font_t intel_one_mono = {
    .dsc = &font_dsc, /*The custom font data. Will be accessed by
                         `get_glyph_bitmap/dsc` */
    //.get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to
    //get glyph's data*/ .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,
    ///*Function pointer to get glyph's bitmap*/
    .line_height = 24, /*The maximum line height required by the font*/
    .base_line = 5,    /*Baseline measured from the bottom of the line*/
};

#endif /*#if INTEL_ONE_MONO*/
