/*!
 * @file logo.h
 *
 * Header file to accompany the demo-3-logo example.
 * A 40x40 pixel Adafruit logo in grayscale (for rendering on LED matrix)
 * and corresponding bitmap (for PixelDust collision detection).
 * Latter has the 'seeds' filled so randomly-placed grains don't
 * end up trapped in there.
 *
 */

#define LOGO_WIDTH 40
#define LOGO_HEIGHT 40

const uint8_t logo_gray[LOGO_HEIGHT][LOGO_WIDTH] = {
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X16, 0XD2, 0XEB, 0X39,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X01,
    0XB7, 0XFF, 0XFF, 0XB1, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X71, 0XFF, 0XFF, 0XFF, 0XF7, 0X0D, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X30, 0XF8, 0XFF, 0XFF, 0XFF, 0XFF,
    0X57, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X0A, 0XD6, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XA9, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X98, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XF2, 0X08, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X51, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0X4D, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X0D, 0XE8, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X9F, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X72,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XEC, 0X02, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0XCB, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0X25, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X22, 0X70, 0X78, 0X77, 0X76, 0X75, 0X74, 0X73,
    0X72, 0X6C, 0X4D, 0X15, 0X00, 0X00, 0X04, 0XFB, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X3F, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0XDA, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFC, 0XB3, 0X2D, 0X0C, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X3C, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0XDD, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XF8, 0X52, 0XEB, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFE, 0X17, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X46, 0XFD, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XF6, 0XC9, 0XFF, 0XFF, 0XFF, 0XC8,
    0X9F, 0XFF, 0XFF, 0XFF, 0XFF, 0XC4, 0X00, 0X17, 0X3D, 0X41, 0X27, 0X03,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X89, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFA,
    0XFF, 0XFF, 0XFD, 0X22, 0X0F, 0XFF, 0XFF, 0XFF, 0XFC, 0X76, 0XC4, 0XFE,
    0XFF, 0XFF, 0XFF, 0XEE, 0XA2, 0X50, 0X0A, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X05, 0XC7, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XC9, 0X00, 0X00, 0XFA, 0XFF, 0XFF,
    0XE6, 0XFC, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XF4, 0XAD,
    0X5C, 0X10, 0X00, 0X00, 0X00, 0X00, 0X21, 0XEF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XA0, 0X00,
    0X16, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XF9, 0XB7, 0X3D, 0X00, 0X00, 0X00, 0X55,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X68, 0X2B, 0X6A, 0XD9,
    0XFF, 0XFF, 0X9F, 0X00, 0X58, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XEC,
    0X00, 0X00, 0X00, 0X00, 0X98, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0X94, 0X00, 0X00, 0X06, 0X91, 0XFF, 0XDC, 0X19, 0XD2, 0XFF, 0XFF, 0XFF,
    0XFC, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XCF, 0X00, 0X00, 0X00, 0X00, 0X09, 0XC6, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XA9, 0X1D, 0X00, 0X00, 0XC6, 0XFF, 0XFF,
    0XFF, 0XD5, 0X5C, 0X18, 0X00, 0X10, 0X9D, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XB4, 0X14, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X0F, 0XB9, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFB, 0XBC,
    0X9E, 0XF0, 0XFF, 0XFF, 0XFF, 0X1D, 0X00, 0X00, 0X00, 0X21, 0XC7, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XF7, 0X6D, 0X01, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X02, 0X65, 0XD7, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XDC, 0X9E, 0X9E,
    0XC7, 0XFC, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XD4,
    0X2E, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X39, 0XAF, 0XEF, 0XFF, 0XFF, 0XFF, 0XE5, 0X64, 0X6C, 0XFF, 0XF2,
    0XC7, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0X97, 0X09, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X69, 0XF8, 0XFF, 0XFF, 0XFF, 0XFF, 0XD3, 0X18,
    0X00, 0X5E, 0XFF, 0XA2, 0X00, 0X8E, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XE7, 0X50, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X64, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XF3, 0X20, 0X00, 0X13, 0XE1, 0XFF, 0XC0, 0X00, 0X05, 0XD5, 0XFF,
    0XFF, 0XFB, 0XC9, 0XEA, 0XFF, 0XFB, 0XCB, 0X72, 0X0D, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X21, 0XF5,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X97, 0X00, 0X1A, 0XCC, 0XFF, 0XFF, 0XFC,
    0X20, 0X00, 0X65, 0XFF, 0XFF, 0XFF, 0XF7, 0X55, 0X0C, 0X04, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X9C, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XCE, 0X8F, 0XEF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XAD, 0X00, 0X25, 0XFF, 0XFF, 0XFF, 0XFF, 0XF9,
    0X31, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X0A, 0XF4, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X96, 0X60, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XB9, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X52, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XF0, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFE, 0X1A, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0XA6, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XB1, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0X54, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X08, 0XF2, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFB, 0X3A, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X74, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X4F, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X76, 0X00, 0XD1, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X7A, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0XA3, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XF9, 0X71,
    0X00, 0X00, 0X5F, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0X7B, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X07, 0XF0, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XF9, 0XA8, 0X2A, 0X00, 0X00, 0X00, 0X01, 0XB5, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X7D, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X42, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0XF8, 0XB3, 0X5F, 0X10, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X0D,
    0XC3, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X7E, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X31,
    0XFC, 0XFF, 0XF8, 0XB1, 0X5D, 0X0F, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X08, 0X94, 0XFE, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF,
    0XFF, 0X80, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X37, 0X4F, 0X0E, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X50, 0XED,
    0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0X81, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X1E, 0XC3, 0XFF, 0XFF, 0XFF, 0XFF, 0X82, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X04, 0X83, 0XFC, 0XFF,
    0XFF, 0X7C, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X40, 0XD9, 0XDF, 0X29, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00,
    0X00, 0X00, 0X00, 0X00};
const uint8_t logo_mask[LOGO_HEIGHT][(LOGO_WIDTH + 7) / 8] = {
    0X00, 0X00, 0X06, 0X00, 0X00, 0X00, 0X00, 0X0F, 0X00, 0X00, 0X00, 0X00,
    0X0F, 0X00, 0X00, 0X00, 0X00, 0X1F, 0X00, 0X00, 0X00, 0X00, 0X3F, 0X80,
    0X00, 0X00, 0X00, 0X7F, 0X80, 0X00, 0X00, 0X00, 0X7F, 0X80, 0X00, 0X00,
    0X00, 0XFF, 0XC0, 0X00, 0X00, 0X00, 0XFF, 0XC0, 0X00, 0X00, 0X01, 0XFF,
    0XC0, 0X00, 0X00, 0X01, 0XFF, 0XC0, 0X00, 0XFF, 0XF9, 0XFF, 0XC0, 0X00,
    0XFF, 0XFD, 0XFF, 0XC0, 0X00, 0X7F, 0XFF, 0XFF, 0XC0, 0X00, 0X7F, 0XFF,
    0XFF, 0XFF, 0X80, 0X3F, 0XFF, 0XFF, 0XFF, 0XF0, 0X1F, 0XFF, 0XFF, 0XFF,
    0XFE, 0X0F, 0XFF, 0XFF, 0XFF, 0XFF, 0X0F, 0XFF, 0XFF, 0XFF, 0XFF, 0X07,
    0XFF, 0XFF, 0XFF, 0XFE, 0X03, 0XFF, 0XFF, 0XFF, 0XF8, 0X00, 0XFF, 0XFF,
    0XFF, 0XF0, 0X00, 0X3F, 0XFF, 0XFF, 0XE0, 0X00, 0X7F, 0XFF, 0XFF, 0X80,
    0X00, 0XFF, 0XFF, 0XFE, 0X00, 0X01, 0XFF, 0XFF, 0XE0, 0X00, 0X03, 0XFF,
    0XFF, 0XF0, 0X00, 0X03, 0XFF, 0XFF, 0XF8, 0X00, 0X03, 0XFF, 0XFF, 0XF8,
    0X00, 0X07, 0XFF, 0XFF, 0XF8, 0X00, 0X07, 0XFF, 0XBF, 0XF8, 0X00, 0X07,
    0XFF, 0X3F, 0XF8, 0X00, 0X0F, 0XFE, 0X1F, 0XF8, 0X00, 0X0F, 0XFC, 0X1F,
    0XF8, 0X00, 0X0F, 0XE0, 0X0F, 0XF8, 0X00, 0X0F, 0X00, 0X07, 0XFC, 0X00,
    0X00, 0X00, 0X01, 0XFC, 0X00, 0X00, 0X00, 0X00, 0XFC, 0X00, 0X00, 0X00,
    0X00, 0X78, 0X00, 0X00, 0X00, 0X00, 0X18, 0X00};
