# MG811DataScience v5.5.2

## MG811DataScience What can be create?
"The first and only Arduino library where MG811 Gas Sensor combine with Data Science"

## 1) Advanced Data Science System for Regression Calculations
<img width="1264" height="577" alt="MG811 gas curves" src="https://github.com/user-attachments/assets/92e7899e-b53b-46e0-8c6b-1ac01a152e7b" />

## 2) Calculation of Response and Resume Curve Depending on the Time of the Correction Coefficient
<img width="1264" height="577" alt="Response and Resume Curve" src="https://github.com/user-attachments/assets/4b7115d6-495a-4c59-83e2-4451eb5590d9" />

## 3) Calculating Theoretical CO2 using the Nernst Equation and Converting It Into a Polynomial Function
<img width="1264" height="577" alt="Theoretical CO2" src="https://github.com/user-attachments/assets/c5b37b61-cee6-42da-b7e5-da913ef14818" />

###

<img width="1264" height="936" alt="nerst" src="https://github.com/user-attachments/assets/e8ecfe3d-8bec-4356-9921-039688b8d2f6" />

## 4) Visualization of the Slope Estimations of Theoretical CO2
<img width="1264" height="577" alt="Theoretical CO2 slope estimation" src="https://github.com/user-attachments/assets/fac27fee-e212-457e-af57-7ad697099709" />

## 5) Slope Estimation in Time-Dependent 4D Space In 2 Different Modes
### 1) Multi-Period Mode
<img width="1264" height="577" alt="CO2 4D ppm slope" src="https://github.com/user-attachments/assets/7fe5aae6-3eeb-49fe-9859-fbe07320fa1b" />
<img width="1264" height="577" alt="CH4 4D ppm slope" src="https://github.com/user-attachments/assets/c7ffbd0b-d7d0-4227-9b49-9c9ac99e1a14" />
<img width="1264" height="577" alt="C2H5OH 4D ppm slope" src="https://github.com/user-attachments/assets/27b2ce6f-bf33-43a8-926a-0b766b1b4c09" />
<img width="1264" height="577" alt="CO 4D ppm slope" src="https://github.com/user-attachments/assets/9493ce5d-901c-4fc1-9b02-fe0586aac040" />

### 2) Single-Period Mode
<img width="1264" height="577" alt="CO2 4D ppm slope-2" src="https://github.com/user-attachments/assets/ece88c87-7eff-4c7c-9175-62b782e8c77c" />
<img width="1264" height="577" alt="CH4 4D ppm slope-2" src="https://github.com/user-attachments/assets/15fb11dd-b683-4ba1-8a97-691ba6f8b737" />
<img width="1264" height="577" alt="C2H5OH 4D ppm slope-2" src="https://github.com/user-attachments/assets/6ef5dd7b-da81-4f87-a3a8-6d724373deea" />
<img width="1264" height="577" alt="CO 4D ppm slope-2" src="https://github.com/user-attachments/assets/d1d7955b-b757-4583-80f5-5e6325f44ca5" />

## 4D Axis Features:
<img width="750" alt="4dformullas" src="https://github.com/user-attachments/assets/7c5a1464-fcb9-4a8f-9693-c2c473f1ec1a" />

## 6) 4D Surface Diagram for MG811 Gases
<img width="1264" height="577" alt="CO2 4D ppm surface" src="https://github.com/user-attachments/assets/d75acaff-04df-4993-a111-f800c30b70cf" />
<img width="1264" height="577" alt="CH4 4D ppm surface" src="https://github.com/user-attachments/assets/012d06c4-94fd-477a-8145-9de40c7fa606" />
<img width="1264" height="577" alt="C2H5OH 4D ppm surface" src="https://github.com/user-attachments/assets/85bdd50e-40da-4b27-9a8d-6e3ee0082502" />
<img width="1264" height="577" alt="CO 4D ppm surface" src="https://github.com/user-attachments/assets/6d159e02-690c-4f70-a47c-bbb8b31cb5f3" />

## Ppm Formullas
| Gas    | EMF_min | EMF_max |
| ------ | ---------------- | ---------------- |
| CH₄    | 323.217          | 324.2145         |
| C₂H₅OH | 320.6234         | 323.616          |
| CO     | 264.1646         | 323.616          |
| CO₂    | 303.6658         | 324.2145         |
<img width="1264" height="757" alt="ppm1" src="https://github.com/user-attachments/assets/b5c17ad7-2ee6-44a4-b71a-f6689fdaf9a2" />
<img width="735" height="641" alt="ppm2" src="https://github.com/user-attachments/assets/55cb0b4f-fc95-4b1b-a341-86e7e5a99632" />
<img width="1264" height="517" alt="ppm3" src="https://github.com/user-attachments/assets/28ba36af-a4e6-4f64-ab67-1bc941609952" />
<img width="1264" height="676" alt="ppm4" src="https://github.com/user-attachments/assets/87acce1b-ab91-4c04-a5da-b11fdcb313dd" />
<img width="1264" height="738" alt="ppm5" src="https://github.com/user-attachments/assets/3af8d549-2d08-4757-8254-eb57059afd7b" />

## Check out all our DataScience libraries under the SpaceData series!

<b> "The first and only Arduino library series where Gas Sensors and Geiger Counter combine with Data Science"

| Library | Scope |
|---------|---------|
| <a href="https://github.com/abcdaaaaaaaaa/MQDataScience">MQDataScience  | MQ2, MQ3, MQ4, MQ5, MQ6, MQ7, MQ8, MQ9, MQ131_LOW, MQ131_HIGH, MQ135, MQ136, MQ137, MQ138, MQ214, MQ216, MQ303A, MQ303B, MQ306A, MQ307A, MQ309A Gas Sensors  |
| <a href="https://github.com/abcdaaaaaaaaa/TGSDataScience">TGSDataScience  | TGS2600, TGS2610, TGS2611 TGS2620, TGS2612, TGS2442, TGS2201, TGS4161, TGS8100, TGS813, TGS822, TGS2602, TGS6812 Gas Sensors |
| <a href="https://github.com/abcdaaaaaaaaa/MG811DataScience">MG811DataScience  | MG811 Gas Sensor  |
| <a href="https://github.com/abcdaaaaaaaaa/SP3S-AQ2DataScience">SP3S-AQ2DataScience  | SP3S-AQ2-01 Gas Sensor  |
| <a href="https://github.com/abcdaaaaaaaaa/RadioactiveDataScience">RadioactiveDataScience  | Geiger Counter  |

## For detailed explanation, You can also check out the github <a href="https://github.com/abcdaaaaaaaaa/MG811DataScience/wiki">Wiki Page!

## You can access the library's article <a href="https://www.spacepedia.info/MG811DataScience">Here!
