#pragma once

#include "./Arduino_GFX.h"
#include "../Arduino_TFT.h"

#define JD9613_TFTWIDTH 126
#define JD9613_TFTHEIGHT 294

#define JD9613_RST_DELAY 100    ///< delay ms wait for reset finish
#define JD9613_SLPIN_DELAY 120  ///< delay ms wait for sleep in finish
#define JD9613_SLPOUT_DELAY 120 ///< delay ms wait for sleep out finish

#define JD9613_NOP 0x00
#define JD9613_SWRESET 0x01
#define JD9613_RDDID 0x04
#define JD9613_RDDST 0x09

#define JD9613_SLPIN 0x10
#define JD9613_SLPOUT 0x11
#define JD9613_PTLON 0x12
#define JD9613_NORON 0x13

#define JD9613_INVOFF 0x20
#define JD9613_INVON 0x21
#define JD9613_DISPOFF 0x28
#define JD9613_DISPON 0x29

#define JD9613_CASET 0x2A
#define JD9613_RASET 0x2B
#define JD9613_RAMWR 0x2C
#define JD9613_RAMRD 0x2E

#define JD9613_PTLAR 0x30
#define JD9613_TELON 0x35
#define JD9613_MADCTL 0x36
#define JD9613_COLMOD 0x3A
#define JD9613_SCANLSET 0x44

#define JD9613_MADCTL_MY 0x80
#define JD9613_MADCTL_MX 0x40
#define JD9613_MADCTL_MV 0x20
#define JD9613_MADCTL_ML 0x10
#define JD9613_MADCTL_BGR 0x08
#define JD9613_MADCTL_MH 0x04
#define JD9613_MADCTL_RGB 0x00

static const uint8_t jd9613_init_operations[] = {
    BEGIN_WRITE,
    WRITE_C8_D8, 0xfe, 0x01,

    WRITE_COMMAND_8, 0xf7,
    WRITE_BYTES, 3, 0x96, 0x13, 0xa9,

    WRITE_C8_D8, 0x90, 0x01,

    WRITE_COMMAND_8, 0x2c,
    WRITE_BYTES, 14,
    0x19, 0x0b, 0x24, 0x1b,
    0x1b, 0x1b, 0xaa, 0x50,
    0x01, 0x16, 0x04, 0x04,
    0x04, 0xd7,

    WRITE_COMMAND_8, 0x2d,
    WRITE_BYTES, 3, 0x66, 0x56, 0x55,

    WRITE_COMMAND_8, 0x2e,
    WRITE_BYTES, 9,
    0x24, 0x04, 0x3f, 0x30,
    0x30, 0xa8, 0xb8, 0xb8,
    0x07,

    WRITE_COMMAND_8, 0x33,
    WRITE_BYTES, 12,
    0x03, 0x03, 0x03, 0x19,
    0x19, 0x19, 0x13, 0x13,
    0x13, 0x1a, 0x1a, 0x1a,

    WRITE_COMMAND_8, 0x10,
    WRITE_BYTES, 13,
    0x0b, 0x08, 0x64, 0xae,
    0x0b, 0x08, 0x64, 0xae,
    0x00, 0x80, 0x00, 0x00,
    0x01,

    WRITE_COMMAND_8, 0x11,
    WRITE_BYTES, 5,
    0x01, 0x1e, 0x01, 0x1e,
    0x00,

    WRITE_COMMAND_8, 0x03,
    WRITE_BYTES, 5,
    0x93, 0x1c, 0x00, 0x01,
    0x7e,

    WRITE_C8_D8, 0x19, 0x00,

    WRITE_COMMAND_8, 0x31,
    WRITE_BYTES, 6,
    0x1b, 0x00, 0x06, 0x05,
    0x05, 0x05,

    WRITE_COMMAND_8, 0x35,
    WRITE_BYTES, 4, 0x00, 0x80, 0x80, 0x00,

    WRITE_C8_D8, 0x12, 0x1b,

    WRITE_COMMAND_8, 0x1a,
    WRITE_BYTES, 8,
    0x01, 0x20, 0x00, 0x08,
    0x01, 0x06, 0x06, 0x06,

    WRITE_COMMAND_8, 0x74,
    WRITE_BYTES, 7,
    0xbd, 0x00, 0x01, 0x08,
    0x01, 0xbb, 0x98,

    WRITE_COMMAND_8, 0x6c,
    WRITE_BYTES, 9,
    0xdc, 0x08, 0x02, 0x01,
    0x08, 0x01, 0x30, 0x08,
    0x00,

    WRITE_COMMAND_8, 0x6d,
    WRITE_BYTES, 9,
    0xdc, 0x08, 0x02, 0x01,
    0x08, 0x02, 0x30, 0x08,
    0x00,

    WRITE_COMMAND_8, 0x76,
    WRITE_BYTES, 9,
    0xda, 0x00, 0x02, 0x20,
    0x39, 0x80, 0x80, 0x50,
    0x05,

    WRITE_COMMAND_8, 0x6e,
    WRITE_BYTES, 9,
    0xdc, 0x00, 0x02, 0x01,
    0x00, 0x02, 0x4f, 0x02,
    0x00,

    WRITE_COMMAND_8, 0x6f,
    WRITE_BYTES, 9,
    0xdc, 0x00, 0x02, 0x01,
    0x00, 0x01, 0x4f, 0x02,
    0x00,

    WRITE_COMMAND_8, 0x80,
    WRITE_BYTES, 7,
    0xbd, 0x00, 0x01, 0x08,
    0x01, 0xbb, 0x98,

    WRITE_COMMAND_8, 0x78,
    WRITE_BYTES, 9,
    0xdc, 0x08, 0x02, 0x01,
    0x08, 0x01, 0x30, 0x08,
    0x00,

    WRITE_COMMAND_8, 0x79,
    WRITE_BYTES, 9,
    0xdc, 0x08, 0x02, 0x01,
    0x08, 0x02, 0x30, 0x08,
    0x00,

    WRITE_COMMAND_8, 0x82,
    WRITE_BYTES, 9,
    0xda, 0x40, 0x02, 0x20,
    0x39, 0x00, 0x80, 0x50,
    0x05,

    WRITE_COMMAND_8, 0x7a,
    WRITE_BYTES, 9,
    0xdc, 0x00, 0x02, 0x01,
    0x00, 0x02, 0x4f, 0x02,
    0x00,

    WRITE_COMMAND_8, 0x7b,
    WRITE_BYTES, 9,
    0xdc, 0x00, 0x02, 0x01,
    0x00, 0x01, 0x4f, 0x02,
    0x00,

    WRITE_COMMAND_8, 0x84,
    WRITE_BYTES, 10,
    0x01, 0x00, 0x09, 0x19,
    0x19, 0x19, 0x19, 0x19,
    0x19, 0x19,

    WRITE_COMMAND_8, 0x85,
    WRITE_BYTES, 10,
    0x19, 0x19, 0x19, 0x03,
    0x02, 0x08, 0x19, 0x19,
    0x19, 0x19,

    WRITE_COMMAND_8, 0x20,
    WRITE_BYTES, 12,
    0x20, 0x00, 0x08, 0x00,
    0x02, 0x00, 0x40, 0x00,
    0x10, 0x00, 0x04, 0x00,

    WRITE_COMMAND_8, 0x1e,
    WRITE_BYTES, 12,
    0x40, 0x00, 0x10, 0x00,
    0x04, 0x00, 0x20, 0x00,
    0x08, 0x00, 0x02, 0x00,

    WRITE_COMMAND_8, 0x24,
    WRITE_BYTES, 12,
    0x20, 0x00, 0x08, 0x00,
    0x02, 0x00, 0x40, 0x00,
    0x10, 0x00, 0x04, 0x00,

    WRITE_COMMAND_8, 0x22,
    WRITE_BYTES, 12,
    0x40, 0x00, 0x10, 0x00,
    0x04, 0x00, 0x20, 0x00,
    0x08, 0x00, 0x02, 0x00,

    WRITE_COMMAND_8, 0x13,
    WRITE_BYTES, 3, 0x63, 0x52, 0x41,

    WRITE_COMMAND_8, 0x14,
    WRITE_BYTES, 3, 0x36, 0x25, 0x14,

    WRITE_COMMAND_8, 0x15,
    WRITE_BYTES, 3, 0x63, 0x52, 0x41,

    WRITE_COMMAND_8, 0x16,
    WRITE_BYTES, 3, 0x36, 0x25, 0x14,

    WRITE_COMMAND_8, 0x1d,
    WRITE_BYTES, 3, 0x10, 0x00, 0x00,

    WRITE_C8_D16, 0x2a, 0x0d, 0x07,

    WRITE_COMMAND_8, 0x27,
    WRITE_BYTES, 6,
    0x00, 0x01, 0x02, 0x03,
    0x04, 0x05,

    WRITE_COMMAND_8, 0x28,
    WRITE_BYTES, 6,
    0x00, 0x01, 0x02, 0x03,
    0x04, 0x05,

    WRITE_C8_D16, 0x26, 0x01, 0x01,
    WRITE_C8_D16, 0x86, 0x01, 0x01,
    WRITE_C8_D8, 0xfe, 0x02,

    WRITE_COMMAND_8, 0x16,
    WRITE_BYTES, 5,
    0x81, 0x43, 0x23, 0x1e,
    0x03,

    WRITE_C8_D8, 0xfe, 0x03,
    WRITE_C8_D8, 0x60, 0x01,

    WRITE_COMMAND_8, 0x61,
    WRITE_BYTES, 15,
    0x00, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x0d, 0x26,
    0x5a, 0x80, 0x80, 0x95,
    0xf8, 0x3b, 0x75,

    WRITE_COMMAND_8, 0x62,
    WRITE_BYTES, 15,
    0x21, 0x22, 0x32, 0x43,
    0x44, 0xd7, 0x0a, 0x59,
    0xa1, 0xe1, 0x52, 0xb7,
    0x11, 0x64, 0xb1,

    WRITE_COMMAND_8, 0x63,
    WRITE_BYTES, 11,
    0x54, 0x55, 0x66, 0x06,
    0xfb, 0x3f, 0x81, 0xc6,
    0x06, 0x45, 0x83,

    WRITE_COMMAND_8, 0x64,
    WRITE_BYTES, 15,
    0x00, 0x00, 0x11, 0x11,
    0x21, 0x00, 0x23, 0x6a,
    0xf8, 0x63, 0x67, 0x70,
    0xa5, 0xdc, 0x02,

    WRITE_COMMAND_8, 0x65,
    WRITE_BYTES, 15,
    0x22, 0x22, 0x32, 0x43,
    0x44, 0x24, 0x44, 0x82,
    0xc1, 0xf8, 0x61, 0xbf,
    0x13, 0x62, 0xad,

    WRITE_COMMAND_8, 0x66,
    WRITE_BYTES, 11,
    0x54, 0x55, 0x65, 0x06,
    0xf5, 0x37, 0x76, 0xb8,
    0xf5, 0x31, 0x6c,

    WRITE_COMMAND_8, 0x67,
    WRITE_BYTES, 15,
    0x00, 0x10, 0x22, 0x22,
    0x22, 0x00, 0x37, 0xa4,
    0x7e, 0x22, 0x25, 0x2c,
    0x4c, 0x72, 0x9a,

    WRITE_COMMAND_8, 0x68,
    WRITE_BYTES, 15,
    0x22, 0x33, 0x43, 0x44,
    0x55, 0xc1, 0xe5, 0x2d,
    0x6f, 0xaf, 0x23, 0x8f,
    0xf3, 0x50, 0xa6,

    WRITE_COMMAND_8, 0x69,
    WRITE_BYTES, 11,
    0x65, 0x66, 0x77, 0x07,
    0xfd, 0x4e, 0x9c, 0xed,
    0x39, 0x86, 0xd3,

    WRITE_C8_D8, 0xfe, 0x05,

    WRITE_COMMAND_8, 0x61,
    WRITE_BYTES, 15,
    0x00, 0x31, 0x44, 0x54,
    0x55, 0x00, 0x92, 0xb5,
    0x88, 0x19, 0x90, 0xe8,
    0x3e, 0x71, 0xa5,

    WRITE_COMMAND_8, 0x62,
    WRITE_BYTES, 15,
    0x55, 0x66, 0x76, 0x77,
    0x88, 0xce, 0xf2, 0x32,
    0x6e, 0xc4, 0x34, 0x8b,
    0xd9, 0x2a, 0x7d,

    WRITE_COMMAND_8, 0x63,
    WRITE_BYTES, 11,
    0x98, 0x99, 0xaa, 0x0a,
    0xdc, 0x2e, 0x7d, 0xc3,
    0x0d, 0x5b, 0x9e,

    WRITE_COMMAND_8, 0x64,
    WRITE_BYTES, 15,
    0x00, 0x31, 0x44, 0x54,
    0x55, 0x00, 0xa2, 0xe5,
    0xcd, 0x5c, 0x94, 0xcf,
    0x09, 0x4a, 0x72,

    WRITE_COMMAND_8, 0x65,
    WRITE_BYTES, 15,
    0x55, 0x65, 0x66, 0x77,
    0x87, 0x9c, 0xc2, 0xff,
    0x36, 0x6a, 0xec, 0x45,
    0x91, 0xd8, 0x20,

    WRITE_COMMAND_8, 0x66,
    WRITE_BYTES, 11,
    0x88, 0x98, 0x99, 0x0a,
    0x68, 0xb0, 0xfb, 0x43,
    0x8c, 0xd5, 0x0e,

    WRITE_COMMAND_8, 0x67,
    WRITE_BYTES, 15,
    0x00, 0x42, 0x55, 0x55,
    0x55, 0x00, 0xcb, 0x62,
    0xc5, 0x09, 0x44, 0x72,
    0xa9, 0xd6, 0xfd,

    WRITE_COMMAND_8, 0x68,
    WRITE_BYTES, 15,
    0x66, 0x66, 0x77, 0x87,
    0x98, 0x21, 0x45, 0x96,
    0xed, 0x29, 0x90, 0xee,
    0x4b, 0xb1, 0x13,

    WRITE_COMMAND_8, 0x69,
    WRITE_BYTES, 11,
    0x99, 0xaa, 0xba, 0x0b,
    0x6a, 0xb8, 0x0d, 0x62,
    0xb8, 0x0e, 0x54,

    WRITE_C8_D8, 0xfe, 0x07,
    WRITE_C8_D8, 0x3e, 0x00,
    WRITE_C8_D16, 0x42, 0x03, 0x10,
    WRITE_C8_D8, 0x4a, 0x31,
    WRITE_C8_D8, 0x5c, 0x01,

    WRITE_COMMAND_8, 0x3c,
    WRITE_BYTES, 6,
    0x07, 0x00, 0x24, 0x04,
    0x3f, 0xe2,

    WRITE_COMMAND_8, 0x44,
    WRITE_BYTES, 4, 0x03, 0x40, 0x3f, 0x02,

    WRITE_COMMAND_8, 0x12,
    WRITE_BYTES, 10,
    0xaa, 0xaa, 0xc0, 0xc8,
    0xd0, 0xd8, 0xe0, 0xe8,
    0xf0, 0xf8,

    WRITE_COMMAND_8, 0x11,
    WRITE_BYTES, 15,
    0xaa, 0xaa, 0xaa, 0x60,
    0x68, 0x70, 0x78, 0x80,
    0x88, 0x90, 0x98, 0xa0,
    0xa8, 0xb0, 0xb8,

    WRITE_COMMAND_8, 0x10,
    WRITE_BYTES, 15,
    0xaa, 0xaa, 0xaa, 0x00,
    0x08, 0x10, 0x18, 0x20,
    0x28, 0x30, 0x38, 0x40,
    0x48, 0x50, 0x58,

    WRITE_COMMAND_8, 0x14,
    WRITE_BYTES, 16,
    0x03, 0x1f, 0x3f, 0x5f,
    0x7f, 0x9f, 0xbf, 0xdf,
    0x03, 0x1f, 0x3f, 0x5f,
    0x7f, 0x9f, 0xbf, 0xdf,

    WRITE_COMMAND_8, 0x18,
    WRITE_BYTES, 12,
    0x70, 0x1a, 0x22, 0xbb,
    0xaa, 0xff, 0x24, 0x71,
    0x0f, 0x01, 0x00, 0x03,

    WRITE_C8_D8, 0xfe, 0x00,
    WRITE_C8_D8, 0x3a, 0x55,
    WRITE_C8_D8, 0xc4, 0x80,

    WRITE_C8_D8, 0x35, 0x00,
    WRITE_C8_D8, 0x53, 0x28,
    WRITE_C8_D8, 0x51, 0xff,

    WRITE_COMMAND_8, 0x11,
    END_WRITE,

    DELAY, JD9613_SLPOUT_DELAY,

    BEGIN_WRITE,
    WRITE_COMMAND_8, 0x29,
    END_WRITE,
    DELAY, JD9613_SLPOUT_DELAY};

class Arduino_JD9613 : public Arduino_TFT
{
public:
  Arduino_JD9613(Arduino_DataBus *bus, int8_t rst = GFX_NOT_DEFINED);

  bool begin(int32_t speed = GFX_NOT_DEFINED) override;
  void writeAddrWindow(int16_t x, int16_t y, uint16_t w, uint16_t h) override;
  void setRotation(uint8_t r) override;
  void invertDisplay(bool) override;
  void displayOn() override;
  void displayOff() override;

protected:
  void tftInit() override;

private:
};
