/**
 * @file      initSequence.cpp
 * @author    Lewis He (lewishe@outlook.com)
 * @license   MIT
 * @copyright Copyright (c) 2023  Shenzhen Xin Yuan Electronic Technology Co., Ltd
 * @date      2023-05-29
 *
 */

#include "initSequence.h"


const lcd_cmd_t sh8501_cmd[SH8501_INIT_SEQUENCE_LENGTH] = {

    // ===  CMD2 password  ===
    {0xfe, {0x20}, 0x01},
    {0xf4, {0x5a}, 0x01},
    {0xf5, {0x59}, 0x01},

    // ===  ID code  ===
    {0xfe, {0x40}, 0x01},
    {0xd8, {0x33}, 0x01},
    {0xd9, {0x06}, 0x01},
    {0xda, {0x00}, 0x01},

    // ===  QSPI setting  ===
    {0xfe, {0x20}, 0x01},
    {0x1a, {0x15}, 0x01},
    {0x19, {0x10}, 0x01},
    {0x1c, {0xa0}, 0x01},

    // ===  Timing Gen  ===
    {0xfe, {0x40}, 0x01},
    {0x01, {0x90}, 0x01},
    {0x02, {0x5c}, 0x01},
    {0x59, {0x01}, 0x01},
    {0x5a, {0x58}, 0x01},
    {0x5b, {0x08}, 0x01},
    {0x5c, {0x08}, 0x01},
    {0x70, {0x01}, 0x01},
    {0x71, {0x58}, 0x01},
    {0x72, {0x08}, 0x01},
    {0x73, {0x08}, 0x01},

    // ===  AOD setting===
    {0xfe, {0x40}, 0x01},
    {0x5d, {0x24}, 0x01},
    {0x60, {0x08}, 0x01},
    {0x61, {0x04}, 0x01},
    {0x62, {0x7f}, 0x01},
    {0x69, {0x06}, 0x01},
    {0x0c, {0xd7}, 0x01},
    {0x0d, {0xfc}, 0x01},
    {0x39, {0x24}, 0x01},
    {0x3d, {0x08}, 0x01},
    {0x47, {0x06}, 0x01},
    {0x6d, {0x04}, 0x01},
    {0x10, {0x11}, 0x01},
    {0x11, {0x09}, 0x01},

    // ===  Power Settings  ===
    {0xfe, {0xe0}, 0x01},
    {0x00, {0x14}, 0x01},
    {0x01, {0x01}, 0x01},
    {0x02, {0x00}, 0x01}, //{0x0200,{0x00},0x01},
    {0x04, {0x04}, 0x01},
    {0x06, {0x0f}, 0x01},
    {0x08, {0x00}, 0x01},
    {0x09, {0x14}, 0x01},
    {0x0a, {0x01}, 0x01},
    {0x0b, {0x00}, 0x01}, //{0x0b00,{0x00},0x01},
    {0x0c, {0x04}, 0x01},
    {0x0e, {0x0f}, 0x01},
    {0x0f, {0x00}, 0x01},
    {0x10, {0x14}, 0x01},
    {0x11, {0x10}, 0x01},
    {0x24, {0x00}, 0x01},
    {0x21, {0x99}, 0x01},
    {0x2d, {0x99}, 0x01},
    {0x32, {0x99}, 0x01},
    {0x26, {0x41}, 0x01},
    {0x22, {0x1a}, 0x01},
    {0x23, {0x13}, 0x01},
    {0x30, {0x01}, 0x01},
    {0xfe, {0x40}, 0x01},
    {0x57, {0x43}, 0x01}, //{0x5700,{0x43},0x01},
    {0x58, {0x33}, 0x01},
    {0x6e, {0x43}, 0x01}, //{0x6e00,{0x43},0x01},
    {0x6f, {0x33}, 0x01},
    {0x74, {0x43}, 0x01}, //{0x7400,{0x43},0x01},
    {0x75, {0x33}, 0x01},

    // // ===  swire setting for RT4722 ===
    // {0xfe,{0x40},0x01},
    // {0x12,{0xfe},0x01},
    // {0x13,{0x08},0x01},
    // {0xc9,{0x21},0x01},
    // {0x96,{0x00},0x01},
    // {0x97,{0x02},0x01},
    // {0xa5,{0xff},0x01},//{0xa500,{0xff},0x01},
    // {0xaa,{0x21},0x01},//{0xaa00,{0x21},0x01},
    // {0xab,{0x00},0x01},//{0xab00,{0x00},0x01},
    // {0x98,{0x00},0x01},
    // {0xa7,{0x21},0x01},
    // {0xa9,{0x00},0x01},

    // ===  swire setting for BV6802 ===
    {0xfe, {0x40}, 0x01},
    {0x12, {0xfe}, 0x01},
    {0x13, {0x08}, 0x01},
    {0xc9, {0x5f}, 0x01},
    {0x96, {0x38}, 0x01},
    {0x97, {0x02}, 0x01},
    {0xa5, {0xff}, 0x01},
    {0xaa, {0x38}, 0x01},
    {0xab, {0x5f}, 0x01},
    {0x98, {0x00}, 0x01},
    {0xa7, {0x38}, 0x01},
    {0xa9, {0x5f}, 0x01},

    //=== GOA mapping ===
    {0xfe, {0x70}, 0x01},
    {0x9b, {0x02}, 0x01},
    {0x9c, {0x03}, 0x01},
    {0x9d, {0x08}, 0x01},
    {0x9e, {0x19}, 0x01},
    {0x9f, {0x19}, 0x01},
    {0xa0, {0x19}, 0x01},
    {0xa2, {0x19}, 0x01},
    {0xa3, {0x19}, 0x01},
    {0xa4, {0x19}, 0x01},
    {0xa5, {0x19}, 0x01},
    {0xa6, {0x11}, 0x01},
    {0xa7, {0x10}, 0x01},
    {0xa9, {0x0f}, 0x01},
    {0xaa, {0x19}, 0x01},
    {0xab, {0x19}, 0x01},
    {0xac, {0x19}, 0x01},
    {0xad, {0x19}, 0x01},
    {0xae, {0x19}, 0x01},
    {0xaf, {0x19}, 0x01},
    {0xb0, {0x19}, 0x01},
    {0xb1, {0x19}, 0x01},
    {0xb2, {0x19}, 0x01},
    {0xb3, {0x19}, 0x01},
    {0xb4, {0x19}, 0x01},
    {0xb5, {0x19}, 0x01},
    {0xb6, {0x19}, 0x01},
    {0xb7, {0x19}, 0x01},
    {0xb8, {0x00}, 0x01},
    {0xb9, {0x01}, 0x01},
    {0xba, {0x09}, 0x01},
    {0xbb, {0x19}, 0x01},
    {0xbc, {0x19}, 0x01},
    {0xbd, {0xf9}, 0x01},
    {0xbe, {0x19}, 0x01},
    {0xbf, {0x19}, 0x01},
    {0xc0, {0x0e}, 0x01},
    {0xc1, {0x0d}, 0x01},
    {0xc2, {0x0c}, 0x01},
    {0xc3, {0x19}, 0x01},
    {0xc4, {0x19}, 0x01},
    {0xc5, {0x19}, 0x01},
    {0xc6, {0x19}, 0x01},
    {0xc7, {0x19}, 0x01},
    {0xc8, {0x19}, 0x01},

    // ===  source/mux sequence ===
    {0xfe, {0x40}, 0x01},
    {0x4c, {0x22}, 0x01},
    {0x53, {0xa0}, 0x01},
    {0x08, {0x0a}, 0x01},

    // ===  SD/SW_Toggle_Sequence_Control ===
    {0xfe, {0xf0}, 0x01},
    {0x72, {0x33}, 0x01},
    {0x73, {0x66}, 0x01},
    {0x74, {0x22}, 0x01},
    {0x75, {0x55}, 0x01},
    {0x76, {0x11}, 0x01},
    {0x77, {0x44}, 0x01},
    {0x78, {0x33}, 0x01},
    {0x79, {0x66}, 0x01},
    {0x7a, {0x22}, 0x01},
    {0x7b, {0x55}, 0x01},
    {0x7c, {0x11}, 0x01},
    {0x7d, {0x44}, 0x01},
    {0x7e, {0x66}, 0x01},
    {0x7f, {0x33}, 0x01},
    {0x80, {0x55}, 0x01},
    {0x81, {0x22}, 0x01},
    {0x82, {0x44}, 0x01},
    {0x83, {0x11}, 0x01},
    {0x84, {0x66}, 0x01},
    {0x85, {0x33}, 0x01},
    {0x86, {0x55}, 0x01},
    {0x87, {0x22}, 0x01},
    {0x88, {0x44}, 0x01},
    {0x89, {0x11}, 0x01},

    // === GIP Setting  ===
    {0xfe, {0x70}, 0x01},
    {0x00, {0xc0}, 0x01},
    {0x01, {0x08}, 0x01},
    {0x02, {0x02}, 0x01},
    {0x03, {0x00}, 0x01},
    {0x04, {0x00}, 0x01},
    {0x05, {0x01}, 0x01},
    {0x06, {0x28}, 0x01},
    {0x07, {0x28}, 0x01},
    {0x09, {0xc0}, 0x01},
    {0x0a, {0x08}, 0x01},
    {0x0b, {0x02}, 0x01},
    {0x0c, {0x00}, 0x01},
    {0x0d, {0x00}, 0x01},
    {0x0e, {0x00}, 0x01},
    {0x0f, {0x28}, 0x01},
    {0x10, {0x28}, 0x01},
    {0x12, {0xc0}, 0x01},
    {0x13, {0x08}, 0x01},
    {0x14, {0x02}, 0x01},
    {0x15, {0x00}, 0x01},
    {0x16, {0x00}, 0x01},
    {0x17, {0x01}, 0x01},
    {0x18, {0xd8}, 0x01},
    {0x19, {0x18}, 0x01},
    {0x1b, {0xc0}, 0x01},
    {0x1c, {0x08}, 0x01},
    {0x1d, {0x02}, 0x01},
    {0x1e, {0x00}, 0x01},
    {0x1f, {0x00}, 0x01},
    {0x20, {0x00}, 0x01},
    {0x21, {0xd8}, 0x01},
    {0x22, {0x18}, 0x01},
    {0x4c, {0x80}, 0x01},
    {0x4d, {0x00}, 0x01},
    {0x4e, {0x01}, 0x01},
    {0x4f, {0x00}, 0x01},
    {0x50, {0x01}, 0x01},
    {0x51, {0x01}, 0x01},
    {0x52, {0x01}, 0x01},
    {0x53, {0xc6}, 0x01},
    {0x54, {0x00}, 0x01},
    {0x55, {0x03}, 0x01},
    {0x56, {0x28}, 0x01},
    {0x58, {0x28}, 0x01},
    {0x65, {0x80}, 0x01},
    {0x66, {0x05}, 0x01},
    {0x67, {0x10}, 0x01},

    // === MUX Sequence Control ===
    {0xfe, {0xf0}, 0x01},
    {0xa3, {0x00}, 0x01},

    {0xfe, {0x70}, 0x01},
    {0x76, {0x00}, 0x01},
    {0x77, {0x00}, 0x01},
    {0x78, {0x05}, 0x01},
    {0x68, {0x08}, 0x01},
    {0x69, {0x08}, 0x01},
    {0x6a, {0x10}, 0x01},
    {0x6b, {0x08}, 0x01},
    {0x6c, {0x08}, 0x01},
    {0x6d, {0x08}, 0x01},

    {0xfe, {0xf0}, 0x01},
    {0xa9, {0x18}, 0x01},
    {0xaa, {0x18}, 0x01},
    {0xab, {0x18}, 0x01},
    {0xac, {0x18}, 0x01},
    {0xad, {0x18}, 0x01},
    {0xae, {0x18}, 0x01},

    {0xfe, {0x70}, 0x01},
    {0x93, {0x00}, 0x01},
    {0x94, {0x00}, 0x01},
    {0x96, {0x05}, 0x01},
    {0xdb, {0x08}, 0x01},
    {0xdc, {0x08}, 0x01},
    {0xdd, {0x10}, 0x01},
    {0xde, {0x08}, 0x01},
    {0xdf, {0x08}, 0x01},
    {0xe0, {0x08}, 0x01},
    {0xe7, {0x18}, 0x01},
    {0xe8, {0x18}, 0x01},
    {0xe9, {0x18}, 0x01},
    {0xea, {0x18}, 0x01},
    {0xeb, {0x18}, 0x01},
    {0xec, {0x18}, 0x01},

    // ===  Power on/off sequence Blank period control  ===
    {0xfe, {0x70}, 0x01},
    {0xd1, {0xf0}, 0x01},
    {0xd2, {0xff}, 0x01},
    {0xd3, {0xf0}, 0x01},
    {0xd4, {0xff}, 0x01},
    {0xd5, {0xa0}, 0x01},
    {0xd6, {0xaa}, 0x01},
    {0xd7, {0xf0}, 0x01},
    {0xd8, {0xff}, 0x01},

    // ===  Source  ===
    {0xfe, {0x40}, 0x01},
    {0x4d, {0xaa}, 0x01},
    {0x4e, {0x00}, 0x01},
    {0x4f, {0xa0}, 0x01},
    {0x50, {0x00}, 0x01},
    {0x51, {0xf3}, 0x01},
    {0x52, {0x23}, 0x01},
    {0x6b, {0xf3}, 0x01},
    {0x6c, {0x13}, 0x01},
    {0x8f, {0xff}, 0x01},
    {0x90, {0xff}, 0x01},
    {0x91, {0x3f}, 0x01},
    {0xa2, {0x10}, 0x01},
    {0x07, {0x21}, 0x01},
    {0x35, {0x81}, 0x01},

    // === gamma setting  ===
    {0xfe, {0x40}, 0x01},
    {0x33, {0x10}, 0x01},
    {0xfe, {0x50}, 0x01},
    {0xa9, {0x30}, 0x01},
    {0xaa, {0xb8}, 0x01},
    {0xab, {0x01}, 0x01},
    {0xfe, {0x60}, 0x01},
    {0xa9, {0x30}, 0x01},
    {0xaa, {0x90}, 0x01},
    {0xab, {0x01}, 0x01},

    //=== Watchedge ===
    {0xfe, {0x90}, 0x01},
    {0xa4, {0x16}, 0x01}, //{0xa400,{0x16},0x01},
    {0xa5, {0x16}, 0x01}, //{0xa500,{0x16},0x01},
    {0xa6, {0x00}, 0x01},
    {0xa7, {0x16}, 0x01}, //{0xa700,{0x16},0x01},
    {0xa9, {0x16}, 0x01}, //{0xa900,{0x16},0x01},
    {0xaa, {0x80}, 0x01},
    {0xab, {0x0f}, 0x01}, //{0xab00,{0x0f},0x01},
    {0xac, {0xff}, 0x01}, //{0xac00,{0xff},0x01},
    {0xae, {0x3f}, 0x01}, //{0xae00,{0x3f},0x01},

    {0x3f, {0x58}, 0x01},
    {0x40, {0xb4}, 0x01},
    {0x41, {0x29}, 0x01},

    //=== SCC ===
    {0xfe, {0x90}, 0x01},
    {0x51, {0x00}, 0x01},
    {0x52, {0x08}, 0x01},
    {0x53, {0x00}, 0x01},
    {0x54, {0x18}, 0x01},
    {0x55, {0x00}, 0x01},
    {0x56, {0x00}, 0x01},
    {0x57, {0x00}, 0x01},
    {0x58, {0x00}, 0x01},
    {0x59, {0x08}, 0x01},
    {0x5a, {0x00}, 0x01},
    {0x5b, {0x18}, 0x01},
    {0x5c, {0x00}, 0x01},
    {0x5d, {0x00}, 0x01},
    {0x5e, {0x80}, 0x01},
    {0x5f, {0x00}, 0x01},
    {0x60, {0x00}, 0x01},
    {0x61, {0x00}, 0x01},
    {0x62, {0x18}, 0x01},
    {0x63, {0x00}, 0x01},
    {0x64, {0x00}, 0x01},
    {0x65, {0x00}, 0x01},
    {0x66, {0x08}, 0x01},
    {0x67, {0x80}, 0x01},
    {0x68, {0x40}, 0x01},
    {0x69, {0x00}, 0x01},
    {0x6a, {0x00}, 0x01},
    {0x6b, {0x00}, 0x01},
    {0x6c, {0x00}, 0x01},
    {0x6d, {0x00}, 0x01},
    {0x6e, {0x00}, 0x01},
    {0x6f, {0x18}, 0x01},
    {0x70, {0x80}, 0x01},
    {0x71, {0x00}, 0x01},
    {0x72, {0x00}, 0x01},
    {0x73, {0x00}, 0x01},
    {0x74, {0x00}, 0x01},
    {0x75, {0x00}, 0x01},
    {0x76, {0x18}, 0x01},
    {0x77, {0x00}, 0x01},
    {0x78, {0x08}, 0x01},
    {0x79, {0x00}, 0x01},
    {0x7a, {0x00}, 0x01},
    {0x7b, {0x00}, 0x01},
    {0x7c, {0x00}, 0x01},
    {0x7d, {0x18}, 0x01},
    {0x7e, {0x00}, 0x01},
    {0x7f, {0x08}, 0x01},
    {0x80, {0x00}, 0x01},
    {0x81, {0x00}, 0x01},
    {0x82, {0x80}, 0x01},
    {0x83, {0x40}, 0x01},
    {0x84, {0x00}, 0x01},
    {0x85, {0x00}, 0x01},
    {0x86, {0x08}, 0x01},
    {0x87, {0x00}, 0x01},
    {0x88, {0x04}, 0x01},
    {0x89, {0x00}, 0x01},
    {0x8a, {0x18}, 0x01},
    {0x8b, {0x40}, 0x01},
    {0x8c, {0x00}, 0x01},
    {0x8d, {0x00}, 0x01},
    {0x8e, {0x00}, 0x01},
    {0x8f, {0x04}, 0x01},
    {0x90, {0x00}, 0x01},
    {0x91, {0x18}, 0x01},
    {0x92, {0x00}, 0x01},
    {0x93, {0x04}, 0x01},
    {0x94, {0x40}, 0x01},
    {0x95, {0x00}, 0x01},
    {0x96, {0x00}, 0x01},
    {0x97, {0x00}, 0x01},
    {0x98, {0x18}, 0x01},
    {0x99, {0x00}, 0x01},
    {0x9a, {0x04}, 0x01},
    {0x9b, {0x00}, 0x01},
    {0x9c, {0x04}, 0x01},
    {0x9d, {0x80}, 0x01},
    {0x9e, {0x40}, 0x01},
    {0x9f, {0x00}, 0x01},
    {0xa0, {0x00}, 0x01},
    {0xa2, {0x04}, 0x01},

    // === Power saving ===
    {0xfe, {0x70}, 0x01},
    {0x98, {0x74}, 0x01},
    {0xc9, {0x05}, 0x01},
    {0xca, {0x05}, 0x01},
    {0xcb, {0x05}, 0x01},
    {0xcc, {0x05}, 0x01},
    {0xcd, {0x05}, 0x01},
    {0xce, {0x85}, 0x01},
    {0xcf, {0x05}, 0x01},
    {0xd0, {0x45}, 0x01},

    {0xfe, {0xe0}, 0x01},
    {0x19, {0x42}, 0x01},
    {0x1e, {0x42}, 0x01},
    {0x1c, {0x41}, 0x01},
    {0x18, {0x00}, 0x01},
    {0x1b, {0x0c}, 0x01},
    {0x1a, {0x9a}, 0x01},
    {0x1d, {0xda}, 0x01},
    {0x28, {0x5f}, 0x01},

    {0xfe, {0x40}, 0x01},
    {0x54, {0xac}, 0x01},
    {0x55, {0xa0}, 0x01},
    {0x48, {0xaa}, 0x01},

    //======================== 194*368 setting ===========================
    {0xfe, {0x40}, 0x01},
    {0x76, {0x96}, 0x01},
    {0x77, {0xc2}, 0x01},
    {0x78, {0x8e}, 0x01},
    {0x79, {0xb3}, 0x01},
    {0x7a, {0x8d}, 0x01},
    {0x7b, {0x11}, 0x01},

    //======================== EDGE SETTING ===========================
    {0xfe, {0x20}, 0x01},
    {0x27, {0xC2}, 0x01},
    // {0xfe,{0x40},0x01},
    // {0xfe,{0x40},0x01},
    // {0x76,{0x01},0x01},

    /*******BIST Star**********///
    // CS0=0;SPI_WriteComm(0xFE);SPI_WriteData(0x90);CS0=1;Delay(10);
    // CS0=0;SPI_WriteComm(0xAA);SPI_WriteData(0x00);CS0=1;Delay(10);
    // CS0=0;SPI_WriteComm(0xFE);SPI_WriteData(0xD0);CS0=1;Delay(10);
    // CS0=0;SPI_WriteComm(0x4E);SPI_WriteData(0x80);CS0=1;Delay(10);
    // CS0=0;SPI_WriteComm(0x4D);SPI_WriteData(0x1F);CS0=1;Delay(10);// 02:Write 04:Red 08:Green 10:Blue
    // CS0=0;SPI_WriteComm(0xFE);SPI_WriteData(0x40);CS0=1;Delay(10);
    // CS0=0;SPI_WriteComm(0x54);SPI_WriteData(0xAF);CS0=1;Delay(10);
    // {0xFE,{0x90},0x01},
    // {0xAA,{0x00},0x01},
    // {0xFE,{0xD0},0x01},
    // {0x4E,{0x80},0x01},
    // {0x4D,{0x1F},0x01},
    // {0xFE,{0x40},0x01},
    // {0x54,{0xAF},0x01},

    /************BIST end***********///
    //=== CMD1 setting ===
    {0xfe, {0x00}, 0x01},
    {0xc4, {0x80}, 0x01},
    {0x3a, {0x55}, 0x01},
    {0x35, {0x00}, 0x01},
    {0x53, {0x20}, 0x01},
    {0x51, {AMOLED_DEFAULT_BRIGHTNESS}, 0x01},
    {0x63, {0xff}, 0x01},
    {0x2a, {0x00, 0x00, 0x00, 0xc1}, 0x04},
    {0x2b, {0x00, 0x00, 0x01, 0x6f}, 0x04},
    {0x11, {}, 0x80},
    {0x29, {}, 0x80},
};

const lcd_cmd_t rm67162_cmd[RM67162_INIT_SEQUENCE_LENGTH] = {
    {0xFE, {0x00}, 0x01}, //SET APGE 00H
    {0x11, {0x00}, 0x80}, // Sleep Out

    {0xFE, {0x05}, 0x01}, //SET APGE
    {0x05, {0x05}, 0x01}, //OVSS control set elvss -3.95v

    {0xFE, {0x01}, 0x01}, //SET APGE
    {0x73, {0x25}, 0x01}, //set OVSS voltage level.= -4.0V

    {0xFE, {0x00}, 0x01}, //SET APGE 00H
    // {0x44, {0x01, 0x66},0x02}, //Set_Tear_Scanline
    // {0x35, {0x00},        0x00}, //TE ON
    // {0x34, {0x00},        0x00}, //TE OFF
    // {0x36, {0x00},        0x01}, //Scan Direction Control
    {0x36, {0x60}, 0x01}, //
    {0x3A, {0x55}, 0x01}, // Interface Pixel Format 16bit/pixel
    // {0x3A, {0x66},        0x01}, //Interface Pixel Format    18bit/pixel
    // {0x3A, {0x77},        0x01}, //Interface Pixel Format    24bit/pixel
    {0x51, {0x00}, 0x01}, // Write Display Brightness MAX_VAL=0XFF
    {0x29, {0x00}, 0x80}, // Display on
    {0x51, {AMOLED_DEFAULT_BRIGHTNESS}, 0x01} // Write Display Brightness   MAX_VAL=0XFF
};

const lcd_cmd_t rm67162_spi_cmd[RM67162_INIT_SPI_SEQUENCE_LENGTH] = {
    {0xFE, {0x04}, 0x01}, //SET APGE3
    {0x6A, {0x00}, 0x01},
    {0xFE, {0x05}, 0x01}, //SET APGE4
    {0xFE, {0x07}, 0x01}, //SET APGE6
    {0x07, {0x4F}, 0x01},
    {0xFE, {0x01}, 0x01}, //SET APGE0
    {0x2A, {0x02}, 0x01},
    {0x2B, {0x73}, 0x01},
    {0xFE, {0x0A}, 0x01}, //SET APGE9
    {0x29, {0x10}, 0x01},
    {0xFE, {0x00}, 0x01},
    {0x51, {AMOLED_DEFAULT_BRIGHTNESS}, 0x01},
    {0x53, {0x20}, 0x01},
    {0x35, {0x00}, 0x01},

    {0x3A, {0x75}, 0x01}, // Interface Pixel Format 16bit/pixel
    {0xC4, {0x80}, 0x01},
    {0x11, {0x00}, 0x01 | 0x80},
    {0x29, {0x00}, 0x01 | 0x80},
};

const lcd_cmd_t rm690b0_cmd[RM690B0_INIT_SEQUENCE_LENGTH] = {
    {0xFE, {0x20}, 0x01},           //SET PAGE
    {0x26, {0x0A}, 0x01},           //MIPI OFF
    {0x24, {0x80}, 0x01},           //SPI write RAM
    {0x5A, {0x51}, 0x01},           //! 230918:SWIRE FOR BV6804
    {0x5B, {0x2E}, 0x01},           //! 230918:SWIRE FOR BV6804
    {0xFE, {0x00}, 0x01},           //SET PAGE
    {0x3A, {0x55}, 0x01},           //Interface Pixel Format    16bit/pixel
    {0xC2, {0x00}, 0x21},           //delay_ms(10);
    {0x35, {0x00}, 0x01},           //TE ON
    {0x51, {0x00}, 0x01},           //Write Display Brightness  MAX_VAL=0XFF
    {0x11, {0x00}, 0x80},           //Sleep Out delay_ms(120);
    {0x29, {0x00}, 0x20},           //Display on delay_ms(10);
    {0x51, {0xFF}, 0x01},           //Write Display Brightness  MAX_VAL=0XFF
};

const lcd_cmd_t jd9613_cmd[JD9613_INIT_SEQUENCE_LENGTH] = {
    {0xfe, {0x01}, 0x02},
    {0xf7, {0x96, 0x13, 0xa9}, 0x04},
    {0x90, {0x01}, 0x02},
    {0x2c, {0x19, 0x0b, 0x24, 0x1b, 0x1b, 0x1b, 0xaa, 0x50, 0x01, 0x16, 0x04, 0x04, 0x04, 0xd7}, 0x0f},
    {0x2d, {0x66, 0x56, 0x55}, 0x04},
    {0x2e, {0x24, 0x04, 0x3f, 0x30, 0x30, 0xa8, 0xb8, 0xb8, 0x07}, 0x0a},
    {0x33, {0x03, 0x03, 0x03, 0x19, 0x19, 0x19, 0x13, 0x13, 0x13, 0x1a, 0x1a, 0x1a}, 0x0d},
    {0x10, {0x0b, 0x08, 0x64, 0xae, 0x0b, 0x08, 0x64, 0xae, 0x00, 0x80, 0x00, 0x00, 0x01}, 0x0e},
    {0x11, {0x01, 0x1e, 0x01, 0x1e, 0x00}, 0x06},
    {0x03, {0x93, 0x1c, 0x00, 0x01, 0x7e}, 0x06},
    {0x19, {0x00}, 0x02},
    {0x31, {0x1b, 0x00, 0x06, 0x05, 0x05, 0x05}, 0x07},
    {0x35, {0x00, 0x80, 0x80, 0x00}, 0x05},
    {0x12, {0x1b}, 0x02},
    {0x1a, {0x01, 0x20, 0x00, 0x08, 0x01, 0x06, 0x06, 0x06}, 0x09},
    {0x74, {0xbd, 0x00, 0x01, 0x08, 0x01, 0xbb, 0x98}, 0x08},
    {0x6c, {0xdc, 0x08, 0x02, 0x01, 0x08, 0x01, 0x30, 0x08, 0x00}, 0x0a},
    {0x6d, {0xdc, 0x08, 0x02, 0x01, 0x08, 0x02, 0x30, 0x08, 0x00}, 0x0a},
    {0x76, {0xda, 0x00, 0x02, 0x20, 0x39, 0x80, 0x80, 0x50, 0x05}, 0x0a},
    {0x6e, {0xdc, 0x00, 0x02, 0x01, 0x00, 0x02, 0x4f, 0x02, 0x00}, 0x0a},
    {0x6f, {0xdc, 0x00, 0x02, 0x01, 0x00, 0x01, 0x4f, 0x02, 0x00}, 0x0a},
    {0x80, {0xbd, 0x00, 0x01, 0x08, 0x01, 0xbb, 0x98}, 0x08},
    {0x78, {0xdc, 0x08, 0x02, 0x01, 0x08, 0x01, 0x30, 0x08, 0x00}, 0x0a},
    {0x79, {0xdc, 0x08, 0x02, 0x01, 0x08, 0x02, 0x30, 0x08, 0x00}, 0x0a},
    {0x82, {0xda, 0x40, 0x02, 0x20, 0x39, 0x00, 0x80, 0x50, 0x05}, 0x0a},
    {0x7a, {0xdc, 0x00, 0x02, 0x01, 0x00, 0x02, 0x4f, 0x02, 0x00}, 0x0a},
    {0x7b, {0xdc, 0x00, 0x02, 0x01, 0x00, 0x01, 0x4f, 0x02, 0x00}, 0x0a},
    {0x84, {0x01, 0x00, 0x09, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19}, 0x0b},
    {0x85, {0x19, 0x19, 0x19, 0x03, 0x02, 0x08, 0x19, 0x19, 0x19, 0x19}, 0x0b},
    {0x20, {0x20, 0x00, 0x08, 0x00, 0x02, 0x00, 0x40, 0x00, 0x10, 0x00, 0x04, 0x00}, 0x0d},
    {0x1e, {0x40, 0x00, 0x10, 0x00, 0x04, 0x00, 0x20, 0x00, 0x08, 0x00, 0x02, 0x00}, 0x0d},
    {0x24, {0x20, 0x00, 0x08, 0x00, 0x02, 0x00, 0x40, 0x00, 0x10, 0x00, 0x04, 0x00}, 0x0d},
    {0x22, {0x40, 0x00, 0x10, 0x00, 0x04, 0x00, 0x20, 0x00, 0x08, 0x00, 0x02, 0x00}, 0x0d},
    {0x13, {0x63, 0x52, 0x41}, 0x04},
    {0x14, {0x36, 0x25, 0x14}, 0x04},
    {0x15, {0x63, 0x52, 0x41}, 0x04},
    {0x16, {0x36, 0x25, 0x14}, 0x04},
    {0x1d, {0x10, 0x00, 0x00}, 0x04},
    {0x2a, {0x0d, 0x07}, 0x03},
    {0x27, {0x00, 0x01, 0x02, 0x03, 0x04, 0x05}, 0x07},
    {0x28, {0x00, 0x01, 0x02, 0x03, 0x04, 0x05}, 0x07},
    {0x26, {0x01, 0x01}, 0x03},
    {0x86, {0x01, 0x01}, 0x03},
    {0xfe, {0x02}, 0x02},
    {0x16, {0x81, 0x43, 0x23, 0x1e, 0x03}, 0x06},
    {0xfe, {0x03}, 0x02},
    {0x60, {0x01}, 0x02},
    {0x61, {0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x0d, 0x26, 0x5a, 0x80, 0x80, 0x95, 0xf8, 0x3b, 0x75}, 0x10},
    {0x62, {0x21, 0x22, 0x32, 0x43, 0x44, 0xd7, 0x0a, 0x59, 0xa1, 0xe1, 0x52, 0xb7, 0x11, 0x64, 0xb1}, 0x10},
    {0x63, {0x54, 0x55, 0x66, 0x06, 0xfb, 0x3f, 0x81, 0xc6, 0x06, 0x45, 0x83}, 0x0c},
    {0x64, {0x00, 0x00, 0x11, 0x11, 0x21, 0x00, 0x23, 0x6a, 0xf8, 0x63, 0x67, 0x70, 0xa5, 0xdc, 0x02}, 0x10},
    {0x65, {0x22, 0x22, 0x32, 0x43, 0x44, 0x24, 0x44, 0x82, 0xc1, 0xf8, 0x61, 0xbf, 0x13, 0x62, 0xad}, 0x10},
    {0x66, {0x54, 0x55, 0x65, 0x06, 0xf5, 0x37, 0x76, 0xb8, 0xf5, 0x31, 0x6c}, 0x0c},
    {0x67, {0x00, 0x10, 0x22, 0x22, 0x22, 0x00, 0x37, 0xa4, 0x7e, 0x22, 0x25, 0x2c, 0x4c, 0x72, 0x9a}, 0x10},
    {0x68, {0x22, 0x33, 0x43, 0x44, 0x55, 0xc1, 0xe5, 0x2d, 0x6f, 0xaf, 0x23, 0x8f, 0xf3, 0x50, 0xa6}, 0x10},
    {0x69, {0x65, 0x66, 0x77, 0x07, 0xfd, 0x4e, 0x9c, 0xed, 0x39, 0x86, 0xd3}, 0x0c},
    {0xfe, {0x05}, 0x02},
    {0x61, {0x00, 0x31, 0x44, 0x54, 0x55, 0x00, 0x92, 0xb5, 0x88, 0x19, 0x90, 0xe8, 0x3e, 0x71, 0xa5}, 0x10},
    {0x62, {0x55, 0x66, 0x76, 0x77, 0x88, 0xce, 0xf2, 0x32, 0x6e, 0xc4, 0x34, 0x8b, 0xd9, 0x2a, 0x7d}, 0x10},
    {0x63, {0x98, 0x99, 0xaa, 0x0a, 0xdc, 0x2e, 0x7d, 0xc3, 0x0d, 0x5b, 0x9e}, 0x0c},
    {0x64, {0x00, 0x31, 0x44, 0x54, 0x55, 0x00, 0xa2, 0xe5, 0xcd, 0x5c, 0x94, 0xcf, 0x09, 0x4a, 0x72}, 0x10},
    {0x65, {0x55, 0x65, 0x66, 0x77, 0x87, 0x9c, 0xc2, 0xff, 0x36, 0x6a, 0xec, 0x45, 0x91, 0xd8, 0x20}, 0x10},
    {0x66, {0x88, 0x98, 0x99, 0x0a, 0x68, 0xb0, 0xfb, 0x43, 0x8c, 0xd5, 0x0e}, 0x0c},
    {0x67, {0x00, 0x42, 0x55, 0x55, 0x55, 0x00, 0xcb, 0x62, 0xc5, 0x09, 0x44, 0x72, 0xa9, 0xd6, 0xfd}, 0x10},
    {0x68, {0x66, 0x66, 0x77, 0x87, 0x98, 0x21, 0x45, 0x96, 0xed, 0x29, 0x90, 0xee, 0x4b, 0xb1, 0x13}, 0x10},
    {0x69, {0x99, 0xaa, 0xba, 0x0b, 0x6a, 0xb8, 0x0d, 0x62, 0xb8, 0x0e, 0x54}, 0x0c},
    {0xfe, {0x07}, 0x02},
    {0x3e, {0x00}, 0x02},
    {0x42, {0x03, 0x10}, 0x03},
    {0x4a, {0x31}, 0x02},
    {0x5c, {0x01}, 0x02},
    {0x3c, {0x07, 0x00, 0x24, 0x04, 0x3f, 0xe2}, 0x07},
    {0x44, {0x03, 0x40, 0x3f, 0x02}, 0x05},
    {0x12, {0xaa, 0xaa, 0xc0, 0xc8, 0xd0, 0xd8, 0xe0, 0xe8, 0xf0, 0xf8}, 0x0b},
    {0x11, {0xaa, 0xaa, 0xaa, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x98, 0xa0, 0xa8, 0xb0, 0xb8}, 0x10},
    {0x10, {0xaa, 0xaa, 0xaa, 0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x50, 0x58}, 0x10},
    {0x14, {0x03, 0x1f, 0x3f, 0x5f, 0x7f, 0x9f, 0xbf, 0xdf, 0x03, 0x1f, 0x3f, 0x5f, 0x7f, 0x9f, 0xbf, 0xdf}, 0x11},
    {0x18, {0x70, 0x1a, 0x22, 0xbb, 0xaa, 0xff, 0x24, 0x71, 0x0f, 0x01, 0x00, 0x03}, 0x0d},
    {0xfe, {0x00}, 0x02},
    {0x3a, {0x55}, 0x02},
    {0xc4, {0x80}, 0x02},
    {0x2a, {0x00, 0x00, 0x00, 0x7d}, 0x05},
    {0x2b, {0x00, 0x00, 0x01, 0x25}, 0x05},
    {0x35, {0x00}, 0x02},
    {0x53, {0x28}, 0x02},
    {0x51, {0xff}, 0x02},
    {0, {0}, 0xff},
};




