| #   | Example Code                                                                                                                   | Features                                                                                                          | Ideal For                                   |
|-----|-------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
| 1   | [GettingStartedProject.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/GettingStartedProject/GettingStartedProject.ino) | Introductory setup for PulseSensor and Arduino.<br>Basic hardware and library integration.                        | Beginners, first-time users                 |
| 2   | [Getting_BPM_to_Monitor.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/Getting_BPM_to_Monitor/Getting_BPM_to_Monitor.ino) | Real-time BPM monitoring on Serial Monitor.<br>Heartbeat alerts.<br>LED visualization on PIN 13.                   | Beginners, basic projects                   |
| 3   | [PulseSensor_ATtiny85_Serial.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_ATtiny85_Serial/PulseSensor_ATtiny85_Serial.ino) | PulseSensor use with ATtiny85, including serial communication.                                                    | Projects using ATtiny85, Serial communication |
| 4   | [PulseSensor_ATtiny85_noSerial.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_ATtiny85_noSerial/PulseSensor_ATtiny85_noSerial.ino) | PulseSensor with ATtiny85, no serial communication.                                                              | ATtiny85 based projects, simplicity focus   |
| 5   | [PulseSensor_BPM.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_BPM/PulseSensor_BPM.ino) | Standard BPM measurement setup with PulseSensor.                                                                 | Standard BPM tracking projects              |
| 6   | [PulseSensor_BPM_Alternative.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_BPM_Alternative/PulseSensor_BPM_Alternative.ino) | Alternative BPM measurement method.                                                                              | Alternative approaches, experimental setups |
| 7   | [PulseSensor_BPM_UNO_R4.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_BPM_UNO_R4/PulseSensor_BPM_UNO_R4.ino) | BPM setup for Arduino UNO R4.                                                                                   | Arduino UNO R4 specific projects            |
| 8   | [PulseSensor_BPM_UNO_R4_LEDmatrix_Heartbeat.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_BPM_UNO_R4_LEDmatrix_Heartbeat/PulseSensor_BPM_UNO_R4_LEDmatrix_Heartbeat.ino) | Heartbeat display on LED matrix using UNO R4.                                                                   | Visual heartbeat display projects           |
| 9   | [PulseSensor_BPM_UNO_R4_LEDmatrix_Plotter.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_BPM_UNO_R4_LEDmatrix_Plotter/PulseSensor_BPM_UNO_R4_LEDmatrix_Plotter.ino) | Plotting heartbeat data on LED matrix with UNO R4.                                                              | Advanced visualization, UNO R4 users        |
| 10  | [PulseSensor_DUE.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_DUE/PulseSensor_DUE.ino) | Demonstrates PulseSensor on Arduino DUE.                                                                        | Arduino DUE specific projects               |
| 11  | [PulseSensor_ESP32.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_ESP32/PulseSensor_ESP32.ino) | PulseSensor integration with ESP32 module.                                                                      | ESP32 advanced projects                     |
| 12  | [PulseSensor_Nucleo.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_Nucleo/PulseSensor_Nucleo.ino) | Using PulseSensor with Nucleo boards.                                                                           | Nucleo board specific applications          |
| 13  | [PulseSensor_PTT.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_PTT/PulseSensor_PTT.ino) | Pulse Transit Time example using two PulsleSensors | Measure pulse wave velocity with a correspoinding Processing sketch
| 14  | [PulseSensor_RP2040.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_RP2040/PulseSensor_RP2040.ino) | PulseSensor examples for RP2040 boards.                                                                         | RP2040 board projects                       |
| 15  | [PulseSensor_Servo.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_Servo/PulseSensor_Servo.ino) | Control a servo based on heart rate data.                                                                   | Hardware interaction, creative projects     |
| 16  | [PulseSensor_Speaker.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_Speaker/PulseSensor_Speaker.ino) | Audio feedback from heart rate data with a speaker.                                                             | Audio-interactive projects                  |
| 17  | [PulseSensor_nRF52.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_nRF52/PulseSensor_nRF52.ino) | PulseSensor with nRF52 series boards.                                                                           | nRF52 Bluetooth projects                    |
| 18  | [PulseSensor_nRF52840_Feather_Express.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/PulseSensor_nRF52840_Feather_Express/PulseSensor_nRF52840_Feather_Express.ino) | nRF52840 Feather Express board integration.                                                                     | BLE focused, nRF52840 Feather Express users |
| 19  | [SoftwareSerialDemo.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/SoftwareSerialDemo/SoftwareSerialDemo.ino) | Software serial communication with PulseSensor.                                                                 | Projects requiring software serial comms    |
| 20  | [TwoPulseSensors_On_OneArduino.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/TwoPulseSensors_On_OneArduino/TwoPulseSensors_On_OneArduino.ino) | Connecting two PulseSensors to a single Arduino.                                                                | Multi-sensor, complex data handling projects|
| 21  | [TwoPulseSensors_On_OneArduino_Alternative.ino](https://github.com/WorldFamousElectronics/PulseSensorPlayground/blob/master/examples/TwoPulseSensors_On_OneArduino_Alternative/TwoPulseSensors_On_OneArduino_Alternative.ino) | Alternative approach for using two PulseSensors with Arduino.                                                    | Experimental setups, alternative methods    |



Joel's Notes:
Best not to use underscores in the names of the code files, because some markdown interprets it as italic.

Getting BPM to Monitor.ino does use interrupts, and I think it is one point where the user experience breaks.

