#include "timersapi.hpp"
//================================================================timers================================================================//
//-----------------------------------------------------------------init-----------------------------------------------------------------//
timers::timers(unsigned int _del)
{
    del = _del;
    timersapi:start();
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//----------------------------------------------------------------control---------------------------------------------------------------//
void timers::start()
{
    run = 1;
    tmr = millis();
}
void timers::stop()
{
    run = 0;
}
void timers::setDel(unsigned int _del)
{
    del = _del;
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------get------------------------------------------------------------------//
unsigned int timers::getDel()
{
    return del;
}
bool timers::getTick()
{
    timers::tickApi();
    bool temp = is;
    is = 0;
    return temp;
}
bool timers::getOverflow()
{
    bool temp = offlag;
    offlag = 0;
    return temp;
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------api------------------------------------------------------------------//
void timers::tickApi()
{
    unsigned long time = millis();
    if(time - tmr >= del){
      if(!overflow && time > tmr)
      {
        is = 1;
        tmr = time;
      }
      if(!overflow && (unsigned long)(time + del) < tmr)
      {
        overflow = 1;
        tmr = (unsigned long)(time + del);
        offlag = 1;
      }
      if(time < tmr)
      {
        overflow = 0;
      }
    }else{
      is = 0;
    }
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//======================================================================================================================================//
//===============================================================counter================================================================//     
//-----------------------------------------------------------------init-----------------------------------------------------------------//
counts::counts(unsigned int _del, int _max)
{
    del = _del;
    max = _max;
    counts::start();
}
counts::counts(unsigned int _del, int _max, int _cnt)
{
    del = _del;
    max = _max;
    counter = _cnt;
    counts::start();
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//----------------------------------------------------------------control---------------------------------------------------------------//
void counts::stop()
{
    run = 0;
}
void counts::start()
{
    run = 1;
    tmr = millis();
}
void counts::setDel(unsigned int _del)
{
    del = _del;
}
void counts::setMax(int _max)
{
    max = _max;
}
void counts::setCounter(int _cnt)
{
    counter = _cnt;
}
void counts::setMode(int _dir, int _ofmode)
{
    dir = _dir;
    ofmode = _ofmode;
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------get------------------------------------------------------------------//
unsigned int counts::getDel()
{
    return del;
}
int counts::getCounter()
{
    counts:counterApi();
    return counter;
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------api------------------------------------------------------------------//
void counts::counterApi()
{
    unsigned long time = millis();
    if(time - tmr >= del){
      if(!overflow && time > tmr)
      {
        counts::count();
        tmr = time;
      }
      if(!overflow && (unsigned long)(time + del) < tmr)
      {
        overflow = 1;
        tmr = (unsigned long)(time + del);
        offlag = 1;
      }
      if(time < tmr)
      {
        overflow = 0;
      }
    }
    counts::overflowCheck();
}
void counts::count()
{
    if(dir == 1)
    {
        counter++;
    }
    if(dir == 0)
    {
        counter--;
    }
    if(dir == 1 && counter == max && ofmode == 1)
    {
        dir = 0;
    }
    if(dir == 1 && counter > max && ofmode == 0)
    {
        counter = 0;
    }
    if(dir == 0 && counter == 0 && ofmode == 1)
    {
        dir = 1;
    }
    if(dir == 0 && counter == 0 && ofmode == 0)
    {
        counter = max;
    }
}
void counts::overflowCheck()
{
    if(offlag)
    {
        counter++;
        offlag = 0;
    }
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//======================================================================================================================================//
//===============================================================counter================================================================//     
//-----------------------------------------------------------------init-----------------------------------------------------------------//
countdowns::countdowns(unsigned int _del, int _run)
{
    del = _del;
    run = _run;
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//----------------------------------------------------------------control---------------------------------------------------------------//
void countdowns::start()
{
    run = 1;
    tmr = millis();
}
void countdowns::stop()
{
    run = 0;
}
void countdowns::setDel(unsigned int _del)
{
    del = _del;
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------get------------------------------------------------------------------//
unsigned int countdowns::getDel()
{
    return del;
}
bool countdowns::counted()
{
    countdowns::countedApi();
    bool temp = is;
    is = 0;
    return temp;
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------api------------------------------------------------------------------//
void countdowns::countedApi()
{
    unsigned long time = millis();
    if(run && time - tmr >= del){
      is = 1;
      tmr = time;
      countdowns::stop();
    }else{
      is = 0;
    }
}
//--------------------------------------------------------------------------------------------------------------------------------------//
//======================================================================================================================================//
