[![Active](https://img.shields.io/badge/Project-Active-brightgreen.svg)](#)
[![Last Commit](https://img.shields.io/github/last-commit/VLPLAY-Games/Xeno-Language)](#)

[![Version](https://img.shields.io/badge/Version-0.1.4-lightgrey.svg)](#)
[![Platform](https://img.shields.io/badge/Platform-ESP32-orange.svg)](#)
[![Language](https://img.shields.io/badge/Language-C%2B%2B-brightgreen.svg)](#)
[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)

[![Arduino Library](https://www.ardu-badge.com/badge/Xeno-Language.svg?)](https://www.ardu-badge.com/Xeno%20Language)

[![Arduino Lint](https://github.com/VLPLAY-Games/Xeno-Language/actions/workflows/arduino-lint.yml/badge.svg)](https://github.com/VLPLAY-Games/Xeno-Language/actions/workflows/arduino-lint.yml)
[![cpplint](https://github.com/VLPLAY-Games/Xeno-Language/actions/workflows/cpplint.yml/badge.svg)](https://github.com/VLPLAY-Games/Xeno-Language/actions/workflows/cpplint.yml)

- [Read in Russian](README.ru.md) 
- [Read in English](README.md)

# Xeno Language

**Xeno Language** — ESP32（Arduino）エコシステム向けのコンパクトで安全なインタプリタ言語と仮想マシン。  
実装形態：**コンパイラ → バイトコード → VM**。数値、文字列、分岐、ループ、基本的なGPIO制御の組み込みコマンドを備えています。

**開発者：VL_PLAY Games**

---

## 🚀 クイックピッチ

✨ **ハイライト**
- `.xeno` ファイルまたは埋め込みソース文字列からコードを実行できます。  
- 軽量でほとんどのESP32プロジェクトへ簡単に組み込めます。  
- ホビイスト、教育、小規模オートメーション向けに設計されています。

⚡️ **パフォーマンス**
- ベンチマークでは、Xenoは同等のネイティブC++に対して概ね **約26倍遅い** と報告されています（ワークロードに依存）。詳細は `benchmark.ino` を参照してください。  
- MicroPythonやLuaなどの他のインタプリタ言語と比べても同程度のオーダーです — 正確な差はコードや使い方によって変わります。ワークロード固有の比較は `benchmark.ino` を使用してください。
### ⚔️ 言語パフォーマンス比較

| 機能 / 言語                  | **Xeno** 🧠       | **MicroPython** 🐍       | **Lua (NodeMCU)** 🌙    | **C++ (ネイティブ)** ⚙️     |
|-----------------------------|:-----------------:|:------------------------:|:----------------------:|:---------------------------:|
| 実行速度（C++比）           | ~26×遅い          | ~18×遅い *(概算)*        | ~20×遅い *(概算)*       | 🥇 基準                     |
| メモリ使用（RAM）           | 低（約20 KB）     | 中（約30 KB）            | 中（約25 KB）           | 高（手動管理）              |
| ファイル実行                | ✅ `.xeno` ファイル | ✅ `.py` ファイル        | ✅ `.lua` ファイル      | ⚠️ コンパイルのみ            |
| ハードウェアアクセス (GPIO等)| ⚠️ 基本（LEDのみ、開発中） | ✅ 豊富                 | ✅ 豊富                 | ✅ 完全                      |
| 組み込みやすさ              | ⭐️⭐️⭐️⭐️⭐️        | ⭐️⭐️⭐️⭐️               | ⭐️⭐️⭐️⭐️               | ⭐️⭐️                       |
| 言語の簡単さ                | ほどほど簡単       | 簡単                     | 中程度                  | 複雑                        |
| C++プロジェクトへの埋め込み | ✅ 完全に埋め込み可 | ⚠️ 制限あり（別ランタイム） | ⚠️ 制限あり（別ランタイム） | —                          |
| 理想的なユースケース         | 教育、簡単なロジック、アプリ内スクリプト | プロトタイピング、IoT | スクリプト自動化         | パフォーマンス重視          |

> ⚡ **注記:**  
> - **Xeno** の速度比は **ESP32-C3 @160 MHz** で計測されたものです。MicroPythonやLuaの値は概算で、ワークロードにより変動します。詳細は `benchmark.ino` を参照してください。  
> - **Xenoの利点:** 多くのESP32ワークフローでのMicroPythonやLuaと異なり、**Xenoは既存のC++ファームウェアに直接組み込めます** — 別のインタプリタ用ファームウェアは不要です。  
> - **GPIO注記:** 現在XenoのハードウェアアクセスはLED制御に限定されています。将来のアップデートで拡張予定です。

---

## システム要件

### ハードウェア
- 任意のESP32系マイクロコントローラ（ESP32、ESP32-S2など）  
- 推奨空きフラッシュ：**≥ 60 KB**  
- 推奨空きRAM：**≥ 20 KB**

### ソフトウェア
- ESP32 Arduino core: **3.2.0+**  
- Arduino IDE: **2.0+**

> 補足: 実際のメモリ使用量は有効化した機能、文字列、含めた例に依存します。プロジェクトでメモリが厳しい場合は、未使用機能を削り、設定ヘッダの `MAX_*` 値を減らしてください。

---

## クイックスタート

### インストール
**方法1: ライブラリマネージャ（推奨）**
- Arduino IDEで: ツール → ライブラリを管理...
- "Xeno Language"を検索
- 「インストール」をクリック

**方法2: 手動インストール**
- [リリースセクション](https://github.com/VLPLAY-Games/Xeno-Language/releases)から最新バージョンのライブラリをダウンロード
- Arduino IDEで: スケッチ → ライブラリをインクルード → .ZIP形式のライブラリをインストール...
- ダウンロードした `Xeno-Language-vX.X.X.zip` ファイルを選択

使用例は: ファイル → スケッチ例 → Xeno Language にあります

### 最小限の Arduino / ESP32 例
```cpp
#include <XenoLanguage.h>

XenoLanguage xeno;

void setup() {
  Serial.begin(115200);

  String program = R"(
    print "Hello from Xeno!"
    halt
  )";

  xeno.compile(program);
  xeno.run();
}

void loop() {
  // Optionally use xeno.step() for single-step execution or poll status
}
```

---

## 日本語

## 言語概要

### 基本コマンド
- `print "text"` — リテラル文字列を出力。  
- `print $var` — 変数の値を出力。  
- `set var expr` — 変数に代入（式をサポート）。  
- `input var` — Serial経由で入力を要求（文字列、数値、ブール値として保存）。  
- `halt` — プログラム実行を停止。  
- `led <pin> on|off` — 許可されたGPIOピンを切り替え。  
- `delay <ms>` — ミリ秒単位で待機（上限あり）。  
- 算術演算子: `+`, `-`, `*`, `/`, `%`, `^` (累乗)。  
- 関数: `abs()`, `sqrt()`, `sin()`, `cos()`, `tan()`, `max()`, `min()`。  
- 定数: `M_PI`, `M_E`, `M_TAU`, `M_SQRT2`, `M_SQRT3`, `P_LIGHT_SPEED`。  
- 制御フロー: `if ... then ... else ... endif`, `for var = start to end ... endfor`。  
- ブール値: `true`, `false`。  
- 一行コメントは `//`。

### クイック構文スニペット
```
// Comments
print "Hello World"
led 13 on
delay 1000

// Variables
set x 10
set name "Xeno"
set flag true
print $x
print $flag

// Arithmetic
set result (x + 5) * 2

// Conditionals
if x > 5 then
print "Larger than 5"
endif

// Loops
for i = 1 to 10
print $i
endfor

// Boolean operations
set a true
set b false
if a == true then
print "a is true"
endif
```

### 演算 & 比較
- 算術: `+ - * / % ^`, `abs()`, `sqrt()`, `sin()`, `cos()`, `tan()`, `max()`, `min()`  
- 定数: `M_PI`, `M_E`, `M_TAU`, `M_SQRT2`, `M_SQRT3`, `P_LIGHT_SPEED`
- 比較: `== != < > <= >=`  
- 制御: `if/then/else/endif`, `for/endfor`  
- 周辺機能: `print`, `led on/off`, `delay`
- データ型: 整数、浮動小数点数、文字列、ブール値

---

## 仮想マシン（VM）

* コンパイル済みバイトコードをランタイムスタック、変数テーブル、文字列テーブルを使って実行。
* 組み込み安全チェック：スタックオーバーフロー、無効オペコード、ゼロ除算、境界チェック。
* API（`class XenoLanguage`）:

  * `bool compile(const String& source)` — ソースをバイトコードにコンパイル。
  * `bool run()` — コンパイル済みバイトコードを実行。
  * `void step()` — 単一のVM命令を実行。
  * `void stop()` — 実行を停止。
  * `bool isRunning() const` — 実行中か確認。
  * `void printCompiledCode()` — バイトコード＋文字列テーブル／デバッグ情報を出力。
  * `void setMaxInstructions(uint32_t max_instr)` — 命令上限を設定。

  * `setStringLimit(256)`           // 最大文字列長  
  * `setVariableNameLimit(32)`      // 変数名の最大長  
  * `setExpressionDepth(32)`        // 式ネストの最大深さ  
  * `setLoopDepth(16)`              // ループネストの最大深さ  
  * `setIfDepth(16)`                // if/else ネストの最大深さ  
  * `setStackSize(256)`             // スタックメモリサイズ  

  * `setAllowedPins({2,3,13})`      // 許可ピン設定  
  * `addAllowedPin(5)`              // ピン追加  
  * `removeAllowedPin(13)`          // ピン削除  

  * `compile_and_run("print 'Hello World'")` — コンパイル+即実行のラッパー。

  * バージョン取得:  
    `getLanguageVersion()`。

---

## セキュリティ & 制限

### デフォルト設定

* `max_string_length = 256`
* `max_variable_name_length = 32`
* `max_expression_depth = 32`
* `max_loop_depth = 16`
* `max_if_depth = 16`
* `max_stack_size = 256`
* `current_max_instructions = 10000`
* `allowed_pins = { LED_BUILTIN }`

### 最小／最大境界

* `MIN_STRING_LENGTH = 1`, `MAX_STRING_LENGTH_LIMIT = 4096`
* `MIN_VARIABLE_NAME_LENGTH = 1`, `MAX_VARIABLE_NAME_LENGTH_LIMIT = 256`
* `MIN_EXPRESSION_DEPTH = 1`, `MAX_EXPRESSION_DEPTH_LIMIT = 256`
* `MIN_LOOP_DEPTH = 1`, `MAX_LOOP_DEPTH_LIMIT = 64`
* `MIN_IF_DEPTH = 1`, `MAX_IF_DEPTH_LIMIT = 64`
* `MIN_STACK_SIZE = 16`, `MAX_STACK_SIZE_LIMIT = 2048`
* `MIN_INSTRUCTIONS_LIMIT = 1000`, `MAX_INSTRUCTIONS_LIMIT = 1000000`
* `MIN_PIN_NUMBER = 0`, `MAX_PIN_NUMBER = 255`

> setterは境界外の値を拒否します。

---

## バイトコード / オペコード（概要）

一般的なVMオペコード例：
```
OP_NOP, OP_PRINT, OP_PRINT_NUM, OP_PUSH, OP_POP,
OP_ADD, OP_SUB, OP_MUL, OP_DIV, OP_MOD,
OP_POW, OP_ABS, OP_SQRT, OP_MAX, OP_MIN,
OP_SIN, OP_COS, OP_TAN,
OP_STORE, OP_LOAD,
OP_JUMP, OP_JUMP_IF,
OP_INPUT, OP_DELAY, OP_LED_ON, OP_LED_OFF,
OP_PUSH_FLOAT, OP_PUSH_STRING, OP_PUSH_BOOL,
OP_EQ, OP_NEQ, OP_LT, OP_GT, OP_LTE, OP_GTE,
OP_HALT
```


---

## 例 & ベンチマーク
リポジトリの `examples/` を参照:
- `comparison.ino` — if/else と比較の例。  
- `float_string.ino` — 浮動小数点と文字列処理。  
- `for_loop.ino` — ループと点滅の例。  
- `input_max_min.ino` — 入力処理 + 数学関数。  
- `math.ino`, `math2.ino` — 数学テストとベンチ。  
- `benchmark.ino` — ネイティブC++とXeno VMの性能比較。
- `bool.ino` — ブール変数と演算。

---

## デバッグのヒント
- ログと入力プロンプトのために常に Serial (115200) を開いてください。  
- `CRITICAL ERROR: Stack overflow` が出たら、式の複雑さを減らすか慎重に `MAX_STACK_SIZE` を増やしてください。  
- GPIOコマンドが失敗する場合は、`xeno_security.h` の許可ピンリストを確認してください。  
- コンパイル済みバイトコードのデバッグには `printCompiledCode()` を使用してください。

---

## ロードマップ & 今後の予定
🎯 今後の予定:
- コア機能の継続的な開発。  
- 最適化の改善とVMオーバーヘッドの削減。  
- **XenoOS** との統合強化と `.xeno` 編集用の良いツール群の提供。  
- 追加の例、CIパイプライン、PlatformIOテンプレートの追加。

---

## コントリビュート
貢献、問題報告、プルリクエストは歓迎します。貢献する際は:
- Apache 2.0 ライセンスを尊重し、明確なコミットメッセージを付けてください。  
- テスト／例を含む小さく焦点の定まったPRを送ってください。

---

## ライセンス
このプロジェクトは **Apache License 2.0** の下でライセンスされています。詳細は `LICENSE` ファイルを参照してください。

**Xeno Language** — 開発: **VL_PLAY Games**.
