[![Version](https://img.shields.io/badge/Version-0.1.2-lightgrey.svg)](#)
[![Platform](https://img.shields.io/badge/Platform-ESP32-orange.svg)](#)
[![Language](https://img.shields.io/badge/Language-C%2B%2B-brightgreen.svg)](#)
[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)

- [Read in English](README.md) 
- [Read in Japanese](README.ja.md)

# Xeno Language

**Xeno Language** — компактный, безопасный интерпретируемый язык и виртуальная машина для экосистемы **ESP32 (Arduino)**.  
Реализовано как: **компилятор → байткод → VM** с встроенными командами для чисел, строк, ветвлений, циклов и базового управления GPIO.

**Разработчик: VL_PLAY Games**

---

## 🚀 Краткое описание

✨ **Основные моменты**
- Выполнение кода из файлов `.xeno` или из встроенных строк с исходным кодом.  
- Лёгкий и легко встраиваемый практически в любой проект на ESP32.  
- Разработан для хобби, образования и простых задач автоматизации.

⚡️ **Производительность**
- По бенчмаркам Xeno примерно **~26× медленнее, чем эквивалентный нативный C++**, в зависимости от нагрузки (см. `benchmark.ino`).  
- По сравнению с другими интерпретируемыми языками для MCU (MicroPython, Lua), производительность Xeno находится в том же диапазоне — точные различия зависят от типа кода и сценария использования. Используйте `benchmark.ino` для сравнений по конкретной нагрузке.
### ⚔️ Сравнение производительности языков

| Функция / Язык              | **Xeno** 🧠       | **MicroPython** 🐍       | **Lua (NodeMCU)** 🌙    | **C++ (Нативный)** ⚙️     |
|-----------------------------|:-----------------:|:------------------------:|:----------------------:|:-------------------------:|
| Скорость выполнения (vs C++)| ~26× медленнее    | ~18× медленнее *(прибл.)*| ~20× медленнее *(прибл.)*| 🥇 Базовый уровень         |
| Использование памяти (RAM)  | Низкое (~20 KB)   | Среднее (~30 KB)         | Среднее (~25 KB)        | Высокий контроль (ручной) |
| Работа с файлами            | ✅ `.xeno` файлы   | ✅ `.py` файлы           | ✅ `.lua` файлы         | ⚠️ Только компиляция       |
| Доступ к железу (GPIO и т.д)| ⚠️ Базовый (только LED, в разработке) | ✅ Богатый | ✅ Богатый | ✅ Полный |
| Удобство встраивания        | ⭐️⭐️⭐️⭐️⭐️        | ⭐️⭐️⭐️⭐️               | ⭐️⭐️⭐️⭐️               | ⭐️⭐️                     |
| Простота языка              | Умеренно простой  | Простой                 | Умеренно               | Сложный                   |
| Встраивание в C++ проекты   | ✅ Полностью встраиваемый | ⚠️ Ограничено (отдельный рантайм) | ⚠️ Ограничено (отдельный рантайм) | — |
| Идеальные случаи использования | Обучение, быстрая логика, скрипты внутри приложения | Прототипирование, IoT | Сценарии автоматизации | Критичные по производительности задачи |

> ⚡ **Примечания:**  
> - Соотношения скорости для **Xeno** измерялись на **ESP32-C3 @160 MHz**. Значения для MicroPython и Lua приведены приблизительно и будут меняться в зависимости от нагрузки. См. `benchmark.ino` для деталей.  
> - **Преимущество Xeno:** в отличие от MicroPython или Lua в большинстве ESP32 рабочих процессов, **Xeno можно встроить прямо в существующую C++-прошивку** — отдельная прошивка интерпретатора не требуется.  
> - **Замечание по GPIO:** доступ к железу в Xeno в настоящее время ограничен управлением LED. Расширение планируется в будущих обновлениях.

---

## Системные требования

### Аппаратное обеспечение
- Любой микроконтроллер класса ESP32 (ESP32, ESP32‑S2 и т.д.)  
- Рекомендуемый свободный Flash: **≥ 60 KB**  
- Рекомендуемый свободный RAM: **≥ 20 KB**

### Программное обеспечение
- ESP32 Arduino core: **3.2.0+**  
- Arduino IDE: **2.0+**

> Примечание: фактическое использование памяти зависит от включённых функций, строк и примеров. Если у вас мало памяти, удалите неиспользуемые функции и уменьшите значения `MAX_*` в конфигурационных заголовках.

---

## Быстрый старт

### Установка
- Скачайте последнюю версию библиотеки из [раздела Releases](https://github.com/VLPLAY-Games/Xeno-Language/releases)
- В Arduino IDE: Скетч → Подключить библиотеку → Добавить .ZIP библиотеку...
- Выберите скачанный файл `Xeno-Language-vX.X.X.zip`

Примеры использования находятся в меню: Файл → Примеры → Xeno Language

### Минимальный пример для Arduino / ESP32
```cpp
#include <XenoLanguage.h>

XenoLanguage xeno;

void setup() {
  Serial.begin(115200);

  String program = R"(
    print "Hello from Xeno!"
    halt
  )";

  xeno.compile(program);
  xeno.run();
}

void loop() {
  // Optionally use xeno.step() for single-step execution or poll status
}
```

---

## Обзор языка

### Базовые команды
- `print "text"` — выводит текстовую строку.  
- `print $var` — выводит значение переменной.  
- `set var expr` — присваивает переменную (поддерживает выражения).  
- `input var` — запрашивает ввод через Serial (сохраняется как строка, число или булево значение).  
- `halt` — останавливает выполнение программы.  
- `led <pin> on|off` — переключает разрешённый GPIO-пин.  
- `delay <ms>` — задержка в миллисекундах (с ограничением).  
- Стек и арифметика: `add`, `sub`, `mul`, `div`, `mod`, `abs`, `pow`, `sqrt`, `max`, `min`.  
- Управление потоком: `if ... then ... else ... endif`, `for var = start to end ... endfor`.  
- Булевы значения: `true`, `false`.  
- Однострочные комментарии: `//`.

### Быстрые примеры синтаксиса
```
// Комментарии
print "Hello World"
led 13 on
delay 1000

// Переменные
set x 10
set name "Xeno"
set flag true
print $x
print $flag

// Арифметика
set result (x + 5) * 2

// Условия
if x > 5 then
print "More than 5"
endif

// Циклы
for i = 1 to 10
print $i
endfor

// Булевы операции
set a true
set b false
if a == true then
print "a is true"
endif
```

### Операции и сравнения
- Арифметика: `+ - * / % ^`, `abs()`, `sqrt()`, `max()`, `min()`  
- Сравнения: `== != < > <= >=` 
- Управление: `if/then/else/endif`, `for/endfor`  
- Периферийные команды: `print`, `led on/off`, `delay`  
- Типы данных: целые числа, числа с плавающей точкой, строки, булевы значения

---

## Виртуальная машина (VM)

- Выполняет скомпилированный байткод с использованием runtime-стека, таблицы переменных и таблицы строк.  
- Встроенные проверки безопасности (переполнение стека, неверная операция, деление на ноль, проверка границ).  
- Основные API (класс `Xeno`):
  - `bool compile(const String& source)` — компиляция исходника в байткод.  
  - `bool run()` — выполнение скомпилированного байткода.  
  - `void step()` — выполнение одной инструкции VM.  
  - `void stop()` — останов выполнения.  
  - `bool isRunning() const` — проверка состояния выполнения.  
  - `void printCompiledCode()` — вывод байткода и таблицы строк / отладочной информации.  
  - `void setMaxInstructions(uint32_t max_instr)` - увеличение лимита инструкций VM
  - Получение информации/версий: `getLanguageVersion()`, `getCompilerVersion()`, `getVMVersion()`.

---

## Байткод / Операнды (кратко)

Типичные опкоды VM включают:
```
OP_NOP, OP_PRINT, OP_PRINT_NUM, OP_PUSH, OP_POP,
OP_ADD, OP_SUB, OP_MUL, OP_DIV, OP_MOD,
OP_POW, OP_ABS, OP_SQRT, OP_MAX, OP_MIN,
OP_STORE, OP_LOAD,
OP_JUMP, OP_JUMP_IF,
OP_INPUT, OP_DELAY, OP_LED_ON, OP_LED_OFF,
OP_PUSH_FLOAT, OP_PUSH_STRING, OP_PUSH_BOOL,
OP_EQ, OP_NEQ, OP_LT, OP_GT, OP_LTE, OP_GTE,
OP_HALT
```

---

## Безопасность и ограничения

Чтобы защитить ESP32 и избежать сбоев во время выполнения, Xeno накладывает консервативные ограничения:
- `MAX_STRING_LENGTH` (256)  
- `MAX_VARIABLE_NAME_LENGTH` (32)  
- `MAX_EXPRESSION_DEPTH` (32)  
- `MAX_LOOP_DEPTH`, `MAX_IF_DEPTH` (16)  
- `MAX_STACK_SIZE` (256)  
- Разрешённые GPIO-пины ограничены и определены в `xeno_security.h` — попытки управления неразрешёнными пинами блокируются.  
- Проверка байткода выполняется на этапе компиляции/загрузки.

---

## Примеры и бенчмарки
Смотрите `examples/` в репозитории:
- `comparison.ino` — примеры с if/else и сравнениями.  
- `float_string.ino` — работа с float и строками.  
- `for_loop.ino` — циклы и примеры мигания.  
- `input_max_min.ino` — ввод и математические функции.  
- `math.ino`, `math2.ino` — математические тесты и бенчмарки.  
- `benchmark.ino` — сравнительный тест производительности между нативным C++ и Xeno VM.
- `bool.ino` — работа с булевыми переменными.

---

## Советы по отладке
- Всегда открывайте Serial (115200) для логов и ввода.  
- Если появляется `CRITICAL ERROR: Stack overflow`, уменьшите сложность выражений или осторожно увеличьте `MAX_STACK_SIZE`.  
- Если команды GPIO не работают — проверьте список разрешённых пинов в `xeno_security.h`.  
- Используйте `printCompiledCode()` для отладки скомпилированного байткода.

---

## Планы
🎯 Планируемые шаги:
- Продолжить активную разработку ядра.  
- Улучшить оптимизации и уменьшить накладные расходы VM.  
- Добавить интеграцию с **XenoOS** и улучшенные инструменты для редактирования `.xeno` файлов.  
- Добавить больше примеров, CI-пайплайнов и шаблонов для PlatformIO.

---

## Участие в проекте
Вклады, проблемы и pull request'ы приветствуются. При внесении изменений:
- Соблюдайте лицензию Apache 2.0 и добавляйте понятные сообщения к коммитам.  
- Делайте небольшие, сфокусированные PR с тестами/примером, когда это возможно.

---

## Лицензия
Проект лицензирован под **Apache License 2.0**. Подробнее см. файл `LICENSE`.

**Xeno Language** — разработчик: **VL_PLAY Games**.
