/*
 * =============================================================================
 *
 *       Filename:  UTF8ToGB2312.h
 *
 *    Description:  Converts UTF-8 string to GB2312 string in Arduino(GB2312 library is included).
 *
 *        Version:  1.1.52
 *        Created:  2023-09-23 14:17:34
 *
 *         Author:  Tika Flow
 *
 * =============================================================================
 */

/* ---------------------------------------------------------------------------*
 *                      include head files
 *----------------------------------------------------------------------------*/
#include <Arduino.h>

#ifndef UTF8_TO_GB2312_H
#define UTF8_TO_GB2312_H
/* ---------------------------------------------------------------------------*
 *                        macro define
 *----------------------------------------------------------------------------*/
#define MAXLENGTH 256

#ifdef __cplusplus
extern "C"{
#endif /* __cplusplus */

typedef unsigned int ucs4_t;

typedef struct {
    unsigned short indx; /* index into big table */
    unsigned short used; /* bitmask of used entries */
} Summary16;

typedef struct {
    ucs4_t unicode;
    int bytes;
} Unibytes;

#if !defined(NULL)
#define NULL ((void *)0)
#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */

static const unsigned short gb2312_2charset[7445] PROGMEM = {
        0x2168,
        0x216c,
        0x2127,
        0x2163,
        0x2140,
        0x2141,
        0x2824,
        0x2822,
        0x2828,
        0x2826,
        0x283a,
        0x282c,
        0x282a,
        0x2830,
        0x282e,
        0x2142,
        0x2834,
        0x2832,
        0x2839,
        0x2821,
        0x2825,
        0x2827,
        0x2829,
        0x282d,
        0x2831,
        0x2823,
        0x282b,
        0x282f,
        0x2833,
        0x2835,
        0x2836,
        0x2837,
        0x2838,
        0x2126,
        0x2125,
        0x2621,
        0x2622,
        0x2623,
        0x2624,
        0x2625,
        0x2626,
        0x2627,
        0x2628,
        0x2629,
        0x262a,
        0x262b,
        0x262c,
        0x262d,
        0x262e,
        0x262f,
        0x2630,
        0x2631,
        0x2632,
        0x2633,
        0x2634,
        0x2635,
        0x2636,
        0x2637,
        0x2638,
        0x2641,
        0x2642,
        0x2643,
        0x2644,
        0x2645,
        0x2646,
        0x2647,
        0x2648,
        0x2649,
        0x264a,
        0x264b,
        0x264c,
        0x264d,
        0x264e,
        0x264f,
        0x2650,
        0x2651,
        0x2652,
        0x2653,
        0x2654,
        0x2655,
        0x2656,
        0x2657,
        0x2658,
        0x2727,
        0x2721,
        0x2722,
        0x2723,
        0x2724,
        0x2725,
        0x2726,
        0x2728,
        0x2729,
        0x272a,
        0x272b,
        0x272c,
        0x272d,
        0x272e,
        0x272f,
        0x2730,
        0x2731,
        0x2732,
        0x2733,
        0x2734,
        0x2735,
        0x2736,
        0x2737,
        0x2738,
        0x2739,
        0x273a,
        0x273b,
        0x273c,
        0x273d,
        0x273e,
        0x273f,
        0x2740,
        0x2741,
        0x2751,
        0x2752,
        0x2753,
        0x2754,
        0x2755,
        0x2756,
        0x2758,
        0x2759,
        0x275a,
        0x275b,
        0x275c,
        0x275d,
        0x275e,
        0x275f,
        0x2760,
        0x2761,
        0x2762,
        0x2763,
        0x2764,
        0x2765,
        0x2766,
        0x2767,
        0x2768,
        0x2769,
        0x276a,
        0x276b,
        0x276c,
        0x276d,
        0x276e,
        0x276f,
        0x2770,
        0x2771,
        0x2757,
        0x212a,
        0x212c,
        0x212e,
        0x212f,
        0x2130,
        0x2131,
        0x212d,
        0x216b,
        0x2164,
        0x2165,
        0x2179,
        0x2166,
        0x216d,
        0x2271,
        0x2272,
        0x2273,
        0x2274,
        0x2275,
        0x2276,
        0x2277,
        0x2278,
        0x2279,
        0x227a,
        0x227b,
        0x227c,
        0x217b,
        0x217c,
        0x217a,
        0x217d,
        0x214a,
        0x2147,
        0x2146,
        0x214c,
        0x2158,
        0x215e,
        0x214f,
        0x214e,
        0x2144,
        0x2145,
        0x2149,
        0x2148,
        0x2152,
        0x2153,
        0x2160,
        0x215f,
        0x2143,
        0x214b,
        0x2157,
        0x2156,
        0x2155,
        0x2159,
        0x2154,
        0x215c,
        0x215d,
        0x215a,
        0x215b,
        0x2151,
        0x214d,
        0x2150,
        0x2259,
        0x225a,
        0x225b,
        0x225c,
        0x225d,
        0x225e,
        0x225f,
        0x2260,
        0x2261,
        0x2262,
        0x2245,
        0x2246,
        0x2247,
        0x2248,
        0x2249,
        0x224a,
        0x224b,
        0x224c,
        0x224d,
        0x224e,
        0x224f,
        0x2250,
        0x2251,
        0x2252,
        0x2253,
        0x2254,
        0x2255,
        0x2256,
        0x2257,
        0x2258,
        0x2231,
        0x2232,
        0x2233,
        0x2234,
        0x2235,
        0x2236,
        0x2237,
        0x2238,
        0x2239,
        0x223a,
        0x223b,
        0x223c,
        0x223d,
        0x223e,
        0x223f,
        0x2240,
        0x2241,
        0x2242,
        0x2243,
        0x2244,
        0x2924,
        0x2925,
        0x2926,
        0x2927,
        0x2928,
        0x2929,
        0x292a,
        0x292b,
        0x292c,
        0x292d,
        0x292e,
        0x292f,
        0x2930,
        0x2931,
        0x2932,
        0x2933,
        0x2934,
        0x2935,
        0x2936,
        0x2937,
        0x2938,
        0x2939,
        0x293a,
        0x293b,
        0x293c,
        0x293d,
        0x293e,
        0x293f,
        0x2940,
        0x2941,
        0x2942,
        0x2943,
        0x2944,
        0x2945,
        0x2946,
        0x2947,
        0x2948,
        0x2949,
        0x294a,
        0x294b,
        0x294c,
        0x294d,
        0x294e,
        0x294f,
        0x2950,
        0x2951,
        0x2952,
        0x2953,
        0x2954,
        0x2955,
        0x2956,
        0x2957,
        0x2958,
        0x2959,
        0x295a,
        0x295b,
        0x295c,
        0x295d,
        0x295e,
        0x295f,
        0x2960,
        0x2961,
        0x2962,
        0x2963,
        0x2964,
        0x2965,
        0x2966,
        0x2967,
        0x2968,
        0x2969,
        0x296a,
        0x296b,
        0x296c,
        0x296d,
        0x296e,
        0x296f,
        0x2176,
        0x2175,
        0x2178,
        0x2177,
        0x2174,
        0x2173,
        0x2170,
        0x2172,
        0x2171,
        0x216f,
        0x216e,
        0x2162,
        0x2161,
        0x2121,
        0x2122,
        0x2123,
        0x2128,
        0x2129,
        0x2134,
        0x2135,
        0x2136,
        0x2137,
        0x2138,
        0x2139,
        0x213a,
        0x213b,
        0x213e,
        0x213f,
        0x217e,
        0x2132,
        0x2133,
        0x213c,
        0x213d,
        0x2421,
        0x2422,
        0x2423,
        0x2424,
        0x2425,
        0x2426,
        0x2427,
        0x2428,
        0x2429,
        0x242a,
        0x242b,
        0x242c,
        0x242d,
        0x242e,
        0x242f,
        0x2430,
        0x2431,
        0x2432,
        0x2433,
        0x2434,
        0x2435,
        0x2436,
        0x2437,
        0x2438,
        0x2439,
        0x243a,
        0x243b,
        0x243c,
        0x243d,
        0x243e,
        0x243f,
        0x2440,
        0x2441,
        0x2442,
        0x2443,
        0x2444,
        0x2445,
        0x2446,
        0x2447,
        0x2448,
        0x2449,
        0x244a,
        0x244b,
        0x244c,
        0x244d,
        0x244e,
        0x244f,
        0x2450,
        0x2451,
        0x2452,
        0x2453,
        0x2454,
        0x2455,
        0x2456,
        0x2457,
        0x2458,
        0x2459,
        0x245a,
        0x245b,
        0x245c,
        0x245d,
        0x245e,
        0x245f,
        0x2460,
        0x2461,
        0x2462,
        0x2463,
        0x2464,
        0x2465,
        0x2466,
        0x2467,
        0x2468,
        0x2469,
        0x246a,
        0x246b,
        0x246c,
        0x246d,
        0x246e,
        0x246f,
        0x2470,
        0x2471,
        0x2472,
        0x2473,
        0x2521,
        0x2522,
        0x2523,
        0x2524,
        0x2525,
        0x2526,
        0x2527,
        0x2528,
        0x2529,
        0x252a,
        0x252b,
        0x252c,
        0x252d,
        0x252e,
        0x252f,
        0x2530,
        0x2531,
        0x2532,
        0x2533,
        0x2534,
        0x2535,
        0x2536,
        0x2537,
        0x2538,
        0x2539,
        0x253a,
        0x253b,
        0x253c,
        0x253d,
        0x253e,
        0x253f,
        0x2540,
        0x2541,
        0x2542,
        0x2543,
        0x2544,
        0x2545,
        0x2546,
        0x2547,
        0x2548,
        0x2549,
        0x254a,
        0x254b,
        0x254c,
        0x254d,
        0x254e,
        0x254f,
        0x2550,
        0x2551,
        0x2552,
        0x2553,
        0x2554,
        0x2555,
        0x2556,
        0x2557,
        0x2558,
        0x2559,
        0x255a,
        0x255b,
        0x255c,
        0x255d,
        0x255e,
        0x255f,
        0x2560,
        0x2561,
        0x2562,
        0x2563,
        0x2564,
        0x2565,
        0x2566,
        0x2567,
        0x2568,
        0x2569,
        0x256a,
        0x256b,
        0x256c,
        0x256d,
        0x256e,
        0x256f,
        0x2570,
        0x2571,
        0x2572,
        0x2573,
        0x2574,
        0x2575,
        0x2576,
        0x2124,
        0x2845,
        0x2846,
        0x2847,
        0x2848,
        0x2849,
        0x284a,
        0x284b,
        0x284c,
        0x284d,
        0x284e,
        0x284f,
        0x2850,
        0x2851,
        0x2852,
        0x2853,
        0x2854,
        0x2855,
        0x2856,
        0x2857,
        0x2858,
        0x2859,
        0x285a,
        0x285b,
        0x285c,
        0x285d,
        0x285e,
        0x285f,
        0x2860,
        0x2861,
        0x2862,
        0x2863,
        0x2864,
        0x2865,
        0x2866,
        0x2867,
        0x2868,
        0x2869,
        0x2265,
        0x2266,
        0x2267,
        0x2268,
        0x2269,
        0x226a,
        0x226b,
        0x226c,
        0x226d,
        0x226e,
        0x523b,
        0x3621,
        0x465f,
        0x4d72,
        0x5549,
        0x487d,
        0x494f,
        0x4f42,
        0x5822,
        0x323b,
        0x536b,
        0x5824,
        0x3373,
        0x5728,
        0x4752,
        0x5827,
        0x4a40,
        0x4770,
        0x317b,
        0x5235,
        0x3454,
        0x362b,
        0x4b3f,
        0x5829,
        0x362a,
        0x413d,
        0x514f,
        0x4925,
        0x582d,
        0x3876,
        0x513e,
        0x635c,
        0x5650,
        0x3761,
        0x342e,
        0x4159,
        0x583c,
        0x4d68,
        0x3524,
        0x4e2a,
        0x5677,
        0x4076,
        0x3e59,
        0x582f,
        0x444b,
        0x3e43,
        0x5831,
        0x4334,
        0x5265,
        0x562e,
        0x4e5a,
        0x5527,
        0x3a75,
        0x3726,
        0x4056,
        0x4639,
        0x4552,
        0x4747,
        0x3954,
        0x334b,
        0x5252,
        0x583f,
        0x3e45,
        0x4672,
        0x5232,
        0x4f30,
        0x4f67,
        0x4a69,
        0x5840,
        0x4272,
        0x4252,
        0x4869,
        0x472c,
        0x414b,
        0x5368,
        0x5579,
        0x4a42,
        0x367e,
        0x5821,
        0x535a,
        0x3f77,
        0x5446,
        0x3b25,
        0x5841,
        0x4e65,
        0x3e2e,
        0x5828,
        0x5147,
        0x5029,
        0x583d,
        0x596f,
        0x4d76,
        0x3f3a,
        0x3d3b,
        0x3a25,
        0x5260,
        0x327a,
        0x3a60,
        0x4436,
        0x4f6d,
        0x3e29,
        0x4d24,
        0x4141,
        0x4757,
        0x5971,
        0x5974,
        0x484b,
        0x5869,
        0x525a,
        0x4a32,
        0x484a,
        0x586c,
        0x586a,
        0x5846,
        0x3d76,
        0x464d,
        0x3370,
        0x586b,
        0x3d71,
        0x3d69,
        0x4854,
        0x3453,
        0x4258,
        0x3256,
        0x5750,
        0x4a4b,
        0x4b7b,
        0x554c,
        0x3836,
        0x4f49,
        0x595a,
        0x5870,
        0x472a,
        0x586e,
        0x347a,
        0x416e,
        0x5254,
        0x586d,
        0x5247,
        0x586f,
        0x4347,
        0x5176,
        0x5659,
        0x5872,
        0x5875,
        0x3c7e,
        0x3c5b,
        0x484e,
        0x375d,
        0x3742,
        0x4673,
        0x5878,
        0x5241,
        0x4e69,
        0x3c3f,
        0x377c,
        0x3725,
        0x505d,
        0x565a,
        0x5345,
        0x3b6f,
        0x3b61,
        0x5871,
        0x4921,
        0x4e30,
        0x342b,
        0x5873,
        0x494b,
        0x5876,
        0x4257,
        0x5877,
        0x4e31,
        0x5879,
        0x322e,
        0x3940,
        0x5923,
        0x3069,
        0x4166,
        0x496c,
        0x4b45,
        0x4b46,
        0x5924,
        0x3568,
        0x352b,
        0x4e3b,
        0x354d,
        0x5721,
        0x5774,
        0x5353,
        0x4c65,
        0x3a4e,
        0x5922,
        0x595c,
        0x5360,
        0x587d,
        0x3770,
        0x5777,
        0x587e,
        0x587a,
        0x5921,
        0x4463,
        0x5336,
        0x5874,
        0x595d,
        0x587b,
        0x4565,
        0x4050,
        0x5170,
        0x305b,
        0x3c51,
        0x5926,
        0x5925,
        0x592c,
        0x592e,
        0x592b,
        0x4a39,
        0x5929,
        0x5636,
        0x335e,
        0x5928,
        0x407d,
        0x4a4c,
        0x592a,
        0x5927,
        0x5930,
        0x3631,
        0x3929,
        0x5240,
        0x4f40,
        0x4242,
        0x3d44,
        0x556c,
        0x3260,
        0x4748,
        0x3f6b,
        0x592d,
        0x592f,
        0x4e6a,
        0x3a6e,
        0x4756,
        0x3163,
        0x3459,
        0x366d,
        0x5934,
        0x3f21,
        0x595e,
        0x474e,
        0x407e,
        0x5938,
        0x4b57,
        0x377d,
        0x5935,
        0x5937,
        0x3123,
        0x5361,
        0x5939,
        0x5045,
        0x5936,
        0x5931,
        0x5932,
        0x4129,
        0x5933,
        0x3c73,
        0x505e,
        0x3829,
        0x3e63,
        0x593d,
        0x593a,
        0x3033,
        0x5942,
        0x5944,
        0x3136,
        0x593f,
        0x3539,
        0x3e73,
        0x4c48,
        0x3a72,
        0x5250,
        0x5943,
        0x3d68,
        0x332b,
        0x5945,
        0x3e6b,
        0x5946,
        0x593b,
        0x445f,
        0x593e,
        0x5941,
        0x5940,
        0x552e,
        0x5635,
        0x4763,
        0x5948,
        0x3c59,
        0x594a,
        0x593c,
        0x594b,
        0x462b,
        0x5949,
        0x5776,
        0x4d23,
        0x3d21,
        0x594c,
        0x453c,
        0x4d35,
        0x594d,
        0x5947,
        0x3325,
        0x3f7e,
        0x3835,
        0x407c,
        0x3078,
        0x3476,
        0x594e,
        0x594f,
        0x3422,
        0x5950,
        0x345f,
        0x3041,
        0x5951,
        0x4935,
        0x4f71,
        0x5952,
        0x4145,
        0x5956,
        0x492e,
        0x5955,
        0x5954,
        0x5957,
        0x4b5b,
        0x3d29,
        0x4627,
        0x5953,
        0x5958,
        0x5959,
        0x4865,
        0x405c,
        0x3679,
        0x5823,
        0x544a,
        0x542a,
        0x5056,
        0x3364,
        0x5557,
        0x4f48,
        0x3962,
        0x3f4b,
        0x4362,
        0x3652,
        0x4d43,
        0x596e,
        0x5970,
        0x3533,
        0x3635,
        0x3e24,
        0x486b,
        0x482b,
        0x304b,
        0x392b,
        0x4179,
        0x5962,
        0x403c,
        0x3932,
        0x3958,
        0x504b,
        0x3178,
        0x4664,
        0x3e5f,
        0x3564,
        0x5748,
        0x5178,
        0x3c66,
        0x4a5e,
        0x3c3d,
        0x5966,
        0x5867,
        0x445a,
        0x3854,
        0x483d,
        0x3261,
        0x5459,
        0x4330,
        0x4361,
        0x5a22,
        0x485f,
        0x5034,
        0x3e7c,
        0x4529,
        0x395a,
        0x5a23,
        0x5429,
        0x5a24,
        0x597b,
        0x362c,
        0x376b,
        0x3179,
        0x597c,
        0x3365,
        0x3e76,
        0x3f76,
        0x5231,
        0x4064,
        0x3633,
        0x597e,
        0x597d,
        0x3e3b,
        0x4660,
        0x573c,
        0x5a21,
        0x4139,
        0x3572,
        0x4168,
        0x3c75,
        0x3455,
        0x415d,
        0x447d,
        0x3c38,
        0x3732,
        0x376f,
        0x596c,
        0x463e,
        0x3f2d,
        0x3b4b,
        0x354a,
        0x5b49,
        0x5057,
        0x4d39,
        0x303c,
        0x3376,
        0x3b77,
        0x5b4a,
        0x3a2f,
        0x5464,
        0x3536,
        0x3573,
        0x5856,
        0x4850,
        0x3756,
        0x4750,
        0x5857,
        0x3f2f,
        0x5b3b,
        0x5858,
        0x504c,
        0x3b2e,
        0x6b3e,
        0x4150,
        0x4175,
        0x5472,
        0x3855,
        0x3434,
        0x3375,
        0x493e,
        0x4550,
        0x4559,
        0x407b,
        0x3170,
        0x5859,
        0x394e,
        0x353d,
        0x585a,
        0x5646,
        0x4b22,
        0x482f,
        0x4932,
        0x344c,
        0x3f4c,
        0x3974,
        0x585b,
        0x585c,
        0x3667,
        0x3c41,
        0x4c6a,
        0x4f77,
        0x585d,
        0x4730,
        0x3950,
        0x3d23,
        0x4c5e,
        0x464a,
        0x5860,
        0x585e,
        0x585f,
        0x307e,
        0x3e67,
        0x4a23,
        0x3c74,
        0x3831,
        0x386e,
        0x5862,
        0x3d4b,
        0x5864,
        0x5863,
        0x457c,
        0x5865,
        0x5866,
        0x4126,
        0x4830,
        0x306c,
        0x3926,
        0x3c53,
        0x4e71,
        0x5b3d,
        0x4153,
        0x362f,
        0x567a,
        0x452c,
        0x3d59,
        0x5b3e,
        0x5b3f,
        0x4078,
        0x3e22,
        0x404d,
        0x5b40,
        0x4a46,
        0x322a,
        0x5342,
        0x4363,
        0x512b,
        0x5b42,
        0x4055,
        0x5b43,
        0x3f31,
        0x443c,
        0x475a,
        0x5b44,
        0x5968,
        0x4957,
        0x3934,
        0x4e70,
        0x5448,
        0x307c,
        0x3452,
        0x5059,
        0x5969,
        0x5e4b,
        0x596b,
        0x5830,
        0x3b2f,
        0x3131,
        0x3357,
        0x584e,
        0x5451,
        0x3d33,
        0x3f6f,
        0x4f3b,
        0x5850,
        0x374b,
        0x5851,
        0x4625,
        0x4778,
        0x523d,
        0x5852,
        0x4464,
        0x4a2e,
        0x4727,
        0x5826,
        0x497d,
        0x4e67,
        0x3b5c,
        0x306b,
        0x3b2a,
        0x502d,
        0x3130,
        0x5764,
        0x573f,
        0x3525,
        0x4274,
        0x444f,
        0x3229,
        0x3237,
        0x3165,
        0x5f32,
        0x553c,
        0x3f28,
        0x422c,
        0x5855,
        0x4231,
        0x5854,
        0x4e54,
        0x5a60,
        0x4e40,
        0x5834,
        0x432e,
        0x5321,
        0x4e23,
        0x3c34,
        0x4834,
        0x4251,
        0x3e6d,
        0x5036,
        0x5a61,
        0x4764,
        0x3327,
        0x3672,
        0x4c7c,
        0x407a,
        0x4077,
        0x5139,
        0x5161,
        0x5847,
        0x325e,
        0x4065,
        0x3a71,
        0x5848,
        0x542d,
        0x4f61,
        0x5849,
        0x584a,
        0x4f43,
        0x3378,
        0x3e47,
        0x584b,
        0x5b4c,
        0x4825,
        0x4f58,
        0x487e,
        0x324e,
        0x5356,
        0x3266,
        0x3c30,
        0x5351,
        0x4b2b,
        0x3734,
        0x3722,
        0x4a65,
        0x4821,
        0x4a5c,
        0x3164,
        0x5070,
        0x4551,
        0x5b45,
        0x357e,
        0x3f5a,
        0x3945,
        0x3e64,
        0x416d,
        0x5f36,
        0x5f35,
        0x563b,
        0x3d50,
        0x5559,
        0x3048,
        0x3623,
        0x3f49,
        0x4c28,
        0x5f33,
        0x4a37,
        0x5352,
        0x584f,
        0x5236,
        0x3a45,
        0x4b3e,
        0x4c3e,
        0x5f37,
        0x3570,
        0x5f34,
        0x5375,
        0x3354,
        0x3877,
        0x5f3a,
        0x3a4f,
        0x3c2a,
        0x3575,
        0x4d2c,
        0x437b,
        0x3a73,
        0x4074,
        0x4d42,
        0x4f72,
        0x5f38,
        0x4f45,
        0x4240,
        0x5f39,
        0x4270,
        0x3e7d,
        0x415f,
        0x4d4c,
        0x5277,
        0x374d,
        0x5f41,
        0x5f44,
        0x3771,
        0x3049,
        0x3656,
        0x3754,
        0x3a2c,
        0x4c7d,
        0x3f54,
        0x4b31,
        0x4674,
        0x5628,
        0x5f45,
        0x4e62,
        0x3333,
        0x4e7c,
        0x3435,
        0x4e47,
        0x3a70,
        0x4e61,
        0x513d,
        0x5f40,
        0x3474,
        0x334a,
        0x3866,
        0x5f3b,
        0x4445,
        0x5f3c,
        0x5f3d,
        0x5f3e,
        0x453b,
        0x5f3f,
        0x5f42,
        0x5431,
        0x5f43,
        0x473a,
        0x4e58,
        0x4458,
        0x5f4a,
        0x5f4f,
        0x565c,
        0x5f49,
        0x5f5a,
        0x4e36,
        0x3a47,
        0x5f4e,
        0x5f48,
        0x455e,
        0x496b,
        0x3a74,
        0x437c,
        0x3e57,
        0x5f46,
        0x5f4d,
        0x4558,
        0x5526,
        0x3a4d,
        0x3e4c,
        0x533d,
        0x3840,
        0x5664,
        0x5f47,
        0x393e,
        0x3f27,
        0x417c,
        0x5f4b,
        0x5f4c,
        0x5f50,
        0x5f5b,
        0x5f65,
        0x5f57,
        0x5f56,
        0x5749,
        0x5f63,
        0x5f64,
        0x656b,
        0x5227,
        0x5f52,
        0x3f29,
        0x545b,
        0x3f48,
        0x5f54,
        0x4f4c,
        0x5f5d,
        0x514a,
        0x5f5e,
        0x3027,
        0x4637,
        0x5f53,
        0x3a65,
        0x365f,
        0x4d5b,
        0x397e,
        0x5455,
        0x5f5f,
        0x4f6c,
        0x3025,
        0x5f67,
        0x5f51,
        0x5146,
        0x5f55,
        0x5f58,
        0x5f59,
        0x5f5c,
        0x3b29,
        0x5f60,
        0x5f61,
        0x5f62,
        0x5f66,
        0x5f68,
        0x5334,
        0x3867,
        0x4536,
        0x5f6a,
        0x495a,
        0x4128,
        0x4444,
        0x3f5e,
        0x4f78,
        0x555c,
        0x5f6e,
        0x3238,
        0x3a5f,
        0x5f6c,
        0x5b41,
        0x5164,
        0x4b74,
        0x343d,
        0x3026,
        0x5f71,
        0x4c46,
        0x5f72,
        0x5f6d,
        0x5f69,
        0x5f6b,
        0x5f6f,
        0x5f70,
        0x3b3d,
        0x5f73,
        0x5f74,
        0x3b23,
        0x4a5b,
        0x4e28,
        0x6027,
        0x332a,
        0x6026,
        0x6021,
        0x5f7e,
        0x4d59,
        0x5f7c,
        0x5f7a,
        0x3f50,
        0x5744,
        0x494c,
        0x5f78,
        0x3021,
        0x5f7d,
        0x5f7b,
        0x6022,
        0x6028,
        0x3748,
        0x4621,
        0x4936,
        0x4032,
        0x5f75,
        0x453e,
        0x5844,
        0x5f79,
        0x4476,
        0x6023,
        0x6024,
        0x6025,
        0x5025,
        0x6034,
        0x4c64,
        0x6031,
        0x3f26,
        0x602f,
        0x4e39,
        0x602b,
        0x4946,
        0x402e,
        0x602e,
        0x3a6d,
        0x3a30,
        0x6029,
        0x5f76,
        0x6033,
        0x6038,
        0x342d,
        0x6039,
        0x4f32,
        0x3a48,
        0x6030,
        0x507a,
        0x602c,
        0x547b,
        0x5f77,
        0x4567,
        0x602d,
        0x5377,
        0x6036,
        0x6037,
        0x6044,
        0x5061,
        0x603c,
        0x6049,
        0x604a,
        0x603e,
        0x602a,
        0x4924,
        0x6041,
        0x6032,
        0x4a48,
        0x6043,
        0x6035,
        0x4e4b,
        0x4b43,
        0x604d,
        0x6046,
        0x6042,
        0x604b,
        0x603a,
        0x603f,
        0x6040,
        0x6045,
        0x6047,
        0x6048,
        0x604c,
        0x603b,
        0x4b54,
        0x6055,
        0x6056,
        0x6052,
        0x6050,
        0x3c4e,
        0x6051,
        0x3842,
        0x5845,
        0x506a,
        0x426f,
        0x604f,
        0x603d,
        0x6054,
        0x6053,
        0x6057,
        0x605c,
        0x6058,
        0x5676,
        0x3330,
        0x576c,
        0x4b3b,
        0x605a,
        0x4e7b,
        0x3a59,
        0x6061,
        0x605d,
        0x522d,
        0x6062,
        0x605b,
        0x6059,
        0x605f,
        0x6060,
        0x605e,
        0x6064,
        0x4677,
        0x582c,
        0x546b,
        0x6066,
        0x4a49,
        0x6065,
        0x3841,
        0x6067,
        0x6068,
        0x6069,
        0x6063,
        0x3a3f,
        0x4c67,
        0x606a,
        0x4f79,
        0x606b,
        0x4842,
        0x3d40,
        0x4452,
        0x606c,
        0x606d,
        0x4774,
        0x4b44,
        0x606e,
        0x3b58,
        0x5836,
        0x5272,
        0x606f,
        0x4d45,
        0x365a,
        0x6071,
        0x5430,
        0x4027,
        0x3451,
        0x4e27,
        0x6070,
        0x6072,
        0x394c,
        0x397a,
        0x4d3c,
        0x6073,
        0x4654,
        0x6074,
        0x5432,
        0x4826,
        0x6076,
        0x6075,
        0x6077,
        0x4d41,
        0x4a25,
        0x545a,
        0x5b57,
        0x5b59,
        0x5b58,
        0x3967,
        0x5b5c,
        0x5b5d,
        0x3558,
        0x5b5a,
        0x5b5b,
        0x3321,
        0x5b5f,
        0x3b78,
        0x5637,
        0x5b60,
        0x3e79,
        0x373b,
        0x5b50,
        0x4c2e,
        0x3f32,
        0x3b35,
        0x5778,
        0x3f53,
        0x3f69,
        0x3c61,
        0x4c33,
        0x5b5e,
        0x3053,
        0x4e6b,
        0x3758,
        0x5739,
        0x4642,
        0x4024,
        0x4c39,
        0x5b67,
        0x5b61,
        0x463a,
        0x5b63,
        0x5b68,
        0x4577,
        0x5b6a,
        0x5b69,
        0x3f40,
        0x5b66,
        0x5b65,
        0x3439,
        0x402c,
        0x4222,
        0x5b62,
        0x5b64,
        0x504d,
        0x5b6d,
        0x405d,
        0x5b72,
        0x3662,
        0x5b73,
        0x5b52,
        0x3938,
        0x542b,
        0x5b6c,
        0x3f51,
        0x5b70,
        0x5b51,
        0x3566,
        0x5b6b,
        0x3f65,
        0x5b6e,
        0x5b71,
        0x5b79,
        0x3921,
        0x3023,
        0x4271,
        0x3347,
        0x5b6f,
        0x5b78,
        0x4652,
        0x5b74,
        0x5b75,
        0x5b77,
        0x5b76,
        0x5b7e,
        0x5372,
        0x323a,
        0x5b7d,
        0x5c24,
        0x5b7b,
        0x5b7a,
        0x5b7c,
        0x4560,
        0x3b79,
        0x5c23,
        0x5c25,
        0x4c43,
        0x3651,
        0x5d40,
        0x5c21,
        0x5c22,
        0x4735,
        0x3669,
        0x5c27,
        0x5c26,
        0x5c29,
        0x3124,
        0x354c,
        0x3f30,
        0x515f,
        0x3642,
        0x5c28,
        0x4b7a,
        0x6b73,
        0x4b5c,
        0x4b7e,
        0x4c41,
        0x487b,
        0x5c2a,
        0x4c6e,
        0x5c2b,
        0x5b53,
        0x5c2f,
        0x5c2c,
        0x3e33,
        0x4a7b,
        0x5c2d,
        0x494a,
        0x4439,
        0x473d,
        0x5c2e,
        0x5476,
        0x5066,
        0x442b,
        0x3655,
        0x5b54,
        0x315a,
        0x5b55,
        0x5b56,
        0x3a3e,
        0x4840,
        0x4a3f,
        0x4849,
        0x5733,
        0x4979,
        0x3f47,
        0x3a78,
        0x523c,
        0x623a,
        0x3426,
        0x3138,
        0x3834,
        0x4f44,
        0x5967,
        0x4f26,
        0x4d62,
        0x596d,
        0x3660,
        0x5239,
        0x393b,
        0x6239,
        0x6237,
        0x3473,
        0x4c6c,
        0x4c2b,
        0x3772,
        0x5832,
        0x516b,
        0x3a3b,
        0x4a27,
        0x4d37,
        0x5244,
        0x3f64,
        0x3c50,
        0x3661,
        0x5e45,
        0x5e46,
        0x5b3c,
        0x5159,
        0x4666,
        0x444e,
        0x376e,
        0x375c,
        0x3f7c,
        0x5760,
        0x4675,
        0x313c,
        0x5e48,
        0x3d31,
        0x4c57,
        0x5e4a,
        0x5e49,
        0x356c,
        0x495d,
        0x3042,
        0x452e,
        0x452b,
        0x444c,
        0x3c69,
        0x4b7d,
        0x3a43,
        0x6579,
        0x4867,
        0x657a,
        0x4d7d,
        0x5731,
        0x383e,
        0x4268,
        0x4851,
        0x657b,
        0x364a,
        0x3c4b,
        0x517d,
        0x6621,
        0x436e,
        0x6624,
        0x657e,
        0x6625,
        0x4d57,
        0x3741,
        0x657c,
        0x657d,
        0x6623,
        0x445d,
        0x6628,
        0x6627,
        0x4343,
        0x465e,
        0x662a,
        0x4437,
        0x6622,
        0x4a3c,
        0x3d63,
        0x3943,
        0x6626,
        0x5055,
        0x4e2f,
        0x6629,
        0x6630,
        0x5226,
        0x3d2a,
        0x662d,
        0x662f,
        0x4051,
        0x524c,
        0x3c27,
        0x6631,
        0x5276,
        0x574b,
        0x4d7e,
        0x4d5e,
        0x4226,
        0x662b,
        0x662c,
        0x3d3f,
        0x662e,
        0x6633,
        0x6632,
        0x6636,
        0x6638,
        0x446f,
        0x4448,
        0x3e6a,
        0x496f,
        0x6637,
        0x3670,
        0x4364,
        0x5369,
        0x6634,
        0x6635,
        0x4822,
        0x663d,
        0x6639,
        0x4645,
        0x4d71,
        0x663b,
        0x663c,
        0x3b69,
        0x663e,
        0x663a,
        0x4037,
        0x5324,
        0x663f,
        0x4974,
        0x6643,
        0x6644,
        0x5076,
        0x433d,
        0x4344,
        0x6642,
        0x6641,
        0x6647,
        0x4f31,
        0x6b74,
        0x664a,
        0x6645,
        0x3c5e,
        0x4929,
        0x3c35,
        0x4f53,
        0x6648,
        0x6649,
        0x664e,
        0x6650,
        0x6651,
        0x664b,
        0x3555,
        0x664c,
        0x664f,
        0x445b,
        0x6646,
        0x664d,
        0x6652,
        0x6654,
        0x6653,
        0x6655,
        0x5978,
        0x6656,
        0x6657,
        0x5753,
        0x665d,
        0x665e,
        0x3f57,
        0x5450,
        0x5756,
        0x3466,
        0x4b6f,
        0x665a,
        0x5843,
        0x574e,
        0x5022,
        0x434f,
        0x665f,
        0x3c3e,
        0x3942,
        0x665b,
        0x5127,
        0x3a22,
        0x424f,
        0x582b,
        0x4a6b,
        0x656e,
        0x665c,
        0x3775,
        0x4866,
        0x4475,
        0x6532,
        0x447e,
        0x4b7c,
        0x6533,
        0x552c,
        0x536e,
        0x4a58,
        0x3032,
        0x4b4e,
        0x4d6a,
        0x3a6a,
        0x6535,
        0x6534,
        0x575a,
        0x3959,
        0x5666,
        0x3628,
        0x4d70,
        0x524b,
        0x3126,
        0x4a35,
        0x3368,
        0x4973,
        0x3f4d,
        0x507b,
        0x4a52,
        0x6536,
        0x3b42,
        0x4f5c,
        0x392c,
        0x5457,
        0x3a26,
        0x5167,
        0x4f7c,
        0x3c52,
        0x6537,
        0x485d,
        0x3f6d,
        0x3176,
        0x4b5e,
        0x3c45,
        0x3c44,
        0x527a,
        0x435c,
        0x3f5c,
        0x383b,
        0x4342,
        0x3a2e,
        0x5422,
        0x475e,
        0x442f,
        0x326c,
        0x3951,
        0x653b,
        0x4148,
        0x552f,
        0x653c,
        0x653e,
        0x3467,
        0x3654,
        0x4b42,
        0x5130,
        0x353c,
        0x4a59,
        0x3762,
        0x4964,
        0x3d2b,
        0x4e3e,
        0x5770,
        0x5021,
        0x4959,
        0x367b,
        0x6658,
        0x3c62,
        0x333e,
        0x4950,
        0x6659,
        0x3322,
        0x5e4c,
        0x5348,
        0x5e4d,
        0x5222,
        0x5e4e,
        0x3e4d,
        0x5e4f,
        0x4a2c,
        0x527c,
        0x335f,
        0x656a,
        0x4461,
        0x3e21,
        0x4e32,
        0x4472,
        0x3e56,
        0x4628,
        0x3263,
        0x3e53,
        0x477c,
        0x4c6b,
        0x3d6c,
        0x4e5d,
        0x4a3a,
        0x4641,
        0x656c,
        0x503c,
        0x5539,
        0x656d,
        0x4a74,
        0x4d40,
        0x4245,
        0x656f,
        0x4244,
        0x6570,
        0x6578,
        0x4d4d,
        0x493d,
        0x5259,
        0x6128,
        0x536c,
        0x4b6a,
        0x4671,
        0x612c,
        0x6127,
        0x6129,
        0x612a,
        0x612f,
        0x326d,
        0x612b,
        0x385a,
        0x612d,
        0x612e,
        0x6130,
        0x353a,
        0x6131,
        0x6133,
        0x6138,
        0x5152,
        0x6136,
        0x6135,
        0x416b,
        0x6137,
        0x5440,
        0x6132,
        0x613a,
        0x3036,
        0x6134,
        0x3f79,
        0x6139,
        0x613b,
        0x613e,
        0x613c,
        0x5645,
        0x4f3f,
        0x613d,
        0x613f,
        0x424d,
        0x366b,
        0x5378,
        0x474d,
        0x3765,
        0x3e7e,
        0x6140,
        0x6141,
        0x6147,
        0x3367,
        0x4669,
        0x345e,
        0x5142,
        0x6148,
        0x6146,
        0x6145,
        0x6143,
        0x6142,
        0x3140,
        0x5538,
        0x6144,
        0x614b,
        0x614c,
        0x614a,
        0x6f7a,
        0x6153,
        0x6152,
        0x4736,
        0x6149,
        0x614e,
        0x6150,
        0x6154,
        0x6151,
        0x614d,
        0x614f,
        0x6155,
        0x6156,
        0x6157,
        0x6158,
        0x615a,
        0x615b,
        0x4e21,
        0x675d,
        0x3428,
        0x565d,
        0x5132,
        0x3332,
        0x3924,
        0x5773,
        0x4749,
        0x3e5e,
        0x392e,
        0x4e57,
        0x326e,
        0x5b4f,
        0x3c3a,
        0x5251,
        0x4b48,
        0x304d,
        0x4f6f,
        0x5963,
        0x3d6d,
        0x3152,
        0x4a50,
        0x323c,
        0x4b27,
        0x372b,
        0x4a26,
        0x4f23,
        0x6078,
        0x554a,
        0x607b,
        0x607a,
        0x4541,
        0x4c7b,
        0x4131,
        0x6079,
        0x5663,
        0x322f,
        0x5644,
        0x355b,
        0x3478,
        0x5621,
        0x4f2f,
        0x306f,
        0x607c,
        0x6121,
        0x3323,
        0x607d,
        0x607e,
        0x4331,
        0x435d,
        0x6122,
        0x3779,
        0x3b4f,
        0x6123,
        0x443b,
        0x6124,
        0x6125,
        0x6126,
        0x3431,
        0x3849,
        0x463d,
        0x446a,
        0x3222,
        0x5052,
        0x675b,
        0x3b43,
        0x5357,
        0x5344,
        0x3963,
        0x624f,
        0x572f,
        0x476c,
        0x3153,
        0x3432,
        0x6251,
        0x5072,
        0x422e,
        0x6250,
        0x3f62,
        0x5326,
        0x3557,
        0x6252,
        0x356a,
        0x436d,
        0x387d,
        0x382e,
        0x4553,
        0x374f,
        0x6254,
        0x6253,
        0x3648,
        0x5779,
        0x4d25,
        0x6258,
        0x6256,
        0x4a7c,
        0x3f35,
        0x5339,
        0x6255,
        0x6257,
        0x412e,
        0x4048,
        0x625b,
        0x625a,
        0x402a,
        0x414e,
        0x625c,
        0x625d,
        0x625e,
        0x5b48,
        0x5153,
        0x4d22,
        0x3d28,
        0x5e43,
        0x5825,
        0x3f2a,
        0x5b4d,
        0x526c,
        0x467a,
        0x452a,
        0x5e44,
        0x3157,
        0x5f2e,
        0x4a3d,
        0x5f31,
        0x392d,
        0x527d,
        0x3825,
        0x3a6b,
        0x335a,
        0x355c,
        0x5545,
        0x4356,
        0x4f52,
        0x3b21,
        0x6573,
        0x6572,
        0x6574,
        0x4d64,
        0x4875,
        0x352f,
        0x473f,
        0x6576,
        0x6c30,
        0x6566,
        0x3969,
        0x3531,
        0x423c,
        0x6568,
        0x6567,
        0x6569,
        0x524d,
        0x616a,
        0x504e,
        0x4d2e,
        0x5165,
        0x324a,
        0x316b,
        0x3172,
        0x456d,
        0x5543,
        0x5330,
        0x615c,
        0x615d,
        0x525b,
        0x3339,
        0x314b,
        0x4d79,
        0x5577,
        0x615e,
        0x3e36,
        0x347d,
        0x615f,
        0x3a5c,
        0x6160,
        0x3b32,
        0x4249,
        0x6161,
        0x506c,
        0x4d3d,
        0x6162,
        0x3543,
        0x4547,
        0x6163,
        0x6164,
        0x5379,
        0x6165,
        0x512d,
        0x6166,
        0x4e22,
        0x6167,
        0x3542,
        0x6168,
        0x3b55,
        0x5044,
        0x6260,
        0x3158,
        0x5264,
        0x6261,
        0x3c49,
        0x484c,
        0x6263,
        0x6c7e,
        0x6c7d,
        0x5f2f,
        0x6262,
        0x563e,
        0x4d7c,
        0x4326,
        0x6343,
        0x5652,
        0x6267,
        0x6268,
        0x5347,
        0x626c,
        0x3f6c,
        0x626d,
        0x6265,
        0x3340,
        0x446e,
        0x626e,
        0x5043,
        0x3a76,
        0x6269,
        0x375e,
        0x3b33,
        0x4c2c,
        0x4b4b,
        0x6264,
        0x6266,
        0x626a,
        0x626b,
        0x6277,
        0x6274,
        0x5475,
        0x6273,
        0x452d,
        0x557a,
        0x4542,
        0x3240,
        0x626f,
        0x6272,
        0x412f,
        0x4b3c,
        0x3521,
        0x6279,
        0x3c31,
        0x6271,
        0x5054,
        0x5439,
        0x6275,
        0x3956,
        0x6276,
        0x4753,
        0x6270,
        0x575c,
        0x6d21,
        0x6278,
        0x6d25,
        0x627e,
        0x4a51,
        0x4135,
        0x3b50,
        0x3f56,
        0x3a63,
        0x4b21,
        0x6d26,
        0x6d23,
        0x6d22,
        0x3b56,
        0x6d27,
        0x5074,
        0x6d24,
        0x3a5e,
        0x3677,
        0x6321,
        0x3632,
        0x4c71,
        0x3927,
        0x4f22,
        0x4721,
        0x3f52,
        0x3671,
        0x627a,
        0x627b,
        0x627d,
        0x627c,
        0x4455,
        0x6322,
        0x5341,
        0x6327,
        0x4744,
        0x4f24,
        0x6329,
        0x3a37,
        0x6328,
        0x3b5a,
        0x6323,
        0x6324,
        0x632a,
        0x6326,
        0x4e72,
        0x5346,
        0x3b3c,
        0x5443,
        0x447a,
        0x6d28,
        0x507c,
        0x6325,
        0x4375,
        0x632d,
        0x312f,
        0x6332,
        0x3c42,
        0x632c,
        0x353f,
        0x4769,
        0x6330,
        0x3e2a,
        0x4d6f,
        0x3b73,
        0x4c68,
        0x632f,
        0x6331,
        0x4f27,
        0x632e,
        0x4e29,
        0x3b5d,
        0x356b,
        0x3e65,
        0x3252,
        0x334d,
        0x3139,
        0x632b,
        0x3251,
        0x352c,
        0x395f,
        0x3668,
        0x4f6b,
        0x6337,
        0x3b4c,
        0x4847,
        0x504a,
        0x6338,
        0x336e,
        0x6d29,
        0x537a,
        0x5364,
        0x6d2a,
        0x6339,
        0x5262,
        0x6335,
        0x535e,
        0x3850,
        0x6333,
        0x6336,
        0x375f,
        0x6334,
        0x4022,
        0x633a,
        0x5438,
        0x3448,
        0x633b,
        0x3b45,
        0x4977,
        0x4965,
        0x443d,
        0x6d2b,
        0x427d,
        0x3b5b,
        0x3f2e,
        0x4e3f,
        0x633c,
        0x3f36,
        0x316f,
        0x5477,
        0x633e,
        0x6d2d,
        0x633f,
        0x3a29,
        0x6d2c,
        0x633d,
        0x6340,
        0x3a36,
        0x362e,
        0x5038,
        0x3043,
        0x6d2e,
        0x6d2f,
        0x4041,
        0x6341,
        0x4533,
        0x6342,
        0x5c32,
        0x6d30,
        0x386a,
        0x4e6c,
        0x6a27,
        0x5067,
        0x4a79,
        0x4856,
        0x4f37,
        0x3349,
        0x4e52,
        0x3d64,
        0x635e,
        0x3b72,
        0x6a28,
        0x553d,
        0x465d,
        0x6a29,
        0x6a2a,
        0x6a2c,
        0x6a2b,
        0x6a2e,
        0x6a2d,
        0x3d58,
        0x6a2f,
        0x423e,
        0x3441,
        0x3477,
        0x3b27,
        0x6c66,
        0x6c65,
        0x373f,
        0x4b79,
        0x3162,
        0x6c67,
        0x4948,
        0x6c68,
        0x6c69,
        0x4a56,
        0x5e50,
        0x3245,
        0x547a,
        0x464b,
        0x3047,
        0x3472,
        0x4853,
        0x4d50,
        0x3f38,
        0x3f5b,
        0x4724,
        0x5634,
        0x4029,
        0x5e51,
        0x4928,
        0x516f,
        0x4524,
        0x3067,
        0x3336,
        0x4845,
        0x3062,
        0x3776,
        0x457a,
        0x3673,
        0x5552,
        0x3350,
        0x3c3c,
        0x332d,
        0x3e71,
        0x3051,
        0x5256,
        0x4a63,
        0x5725,
        0x4d36,
        0x3636,
        0x3f39,
        0x555b,
        0x3827,
        0x4557,
        0x5e52,
        0x3f59,
        0x4255,
        0x4740,
        0x3b24,
        0x3128,
        0x456a,
        0x457b,
        0x4c27,
        0x3127,
        0x3556,
        0x4428,
        0x5e53,
        0x513a,
        0x3369,
        0x4372,
        0x3777,
        0x5674,
        0x3523,
        0x3270,
        0x4434,
        0x4469,
        0x402d,
        0x5e54,
        0x3068,
        0x4544,
        0x4160,
        0x3955,
        0x3e5c,
        0x4d58,
        0x304e,
        0x4d4f,
        0x5e56,
        0x3e50,
        0x573e,
        0x5e55,
        0x5550,
        0x305d,
        0x4462,
        0x4223,
        0x3c70,
        0x5335,
        0x4039,
        0x4521,
        0x3226,
        0x5471,
        0x4028,
        0x4a43,
        0x5e57,
        0x557c,
        0x3930,
        0x482d,
        0x4b29,
        0x5e59,
        0x3f3d,
        0x4634,
        0x5727,
        0x4a30,
        0x4443,
        0x3356,
        0x3952,
        0x5638,
        0x6a7c,
        0x3034,
        0x3f66,
        0x4c74,
        0x4d5a,
        0x563f,
        0x424e,
        0x4e4e,
        0x4c22,
        0x502e,
        0x4453,
        0x3532,
        0x5e58,
        0x5575,
        0x3c37,
        0x3b53,
        0x3024,
        0x4532,
        0x346c,
        0x5571,
        0x6a7d,
        0x5e5a,
        0x4d26,
        0x4d6c,
        0x4e66,
        0x5e5c,
        0x4d31,
        0x4026,
        0x573d,
        0x5e5b,
        0x3046,
        0x3a34,
        0x4953,
        0x4473,
        0x3e68,
        0x3236,
        0x404c,
        0x4b70,
        0x3c71,
        0x3b3b,
        0x3537,
        0x4575,
        0x5e66,
        0x5e63,
        0x3e5d,
        0x5e5f,
        0x3437,
        0x3d5d,
        0x5e60,
        0x446d,
        0x4f46,
        0x3560,
        0x365e,
        0x4a5a,
        0x3574,
        0x5e65,
        0x5546,
        0x5e61,
        0x4c4d,
        0x467e,
        0x4545,
        0x5234,
        0x3e72,
        0x4253,
        0x4c3d,
        0x3338,
        0x3d53,
        0x3f58,
        0x4d46,
        0x515a,
        0x346b,
        0x5e64,
        0x5e5d,
        0x5e67,
        0x6a7e,
        0x4230,
        0x5e62,
        0x5640,
        0x3527,
        0x3274,
        0x5e68,
        0x5e72,
        0x5e6d,
        0x5e71,
        0x4860,
        0x5761,
        0x5e6f,
        0x4368,
        0x4c61,
        0x3265,
        0x523e,
        0x5e6e,
        0x5e6b,
        0x4e55,
        0x3427,
        0x3f2b,
        0x3e3e,
        0x3d52,
        0x5e69,
        0x542e,
        0x5e5e,
        0x5e6a,
        0x403f,
        0x5e6c,
        0x3273,
        0x3869,
        0x4227,
        0x3d41,
        0x5e75,
        0x5e78,
        0x322b,
        0x3424,
        0x346a,
        0x4926,
        0x5e76,
        0x4b51,
        0x3863,
        0x5e77,
        0x5e7a,
        0x5e79,
        0x4c42,
        0x3061,
        0x346e,
        0x653a,
        0x502f,
        0x326b,
        0x6b21,
        0x5e74,
        0x4963,
        0x5e73,
        0x305a,
        0x5221,
        0x3177,
        0x4c2f,
        0x5e70,
        0x4b24,
        0x552a,
        0x5e7b,
        0x345d,
        0x4426,
        0x5e7d,
        0x437e,
        0x4421,
        0x5f21,
        0x414c,
        0x5e7c,
        0x3e6f,
        0x4632,
        0x3345,
        0x4876,
        0x4b3a,
        0x5e7e,
        0x5f24,
        0x5732,
        0x3337,
        0x4143,
        0x474b,
        0x3225,
        0x3469,
        0x572b,
        0x446c,
        0x5f22,
        0x5f23,
        0x5f25,
        0x3a33,
        0x5f26,
        0x405e,
        0x4943,
        0x3259,
        0x4766,
        0x5f27,
        0x475c,
        0x5f28,
        0x6b22,
        0x4b53,
        0x5f2a,
        0x5f29,
        0x3241,
        0x454a,
        0x5f2b,
        0x545c,
        0x4841,
        0x5f2c,
        0x3e70,
        0x5f2d,
        0x5627,
        0x6a37,
        0x6b36,
        0x4a55,
        0x587c,
        0x3844,
        0x3925,
        0x3745,
        0x557e,
        0x394a,
        0x5027,
        0x744d,
        0x3550,
        0x4374,
        0x3e48,
        0x6b37,
        0x303d,
        0x3d4c,
        0x4132,
        0x3156,
        0x3328,
        0x3852,
        0x4922,
        0x3658,
        0x6b38,
        0x3e34,
        0x4a7d,
        0x4743,
        0x557b,
        0x3773,
        0x4e44,
        0x552b,
        0x3173,
        0x6c33,
        0x305f,
        0x6c35,
        0x3637,
        0x414f,
        0x757a,
        0x5031,
        0x5565,
        0x4e53,
        0x3d6f,
        0x3362,
        0x382b,
        0x5536,
        0x6d3d,
        0x364f,
        0x4b39,
        0x5042,
        0x373d,
        0x6c36,
        0x4a29,
        0x4554,
        0x6c39,
        0x6c38,
        0x4243,
        0x6c37,
        0x507d,
        0x6c3a,
        0x6c3b,
        0x5765,
        0x6c3c,
        0x6c3d,
        0x466c,
        0x4e5e,
        0x3c48,
        0x4855,
        0x3529,
        0x3e49,
        0x563c,
        0x5467,
        0x512e,
        0x5071,
        0x6a38,
        0x6a39,
        0x6a3a,
        0x3a35,
        0x4a31,
        0x3f75,
        0x4d7a,
        0x6a40,
        0x303a,
        0x6a3e,
        0x4025,
        0x6a3b,
        0x327d,
        0x4377,
        0x3b68,
        0x5257,
        0x4e74,
        0x6a3f,
        0x6a3c,
        0x6a43,
        0x5047,
        0x5333,
        0x343a,
        0x4341,
        0x5772,
        0x5551,
        0x4a47,
        0x6a45,
        0x6a44,
        0x6a47,
        0x6a46,
        0x5667,
        0x4f54,
        0x6a4b,
        0x3b4e,
        0x3d7a,
        0x494e,
        0x6a4c,
        0x4939,
        0x4f7e,
        0x6a4a,
        0x544e,
        0x6a4d,
        0x6a4f,
        0x4d6d,
        0x6a49,
        0x6a4e,
        0x4e6e,
        0x3b5e,
        0x333f,
        0x4655,
        0x3e30,
        0x4e7a,
        0x4767,
        0x3e27,
        0x6a50,
        0x5647,
        0x4140,
        0x545d,
        0x6a51,
        0x4f3e,
        0x6a52,
        0x4a6e,
        0x452f,
        0x3035,
        0x6a54,
        0x6a53,
        0x745f,
        0x443a,
        0x3129,
        0x655f,
        0x6a55,
        0x4a6f,
        0x6a56,
        0x6a57,
        0x4658,
        0x6a58,
        0x6a59,
        0x543b,
        0x477a,
        0x5237,
        0x387c,
        0x6a42,
        0x325c,
        0x427c,
        0x5478,
        0x4c66,
        0x576e,
        0x5442,
        0x5350,
        0x6b43,
        0x4573,
        0x377e,
        0x6b54,
        0x4b37,
        0x6b5e,
        0x404a,
        0x4d7b,
        0x332f,
        0x465a,
        0x6b7c,
        0x443e,
        0x4e34,
        0x4429,
        0x313e,
        0x547d,
        0x4a75,
        0x566c,
        0x4653,
        0x3664,
        0x3b7a,
        0x5060,
        0x4931,
        0x5453,
        0x4828,
        0x384b,
        0x683e,
        0x493c,
        0x683b,
        0x406e,
        0x5053,
        0x3244,
        0x3465,
        0x683c,
        0x5548,
        0x3645,
        0x683d,
        0x4a78,
        0x385c,
        0x4c75,
        0x4034,
        0x516e,
        0x683f,
        0x6842,
        0x3a3c,
        0x312d,
        0x3d5c,
        0x6a3d,
        0x6843,
        0x6846,
        0x684b,
        0x684c,
        0x4b49,
        0x3065,
        0x3c2b,
        0x3939,
        0x6841,
        0x4d77,
        0x684a,
        0x4e76,
        0x556d,
        0x4156,
        0x6844,
        0x4336,
        0x397b,
        0x5626,
        0x6848,
        0x4a60,
        0x5466,
        0x6840,
        0x6845,
        0x6847,
        0x4739,
        0x3763,
        0x6849,
        0x3f5d,
        0x6852,
        0x6857,
        0x6855,
        0x3c5c,
        0x3c4f,
        0x685b,
        0x685e,
        0x685a,
        0x317a,
        0x3058,
        0x4433,
        0x384c,
        0x4662,
        0x483e,
        0x4861,
        0x684f,
        0x6854,
        0x6856,
        0x3971,
        0x6858,
        0x5775,
        0x447b,
        0x685c,
        0x3269,
        0x6851,
        0x3c6d,
        0x3f42,
        0x684d,
        0x5679,
        0x4178,
        0x3271,
        0x685f,
        0x4a41,
        0x6859,
        0x5524,
        0x316a,
        0x553b,
        0x684e,
        0x6850,
        0x3630,
        0x6853,
        0x685d,
        0x4038,
        0x4a77,
        0x4b28,
        0x465c,
        0x4075,
        0x6869,
        0x5023,
        0x6872,
        0x566a,
        0x6860,
        0x6861,
        0x5179,
        0x3a4b,
        0x3879,
        0x3871,
        0x5454,
        0x686f,
        0x686e,
        0x686c,
        0x3970,
        0x4c52,
        0x6866,
        0x4e26,
        0x3f72,
        0x3038,
        0x6871,
        0x6870,
        0x5740,
        0x6864,
        0x4d29,
        0x4923,
        0x3b38,
        0x3d5b,
        0x686a,
        0x6862,
        0x6863,
        0x6865,
        0x3535,
        0x6867,
        0x4745,
        0x686b,
        0x686d,
        0x3d30,
        0x572e,
        0x6878,
        0x6875,
        0x4d30,
        0x6876,
        0x413a,
        0x6868,
        0x4337,
        0x3070,
        0x6874,
        0x6877,
        0x3923,
        0x4952,
        0x434e,
        0x4e60,
        0x4066,
        0x4b73,
        0x4c5d,
        0x5035,
        0x4a61,
        0x6873,
        0x3c6c,
        0x6879,
        0x435e,
        0x4665,
        0x3977,
        0x3074,
        0x5758,
        0x3c2c,
        0x456f,
        0x4c44,
        0x6926,
        0x492d,
        0x6922,
        0x4062,
        0x3f43,
        0x687e,
        0x3957,
        0x687b,
        0x6924,
        0x524e,
        0x6923,
        0x5632,
        0x5735,
        0x6927,
        0x3d37,
        0x687c,
        0x687d,
        0x6921,
        0x4d56,
        0x522c,
        0x6932,
        0x6929,
        0x342a,
        0x343b,
        0x692b,
        0x5028,
        0x6925,
        0x337e,
        0x692c,
        0x4063,
        0x692a,
        0x6939,
        0x6938,
        0x692e,
        0x687a,
        0x6928,
        0x3f2c,
        0x6931,
        0x693a,
        0x4225,
        0x692f,
        0x3845,
        0x692d,
        0x535c,
        0x6934,
        0x6935,
        0x6937,
        0x6947,
        0x4046,
        0x6945,
        0x6930,
        0x693b,
        0x3071,
        0x693c,
        0x5525,
        0x693e,
        0x693f,
        0x6941,
        0x4171,
        0x4836,
        0x693d,
        0x6942,
        0x6943,
        0x6933,
        0x6936,
        0x3b31,
        0x6940,
        0x3c77,
        0x6944,
        0x6946,
        0x694a,
        0x694e,
        0x325b,
        0x6948,
        0x372e,
        0x694b,
        0x694c,
        0x5541,
        0x4423,
        0x6958,
        0x3a61,
        0x6949,
        0x5323,
        0x6954,
        0x6957,
        0x6950,
        0x694f,
        0x4741,
        0x6952,
        0x6959,
        0x3348,
        0x6953,
        0x4f70,
        0x694d,
        0x3377,
        0x6956,
        0x695a,
        0x4c34,
        0x4f2d,
        0x6955,
        0x695c,
        0x695b,
        0x695e,
        0x6951,
        0x695d,
        0x695f,
        0x434a,
        0x4737,
        0x344e,
        0x3b36,
        0x5040,
        0x6c23,
        0x4537,
        0x537b,
        0x6c24,
        0x6c25,
        0x465b,
        0x3f6e,
        0x6c26,
        0x6c27,
        0x502a,
        0x4738,
        0x3868,
        0x6c28,
        0x5639,
        0x557d,
        0x344b,
        0x323d,
        0x4e64,
        0x4667,
        0x4d61,
        0x3475,
        0x4b40,
        0x3c5f,
        0x6962,
        0x6963,
        0x516a,
        0x6965,
        0x3479,
        0x6964,
        0x5133,
        0x4a62,
        0x3250,
        0x6968,
        0x6966,
        0x6967,
        0x5633,
        0x6969,
        0x696a,
        0x696b,
        0x696c,
        0x6c2f,
        0x4539,
        0x364e,
        0x5273,
        0x356e,
        0x3b59,
        0x6c31,
        0x5263,
        0x4e63,
        0x4438,
        0x433f,
        0x363e,
        0x5839,
        0x3148,
        0x314f,
        0x3151,
        0x457e,
        0x3150,
        0x432b,
        0x5531,
        0x6b24,
        0x3a41,
        0x4c3a,
        0x6b25,
        0x6b27,
        0x6b28,
        0x6b26,
        0x6b29,
        0x6b2b,
        0x6b2a,
        0x6b2c,
        0x4a4f,
        0x5835,
        0x4371,
        0x4325,
        0x4678,
        0x6b2d,
        0x444a,
        0x6b2e,
        0x6b2f,
        0x6b30,
        0x3755,
        0x377a,
        0x6b31,
        0x4762,
        0x6b33,
        0x3a24,
        0x5175,
        0x3031,
        0x6b32,
        0x6b34,
        0x352a,
        0x4248,
        0x4768,
        0x6b35,
        0x4b2e,
        0x635f,
        0x5340,
        0x595b,
        0x4d21,
        0x562d,
        0x4773,
        0x5960,
        0x3b63,
        0x3a3a,
        0x6362,
        0x4f2b,
        0x6360,
        0x4947,
        0x3a39,
        0x5134,
        0x6361,
        0x486a,
        0x392f,
        0x3d2d,
        0x3358,
        0x4e5b,
        0x4c40,
        0x6368,
        0x6369,
        0x4d74,
        0x4c2d,
        0x3c33,
        0x636a,
        0x636b,
        0x505a,
        0x467b,
        0x375a,
        0x475f,
        0x524a,
        0x4e56,
        0x6364,
        0x636c,
        0x4972,
        0x3341,
        0x6367,
        0x4663,
        0x6365,
        0x6d33,
        0x6366,
        0x4933,
        0x4566,
        0x3935,
        0x433b,
        0x6363,
        0x453d,
        0x4124,
        0x4259,
        0x3257,
        0x636d,
        0x3b26,
        0x442d,
        0x6370,
        0x3e5a,
        0x637b,
        0x6375,
        0x3a53,
        0x3750,
        0x534d,
        0x564e,
        0x5553,
        0x3941,
        0x5534,
        0x5158,
        0x5039,
        0x4776,
        0x482a,
        0x3234,
        0x435a,
        0x636e,
        0x637c,
        0x636f,
        0x3728,
        0x6377,
        0x6374,
        0x373a,
        0x4522,
        0x6376,
        0x455d,
        0x3228,
        0x467c,
        0x4460,
        0x5722,
        0x4061,
        0x6379,
        0x637a,
        0x637d,
        0x4c29,
        0x6373,
        0x533e,
        0x3143,
        0x6d34,
        0x6371,
        0x6372,
        0x6378,
        0x503a,
        0x4643,
        0x5473,
        0x637e,
        0x3d60,
        0x6427,
        0x6426,
        0x5173,
        0x6423,
        0x6429,
        0x4877,
        0x4f34,
        0x6428,
        0x642e,
        0x4265,
        0x3634,
        0x3d72,
        0x6422,
        0x3a69,
        0x642a,
        0x642c,
        0x367d,
        0x565e,
        0x6432,
        0x642d,
        0x6421,
        0x3b6e,
        0x4d5d,
        0x4722,
        0x4549,
        0x4177,
        0x6424,
        0x4733,
        0x3d2c,
        0x3d3d,
        0x6425,
        0x5747,
        0x3262,
        0x642b,
        0x3c43,
        0x642f,
        0x3b6b,
        0x6430,
        0x4528,
        0x6431,
        0x5563,
        0x3f23,
        0x643a,
        0x6437,
        0x643b,
        0x643d,
        0x4656,
        0x3a46,
        0x404b,
        0x3821,
        0x6434,
        0x5421,
        0x3a23,
        0x3d7e,
        0x643c,
        0x4d3f,
        0x4479,
        0x4f7b,
        0x4966,
        0x533f,
        0x4f51,
        0x6433,
        0x6438,
        0x6439,
        0x4c69,
        0x4c4e,
        0x4054,
        0x6435,
        0x4130,
        0x6436,
        0x4e50,
        0x3b41,
        0x3553,
        0x4873,
        0x3d27,
        0x5547,
        0x492c,
        0x3822,
        0x644a,
        0x644c,
        0x5144,
        0x523a,
        0x3a2d,
        0x3a54,
        0x6443,
        0x356d,
        0x574d,
        0x6440,
        0x4f7d,
        0x643f,
        0x415c,
        0x4c4a,
        0x4a67,
        0x4457,
        0x4c54,
        0x6448,
        0x6447,
        0x6441,
        0x6444,
        0x352d,
        0x5359,
        0x6446,
        0x5279,
        0x3463,
        0x3b34,
        0x496e,
        0x343e,
        0x3b6c,
        0x514d,
        0x4c6d,
        0x6d35,
        0x4765,
        0x5428,
        0x644b,
        0x5755,
        0x6442,
        0x3d25,
        0x6445,
        0x5366,
        0x6449,
        0x4978,
        0x643e,
        0x5365,
        0x477e,
        0x3649,
        0x547c,
        0x3233,
        0x6457,
        0x4e42,
        0x644d,
        0x4e3c,
        0x385b,
        0x6456,
        0x3f4a,
        0x534e,
        0x436c,
        0x4548,
        0x6458,
        0x4d44,
        0x644f,
        0x6454,
        0x6455,
        0x3a7e,
        0x4f66,
        0x553f,
        0x6452,
        0x6450,
        0x644e,
        0x4d65,
        0x4a2a,
        0x4023,
        0x3d26,
        0x6453,
        0x3848,
        0x6467,
        0x5434,
        0x645b,
        0x416f,
        0x6469,
        0x5267,
        0x645f,
        0x6460,
        0x4f2a,
        0x4b5d,
        0x645a,
        0x6451,
        0x6465,
        0x485c,
        0x6463,
        0x4467,
        0x6462,
        0x6461,
        0x337c,
        0x6468,
        0x3561,
        0x574c,
        0x6466,
        0x3b2c,
        0x5752,
        0x4c4f,
        0x6b78,
        0x6464,
        0x3976,
        0x564d,
        0x6459,
        0x645c,
        0x427a,
        0x645e,
        0x424b,
        0x4044,
        0x4250,
        0x3175,
        0x4c32,
        0x354e,
        0x646f,
        0x462f,
        0x4661,
        0x6475,
        0x4229,
        0x406c,
        0x515d,
        0x646e,
        0x442e,
        0x646d,
        0x6476,
        0x6474,
        0x427e,
        0x645d,
        0x6470,
        0x4a7e,
        0x5544,
        0x6471,
        0x517a,
        0x646b,
        0x646c,
        0x6472,
        0x4e2b,
        0x454b,
        0x4731,
        0x423a,
        0x646a,
        0x414a,
        0x4c36,
        0x3331,
        0x647b,
        0x6473,
        0x647a,
        0x647d,
        0x647c,
        0x334e,
        0x333a,
        0x6477,
        0x6479,
        0x6478,
        0x456c,
        0x403d,
        0x5468,
        0x6522,
        0x3044,
        0x6524,
        0x6523,
        0x3c24,
        0x6525,
        0x6521,
        0x647e,
        0x3174,
        0x6528,
        0x6529,
        0x6526,
        0x6527,
        0x652a,
        0x4659,
        0x652b,
        0x652d,
        0x652c,
        0x652f,
        0x652e,
        0x3960,
        0x6530,
        0x6531,
        0x3b70,
        0x6c61,
        0x4370,
        0x3546,
        0x3b52,
        0x4169,
        0x546e,
        0x3e44,
        0x5746,
        0x5456,
        0x3253,
        0x6c3e,
        0x6a41,
        0x422f,
        0x3436,
        0x5157,
        0x3334,
        0x4832,
        0x3f3b,
        0x6c40,
        0x564b,
        0x6c3f,
        0x6c41,
        0x6c45,
        0x3e66,
        0x4c3f,
        0x455a,
        0x3e3c,
        0x6c46,
        0x317e,
        0x6c44,
        0x5528,
        0x3563,
        0x6c42,
        0x4136,
        0x3363,
        0x6c43,
        0x4b38,
        0x4043,
        0x4c7e,
        0x4152,
        0x6c48,
        0x3a66,
        0x4053,
        0x5672,
        0x514c,
        0x3f3e,
        0x3733,
        0x4955,
        0x6c47,
        0x3b62,
        0x4c4c,
        0x3d7d,
        0x4848,
        0x4f29,
        0x4d69,
        0x456b,
        0x3769,
        0x5149,
        0x3a38,
        0x6c49,
        0x6c4a,
        0x3b40,
        0x6c4b,
        0x6c62,
        0x313a,
        0x3759,
        0x3d39,
        0x6c4c,
        0x5166,
        0x6c4d,
        0x483b,
        0x6c51,
        0x6c53,
        0x3b4d,
        0x3c65,
        0x6c4f,
        0x4937,
        0x433a,
        0x6c63,
        0x5555,
        0x6c50,
        0x5673,
        0x6c52,
        0x6c4e,
        0x6c54,
        0x6c55,
        0x493f,
        0x4f28,
        0x505c,
        0x512c,
        0x485b,
        0x6c56,
        0x4e75,
        0x4a6c,
        0x6c5a,
        0x6c59,
        0x303e,
        0x6c57,
        0x6c58,
        0x6c64,
        0x483c,
        0x4147,
        0x6c5c,
        0x5160,
        0x6c5b,
        0x546f,
        0x6c5d,
        0x5b46,
        0x6c5e,
        0x312c,
        0x6c5f,
        0x6c60,
        0x5726,
        0x4540,
        0x6b3c,
        0x302e,
        0x3e74,
        0x3838,
        0x522f,
        0x3056,
        0x3579,
        0x5833,
        0x4b2c,
        0x635d,
        0x462c,
        0x3066,
        0x4546,
        0x6b39,
        0x6b3a,
        0x6b3b,
        0x5140,
        0x4523,
        0x6a72,
        0x4432,
        0x4435,
        0x404e,
        0x6a73,
        0x4441,
        0x4e6f,
        0x6a70,
        0x6a74,
        0x497c,
        0x4723,
        0x4c58,
        0x4e7e,
        0x6a75,
        0x6a76,
        0x4f2c,
        0x4067,
        0x6a77,
        0x363f,
        0x6a78,
        0x6a79,
        0x6a7a,
        0x6a7b,
        0x6a71,
        0x482e,
        0x616b,
        0x3738,
        0x616c,
        0x616d,
        0x5734,
        0x616e,
        0x616f,
        0x534c,
        0x6171,
        0x3f71,
        0x6170,
        0x3552,
        0x3137,
        0x6173,
        0x6172,
        0x3a7c,
        0x6174,
        0x3937,
        0x3e51,
        0x447c,
        0x3a5d,
        0x3d46,
        0x6175,
        0x6177,
        0x3640,
        0x4f41,
        0x4a28,
        0x6176,
        0x5578,
        0x537c,
        0x6178,
        0x617c,
        0x6179,
        0x617a,
        0x406a,
        0x617e,
        0x6221,
        0x4047,
        0x617b,
        0x617d,
        0x6225,
        0x4154,
        0x6223,
        0x6228,
        0x327e,
        0x6222,
        0x434d,
        0x3242,
        0x6227,
        0x6226,
        0x6224,
        0x6229,
        0x622b,
        0x5049,
        0x566d,
        0x4328,
        0x622c,
        0x4f57,
        0x622e,
        0x3a6f,
        0x6960,
        0x622d,
        0x622a,
        0x3b2b,
        0x5433,
        0x6230,
        0x622f,
        0x6961,
        0x6231,
        0x6232,
        0x6233,
        0x4c21,
        0x6234,
        0x6235,
        0x507e,
        0x424a,
        0x5371,
        0x4d75,
        0x6760,
        0x6761,
        0x3e41,
        0x426a,
        0x6764,
        0x6763,
        0x4d66,
        0x4335,
        0x6762,
        0x3b37,
        0x4f56,
        0x4161,
        0x6769,
        0x6768,
        0x6774,
        0x3223,
        0x676a,
        0x6766,
        0x676c,
        0x676b,
        0x493a,
        0x5564,
        0x6765,
        0x3729,
        0x6767,
        0x676e,
        0x6773,
        0x5669,
        0x676d,
        0x6772,
        0x6771,
        0x3060,
        0x6775,
        0x4772,
        0x4045,
        0x406d,
        0x4170,
        0x6770,
        0x6776,
        0x4b76,
        0x6822,
        0x6821,
        0x5741,
        0x677a,
        0x6779,
        0x677b,
        0x6777,
        0x677e,
        0x677d,
        0x677c,
        0x4155,
        0x4759,
        0x457d,
        0x4543,
        0x476d,
        0x6823,
        0x6826,
        0x6825,
        0x6827,
        0x3a77,
        0x6778,
        0x6824,
        0x4870,
        0x492a,
        0x6829,
        0x3965,
        0x517e,
        0x6828,
        0x682a,
        0x682d,
        0x682e,
        0x4127,
        0x682f,
        0x6830,
        0x682c,
        0x6834,
        0x682b,
        0x6831,
        0x6835,
        0x6832,
        0x6833,
        0x6837,
        0x6836,
        0x394f,
        0x702c,
        0x702d,
        0x4630,
        0x306a,
        0x483f,
        0x4d5f,
        0x4e4d,
        0x6a31,
        0x6a32,
        0x463f,
        0x3449,
        0x6a33,
        0x5567,
        0x5d79,
        0x6a34,
        0x6a35,
        0x6a36,
        0x384a,
        0x5f30,
        0x4975,
        0x4c70,
        0x497a,
        0x497b,
        0x5343,
        0x4b26,
        0x3826,
        0x702e,
        0x3142,
        0x6538,
        0x4c6f,
        0x5349,
        0x3c57,
        0x496a,
        0x3567,
        0x4450,
        0x3569,
        0x6e2e,
        0x3b2d,
        0x675e,
        0x6e2f,
        0x3329,
        0x6e32,
        0x6e31,
        0x3d67,
        0x6e30,
        0x4e37,
        0x454f,
        0x4174,
        0x5b4e,
        0x6e33,
        0x5073,
        0x4254,
        0x4668,
        0x372c,
        0x6e34,
        0x336b,
        0x3b7b,
        0x6e35,
        0x675c,
        0x6e36,
        0x3d2e,
        0x7162,
        0x4a68,
        0x5249,
        0x705a,
        0x705b,
        0x705c,
        0x4146,
        0x386d,
        0x3e4e,
        0x705e,
        0x4531,
        0x705d,
        0x5171,
        0x7060,
        0x304c,
        0x3d6a,
        0x525f,
        0x705f,
        0x342f,
        0x3768,
        0x7066,
        0x7065,
        0x4623,
        0x7061,
        0x7062,
        0x3443,
        0x7063,
        0x556e,
        0x4c5b,
        0x3e52,
        0x3c32,
        0x7068,
        0x7067,
        0x7064,
        0x3221,
        0x5622,
        0x5338,
        0x3e37,
        0x482c,
        0x706a,
        0x5177,
        0x564c,
        0x3a5b,
        0x7069,
        0x363b,
        0x4d34,
        0x4626,
        0x4121,
        0x706b,
        0x706e,
        0x706d,
        0x7070,
        0x706c,
        0x3b3e,
        0x706f,
        0x4c35,
        0x7072,
        0x3355,
        0x3154,
        0x7073,
        0x7074,
        0x7076,
        0x3461,
        0x7071,
        0x7077,
        0x707a,
        0x7078,
        0x7075,
        0x707d,
        0x7079,
        0x707c,
        0x707e,
        0x7121,
        0x4e41,
        0x7124,
        0x7123,
        0x4176,
        0x707b,
        0x4a5d,
        0x3471,
        0x3171,
        0x4c31,
        0x7126,
        0x7127,
        0x712c,
        0x554e,
        0x7129,
        0x4833,
        0x7122,
        0x712b,
        0x7128,
        0x7125,
        0x712a,
        0x3029,
        0x712d,
        0x712f,
        0x7131,
        0x7130,
        0x712e,
        0x5122,
        0x7132,
        0x7133,
        0x396f,
        0x3547,
        0x3057,
        0x3059,
        0x546d,
        0x3544,
        0x3d54,
        0x3b4a,
        0x7027,
        0x385e,
        0x7028,
        0x3028,
        0x7029,
        0x4d6e,
        0x702a,
        0x702b,
        0x4624,
        0x5665,
        0x7164,
        0x7165,
        0x4373,
        0x535b,
        0x5651,
        0x4568,
        0x532f,
        0x5266,
        0x6e41,
        0x303b,
        0x5535,
        0x514e,
        0x3c60,
        0x3a50,
        0x3f78,
        0x3847,
        0x3541,
        0x454c,
        0x4a22,
        0x434b,
        0x6e42,
        0x443f,
        0x3622,
        0x6d6c,
        0x4324,
        0x5631,
        0x4f60,
        0x6d6f,
        0x454e,
        0x365c,
        0x4a21,
        0x6d6d,
        0x6d70,
        0x6d71,
        0x433c,
        0x3f34,
        0x6d6e,
        0x6d74,
        0x6d72,
        0x5566,
        0x435f,
        0x6d73,
        0x6d76,
        0x5523,
        0x5123,
        0x6d75,
        0x4350,
        0x6d77,
        0x3f74,
        0x3e6c,
        0x6d78,
        0x4c77,
        0x515b,
        0x5745,
        0x5576,
        0x6d7c,
        0x6d7b,
        0x6d79,
        0x6d7a,
        0x6d7d,
        0x3e26,
        0x4b2f,
        0x6e21,
        0x363d,
        0x6e22,
        0x4440,
        0x6d7e,
        0x3d5e,
        0x3247,
        0x3643,
        0x6e25,
        0x583a,
        0x6e23,
        0x6e26,
        0x4369,
        0x3372,
        0x6e27,
        0x6e24,
        0x4f39,
        0x6e28,
        0x4277,
        0x6e29,
        0x6e2a,
        0x5e2b,
        0x4633,
        0x4746,
        0x5675,
        0x3549,
        0x4b32,
        0x6e2b,
        0x4d2b,
        0x6e2c,
        0x5530,
        0x6e2d,
        0x7644,
        0x5b47,
        0x3423,
        0x432c,
        0x7166,
        0x4a38,
        0x5253,
        0x562a,
        0x6f72,
        0x3e58,
        0x3d43,
        0x6f73,
        0x364c,
        0x302b,
        0x4a2f,
        0x6d36,
        0x6d37,
        0x4e79,
        0x372f,
        0x3f73,
        0x6d38,
        0x426b,
        0x4930,
        0x6d39,
        0x4676,
        0x3f33,
        0x6d3c,
        0x4578,
        0x5150,
        0x5729,
        0x6d3a,
        0x6d3b,
        0x5162,
        0x6d3f,
        0x6d40,
        0x6d44,
        0x6d48,
        0x6d46,
        0x6d4e,
        0x5568,
        0x6d49,
        0x6d47,
        0x6d3e,
        0x4569,
        0x4646,
        0x4969,
        0x5452,
        0x6d41,
        0x6d42,
        0x6d43,
        0x6d45,
        0x4079,
        0x3421,
        0x3968,
        0x6d50,
        0x6d51,
        0x6d4a,
        0x6d4f,
        0x4e78,
        0x4b36,
        0x6d4c,
        0x6d4d,
        0x4f75,
        0x6d52,
        0x4172,
        0x5332,
        0x6d4b,
        0x4837,
        0x3c6f,
        0x4570,
        0x6d56,
        0x356f,
        0x4235,
        0x302d,
        0x4b69,
        0x312e,
        0x6d54,
        0x4d6b,
        0x3562,
        0x6d55,
        0x6d53,
        0x6d57,
        0x357a,
        0x6d58,
        0x6d59,
        0x6d5c,
        0x314c,
        0x4576,
        0x3c6e,
        0x6d5a,
        0x4c3c,
        0x326a,
        0x6d5b,
        0x446b,
        0x3445,
        0x3075,
        0x6d5f,
        0x405a,
        0x3468,
        0x454d,
        0x6d5d,
        0x3f44,
        0x6d5e,
        0x4425,
        0x6d60,
        0x6d61,
        0x6d63,
        0x4157,
        0x3b47,
        0x3d38,
        0x6d62,
        0x6d64,
        0x6d66,
        0x6d65,
        0x6d67,
        0x4a3e,
        0x6c6a,
        0x4071,
        0x4967,
        0x6c6b,
        0x466e,
        0x6c6c,
        0x466d,
        0x6c6d,
        0x6c70,
        0x5766,
        0x6c73,
        0x6c71,
        0x6c6e,
        0x6c6f,
        0x5723,
        0x4971,
        0x4b6e,
        0x6c74,
        0x6c72,
        0x4f69,
        0x6c76,
        0x4631,
        0x3c40,
        0x6c75,
        0x353b,
        0x3b76,
        0x6c77,
        0x5977,
        0x3d7b,
        0x423b,
        0x6c78,
        0x6c79,
        0x3823,
        0x6c7a,
        0x6c7b,
        0x6c7c,
        0x536d,
        0x582e,
        0x406b,
        0x475d,
        0x3a4c,
        0x5063,
        0x4b3d,
        0x4d3a,
        0x3851,
        0x317c,
        0x476f,
        0x5656,
        0x3f46,
        0x436b,
        0x6f75,
        0x4358,
        0x5762,
        0x6f77,
        0x3353,
        0x4758,
        0x516d,
        0x5648,
        0x6f78,
        0x6f76,
        0x3b7d,
        0x3346,
        0x3d55,
        0x5246,
        0x3b60,
        0x4f21,
        0x6f7c,
        0x6f7b,
        0x6f79,
        0x334c,
        0x4954,
        0x4b30,
        0x6f7e,
        0x305e,
        0x5649,
        0x6f7d,
        0x336d,
        0x7655,
        0x4e48,
        0x7022,
        0x7021,
        0x353e,
        0x3c5a,
        0x3b7c,
        0x3865,
        0x4442,
        0x7023,
        0x4b6b,
        0x7026,
        0x5128,
        0x3e3f,
        0x476e,
        0x7136,
        0x7137,
        0x3f55,
        0x3429,
        0x7138,
        0x4d3b,
        0x4754,
        0x552d,
        0x7139,
        0x713a,
        0x474f,
        0x5224,
        0x564f,
        0x713b,
        0x3d51,
        0x3430,
        0x3e3d,
        0x345c,
        0x4e51,
        0x3f5f,
        0x713d,
        0x3f7a,
        0x713c,
        0x713f,
        0x713e,
        0x7140,
        0x7141,
        0x417e,
        0x4122,
        0x4a7a,
        0x553e,
        0x3e3a,
        0x3e39,
        0x5542,
        0x3f22,
        0x4d2f,
        0x7135,
        0x3d5f,
        0x364b,
        0x5671,
        0x7343,
        0x7344,
        0x384d,
        0x7346,
        0x7347,
        0x304a,
        0x7345,
        0x7349,
        0x4b71,
        0x734b,
        0x5026,
        0x314a,
        0x7348,
        0x734f,
        0x3551,
        0x7357,
        0x7352,
        0x7354,
        0x7353,
        0x377b,
        0x313f,
        0x734e,
        0x734a,
        0x355a,
        0x7350,
        0x7351,
        0x7355,
        0x734d,
        0x3c63,
        0x417d,
        0x7356,
        0x735a,
        0x734c,
        0x3548,
        0x3d6e,
        0x735c,
        0x3724,
        0x3f70,
        0x567e,
        0x4d32,
        0x3470,
        0x325f,
        0x7358,
        0x7359,
        0x4938,
        0x735d,
        0x735e,
        0x7361,
        0x735f,
        0x7363,
        0x7362,
        0x735b,
        0x3f6a,
        0x336f,
        0x7360,
        0x4729,
        0x3c72,
        0x736b,
        0x393f,
        0x7364,
        0x322d,
        0x3b7e,
        0x4b63,
        0x736d,
        0x7369,
        0x395c,
        0x736e,
        0x7365,
        0x7366,
        0x736a,
        0x4261,
        0x736c,
        0x736f,
        0x7368,
        0x3c7d,
        0x4f64,
        0x7370,
        0x7367,
        0x7372,
        0x572d,
        0x462a,
        0x7373,
        0x7371,
        0x4228,
        0x385d,
        0x7375,
        0x7374,
        0x345b,
        0x7376,
        0x7377,
        0x7378,
        0x403a,
        0x4069,
        0x4571,
        0x737b,
        0x737a,
        0x3458,
        0x737e,
        0x7379,
        0x737c,
        0x737d,
        0x7421,
        0x7423,
        0x3b49,
        0x7422,
        0x7424,
        0x323e,
        0x7426,
        0x7425,
        0x3c2e,
        0x4357,
        0x5961,
        0x4060,
        0x744c,
        0x5751,
        0x375b,
        0x744e,
        0x4123,
        0x4649,
        0x3456,
        0x5533,
        0x7450,
        0x744f,
        0x7451,
        0x4b5a,
        0x7452,
        0x5441,
        0x5660,
        0x3760,
        0x4138,
        0x413b,
        0x7453,
        0x3e2c,
        0x3462,
        0x7454,
        0x7455,
        0x3e2b,
        0x7456,
        0x745b,
        0x7457,
        0x745a,
        0x3a7d,
        0x7458,
        0x7459,
        0x3862,
        0x4c47,
        0x745c,
        0x325a,
        0x4353,
        0x5463,
        0x3f37,
        0x745d,
        0x4534,
        0x7469,
        0x4f35,
        0x4e49,
        0x4b58,
        0x4b77,
        0x3d74,
        0x574f,
        0x405b,
        0x5075,
        0x746a,
        0x746b,
        0x746c,
        0x7763,
        0x3731,
        0x746d,
        0x576b,
        0x746e,
        0x6679,
        0x3e40,
        0x667a,
        0x3a6c,
        0x667b,
        0x4f4b,
        0x667c,
        0x543c,
        0x3c36,
        0x667d,
        0x667e,
        0x3c4d,
        0x4852,
        0x4e33,
        0x6721,
        0x343f,
        0x6722,
        0x4934,
        0x3859,
        0x4449,
        0x575d,
        0x425a,
        0x3757,
        0x563d,
        0x4e46,
        0x3744,
        0x4526,
        0x6723,
        0x4f5f,
        0x6724,
        0x6725,
        0x6726,
        0x4137,
        0x5769,
        0x4970,
        0x4f38,
        0x562f,
        0x5655,
        0x6727,
        0x306d,
        0x6728,
        0x6729,
        0x495c,
        0x526f,
        0x3e2d,
        0x672a,
        0x3073,
        0x485e,
        0x3d61,
        0x672b,
        0x4846,
        0x672c,
        0x3b66,
        0x3878,
        0x5124,
        0x672d,
        0x4267,
        0x3e78,
        0x3d4a,
        0x4d33,
        0x672e,
        0x672f,
        0x3e6e,
        0x5065,
        0x4b67,
        0x4c50,
        0x3c4c,
        0x6730,
        0x3c28,
        0x5077,
        0x6731,
        0x5078,
        0x6732,
        0x6733,
        0x3442,
        0x6734,
        0x6735,
        0x497e,
        0x4e2c,
        0x4360,
        0x6737,
        0x3141,
        0x3371,
        0x6738,
        0x6739,
        0x575b,
        0x5540,
        0x673a,
        0x424c,
        0x573a,
        0x673b,
        0x673c,
        0x673d,
        0x3c6a,
        0x4365,
        0x4042,
        0x673e,
        0x673f,
        0x3c29,
        0x6740,
        0x6741,
        0x6736,
        0x3650,
        0x6742,
        0x6743,
        0x6744,
        0x3b3a,
        0x355e,
        0x4246,
        0x3160,
        0x6745,
        0x5435,
        0x6746,
        0x383f,
        0x6748,
        0x6747,
        0x376c,
        0x6749,
        0x3278,
        0x674a,
        0x674b,
        0x674c,
        0x674d,
        0x674e,
        0x674f,
        0x6750,
        0x5327,
        0x4b75,
        0x6751,
        0x6752,
        0x6753,
        0x6754,
        0x4949,
        0x6755,
        0x6756,
        0x6757,
        0x6758,
        0x6759,
        0x3d49,
        0x675a,
        0x733e,
        0x3857,
        0x4831,
        0x733f,
        0x7340,
        0x7341,
        0x395e,
        0x4d78,
        0x5868,
        0x3a31,
        0x425e,
        0x6e37,
        0x3723,
        0x6e39,
        0x6e38,
        0x3055,
        0x6e3b,
        0x5556,
        0x576f,
        0x5643,
        0x6e3d,
        0x4a70,
        0x6e3c,
        0x6e3e,
        0x6e40,
        0x6e3f,
        0x5172,
        0x473c,
        0x4340,
        0x3861,
        0x4167,
        0x7446,
        0x505f,
        0x7447,
        0x4f5b,
        0x483a,
        0x7448,
        0x7449,
        0x744a,
        0x744b,
        0x597a,
        0x387e,
        0x6571,
        0x5370,
        0x7460,
        0x4e4c,
        0x3361,
        0x7134,
        0x526e,
        0x7461,
        0x4f68,
        0x7462,
        0x474c,
        0x3554,
        0x3464,
        0x7464,
        0x7463,
        0x7465,
        0x7466,
        0x7467,
        0x3a32,
        0x303f,
        0x7468,
        0x372d,
        0x526d,
        0x522b,
        0x404f,
        0x3f3c,
        0x6b23,
        0x555f,
        0x6a48,
        0x7173,
        0x3678,
        0x4b23,
        0x444d,
        0x7167,
        0x7168,
        0x387b,
        0x7169,
        0x3a44,
        0x5445,
        0x3052,
        0x716a,
        0x716b,
        0x716c,
        0x716d,
        0x716e,
        0x716f,
        0x7171,
        0x7170,
        0x4555,
        0x7172,
        0x367a,
        0x7174,
        0x522e,
        0x5e47,
        0x4b4a,
        0x335c,
        0x3522,
        0x3922,
        0x4474,
        0x7175,
        0x7176,
        0x4144,
        0x417b,
        0x5630,
        0x7177,
        0x7178,
        0x412a,
        0x4638,
        0x3e5b,
        0x7179,
        0x344f,
        0x717a,
        0x6d32,
        0x6d31,
        0x4b60,
        0x525e,
        0x4b41,
        0x5558,
        0x4862,
        0x405f,
        0x3c21,
        0x6b41,
        0x5024,
        0x5662,
        0x3647,
        0x3858,
        0x6b40,
        0x384e,
        0x6b3f,
        0x3326,
        0x3949,
        0x562b,
        0x3774,
        0x374a,
        0x3c67,
        0x373e,
        0x6b46,
        0x6b47,
        0x3039,
        0x3f4f,
        0x6b45,
        0x537d,
        0x6b48,
        0x6b49,
        0x374e,
        0x6b42,
        0x6b44,
        0x4976,
        0x5657,
        0x554d,
        0x5032,
        0x6b4f,
        0x4e38,
        0x6b50,
        0x3528,
        0x3133,
        0x6b52,
        0x4c25,
        0x4556,
        0x6b53,
        0x6b51,
        0x455f,
        0x6b4e,
        0x4a24,
        0x6b55,
        0x307b,
        0x3a7a,
        0x5837,
        0x7163,
        0x6b4a,
        0x6b4b,
        0x6b4c,
        0x6b4d,
        0x6b56,
        0x6640,
        0x6b59,
        0x3f68,
        0x5248,
        0x6b57,
        0x6b5c,
        0x386c,
        0x6b58,
        0x3d3a,
        0x5058,
        0x3037,
        0x6b5d,
        0x445c,
        0x562c,
        0x3460,
        0x4276,
        0x3c39,
        0x6b5a,
        0x6b5b,
        0x5460,
        0x466a,
        0x4454,
        0x6b5f,
        0x4527,
        0x5975,
        0x3231,
        0x6b64,
        0x3d45,
        0x6b62,
        0x6b63,
        0x382c,
        0x4d51,
        0x6b65,
        0x6b61,
        0x4133,
        0x4622,
        0x4c73,
        0x6b66,
        0x4030,
        0x5238,
        0x6b67,
        0x382f,
        0x382d,
        0x6b68,
        0x473b,
        0x4d73,
        0x6b6a,
        0x6b6b,
        0x6b6d,
        0x5048,
        0x6b72,
        0x6b6e,
        0x6b71,
        0x4879,
        0x517c,
        0x6b6c,
        0x6b69,
        0x3839,
        0x4f59,
        0x4465,
        0x6b6f,
        0x6b70,
        0x4c5a,
        0x4d48,
        0x3072,
        0x6b76,
        0x6b75,
        0x3232,
        0x3860,
        0x6b77,
        0x316c,
        0x4c45,
        0x4424,
        0x4f25,
        0x6b79,
        0x6c22,
        0x4572,
        0x6b7a,
        0x4945,
        0x625f,
        0x6b7e,
        0x4d4e,
        0x6c21,
        0x315b,
        0x5337,
        0x525c,
        0x6b7d,
        0x6b7b,
        0x333c,
        0x6a30,
        0x5754,
        0x742b,
        0x3374,
        0x5641,
        0x5642,
        0x5569,
        0x3e4a,
        0x7427,
        0x5228,
        0x7428,
        0x7429,
        0x742a,
        0x3e4b,
        0x535f,
        0x4960,
        0x4961,
        0x7342,
        0x4a66,
        0x4c72,
        0x6236,
        0x4b34,
        0x4e68,
        0x565b,
        0x742d,
        0x742e,
        0x742f,
        0x7432,
        0x3a3d,
        0x7433,
        0x3063,
        0x7430,
        0x7431,
        0x3d22,
        0x3255,
        0x7436,
        0x7437,
        0x3666,
        0x3230,
        0x4f4f,
        0x7434,
        0x342c,
        0x7435,
        0x7438,
        0x7439,
        0x4d27,
        0x743a,
        0x743b,
        0x743c,
        0x4b52,
        0x743d,
        0x743e,
        0x743f,
        0x745e,
        0x413c,
        0x3c68,
        0x492b,
        0x515e,
        0x6575,
        0x5c33,
        0x5255,
        0x5c34,
        0x302c,
        0x5c35,
        0x3d5a,
        0x5c39,
        0x5842,
        0x5c37,
        0x5373,
        0x4956,
        0x5c3a,
        0x5c36,
        0x5c3b,
        0x4322,
        0x5c3c,
        0x5c45,
        0x5c3d,
        0x4e5f,
        0x5625,
        0x5c4f,
        0x5c4d,
        0x5c52,
        0x3d66,
        0x422b,
        0x5c38,
        0x5c4b,
        0x5c4e,
        0x5c3e,
        0x3752,
        0x3045,
        0x5c47,
        0x503e,
        0x5c41,
        0x3b28,
        0x373c,
        0x5c4c,
        0x5c46,
        0x5c3f,
        0x475b,
        0x513f,
        0x5c40,
        0x5c4a,
        0x5c50,
        0x4e2d,
        0x5c42,
        0x5c43,
        0x5c48,
        0x5c49,
        0x3254,
        0x5c51,
        0x4b55,
        0x5437,
        0x5c5b,
        0x5c5f,
        0x4c26,
        0x5c66,
        0x4367,
        0x5c5c,
        0x3f41,
        0x5c59,
        0x307a,
        0x3936,
        0x5c65,
        0x5c53,
        0x5c44,
        0x5c56,
        0x4874,
        0x3f60,
        0x493b,
        0x313d,
        0x5322,
        0x5c5a,
        0x5c55,
        0x463b,
        0x5c5e,
        0x5742,
        0x432f,
        0x3736,
        0x4751,
        0x4329,
        0x5c62,
        0x5c58,
        0x5c6b,
        0x5c54,
        0x5c5d,
        0x3e25,
        0x5c57,
        0x5c60,
        0x5c63,
        0x5c64,
        0x5c78,
        0x5c61,
        0x5d22,
        0x5c67,
        0x3c6b,
        0x3444,
        0x4323,
        0x3267,
        0x5c7a,
        0x5c72,
        0x5c6f,
        0x5c7c,
        0x5c6e,
        0x5270,
        0x3268,
        0x4857,
        0x4863,
        0x5c7b,
        0x5c6d,
        0x5c77,
        0x5c75,
        0x3e23,
        0x5c74,
        0x325d,
        0x5c73,
        0x3c76,
        0x5c68,
        0x3b44,
        0x4073,
        0x3c54,
        0x5c69,
        0x5c6a,
        0x5c71,
        0x5c76,
        0x5c79,
        0x3534,
        0x4859,
        0x3b67,
        0x5c7e,
        0x5c7d,
        0x532b,
        0x5d21,
        0x5d23,
        0x5d25,
        0x5271,
        0x5d24,
        0x5d26,
        0x5d27,
        0x5229,
        0x3a49,
        0x5d29,
        0x5d36,
        0x5d31,
        0x5d34,
        0x5d30,
        0x464e,
        0x4072,
        0x492f,
        0x5c6c,
        0x5d2e,
        0x5d37,
        0x5c70,
        0x5d2f,
        0x5d38,
        0x5d2c,
        0x5d39,
        0x5d33,
        0x5d2d,
        0x442a,
        0x5d28,
        0x4033,
        0x412b,
        0x5d2a,
        0x5d2b,
        0x5d32,
        0x3b71,
        0x5d35,
        0x5328,
        0x5d3a,
        0x5d3b,
        0x4327,
        0x5d52,
        0x5d3c,
        0x5d51,
        0x393d,
        0x3e55,
        0x3e7a,
        0x3a4a,
        0x5d4a,
        0x5d45,
        0x5d3f,
        0x324b,
        0x5d43,
        0x5d4b,
        0x3224,
        0x5d55,
        0x5d3e,
        0x4650,
        0x5d50,
        0x5d54,
        0x4162,
        0x3746,
        0x5d4e,
        0x5d4f,
        0x5d44,
        0x5d3d,
        0x5d4d,
        0x4c51,
        0x5d49,
        0x5d42,
        0x4348,
        0x463c,
        0x4e2e,
        0x5d4c,
        0x5d48,
        0x5d41,
        0x5d46,
        0x425c,
        0x5329,
        0x532a,
        0x5d53,
        0x4f74,
        0x4878,
        0x5d66,
        0x5d47,
        0x5d60,
        0x4264,
        0x5d61,
        0x5d57,
        0x5678,
        0x5d59,
        0x5d58,
        0x3870,
        0x5d56,
        0x464f,
        0x362d,
        0x5d62,
        0x3a79,
        0x5461,
        0x5d67,
        0x3450,
        0x5d5a,
        0x3f7b,
        0x5d63,
        0x5d5f,
        0x5d5d,
        0x3559,
        0x5d5b,
        0x5d5c,
        0x5d5e,
        0x3d2f,
        0x5d64,
        0x5d65,
        0x5d75,
        0x4349,
        0x4b62,
        0x5d72,
        0x5861,
        0x4651,
        0x5d74,
        0x5574,
        0x5d73,
        0x5d70,
        0x5d6c,
        0x5d6f,
        0x5d68,
        0x506e,
        0x4858,
        0x5d6e,
        0x5d69,
        0x5d6a,
        0x4b72,
        0x5d6d,
        0x314d,
        0x4036,
        0x3c3b,
        0x5d71,
        0x5d77,
        0x5d76,
        0x5d6b,
        0x456e,
        0x5d7b,
        0x5e24,
        0x5e23,
        0x5d78,
        0x436f,
        0x427b,
        0x5561,
        0x4e35,
        0x5d7d,
        0x324c,
        0x4468,
        0x4a5f,
        0x473e,
        0x5d7a,
        0x5d7c,
        0x5d7e,
        0x5e22,
        0x302a,
        0x314e,
        0x5e2c,
        0x5e26,
        0x3d36,
        0x486f,
        0x5e21,
        0x5e25,
        0x5e29,
        0x5e28,
        0x5e27,
        0x5e2d,
        0x544c,
        0x5e33,
        0x5e2a,
        0x5e2e,
        0x4059,
        0x3121,
        0x5e36,
        0x5e31,
        0x5e32,
        0x5126,
        0x5e35,
        0x5e2f,
        0x5e30,
        0x503d,
        0x5e34,
        0x4a6d,
        0x5e39,
        0x5e38,
        0x5e37,
        0x5e3b,
        0x3d65,
        0x3258,
        0x436a,
        0x5e3a,
        0x453a,
        0x5e3c,
        0x4c59,
        0x372a,
        0x5465,
        0x5e3d,
        0x5e3f,
        0x4422,
        0x5e41,
        0x5e3e,
        0x5e40,
        0x553a,
        0x5e42,
        0x722e,
        0x3b22,
        0x4232,
        0x4530,
        0x4247,
        0x722f,
        0x5069,
        0x535d,
        0x6b3d,
        0x3366,
        0x7230,
        0x7231,
        0x4a2d,
        0x3a67,
        0x7233,
        0x7235,
        0x7234,
        0x4b64,
        0x4f3a,
        0x7232,
        0x4a34,
        0x524f,
        0x426c,
        0x4e43,
        0x7238,
        0x3076,
        0x7237,
        0x723e,
        0x324f,
        0x5141,
        0x723a,
        0x723c,
        0x5469,
        0x723b,
        0x7236,
        0x723f,
        0x723d,
        0x7239,
        0x7247,
        0x7244,
        0x7246,
        0x724a,
        0x7242,
        0x7240,
        0x7245,
        0x567b,
        0x7241,
        0x4779,
        0x495f,
        0x7248,
        0x3946,
        0x3530,
        0x7243,
        0x7249,
        0x7250,
        0x7256,
        0x3b57,
        0x7255,
        0x4d5c,
        0x566b,
        0x7252,
        0x7254,
        0x3872,
        0x724b,
        0x724e,
        0x4279,
        0x555d,
        0x724c,
        0x724d,
        0x724f,
        0x7253,
        0x7259,
        0x533c,
        0x366a,
        0x4a71,
        0x3764,
        0x7257,
        0x7258,
        0x725a,
        0x725d,
        0x725b,
        0x725c,
        0x5151,
        0x7251,
        0x4d49,
        0x4e4f,
        0x5629,
        0x7263,
        0x435b,
        0x7260,
        0x402f,
        0x726c,
        0x725e,
        0x7261,
        0x7268,
        0x7262,
        0x7267,
        0x7266,
        0x7269,
        0x725f,
        0x7264,
        0x726a,
        0x532c,
        0x7265,
        0x3275,
        0x7272,
        0x502b,
        0x7275,
        0x3b48,
        0x7279,
        0x7270,
        0x7276,
        0x7278,
        0x727a,
        0x7273,
        0x7271,
        0x3a7b,
        0x357b,
        0x726f,
        0x7277,
        0x726d,
        0x726e,
        0x726b,
        0x7326,
        0x7323,
        0x7322,
        0x7274,
        0x485a,
        0x727b,
        0x7325,
        0x4378,
        0x727d,
        0x7327,
        0x7329,
        0x7324,
        0x727c,
        0x732b,
        0x732a,
        0x425d,
        0x732e,
        0x7330,
        0x7321,
        0x7331,
        0x732c,
        0x732f,
        0x727e,
        0x732d,
        0x7332,
        0x7334,
        0x7328,
        0x7333,
        0x7335,
        0x5037,
        0x7338,
        0x5979,
        0x7339,
        0x7337,
        0x4864,
        0x7336,
        0x733a,
        0x733b,
        0x3440,
        0x6e43,
        0x733c,
        0x733d,
        0x512a,
        0x742c,
        0x5046,
        0x5050,
        0x515c,
        0x4f4e,
        0x3d56,
        0x5143,
        0x3a62,
        0x6169,
        0x5242,
        0x7142,
        0x3239,
        0x316d,
        0x7143,
        0x4940,
        0x3344,
        0x5972,
        0x4b25,
        0x7144,
        0x5654,
        0x7145,
        0x7440,
        0x7146,
        0x542c,
        0x7147,
        0x3040,
        0x7441,
        0x7442,
        0x347c,
        0x455b,
        0x4c3b,
        0x5064,
        0x4d60,
        0x7148,
        0x5973,
        0x313b,
        0x4f2e,
        0x3824,
        0x714a,
        0x714b,
        0x3243,
        0x4151,
        0x5730,
        0x7149,
        0x714c,
        0x714e,
        0x5976,
        0x5261,
        0x5423,
        0x7443,
        0x4839,
        0x7444,
        0x714d,
        0x714f,
        0x3f63,
        0x7150,
        0x7154,
        0x7156,
        0x7151,
        0x4951,
        0x4561,
        0x4263,
        0x397c,
        0x7153,
        0x7155,
        0x3953,
        0x715b,
        0x3a56,
        0x307d,
        0x7159,
        0x7158,
        0x7152,
        0x715a,
        0x7157,
        0x486c,
        0x4d4a,
        0x715d,
        0x653d,
        0x715c,
        0x715e,
        0x715f,
        0x4f65,
        0x7445,
        0x3d73,
        0x7160,
        0x7161,
        0x4e77,
        0x522a,
        0x717b,
        0x3832,
        0x3c7b,
        0x395b,
        0x3966,
        0x4359,
        0x4a53,
        0x6a68,
        0x4040,
        0x3e75,
        0x6a69,
        0x6a6a,
        0x6a6b,
        0x6a6c,
        0x6a6d,
        0x6a6e,
        0x6a6f,
        0x3d47,
        0x757b,
        0x757d,
        0x757e,
        0x757c,
        0x3d62,
        0x7621,
        0x3425,
        0x7622,
        0x7623,
        0x6c32,
        0x5154,
        0x596a,
        0x7624,
        0x6e3a,
        0x5532,
        0x537e,
        0x4c5c,
        0x4a44,
        0x6540,
        0x7625,
        0x3e2f,
        0x4629,
        0x5a25,
        0x3c46,
        0x3629,
        0x383c,
        0x484f,
        0x3c25,
        0x5a26,
        0x5a27,
        0x4c56,
        0x4843,
        0x5a28,
        0x467d,
        0x5135,
        0x5269,
        0x5136,
        0x3c47,
        0x3d32,
        0x3b64,
        0x5a29,
        0x5a2a,
        0x5148,
        0x5a2b,
        0x506d,
        0x366f,
        0x425b,
        0x4b4f,
        0x376d,
        0x4968,
        0x3743,
        0x3e77,
        0x5624,
        0x5a2c,
        0x5a2d,
        0x4640,
        0x5767,
        0x4a36,
        0x5529,
        0x4b5f,
        0x556f,
        0x5a2e,
        0x565f,
        0x344a,
        0x5a30,
        0x5a2f,
        0x526b,
        0x5a31,
        0x5a32,
        0x5a33,
        0x4a54,
        0x5a34,
        0x4a2b,
        0x5a35,
        0x5a36,
        0x334f,
        0x566f,
        0x5a37,
        0x3b30,
        0x352e,
        0x5a38,
        0x5a39,
        0x396e,
        0x512f,
        0x5268,
        0x5a3a,
        0x3843,
        0x4f6a,
        0x326f,
        0x5a3b,
        0x5a3c,
        0x3d6b,
        0x4e5c,
        0x536f,
        0x5a3d,
        0x4e73,
        0x5a3e,
        0x5355,
        0x3b65,
        0x5a3f,
        0x4b35,
        0x4b50,
        0x5a40,
        0x476b,
        0x566e,
        0x5a41,
        0x4535,
        0x3641,
        0x5a42,
        0x374c,
        0x3f4e,
        0x5a43,
        0x5a44,
        0x4b2d,
        0x5a45,
        0x3577,
        0x5a46,
        0x4142,
        0x573b,
        0x5a47,
        0x4c38,
        0x526a,
        0x4431,
        0x5a48,
        0x357d,
        0x3b51,
        0x5a49,
        0x5033,
        0x5a4a,
        0x5a4b,
        0x4e3d,
        0x5a4c,
        0x5a4d,
        0x5a4e,
        0x3277,
        0x5a51,
        0x5a4f,
        0x5168,
        0x5a50,
        0x4355,
        0x5a52,
        0x5a53,
        0x5a54,
        0x5a55,
        0x503b,
        0x5225,
        0x3079,
        0x5a56,
        0x472b,
        0x5a57,
        0x3d77,
        0x4321,
        0x5a58,
        0x5a59,
        0x437d,
        0x4c37,
        0x5a5a,
        0x5a5b,
        0x403e,
        0x4657,
        0x5a5c,
        0x5a5d,
        0x4734,
        0x5a5e,
        0x5a5f,
        0x3948,
        0x3b6d,
        0x3639,
        0x7478,
        0x7479,
        0x4d63,
        0x7539,
        0x6b60,
        0x4f73,
        0x3b3f,
        0x3a40,
        0x5425,
        0x6159,
        0x7574,
        0x312a,
        0x3272,
        0x7575,
        0x7577,
        0x3a51,
        0x7576,
        0x4332,
        0x7579,
        0x7578,
        0x3134,
        0x556a,
        0x383a,
        0x3931,
        0x3246,
        0x5470,
        0x4f4d,
        0x305c,
        0x554b,
        0x3b75,
        0x564a,
        0x3737,
        0x4c30,
        0x4636,
        0x3161,
        0x393a,
        0x567c,
        0x3961,
        0x3721,
        0x3c7a,
        0x6a5a,
        0x6a5b,
        0x4c79,
        0x3973,
        0x6a5c,
        0x347b,
        0x4333,
        0x3751,
        0x3a58,
        0x6a5d,
        0x5474,
        0x6a5e,
        0x3c56,
        0x3b5f,
        0x6a5f,
        0x415e,
        0x4238,
        0x545f,
        0x574a,
        0x6a60,
        0x6a61,
        0x6a64,
        0x6a62,
        0x6a63,
        0x495e,
        0x3833,
        0x3644,
        0x6a65,
        0x4a6a,
        0x494d,
        0x344d,
        0x6259,
        0x4562,
        0x6a66,
        0x4035,
        0x5738,
        0x6a67,
        0x572c,
        0x487c,
        0x5853,
        0x584d,
        0x545e,
        0x5479,
        0x4944,
        0x532e,
        0x3853,
        0x3360,
        0x4962,
        0x7476,
        0x3a55,
        0x7477,
        0x575f,
        0x7471,
        0x3830,
        0x5554,
        0x384f,
        0x4670,
        0x3343,
        0x7472,
        0x332c,
        0x543d,
        0x4777,
        0x7474,
        0x7473,
        0x4c4b,
        0x4824,
        0x7475,
        0x5763,
        0x453f,
        0x7540,
        0x753b,
        0x7543,
        0x7542,
        0x563a,
        0x7541,
        0x543e,
        0x7544,
        0x754c,
        0x304f,
        0x3578,
        0x7549,
        0x754a,
        0x455c,
        0x7545,
        0x7546,
        0x7547,
        0x754b,
        0x3e60,
        0x7548,
        0x387a,
        0x7550,
        0x7553,
        0x3f67,
        0x3972,
        0x753c,
        0x754d,
        0x4237,
        0x4c78,
        0x3c79,
        0x754e,
        0x754f,
        0x7551,
        0x3665,
        0x7552,
        0x7555,
        0x753d,
        0x7554,
        0x533b,
        0x336c,
        0x4c24,
        0x7556,
        0x7557,
        0x3e61,
        0x7558,
        0x4c5f,
        0x755b,
        0x3248,
        0x5759,
        0x7559,
        0x755a,
        0x755c,
        0x7562,
        0x7560,
        0x755f,
        0x755d,
        0x7561,
        0x755e,
        0x7564,
        0x7565,
        0x4c63,
        0x653f,
        0x3538,
        0x7563,
        0x7568,
        0x4c23,
        0x7566,
        0x7567,
        0x753e,
        0x3144,
        0x753f,
        0x3545,
        0x3264,
        0x756c,
        0x7569,
        0x3657,
        0x756d,
        0x756a,
        0x756b,
        0x345a,
        0x546a,
        0x756e,
        0x3379,
        0x756f,
        0x7571,
        0x7570,
        0x7572,
        0x7573,
        0x496d,
        0x392a,
        0x477b,
        0x3663,
        0x4c49,
        0x6a26,
        0x3335,
        0x547e,
        0x396c,
        0x5079,
        0x696d,
        0x572a,
        0x696e,
        0x4256,
        0x486d,
        0x3a64,
        0x696f,
        0x6970,
        0x6971,
        0x5661,
        0x6972,
        0x6973,
        0x6975,
        0x6974,
        0x6976,
        0x6977,
        0x4761,
        0x6978,
        0x5458,
        0x6979,
        0x3d4e,
        0x697a,
        0x697b,
        0x3d4f,
        0x697c,
        0x3828,
        0x413e,
        0x697d,
        0x3132,
        0x3b54,
        0x3975,
        0x697e,
        0x6a21,
        0x6a22,
        0x6a23,
        0x3778,
        0x3c2d,
        0x4a64,
        0x604e,
        0x542f,
        0x4f3d,
        0x5537,
        0x6a24,
        0x555e,
        0x6a25,
        0x5041,
        0x393c,
        0x3447,
        0x3159,
        0x4031,
        0x3166,
        0x3167,
        0x3168,
        0x333d,
        0x4868,
        0x6541,
        0x315f,
        0x4149,
        0x346f,
        0x4728,
        0x5358,
        0x4679,
        0x5138,
        0x397d,
        0x4275,
        0x532d,
        0x544b,
        0x3d7c,
        0x6542,
        0x3735,
        0x6543,
        0x3b39,
        0x5562,
        0x3d78,
        0x5436,
        0x4e25,
        0x412c,
        0x3359,
        0x4c76,
        0x6546,
        0x6544,
        0x6548,
        0x654a,
        0x6547,
        0x354f,
        0x4648,
        0x357c,
        0x6545,
        0x4a76,
        0x6549,
        0x4354,
        0x3145,
        0x3c23,
        0x5737,
        0x4d4b,
        0x4b4d,
        0x4a4a,
        0x4c53,
        0x654c,
        0x654b,
        0x4466,
        0x5121,
        0x5137,
        0x654d,
        0x6550,
        0x4d38,
        0x5670,
        0x654f,
        0x355d,
        0x4d3e,
        0x6551,
        0x363a,
        0x4d28,
        0x3964,
        0x4a45,
        0x3351,
        0x4b59,
        0x546c,
        0x6552,
        0x376a,
        0x654e,
        0x6555,
        0x347e,
        0x6556,
        0x6553,
        0x6554,
        0x525d,
        0x425f,
        0x3146,
        0x5362,
        0x365d,
        0x4b6c,
        0x6557,
        0x5376,
        0x3169,
        0x3674,
        0x655a,
        0x6558,
        0x6559,
        0x3540,
        0x5245,
        0x655c,
        0x655e,
        0x655d,
        0x4732,
        0x5223,
        0x655b,
        0x5462,
        0x555a,
        0x6560,
        0x5771,
        0x6561,
        0x315c,
        0x517b,
        0x6562,
        0x6564,
        0x6563,
        0x6565,
        0x5258,
        0x354b,
        0x675f,
        0x5a75,
        0x5a78,
        0x5a76,
        0x5a77,
        0x5a7a,
        0x504f,
        0x4447,
        0x306e,
        0x5030,
        0x5a79,
        0x534a,
        0x3a2a,
        0x5b22,
        0x4771,
        0x5a7c,
        0x5a7b,
        0x495b,
        0x5a7d,
        0x5b21,
        0x575e,
        0x5a7e,
        0x415a,
        0x5b25,
        0x5374,
        0x5b27,
        0x5b24,
        0x5b28,
        0x3d3c,
        0x4049,
        0x5b23,
        0x5b26,
        0x5623,
        0x5b29,
        0x5b2d,
        0x5b2e,
        0x5b2c,
        0x3a42,
        0x3f24,
        0x5b2b,
        0x5b2a,
        0x5447,
        0x323f,
        0x5b2f,
        0x3979,
        0x5b30,
        0x333b,
        0x3526,
        0x363c,
        0x5b31,
        0x3675,
        0x5b32,
        0x3149,
        0x5b34,
        0x5b33,
        0x5b35,
        0x5b37,
        0x5b36,
        0x5b38,
        0x5b39,
        0x5b3a,
        0x534f,
        0x747a,
        0x4775,
        0x5743,
        0x4564,
        0x747c,
        0x747d,
        0x747b,
        0x3e46,
        0x506f,
        0x3753,
        0x544d,
        0x4c2a,
        0x7522,
        0x7521,
        0x3a28,
        0x747e,
        0x4b56,
        0x7524,
        0x4052,
        0x336a,
        0x4d2a,
        0x7525,
        0x7523,
        0x3d34,
        0x7528,
        0x7529,
        0x3d4d,
        0x4338,
        0x3f61,
        0x4b61,
        0x752a,
        0x7526,
        0x7527,
        0x4470,
        0x752c,
        0x343c,
        0x576d,
        0x3457,
        0x752b,
        0x752e,
        0x752d,
        0x752f,
        0x5051,
        0x4351,
        0x4829,
        0x7530,
        0x7531,
        0x7532,
        0x7533,
        0x7534,
        0x7535,
        0x7537,
        0x7536,
        0x7538,
        0x3249,
        0x5354,
        0x4a4d,
        0x406f,
        0x5658,
        0x5230,
        0x413f,
        0x3d70,
        0x382a,
        0x3c78,
        0x7646,
        0x7647,
        0x7648,
        0x7649,
        0x764a,
        0x764c,
        0x764b,
        0x7769,
        0x764d,
        0x764e,
        0x6e44,
        0x6e45,
        0x6e46,
        0x556b,
        0x3624,
        0x6e48,
        0x6e47,
        0x6e49,
        0x6e4a,
        0x4725,
        0x6e4b,
        0x6e4c,
        0x3730,
        0x3576,
        0x6e4d,
        0x6e4f,
        0x6e4e,
        0x3846,
        0x6e50,
        0x6e51,
        0x6e52,
        0x365b,
        0x332e,
        0x5653,
        0x4446,
        0x3135,
        0x3856,
        0x6e53,
        0x6e54,
        0x543f,
        0x4755,
        0x3e7b,
        0x4e59,
        0x3933,
        0x6e56,
        0x6e55,
        0x6e58,
        0x6e57,
        0x4525,
        0x6e59,
        0x6e5a,
        0x472e,
        0x6e5b,
        0x472f,
        0x6e5c,
        0x3227,
        0x6e5d,
        0x6e5e,
        0x6e5f,
        0x6e60,
        0x6e61,
        0x576a,
        0x6e62,
        0x6e63,
        0x3c58,
        0x6e64,
        0x534b,
        0x4c7a,
        0x322c,
        0x4165,
        0x6e65,
        0x4726,
        0x432d,
        0x6e66,
        0x6e67,
        0x6e68,
        0x6e69,
        0x6e6a,
        0x6e6b,
        0x6e6c,
        0x6e6d,
        0x6e6e,
        0x6e6f,
        0x6e70,
        0x6e71,
        0x6e72,
        0x6e74,
        0x6e73,
        0x6e75,
        0x4d2d,
        0x4241,
        0x6e76,
        0x6e77,
        0x6e78,
        0x5521,
        0x6e79,
        0x4f33,
        0x6e7a,
        0x6e7b,
        0x6e7c,
        0x6e7d,
        0x6f21,
        0x6e7e,
        0x6f22,
        0x3875,
        0x437a,
        0x6f23,
        0x6f24,
        0x3d42,
        0x523f,
        0x3279,
        0x6f25,
        0x6f26,
        0x6f27,
        0x5278,
        0x6f28,
        0x567d,
        0x6f29,
        0x464c,
        0x6f2a,
        0x6f2b,
        0x4134,
        0x6f2c,
        0x4f7a,
        0x4b78,
        0x6f2e,
        0x6f2d,
        0x337a,
        0x3978,
        0x6f2f,
        0x6f30,
        0x5062,
        0x6f31,
        0x6f32,
        0x3766,
        0x503f,
        0x6f33,
        0x6f34,
        0x6f35,
        0x4871,
        0x4c60,
        0x6f36,
        0x6f37,
        0x6f38,
        0x6f39,
        0x6f3a,
        0x5560,
        0x6f3b,
        0x346d,
        0x432a,
        0x6f3c,
        0x6f3d,
        0x6f3e,
        0x6f3f,
        0x4e7d,
        0x6f40,
        0x4260,
        0x3438,
        0x5736,
        0x3d75,
        0x4f47,
        0x6f43,
        0x6f41,
        0x6f42,
        0x6f44,
        0x3627,
        0x3c7c,
        0x3e62,
        0x434c,
        0x6f45,
        0x6f46,
        0x6f47,
        0x6f4f,
        0x6f48,
        0x6f49,
        0x6f4a,
        0x4742,
        0x6f71,
        0x364d,
        0x6f4b,
        0x6f4c,
        0x6f4d,
        0x3646,
        0x433e,
        0x6f4e,
        0x6f50,
        0x6f51,
        0x6f52,
        0x5572,
        0x6f53,
        0x4477,
        0x6f54,
        0x4478,
        0x6f55,
        0x6f56,
        0x3864,
        0x3077,
        0x6f57,
        0x6f58,
        0x6f59,
        0x6f5a,
        0x6f5b,
        0x6f5c,
        0x6f5d,
        0x6f5e,
        0x3e35,
        0x6f61,
        0x6f5f,
        0x6f60,
        0x6f62,
        0x6f63,
        0x414d,
        0x6f64,
        0x6f65,
        0x6f66,
        0x6f67,
        0x6f68,
        0x6f69,
        0x6f6a,
        0x6f6b,
        0x6f6c,
        0x4058,
        0x6f6d,
        0x412d,
        0x6f6e,
        0x6f6f,
        0x6f70,
        0x4f62,
        0x3324,
        0x4345,
        0x6345,
        0x4941,
        0x6346,
        0x3155,
        0x4e4a,
        0x3433,
        0x4872,
        0x6347,
        0x4f50,
        0x6348,
        0x3c64,
        0x6349,
        0x634a,
        0x4346,
        0x5522,
        0x4456,
        0x396b,
        0x4e45,
        0x634b,
        0x4376,
        0x634c,
        0x3727,
        0x3873,
        0x3a52,
        0x634d,
        0x634e,
        0x5444,
        0x634f,
        0x6350,
        0x514b,
        0x6351,
        0x6352,
        0x6353,
        0x6354,
        0x5156,
        0x6355,
        0x327b,
        0x403b,
        0x6356,
        0x402b,
        0x6357,
        0x6358,
        0x6359,
        0x635a,
        0x635b,
        0x3837,
        0x5a62,
        0x3653,
        0x5a64,
        0x5a63,
        0x5a66,
        0x486e,
        0x5a65,
        0x3740,
        0x5174,
        0x5275,
        0x5573,
        0x3d57,
        0x5768,
        0x5a68,
        0x5a67,
        0x3022,
        0x4d53,
        0x5a69,
        0x383d,
        0x3c4a,
        0x423d,
        0x4224,
        0x3342,
        0x5a6a,
        0x422a,
        0x4430,
        0x3d35,
        0x4f5e,
        0x5a6b,
        0x4942,
        0x315d,
        0x5a6c,
        0x3638,
        0x543a,
        0x337d,
        0x5a6d,
        0x5449,
        0x4f55,
        0x4563,
        0x5a6e,
        0x5a6f,
        0x5a70,
        0x416a,
        0x4c55,
        0x4f5d,
        0x5367,
        0x4221,
        0x5a71,
        0x4b65,
        0x5a72,
        0x4b66,
        0x527e,
        0x3874,
        0x5a73,
        0x302f,
        0x4f36,
        0x554f,
        0x4b6d,
        0x5a74,
        0x6344,
        0x4125,
        0x763f,
        0x7640,
        0x7641,
        0x4451,
        0x4838,
        0x5163,
        0x505b,
        0x5145,
        0x3c2f,
        0x394d,
        0x6f74,
        0x3446,
        0x533a,
        0x7642,
        0x337b,
        0x7643,
        0x3571,
        0x7645,
        0x536a,
        0x7627,
        0x5129,
        0x7629,
        0x7628,
        0x4163,
        0x4057,
        0x3122,
        0x4e6d,
        0x5068,
        0x762b,
        0x4f76,
        0x762a,
        0x5570,
        0x762c,
        0x4339,
        0x3b74,
        0x762e,
        0x762d,
        0x445e,
        0x4158,
        0x4b2a,
        0x4f3c,
        0x762f,
        0x7630,
        0x7631,
        0x4236,
        0x3054,
        0x4579,
        0x7632,
        0x4760,
        0x7626,
        0x3e38,
        0x3e32,
        0x3565,
        0x3747,
        0x3f3f,
        0x4352,
        0x4366,
        0x584c,
        0x386f,
        0x3d79,
        0x5125,
        0x3050,
        0x7730,
        0x7731,
        0x502c,
        0x3030,
        0x7732,
        0x7733,
        0x7734,
        0x474a,
        0x3e4f,
        0x7737,
        0x7736,
        0x315e,
        0x7735,
        0x7738,
        0x7739,
        0x4e24,
        0x484d,
        0x3a2b,
        0x6838,
        0x6839,
        0x683a,
        0x3e42,
        0x5274,
        0x544f,
        0x4958,
        0x5233,
        0x3625,
        0x476a,
        0x717c,
        0x4f6e,
        0x4b33,
        0x506b,
        0x676f,
        0x4d67,
        0x394b,
        0x3659,
        0x717d,
        0x3064,
        0x4b4c,
        0x717e,
        0x5424,
        0x422d,
        0x416c,
        0x4644,
        0x3e31,
        0x7221,
        0x3c55,
        0x7222,
        0x7223,
        0x7224,
        0x5243,
        0x4635,
        0x4d47,
        0x7225,
        0x5331,
        0x3f45,
        0x4c62,
        0x7226,
        0x7227,
        0x5155,
        0x366e,
        0x7228,
        0x7229,
        0x355f,
        0x722a,
        0x722b,
        0x327c,
        0x722c,
        0x722d,
        0x4827,
        0x3767,
        0x6c29,
        0x6c2a,
        0x6c2b,
        0x6c2c,
        0x462e,
        0x6c2d,
        0x6c2e,
        0x3749,
        0x4a33,
        0x6238,
        0x774f,
        0x7750,
        0x324d,
        0x7751,
        0x7753,
        0x7752,
        0x623b,
        0x3c22,
        0x623c,
        0x623d,
        0x623e,
        0x623f,
        0x6240,
        0x6241,
        0x3739,
        0x527b,
        0x3d24,
        0x4a4e,
        0x3125,
        0x4b47,
        0x6242,
        0x367c,
        0x4844,
        0x6243,
        0x3d48,
        0x317d,
        0x6244,
        0x3676,
        0x6245,
        0x4459,
        0x6246,
        0x4f5a,
        0x395d,
        0x6247,
        0x4021,
        0x6248,
        0x3276,
        0x6249,
        0x4173,
        0x624a,
        0x624b,
        0x4278,
        0x624c,
        0x624d,
        0x624e,
        0x4a57,
        0x5838,
        0x5965,
        0x4f63,
        0x7025,
        0x5c30,
        0x426d,
        0x5426,
        0x4d54,
        0x5131,
        0x335b,
        0x477d,
        0x3235,
        0x423f,
        0x6660,
        0x4a3b,
        0x6661,
        0x6662,
        0x3e54,
        0x6663,
        0x5724,
        0x4d55,
        0x6665,
        0x3c5d,
        0x6664,
        0x6666,
        0x6667,
        0x426e,
        0x3d3e,
        0x6668,
        0x4266,
        0x3a27,
        0x6669,
        0x666a,
        0x3352,
        0x5169,
        0x3f25,
        0x666b,
        0x466f,
        0x666c,
        0x666d,
        0x666e,
        0x462d,
        0x666f,
        0x4927,
        0x6670,
        0x6671,
        0x6672,
        0x6539,
        0x6673,
        0x6674,
        0x4262,
        0x6675,
        0x6676,
        0x5668,
        0x6677,
        0x6678,
        0x3947,
        0x773b,
        0x773a,
        0x773e,
        0x773c,
        0x3a21,
        0x773f,
        0x7740,
        0x7742,
        0x7741,
        0x7744,
        0x7743,
        0x7745,
        0x7746,
        0x7747,
        0x4b68,
        0x385f,
        0x7754,
        0x7755,
        0x7756,
        0x7758,
        0x775a,
        0x7757,
        0x775b,
        0x7759,
        0x5757,
        0x775c,
        0x775d,
        0x775e,
        0x775f,
        0x7760,
        0x5b4b,
        0x582a,
        0x6577,
        0x396d,
        0x3f7d,
        0x3b6a,
        0x7749,
        0x4647,
        0x7748,
        0x774a,
        0x774c,
        0x774b,
        0x774d,
        0x4e3a,
        0x774e,
        0x4427,
        0x5363,
        0x764f,
        0x4233,
        0x7650,
        0x7651,
        0x7652,
        0x7653,
        0x7654,
        0x7656,
        0x312b,
        0x7657,
        0x7658,
        0x7659,
        0x765a,
        0x765b,
        0x765c,
        0x765d,
        0x765e,
        0x4f4a,
        0x765f,
        0x7660,
        0x7661,
        0x7662,
        0x7663,
        0x7664,
        0x4070,
        0x7665,
        0x7666,
        0x7667,
        0x7668,
        0x7669,
        0x766a,
        0x766b,
        0x766c,
        0x766d,
        0x766e,
        0x766f,
        0x7670,
        0x7671,
        0x7672,
        0x7673,
        0x7674,
        0x3e28,
        0x7675,
        0x7676,
        0x7677,
        0x7678,
        0x487a,
        0x7679,
        0x767a,
        0x767b,
        0x767c,
        0x767d,
        0x767e,
        0x7721,
        0x7722,
        0x7723,
        0x7724,
        0x7725,
        0x7726,
        0x7727,
        0x7728,
        0x316e,
        0x7729,
        0x772a,
        0x772b,
        0x772c,
        0x772d,
        0x415b,
        0x772e,
        0x772f,
        0x4471,
        0x702f,
        0x3c26,
        0x7030,
        0x4379,
        0x4538,
        0x513b,
        0x7031,
        0x7032,
        0x7033,
        0x7034,
        0x7035,
        0x513c,
        0x516c,
        0x7037,
        0x7036,
        0x5427,
        0x4d52,
        0x7038,
        0x703a,
        0x7039,
        0x703b,
        0x703c,
        0x386b,
        0x703d,
        0x3a68,
        0x703e,
        0x703f,
        0x3e69,
        0x7040,
        0x366c,
        0x7041,
        0x7042,
        0x7043,
        0x7044,
        0x4835,
        0x7045,
        0x7046,
        0x7047,
        0x4574,
        0x7048,
        0x7049,
        0x704a,
        0x773d,
        0x704b,
        0x704c,
        0x704d,
        0x704e,
        0x704f,
        0x3a57,
        0x7050,
        0x7051,
        0x7052,
        0x7053,
        0x7054,
        0x7055,
        0x7056,
        0x7058,
        0x5325,
        0x7057,
        0x7059,
        0x753a,
        0x4239,
        0x7764,
        0x7765,
        0x7766,
        0x7767,
        0x7768,
        0x4234,
        0x776a,
        0x776b,
        0x4273,
        0x7470,
        0x746f,
        0x4269,
        0x7761,
        0x7762,
        0x3b46,
        0x5964,
        0x4a72,
        0x4068,
        0x7024,
        0x3a5a,
        0x472d,
        0x442c,
        0x776c,
        0x776d,
        0x776e,
        0x7770,
        0x776f,
        0x7771,
        0x7774,
        0x7773,
        0x7772,
        0x7775,
        0x7776,
        0x6d69,
        0x6d6a,
        0x6d6b,
        0x763c,
        0x763d,
        0x763e,
        0x3626,
        0x583e,
        0x3944,
        0x583b,
        0x5c31,
        0x4a73,
        0x7777,
        0x7778,
        0x7779,
        0x777b,
        0x777a,
        0x3147,
        0x777c,
        0x777d,
        0x777e,
        0x466b,
        0x6c34,
        0x335d,
        0x7633,
        0x7634,
        0x4164,
        0x7635,
        0x7636,
        0x7637,
        0x7638,
        0x7639,
        0x763a,
        0x4823,
        0x763b,
        0x417a,
        0x3928,
        0x6d68,
        0x396a,
        0x595f,
        0x2321,
        0x2322,
        0x2323,
        0x2167,
        0x2325,
        0x2326,
        0x2327,
        0x2328,
        0x2329,
        0x232a,
        0x232b,
        0x232c,
        0x232d,
        0x232e,
        0x232f,
        0x2330,
        0x2331,
        0x2332,
        0x2333,
        0x2334,
        0x2335,
        0x2336,
        0x2337,
        0x2338,
        0x2339,
        0x233a,
        0x233b,
        0x233c,
        0x233d,
        0x233e,
        0x233f,
        0x2340,
        0x2341,
        0x2342,
        0x2343,
        0x2344,
        0x2345,
        0x2346,
        0x2347,
        0x2348,
        0x2349,
        0x234a,
        0x234b,
        0x234c,
        0x234d,
        0x234e,
        0x234f,
        0x2350,
        0x2351,
        0x2352,
        0x2353,
        0x2354,
        0x2355,
        0x2356,
        0x2357,
        0x2358,
        0x2359,
        0x235a,
        0x235b,
        0x235c,
        0x235d,
        0x235e,
        0x235f,
        0x2360,
        0x2361,
        0x2362,
        0x2363,
        0x2364,
        0x2365,
        0x2366,
        0x2367,
        0x2368,
        0x2369,
        0x236a,
        0x236b,
        0x236c,
        0x236d,
        0x236e,
        0x236f,
        0x2370,
        0x2371,
        0x2372,
        0x2373,
        0x2374,
        0x2375,
        0x2376,
        0x2377,
        0x2378,
        0x2379,
        0x237a,
        0x237b,
        0x237c,
        0x237d,
        0x212b,
        0x2169,
        0x216a,
        0x237e,
        0x2324,
};

static const Summary16 gb2312_uni2indx_page00[70] = {
        /* 0x0000 */
        {0,   0x0000},
        {0,   0x0000},
        {0,   0x0000},
        {0,   0x0000},
        {0,   0x0000},
        {0,   0x0000},
        {0,   0x0000},
        {0,   0x0000},
        {0,   0x0000},
        {0,   0x0000},
        {0,   0x0190},
        {3,   0x0003},
        {5,   0x0000},
        {5,   0x0080},
        {6,   0x3703},
        {13,  0x168c},
        /* 0x0100 */
        {19,  0x0002},
        {20,  0x0808},
        {22,  0x0800},
        {23,  0x0000},
        {23,  0x2000},
        {24,  0x0000},
        {24,  0x0800},
        {25,  0x0000},
        {25,  0x0000},
        {25,  0x0000},
        {25,  0x0000},
        {25,  0x0000},
        {25,  0x4000},
        {26,  0x1555},
        {33,  0x0000},
        {33,  0x0000},
        /* 0x0200 */
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0000},
        {33,  0x0280},
        {35,  0x0000},
        {35,  0x0000},
        {35,  0x0000},
        /* 0x0300 */
        {35,  0x0000},
        {35,  0x0000},
        {35,  0x0000},
        {35,  0x0000},
        {35,  0x0000},
        {35,  0x0000},
        {35,  0x0000},
        {35,  0x0000},
        {35,  0x0000},
        {35,  0xfffe},
        {50,  0x03fb},
        {59,  0xfffe},
        {74,  0x03fb},
        {83,  0x0000},
        {83,  0x0000},
        {83,  0x0000},
        /* 0x0400 */
        {83,  0x0002},
        {84,  0xffff},
        {100, 0xffff},
        {116, 0xffff},
        {132, 0xffff},
        {148, 0x0002},
};
static const Summary16 gb2312_uni2indx_page20[101] = {
        /* 0x2000 */
        {149, 0x0000},
        {149, 0x3360},
        {155, 0x0040},
        {156, 0x080d},
        {160, 0x0000},
        {160, 0x0000},
        {160, 0x0000},
        {160, 0x0000},
        {160, 0x0000},
        {160, 0x0000},
        {160, 0x0000},
        {160, 0x0000},
        {160, 0x0000},
        {160, 0x0000},
        {160, 0x0000},
        {160, 0x0000},
        /* 0x2100 */
        {160, 0x0008},
        {161, 0x0040},
        {162, 0x0000},
        {162, 0x0000},
        {162, 0x0000},
        {162, 0x0000},
        {162, 0x0fff},
        {174, 0x0000},
        {174, 0x0000},
        {174, 0x000f},
        {178, 0x0000},
        {178, 0x0000},
        {178, 0x0000},
        {178, 0x0000},
        {178, 0x0000},
        {178, 0x0000},
        /* 0x2200 */
        {178, 0x8100},
        {180, 0x6402},
        {184, 0x4fa1},
        {192, 0x20f0},
        {197, 0x1100},
        {199, 0x0000},
        {199, 0xc033},
        {205, 0x0000},
        {205, 0x0000},
        {205, 0x0200},
        {206, 0x0020},
        {207, 0x0000},
        {207, 0x0000},
        {207, 0x0000},
        {207, 0x0000},
        {207, 0x0000},
        /* 0x2300 */
        {207, 0x0000},
        {207, 0x0004},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        /* 0x2400 */
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x0000},
        {208, 0x03ff},
        {218, 0xfff0},
        {230, 0xffff},
        {246, 0x0fff},
        {258, 0x0000},
        {258, 0x0000},
        {258, 0x0000},
        {258, 0x0000},
        {258, 0x0000},
        {258, 0x0000},
        /* 0x2500 */
        {258, 0xffff},
        {274, 0xffff},
        {290, 0xffff},
        {306, 0xffff},
        {322, 0x0fff},
        {334, 0x0000},
        {334, 0x0000},
        {334, 0x0000},
        {334, 0x0000},
        {334, 0x0000},
        {334, 0x0003},
        {336, 0x000c},
        {338, 0xc8c0},
        {343, 0x0000},
        {343, 0x0000},
        {343, 0x0000},
        /* 0x2600 */
        {343, 0x0060},
        {345, 0x0000},
        {345, 0x0000},
        {345, 0x0000},
        {345, 0x0005},
};
static const Summary16 gb2312_uni2indx_page30[35] = {
        /* 0x3000 */
        {347, 0xff2f},
        {360, 0x00fb},
        {367, 0x0000},
        {367, 0x0000},
        {367, 0xfffe},
        {382, 0xffff},
        {398, 0xffff},
        {414, 0xffff},
        {430, 0xffff},
        {446, 0x000f},
        {450, 0xfffe},
        {465, 0xffff},
        {481, 0xffff},
        {497, 0xffff},
        {513, 0xffff},
        {529, 0x087f},
        /* 0x3100 */
        {537, 0xffe0},
        {548, 0xffff},
        {564, 0x03ff},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x0000},
        /* 0x3200 */
        {574, 0x0000},
        {574, 0x0000},
        {574, 0x03ff},
};
static const Summary16 gb2312_uni2indx_page4e[1263] = {
        /* 0x4e00 */
        {584,  0x7f8b},
        {595,  0x7f7b},
        {608,  0x3db4},
        {617,  0xef55},
        {628,  0xfba8},
        {638,  0xf35d},
        {649,  0x0243},
        {653,  0x400b},
        {657,  0xfb40},
        {665,  0x8d3e},
        {674,  0x7bf7},
        {687,  0x8c2c},
        {693,  0x6eff},
        {706,  0xe3fa},
        {717,  0x1d3a},
        {725,  0xa8ed},
        /* 0x4f00 */
        {734,  0xe602},
        {740,  0xcf83},
        {749,  0x8cf5},
        {758,  0x3555},
        {766,  0xe048},
        {771,  0xffab},
        {784,  0x92b9},
        {792,  0xd859},
        {800,  0xab18},
        {807,  0x2892},
        {812,  0xd7e9},
        {823,  0x8020},
        {825,  0xc438},
        {831,  0xf583},
        {840,  0xe74a},
        {849,  0x450a},
        /* 0x5000 */
        {854,  0xb000},
        {857,  0x9714},
        {864,  0x7762},
        {873,  0x5400},
        {876,  0xd188},
        {882,  0x1420},
        {885,  0x1020},
        {887,  0xc8c0},
        {892,  0x2121},
        {896,  0x0000},
        {896,  0x13a8},
        {902,  0x0c04},
        {905,  0x8000},
        {906,  0x0440},
        {908,  0x70c0},
        {913,  0x0828},
        /* 0x5100 */
        {916,  0x08c0},
        {919,  0x0004},
        {920,  0x0002},
        {921,  0x8000},
        {922,  0x2b7b},
        {932,  0x1472},
        {938,  0x7924},
        {945,  0x3bfb},
        {957,  0x3327},
        {965,  0x1ae4},
        {972,  0x9835},
        {979,  0x38ef},
        {989,  0x9ad1},
        {997,  0x2802},
        {1000, 0xa813},
        {1006, 0xbf69},
        /* 0x5200 */
        {1017, 0x65cf},
        {1027, 0x2fc6},
        {1036, 0x6b11},
        {1043, 0xafc9},
        {1053, 0x340f},
        {1060, 0x5053},
        {1066, 0x86a2},
        {1072, 0xa004},
        {1075, 0x0106},
        {1078, 0xe809},
        {1084, 0x3f0f},
        {1094, 0xc00e},
        {1099, 0x0a88},
        {1103, 0x8145},
        {1108, 0x0010},
        {1109, 0xc601},
        /* 0x5300 */
        {1114, 0xa161},
        {1120, 0x26e1},
        {1127, 0x444b},
        {1133, 0xce00},
        {1138, 0xc7aa},
        {1147, 0xd4ee},
        {1157, 0xcadf},
        {1168, 0x85bb},
        {1177, 0x3a74},
        {1185, 0xa520},
        {1190, 0x436c},
        {1197, 0x8840},
        {1200, 0x3f06},
        {1208, 0x8bd2},
        {1216, 0xff79},
        {1229, 0x3bef},
        /* 0x5400 */
        {1241, 0xf75a},
        {1252, 0xe8ef},
        {1263, 0xfbcb},
        {1275, 0x5b36},
        {1284, 0x0d49},
        {1290, 0x1bfd},
        {1301, 0x0154},
        {1305, 0x39ee},
        {1315, 0xd855},
        {1323, 0x2e75},
        {1332, 0xbfd8},
        {1343, 0xa91a},
        {1350, 0xf3d7},
        {1362, 0xf6bf},
        {1375, 0x67e0},
        {1383, 0xb40c},
        /* 0x5500 */
        {1389, 0x82c2},
        {1394, 0x0813},
        {1398, 0xd49d},
        {1407, 0xd08b},
        {1414, 0x065a},
        {1420, 0x1061},
        {1424, 0x74f2},
        {1433, 0x59e0},
        {1440, 0x8f9f},
        {1451, 0xb312},
        {1458, 0x0080},
        {1459, 0x6aaa},
        {1467, 0x3230},
        {1472, 0xb05e},
        {1480, 0x9d7a},
        {1490, 0x60ac},
        /* 0x5600 */
        {1496, 0xd303},
        {1503, 0xc900},
        {1507, 0x3098},
        {1512, 0x8a56},
        {1519, 0x7000},
        {1522, 0x1390},
        {1527, 0x1f14},
        {1534, 0x1842},
        {1538, 0xc060},
        {1542, 0x0008},
        {1543, 0x8008},
        {1545, 0x1080},
        {1547, 0x0400},
        {1548, 0xec90},
        {1555, 0x2817},
        {1561, 0xe633},
        /* 0x5700 */
        {1570, 0x0758},
        {1576, 0x9000},
        {1578, 0xf708},
        {1586, 0x4e09},
        {1592, 0xf485},
        {1600, 0xfc83},
        {1609, 0xaf53},
        {1619, 0x18c8},
        {1624, 0x187c},
        {1631, 0x080c},
        {1634, 0x6adf},
        {1645, 0x0114},
        {1648, 0xc80c},
        {1653, 0xa734},
        {1661, 0xa011},
        {1665, 0x2710},
        /* 0x5800 */
        {1670, 0x28c5},
        {1676, 0x4222},
        {1680, 0x0413},
        {1684, 0x0021},
        {1686, 0x3010},
        {1689, 0x4112},
        {1693, 0x1820},
        {1696, 0x4000},
        {1697, 0x022b},
        {1702, 0xc60c},
        {1708, 0x0300},
        {1710, 0x1000},
        {1711, 0x0022},
        {1713, 0x0022},
        {1715, 0x5810},
        {1719, 0x0249},
        /* 0x5900 */
        {1723, 0xa094},
        {1728, 0x9670},
        {1735, 0xeeb0},
        {1744, 0x1792},
        {1751, 0xcb96},
        {1760, 0x05f2},
        {1767, 0x0025},
        {1770, 0x2358},
        {1776, 0x25de},
        {1785, 0x42cc},
        {1791, 0xcf38},
        {1800, 0x4a04},
        {1804, 0x0c40},
        {1807, 0x359f},
        {1817, 0x1128},
        {1821, 0x8a00},
        /* 0x5a00 */
        {1824, 0x13fa},
        {1833, 0x910a},
        {1838, 0x0229},
        {1842, 0x1056},
        {1847, 0x0641},
        {1851, 0x0420},
        {1853, 0x0484},
        {1856, 0x84f0},
        {1862, 0x0000},
        {1862, 0x0c04},
        {1865, 0x0400},
        {1866, 0x412c},
        {1871, 0x1206},
        {1875, 0x1154},
        {1880, 0x0a4b},
        {1886, 0x0002},
        /* 0x5b00 */
        {1887, 0x0200},
        {1888, 0x00c0},
        {1890, 0x0000},
        {1890, 0x0094},
        {1893, 0x0001},
        {1894, 0xbfbb},
        {1907, 0x167c},
        {1915, 0x242b},
        {1921, 0x9bbb},
        {1932, 0x7fa8},
        {1942, 0x0c7f},
        {1951, 0xe379},
        {1961, 0x10f4},
        {1967, 0xe00d},
        {1973, 0x4132},
        {1978, 0x9f01},
        /* 0x5c00 */
        {1985, 0x8652},
        {1991, 0x3572},
        {1999, 0x10b4},
        {2004, 0xff12},
        {2014, 0xcf27},
        {2024, 0x4223},
        {2029, 0xc06b},
        {2036, 0x8602},
        {2040, 0x3106},
        {2045, 0x1fd3},
        {2055, 0x3a0c},
        {2061, 0xa1aa},
        {2068, 0x0812},
        {2071, 0x0204},
        {2073, 0x2572},
        {2080, 0x0801},
        /* 0x5d00 */
        {2082, 0x40cc},
        {2087, 0x4850},
        {2091, 0x62d0},
        {2097, 0x6010},
        {2100, 0x1c80},
        {2104, 0x2900},
        {2107, 0x9a00},
        {2111, 0x0010},
        {2112, 0x0004},
        {2113, 0x2200},
        {2115, 0x0000},
        {2115, 0x0080},
        {2116, 0x2020},
        {2118, 0x6800},
        {2121, 0xcbe6},
        {2131, 0x609e},
        /* 0x5e00 */
        {2138, 0x916e},
        {2146, 0x3f73},
        {2157, 0x60c0},
        {2161, 0x3982},
        {2167, 0x1034},
        {2171, 0x4830},
        {2175, 0x0006},
        {2177, 0xbd5c},
        {2187, 0x8cd1},
        {2194, 0xd6fb},
        {2206, 0x20e1},
        {2211, 0x43e8},
        {2218, 0x0600},
        {2220, 0x084e},
        {2225, 0x0500},
        {2227, 0xc4d0},
        /* 0x5f00 */
        {2233, 0x8d1f},
        {2242, 0x89aa},
        {2249, 0xa6e1},
        {2257, 0x1602},
        {2261, 0x0001},
        {2262, 0x21ed},
        {2270, 0x3656},
        {2278, 0x1a8b},
        {2285, 0x1fb7},
        {2296, 0x13a5},
        {2303, 0x6502},
        {2308, 0x30a0},
        {2312, 0xb278},
        {2320, 0x23c7},
        {2328, 0x6c93},
        {2336, 0xe922},
        /* 0x6000 */
        {2343, 0xe47f},
        {2354, 0x3a74},
        {2362, 0x8fe3},
        {2372, 0x9820},
        {2376, 0x280e},
        {2381, 0x2625},
        {2387, 0xbf9c},
        {2398, 0xbf49},
        {2408, 0x3218},
        {2413, 0xac54},
        {2420, 0xb949},
        {2428, 0x1916},
        {2434, 0x0c60},
        {2438, 0xb522},
        {2445, 0xfbc1},
        {2455, 0x0659},
        /* 0x6100 */
        {2461, 0xe343},
        {2469, 0x8420},
        {2472, 0x08d9},
        {2478, 0x8000},
        {2479, 0x5500},
        {2483, 0x2022},
        {2486, 0x0184},
        {2489, 0x00a1},
        {2492, 0x4800},
        {2494, 0x2010},
        {2496, 0x1380},
        {2500, 0x4080},
        {2502, 0x0d04},
        {2506, 0x0016},
        {2509, 0x0040},
        {2510, 0x8020},
        /* 0x6200 */
        {2512, 0xfd40},
        {2520, 0x8de7},
        {2530, 0x5436},
        {2537, 0xe098},
        {2543, 0x7b8b},
        {2553, 0x091e},
        {2559, 0xfec8},
        {2569, 0xd249},
        {2576, 0x0611},
        {2580, 0x8dee},
        {2590, 0x1937},
        {2598, 0xba22},
        {2605, 0x77f4},
        {2616, 0x9fdd},
        {2628, 0xf3ec},
        {2639, 0xf0da},
        /* 0x6300 */
        {2648, 0x4386},
        {2654, 0xec42},
        {2661, 0x8d3f},
        {2671, 0x2604},
        {2675, 0xfa6c},
        {2685, 0xc021},
        {2689, 0x628e},
        {2696, 0x0cc2},
        {2701, 0xd785},
        {2710, 0x0145},
        {2714, 0x77ad},
        {2725, 0x5599},
        {2733, 0xe250},
        {2739, 0x4045},
        {2743, 0x260b},
        {2749, 0xa154},
        /* 0x6400 */
        {2755, 0x9827},
        {2762, 0x5819},
        {2768, 0x3443},
        {2774, 0xa410},
        {2778, 0x05f2},
        {2785, 0x4114},
        {2789, 0x2280},
        {2792, 0x0700},
        {2795, 0x00b4},
        {2799, 0x4266},
        {2805, 0x7210},
        {2810, 0x15a1},
        {2816, 0x6025},
        {2821, 0x4185},
        {2826, 0x0054},
        {2829, 0x0000},
        /* 0x6500 */
        {2829, 0x0201},
        {2831, 0x0104},
        {2833, 0xc820},
        {2837, 0xcb70},
        {2845, 0x9320},
        {2850, 0x6a62},
        {2857, 0x184c},
        {2862, 0x0095},
        {2866, 0x1880},
        {2869, 0x9a8b},
        {2877, 0xaab2},
        {2885, 0x3201},
        {2889, 0xd87a},
        {2898, 0x00c4},
        {2901, 0xf3e5},
        {2912, 0x04c3},
        /* 0x6600 */
        {2917, 0xd44d},
        {2925, 0xa238},
        {2931, 0xa1a1},
        {2937, 0x5072},
        {2943, 0x980a},
        {2948, 0x84fc},
        {2956, 0xc152},
        {2962, 0x44d1},
        {2968, 0x1094},
        {2972, 0x20c2},
        {2976, 0x4180},
        {2979, 0x4210},
        {2982, 0x0000},
        {2982, 0x3a00},
        {2986, 0x0240},
        {2988, 0xd29d},
        /* 0x6700 */
        {2997, 0x2f01},
        {3003, 0xa8b1},
        {3010, 0xbd40},
        {3017, 0x2432},
        {3022, 0xd34d},
        {3031, 0xd04b},
        {3038, 0xa723},
        {3046, 0xd0ad},
        {3054, 0x0a92},
        {3059, 0x75a1},
        {3067, 0xadac},
        {3076, 0x01e9},
        {3082, 0x801a},
        {3086, 0x771f},
        {3097, 0x9225},
        {3103, 0xa01b},
        /* 0x6800 */
        {3109, 0xdfa1},
        {3119, 0x20ca},
        {3124, 0x0602},
        {3127, 0x738c},
        {3135, 0x577f},
        {3147, 0x003b},
        {3152, 0x0bff},
        {3163, 0x00d0},
        {3166, 0x806a},
        {3171, 0x0088},
        {3173, 0xa1c4},
        {3179, 0x0029},
        {3182, 0x2a05},
        {3187, 0x0524},
        {3191, 0x4009},
        {3194, 0x1623},
        /* 0x6900 */
        {3200, 0x6822},
        {3205, 0x8005},
        {3208, 0x2011},
        {3211, 0xa211},
        {3216, 0x0004},
        {3217, 0x6490},
        {3222, 0x4849},
        {3227, 0x1382},
        {3232, 0x23d5},
        {3240, 0x1930},
        {3245, 0x2980},
        {3249, 0x0892},
        {3253, 0x5402},
        {3257, 0x8811},
        {3261, 0x2001},
        {3263, 0xa004},
        /* 0x6a00 */
        {3266, 0x0400},
        {3267, 0x8180},
        {3270, 0x8502},
        {3274, 0x6022},
        {3278, 0x0090},
        {3280, 0x0b01},
        {3284, 0x0022},
        {3286, 0x1202},
        {3289, 0x4011},
        {3292, 0x0083},
        {3295, 0x1a01},
        {3299, 0x0000},
        {3299, 0x0000},
        {3299, 0x0000},
        {3299, 0x0000},
        {3299, 0x0000},
        /* 0x6b00 */
        {3299, 0x0000},
        {3299, 0x0000},
        {3299, 0x009f},
        {3305, 0x4684},
        {3310, 0x12c8},
        {3315, 0x0200},
        {3316, 0x04fc},
        {3323, 0x1a00},
        {3326, 0x2ede},
        {3336, 0x0c4c},
        {3341, 0x0402},
        {3343, 0x80b8},
        {3348, 0xa826},
        {3354, 0x0afc},
        {3362, 0x8c02},
        {3366, 0x2228},
        /* 0x6c00 */
        {3370, 0xa0e0},
        {3375, 0x8f7b},
        {3386, 0xc7d6},
        {3396, 0x2135},
        {3402, 0x06c7},
        {3409, 0xf8b1},
        {3418, 0x0713},
        {3424, 0x6255},
        {3431, 0x936e},
        {3440, 0x8a19},
        {3446, 0x6efa},
        {3457, 0xfb0e},
        {3467, 0x1630},
        {3472, 0x48f9},
        {3480, 0xcd2f},
        {3490, 0x7deb},
        /* 0x6d00 */
        {3502, 0x5892},
        {3508, 0x4e84},
        {3514, 0x4ca0},
        {3519, 0x7a2e},
        {3528, 0xedea},
        {3539, 0x561e},
        {3547, 0xc649},
        {3554, 0x1190},
        {3558, 0x5324},
        {3564, 0xe83a},
        {3572, 0xcfdb},
        {3584, 0x8124},
        {3588, 0x18f1},
        {3595, 0x6342},
        {3601, 0x5853},
        {3608, 0x1a8a},
        /* 0x6e00 */
        {3614, 0x7420},
        {3619, 0x24d3},
        {3626, 0xaa3b},
        {3635, 0x0514},
        {3639, 0x6018},
        {3643, 0x8958},
        {3649, 0x4800},
        {3651, 0xc000},
        {3653, 0x8268},
        {3658, 0x9101},
        {3662, 0x84a4},
        {3667, 0x2cd6},
        {3675, 0x8886},
        {3680, 0xc4ba},
        {3688, 0x0377},
        {3696, 0x0210},
        /* 0x6f00 */
        {3698, 0x8244},
        {3702, 0x0038},
        {3705, 0xae11},
        {3712, 0x404a},
        {3716, 0x28c0},
        {3720, 0x5100},
        {3723, 0x6044},
        {3727, 0x1514},
        {3732, 0x7310},
        {3738, 0x1000},
        {3739, 0x0082},
        {3741, 0x0248},
        {3744, 0x0205},
        {3747, 0x4006},
        {3750, 0xc003},
        {3754, 0x0000},
        /* 0x7000 */
        {3754, 0x0000},
        {3754, 0x0c02},
        {3757, 0x0008},
        {3758, 0x0220},
        {3760, 0x9000},
        {3762, 0x4000},
        {3763, 0xb800},
        {3767, 0xd161},
        {3774, 0x4621},
        {3779, 0x3274},
        {3786, 0xf800},
        {3791, 0x3b8a},
        {3799, 0x050f},
        {3805, 0x8b00},
        {3809, 0xbbd0},
        {3818, 0x2280},
        /* 0x7100 */
        {3821, 0x0600},
        {3823, 0x0769},
        {3830, 0x8040},
        {3832, 0x0043},
        {3835, 0x5420},
        {3839, 0x5000},
        {3841, 0x41d0},
        {3846, 0x250c},
        {3851, 0x8410},
        {3854, 0x8310},
        {3858, 0x1101},
        {3861, 0x0228},
        {3864, 0x4008},
        {3866, 0x0030},
        {3868, 0x40a1},
        {3872, 0x0200},
        /* 0x7200 */
        {3873, 0x0040},
        {3874, 0x2000},
        {3875, 0x1500},
        {3878, 0xabe3},
        {3888, 0x3180},
        {3892, 0xaa44},
        {3898, 0xc2c6},
        {3905, 0xc624},
        {3911, 0xac13},
        {3918, 0x8004},
        {3920, 0xb000},
        {3923, 0x03d1},
        {3929, 0x611e},
        {3936, 0x4285},
        {3941, 0xf303},
        {3949, 0x1d9f},
        /* 0x7300 */
        {3959, 0x440a},
        {3963, 0x78e8},
        {3971, 0x5e26},
        {3979, 0xc392},
        {3986, 0x2000},
        {3987, 0x0085},
        {3990, 0xb001},
        {3994, 0x4000},
        {3995, 0x4a90},
        {4000, 0x8842},
        {4004, 0xca04},
        {4009, 0x0c8d},
        {4015, 0xa705},
        {4022, 0x4203},
        {4026, 0x22a1},
        {4031, 0x0004},
        /* 0x7400 */
        {4032, 0x8668},
        {4038, 0x0c01},
        {4041, 0x5564},
        {4048, 0x1079},
        {4054, 0x0002},
        {4055, 0xdea0},
        {4063, 0x2000},
        {4064, 0x40c1},
        {4068, 0x488b},
        {4074, 0x5001},
        {4077, 0x0380},
        {4080, 0x0400},
        {4081, 0x0000},
        {4081, 0x5004},
        {4084, 0xc05d},
        {4091, 0x80d0},
        /* 0x7500 */
        {4095, 0xa010},
        {4098, 0x970a},
        {4105, 0xbb20},
        {4112, 0x4daf},
        {4122, 0xd921},
        {4129, 0x1e10},
        {4134, 0x0460},
        {4137, 0x8314},
        {4142, 0x8848},
        {4146, 0xa6d6},
        {4155, 0xd83b},
        {4164, 0x733f},
        {4175, 0x27bc},
        {4184, 0x4974},
        {4191, 0x0ddc},
        {4199, 0x9213},
        /* 0x7600 */
        {4205, 0x142b},
        {4211, 0x8ba1},
        {4218, 0x2e75},
        {4227, 0xd139},
        {4235, 0x3009},
        {4239, 0x5050},
        {4243, 0x8808},
        {4246, 0x6900},
        {4250, 0x49d4},
        {4257, 0x024a},
        {4261, 0x4010},
        {4263, 0x8016},
        {4267, 0xe564},
        {4275, 0x89d7},
        {4284, 0xc020},
        {4287, 0x5316},
        /* 0x7700 */
        {4294, 0x2b92},
        {4301, 0x8600},
        {4304, 0xa345},
        {4311, 0x15e0},
        {4317, 0x008b},
        {4321, 0x0c03},
        {4325, 0x196e},
        {4333, 0xe200},
        {4337, 0x7031},
        {4343, 0x8006},
        {4346, 0x16a5},
        {4353, 0xa829},
        {4359, 0x2000},
        {4360, 0x1880},
        {4363, 0x7aac},
        {4372, 0xe148},
        /* 0x7800 */
        {4378, 0x3207},
        {4384, 0xb5d6},
        {4394, 0x32e8},
        {4401, 0x5f91},
        {4410, 0x50a1},
        {4415, 0x20e5},
        {4421, 0x7c00},
        {4426, 0x1080},
        {4428, 0x7280},
        {4433, 0x9d8a},
        {4441, 0x00aa},
        {4445, 0x421f},
        {4452, 0x0e22},
        {4457, 0x0231},
        {4461, 0x1100},
        {4463, 0x0494},
        /* 0x7900 */
        {4467, 0x0022},
        {4469, 0x4008},
        {4471, 0x0010},
        {4472, 0x5c10},
        {4477, 0x0343},
        {4482, 0xfcc8},
        {4491, 0xa1a5},
        {4498, 0x0580},
        {4501, 0x8433},
        {4507, 0x0400},
        {4508, 0x0080},
        {4509, 0x6e08},
        {4515, 0x2a4b},
        {4522, 0x8126},
        {4527, 0xaad8},
        {4535, 0x2901},
        /* 0x7a00 */
        {4539, 0x684d},
        {4546, 0x4490},
        {4550, 0x0009},
        {4552, 0xba88},
        {4559, 0x0040},
        {4560, 0x0082},
        {4562, 0x0000},
        {4562, 0x87d1},
        {4570, 0x215b},
        {4577, 0xb1e6},
        {4586, 0x3161},
        {4592, 0x8008},
        {4594, 0x0800},
        {4595, 0xc240},
        {4599, 0xa069},
        {4605, 0xa600},
        /* 0x7b00 */
        {4609, 0x8d58},
        {4616, 0x4a32},
        {4622, 0x5d71},
        {4631, 0x550a},
        {4637, 0x9aa0},
        {4643, 0x2d57},
        {4652, 0x4005},
        {4655, 0x4aa6},
        {4662, 0x2021},
        {4665, 0x30b1},
        {4671, 0x3fc6},
        {4681, 0x0112},
        {4684, 0x10c2},
        {4688, 0x260a},
        {4693, 0x4462},
        {4698, 0x5082},
        /* 0x7c00 */
        {4702, 0x9880},
        {4706, 0x8040},
        {4708, 0x04c0},
        {4711, 0x8100},
        {4713, 0x2003},
        {4716, 0x0000},
        {4716, 0x0000},
        {4716, 0x3818},
        {4721, 0x0200},
        {4722, 0xf1a6},
        {4731, 0x4434},
        {4736, 0x720e},
        {4743, 0x35a2},
        {4750, 0x92e0},
        {4756, 0x8101},
        {4759, 0x0900},
        /* 0x7d00 */
        {4761, 0x0400},
        {4762, 0x0000},
        {4762, 0x8885},
        {4767, 0x0000},
        {4767, 0x0000},
        {4767, 0x0000},
        {4767, 0x4000},
        {4768, 0x0080},
        {4769, 0x0000},
        {4769, 0x0000},
        {4769, 0x4040},
        {4771, 0x0000},
        {4771, 0x0000},
        {4771, 0x0000},
        {4771, 0x0000},
        {4771, 0x0000},
        /* 0x7e00 */
        {4771, 0x0000},
        {4771, 0x0000},
        {4771, 0x0000},
        {4771, 0x0800},
        {4772, 0x0082},
        {4774, 0x0000},
        {4774, 0x0000},
        {4774, 0x0000},
        {4774, 0x0004},
        {4775, 0x8800},
        {4777, 0xbfff},
        {4792, 0xe7ef},
        {4805, 0xffff},
        {4821, 0xffbf},
        {4836, 0xefef},
        {4850, 0xfdff},
        /* 0x7f00 */
        {4865, 0xfbff},
        {4880, 0xbffe},
        {4894, 0xffff},
        {4910, 0x057f},
        {4919, 0x0034},
        {4922, 0x85b3},
        {4930, 0x4706},
        {4936, 0x4216},
        {4941, 0x5402},
        {4945, 0xe410},
        {4950, 0x8092},
        {4954, 0xb305},
        {4961, 0x5422},
        {4966, 0x8130},
        {4970, 0x4263},
        {4976, 0x180b},
        /* 0x8000 */
        {4981, 0x387b},
        {4990, 0x13f5},
        {4999, 0x07e5},
        {5007, 0xa9ea},
        {5016, 0x3c4c},
        {5023, 0x0514},
        {5027, 0x0600},
        {5029, 0x8002},
        {5031, 0x1ad9},
        {5039, 0xbd48},
        {5047, 0xee37},
        {5058, 0xf496},
        {5067, 0x705f},
        {5076, 0x7ec0},
        {5084, 0xbfb2},
        {5095, 0x355f},
        /* 0x8100 */
        {5105, 0xe644},
        {5112, 0x455f},
        {5121, 0x9000},
        {5123, 0x4146},
        {5128, 0x1d40},
        {5133, 0x063b},
        {5140, 0x62a1},
        {5146, 0xfe13},
        {5156, 0x8505},
        {5161, 0x3902},
        {5166, 0x0548},
        {5170, 0x0c08},
        {5173, 0x144f},
        {5180, 0x0000},
        {5180, 0x3488},
        {5185, 0x5818},
        /* 0x8200 */
        {5190, 0x3077},
        {5198, 0xd815},
        {5205, 0xbd0e},
        {5214, 0x4bfb},
        {5225, 0x8a90},
        {5230, 0x8500},
        {5233, 0xc100},
        {5236, 0xe61d},
        {5245, 0xed14},
        {5253, 0xb386},
        {5261, 0xff72},
        {5273, 0x639b},
        {5282, 0xfd92},
        {5292, 0xd9be},
        {5303, 0x887b},
        {5311, 0x0a92},
        /* 0x8300 */
        {5316, 0xd3fe},
        {5328, 0x1cb2},
        {5335, 0xb980},
        {5341, 0x177a},
        {5350, 0x82c9},
        {5356, 0xdc17},
        {5365, 0xfffb},
        {5380, 0x3980},
        {5385, 0x4260},
        {5389, 0x590c},
        {5395, 0x0f01},
        {5400, 0x37df},
        {5412, 0x94a3},
        {5419, 0xb150},
        {5425, 0x0623},
        {5430, 0x2307},
        /* 0x8400 */
        {5436, 0xf85a},
        {5445, 0x3102},
        {5449, 0x01f0},
        {5454, 0x3102},
        {5458, 0x0040},
        {5459, 0x1e82},
        {5465, 0x3a0a},
        {5471, 0x056a},
        {5477, 0x5b84},
        {5484, 0x1280},
        {5487, 0x8002},
        {5489, 0xa714},
        {5496, 0x2612},
        {5501, 0xa04b},
        {5507, 0x1069},
        {5512, 0x9001},
        /* 0x8500 */
        {5515, 0x1000},
        {5516, 0x848a},
        {5521, 0x1802},
        {5524, 0x3f80},
        {5531, 0x0708},
        {5535, 0x4240},
        {5538, 0x0110},
        {5540, 0x4e14},
        {5546, 0x80b0},
        {5550, 0x1800},
        {5552, 0xc510},
        {5557, 0x0281},
        {5560, 0x8202},
        {5563, 0x1029},
        {5567, 0x0210},
        {5569, 0x8800},
        /* 0x8600 */
        {5571, 0x0020},
        {5572, 0x0042},
        {5574, 0x0280},
        {5576, 0x1100},
        {5578, 0xe000},
        {5581, 0x4413},
        {5586, 0x5804},
        {5590, 0xfe02},
        {5598, 0x3c07},
        {5605, 0x3028},
        {5609, 0x9798},
        {5617, 0x0473},
        {5623, 0xced1},
        {5632, 0xcb13},
        {5640, 0x6210},
        {5644, 0x431f},
        /* 0x8700 */
        {5652, 0x278d},
        {5660, 0x55ac},
        {5668, 0x422e},
        {5674, 0xc892},
        {5680, 0x5380},
        {5685, 0x0288},
        {5688, 0x4039},
        {5693, 0x7851},
        {5700, 0x292c},
        {5706, 0x8088},
        {5709, 0xb900},
        {5714, 0x2428},
        {5718, 0x0c41},
        {5722, 0x080e},
        {5726, 0x4421},
        {5730, 0x4200},
        /* 0x8800 */
        {5732, 0x0408},
        {5734, 0x0868},
        {5738, 0x0006},
        {5740, 0x1204},
        {5743, 0x3031},
        {5748, 0x0290},
        {5751, 0x5b3e},
        {5761, 0xe085},
        {5767, 0x2936},
        {5774, 0x1044},
        {5777, 0x2814},
        {5781, 0x1082},
        {5784, 0x4266},
        {5790, 0x8334},
        {5796, 0x013c},
        {5801, 0x531b},
        /* 0x8900 */
        {5809, 0x0404},
        {5811, 0x0e0d},
        {5817, 0x0c22},
        {5821, 0x0051},
        {5824, 0x0012},
        {5826, 0xc000},
        {5828, 0x0040},
        {5829, 0x8800},
        {5831, 0x004a},
        {5834, 0x0000},
        {5834, 0x0000},
        {5834, 0x0000},
        {5834, 0xdff6},
        {5847, 0x5447},
        {5854, 0x8868},
        {5859, 0x0008},
        /* 0x8a00 */
        {5860, 0x0081},
        {5862, 0x0000},
        {5862, 0x0000},
        {5862, 0x4000},
        {5863, 0x0100},
        {5864, 0x0000},
        {5864, 0x0000},
        {5864, 0x0200},
        {5865, 0x0600},
        {5867, 0x0008},
        {5868, 0x0000},
        {5868, 0x0000},
        {5868, 0x0000},
        {5868, 0x0000},
        {5868, 0x0000},
        {5868, 0x0000},
        /* 0x8b00 */
        {5868, 0x0080},
        {5869, 0x0000},
        {5869, 0x0040},
        {5870, 0x0000},
        {5870, 0x0000},
        {5870, 0x0000},
        {5870, 0x1040},
        {5872, 0x0000},
        {5872, 0x0000},
        {5872, 0x0000},
        {5872, 0xefff},
        {5887, 0xf7fd},
        {5901, 0xff7f},
        {5916, 0xfffe},
        {5931, 0xfbff},
        {5946, 0xffff},
        /* 0x8c00 */
        {5962, 0xfdff},
        {5977, 0xbfff},
        {5992, 0xffff},
        {6008, 0x00ff},
        {6016, 0x12c2},
        {6021, 0x0420},
        {6023, 0x0c06},
        {6027, 0x0708},
        {6031, 0x1624},
        {6036, 0x0110},
        {6038, 0x0000},
        {6038, 0x0000},
        {6038, 0x0000},
        {6038, 0x0000},
        {6038, 0x0000},
        {6038, 0x0000},
        /* 0x8d00 */
        {6038, 0x0000},
        {6038, 0xe000},
        {6041, 0xfffe},
        {6056, 0xffff},
        {6072, 0xffff},
        {6088, 0x7f79},
        {6100, 0x28df},
        {6109, 0x00f9},
        {6115, 0x0c32},
        {6120, 0x8012},
        {6123, 0x0008},
        {6124, 0xd53a},
        {6133, 0xd858},
        {6140, 0xecc2},
        {6148, 0x9d18},
        {6155, 0x2fa8},
        /* 0x8e00 */
        {6163, 0x9620},
        {6168, 0xe010},
        {6172, 0xd60c},
        {6179, 0x2622},
        {6184, 0x0f97},
        {6193, 0x0206},
        {6196, 0xb240},
        {6201, 0x9055},
        {6207, 0x80a2},
        {6211, 0x5011},
        {6215, 0x9800},
        {6218, 0x0404},
        {6220, 0x4000},
        {6221, 0x0000},
        {6221, 0x0000},
        {6221, 0x0000},
        /* 0x8f00 */
        {6221, 0x0000},
        {6221, 0x0000},
        {6221, 0x0000},
        {6221, 0x0000},
        {6221, 0x0000},
        {6221, 0x0000},
        {6221, 0xfbc0},
        {6230, 0xffff},
        {6246, 0xeffe},
        {6260, 0xdffb},
        {6274, 0x0b08},
        {6278, 0x6243},
        {6284, 0x41b6},
        {6291, 0xfb3b},
        {6303, 0x6f74},
        {6313, 0x2389},
        /* 0x9000 */
        {6319, 0xae7f},
        {6331, 0xecd7},
        {6342, 0xe047},
        {6349, 0x5960},
        {6355, 0xa096},
        {6361, 0x098f},
        {6368, 0x612c},
        {6374, 0xa030},
        {6378, 0x090d},
        {6383, 0x2aaa},
        {6390, 0xd44e},
        {6398, 0x4f7b},
        {6409, 0xc4b2},
        {6416, 0x388b},
        {6423, 0xa9c6},
        {6431, 0x6110},
        /* 0x9100 */
        {6435, 0x0014},
        {6437, 0x4200},
        {6439, 0x800c},
        {6442, 0x0202},
        {6444, 0xfe48},
        {6453, 0x6485},
        {6459, 0xd63e},
        {6469, 0xe3f7},
        {6481, 0x3aa0},
        {6487, 0x0c07},
        {6492, 0xe40c},
        {6498, 0x0430},
        {6501, 0xf680},
        {6508, 0x1002},
        {6510, 0x0000},
        {6510, 0x0000},
        /* 0x9200 */
        {6510, 0x0000},
        {6510, 0x0000},
        {6510, 0x0000},
        {6510, 0x0000},
        {6510, 0x0000},
        {6510, 0x0000},
        {6510, 0x0000},
        {6510, 0x0010},
        {6511, 0x4000},
        {6512, 0x0000},
        {6512, 0x4000},
        {6513, 0x0000},
        {6513, 0x0100},
        {6514, 0x0000},
        {6514, 0x0000},
        {6514, 0x0000},
        /* 0x9300 */
        {6514, 0x0000},
        {6514, 0x0000},
        {6514, 0x0000},
        {6514, 0x4000},
        {6515, 0x0000},
        {6515, 0x0000},
        {6515, 0x0400},
        {6516, 0x0000},
        {6516, 0x8000},
        {6517, 0x0000},
        {6517, 0x0000},
        {6517, 0x0000},
        {6517, 0x0400},
        {6518, 0x0040},
        {6519, 0x0000},
        {6519, 0x0000},
        /* 0x9400 */
        {6519, 0x0000},
        {6519, 0x0000},
        {6519, 0x0000},
        {6519, 0x4000},
        {6520, 0x0000},
        {6520, 0x0000},
        {6520, 0x0800},
        {6521, 0x0000},
        {6521, 0xffe0},
        {6532, 0xfebd},
        {6545, 0xffff},
        {6561, 0xffff},
        {6577, 0x7f7f},
        {6591, 0xfbe7},
        {6604, 0xffbf},
        {6619, 0xf7ff},
        /* 0x9500 */
        {6634, 0xffff},
        {6650, 0xefff},
        {6665, 0xff7e},
        {6679, 0xdff7},
        {6693, 0xf6f7},
        {6706, 0xfbdf},
        {6720, 0xbffe},
        {6734, 0x804f},
        {6740, 0x0000},
        {6740, 0x0000},
        {6740, 0x0000},
        {6740, 0x0000},
        {6740, 0x0000},
        {6740, 0x0000},
        {6740, 0xef00},
        {6747, 0x7fff},
        /* 0x9600 */
        {6762, 0xff7f},
        {6777, 0xb6f7},
        {6789, 0x4406},
        {6793, 0xb87e},
        {6803, 0x3bf5},
        {6814, 0x8831},
        {6819, 0x1796},
        {6827, 0x00f4},
        {6832, 0xa960},
        {6838, 0x1391},
        {6844, 0x0080},
        {6845, 0x7249},
        {6852, 0xf2f3},
        {6863, 0x0024},
        {6865, 0x8701},
        {6870, 0x42c8},
        /* 0x9700 */
        {6875, 0xe3d3},
        {6885, 0x5048},
        {6889, 0x2400},
        {6891, 0x4305},
        {6896, 0x0000},
        {6896, 0x4a4c},
        {6902, 0x0227},
        {6907, 0x1058},
        {6911, 0x2820},
        {6914, 0x0116},
        {6918, 0xa809},
        {6923, 0x0014},
        {6925, 0x0000},
        {6925, 0x0000},
        {6925, 0x3ec0},
        {6932, 0x0068},
        /* 0x9800 */
        {6935, 0x0000},
        {6935, 0x0000},
        {6935, 0x0000},
        {6935, 0x0000},
        {6935, 0x0000},
        {6935, 0x0000},
        {6935, 0x0000},
        {6935, 0xffe0},
        {6946, 0xb7ff},
        {6960, 0xfddb},
        {6973, 0x00f7},
        {6980, 0x0000},
        {6980, 0x4000},
        {6981, 0xc72e},
        {6990, 0x0180},
        {6992, 0x0000},
        /* 0x9900 */
        {6992, 0x2000},
        {6993, 0x0001},
        {6994, 0x4000},
        {6995, 0x0000},
        {6995, 0x0000},
        {6995, 0x0030},
        {6997, 0xffa8},
        {7008, 0xb4f7},
        {7019, 0xadf3},
        {7030, 0x03ff},
        {7040, 0x0120},
        {7042, 0x0000},
        {7042, 0x0000},
        {7042, 0x0000},
        {7042, 0x0000},
        {7042, 0x0000},
        /* 0x9a00 */
        {7042, 0x0000},
        {7042, 0x0000},
        {7042, 0x0000},
        {7042, 0x0000},
        {7042, 0x0000},
        {7042, 0x0000},
        {7042, 0xf000},
        {7046, 0xfffb},
        {7061, 0x9df7},
        {7073, 0xfdcf},
        {7086, 0x01bf},
        {7094, 0x15c3},
        {7101, 0x1827},
        {7107, 0x810a},
        {7111, 0xa842},
        {7116, 0x0a00},
        /* 0x9b00 */
        {7118, 0x8108},
        {7121, 0x8008},
        {7123, 0x8008},
        {7125, 0x1804},
        {7128, 0xa3be},
        {7138, 0x0012},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        /* 0x9c00 */
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x0000},
        {7140, 0x9000},
        {7142, 0x69e6},
        {7151, 0xdc37},
        {7161, 0x6bff},
        {7174, 0x3dff},
        {7187, 0xfcf8},
        {7198, 0xf3f9},
        {7210, 0x0004},
};
static const Summary16 gb2312_uni2indx_page9e[27] = {
        /* 0x9e00 */
        {7211, 0x0000},
        {7211, 0x8000},
        {7212, 0xbf6f},
        {7225, 0xe7ee},
        {7237, 0xdffe},
        {7251, 0x5da2},
        {7259, 0x3fd8},
        {7269, 0xc00b},
        {7274, 0x0984},
        {7278, 0xa00c},
        {7282, 0x0040},
        {7283, 0x6910},
        {7288, 0xe210},
        {7293, 0xb912},
        {7300, 0x86a5},
        {7307, 0x5a00},
        /* 0x9f00 */
        {7311, 0x6800},
        {7314, 0x0289},
        {7318, 0x9005},
        {7322, 0x6a80},
        {7327, 0x0010},
        {7328, 0x0003},
        {7330, 0x0000},
        {7330, 0x8000},
        {7331, 0x1ff9},
        {7342, 0x8e00},
        {7346, 0x0001},
};
static const Summary16 gb2312_uni2indx_pageff[15] = {
        /* 0xff00 */
        {7347, 0xfffe},
        {7362, 0xffff},
        {7378, 0xffff},
        {7394, 0xffff},
        {7410, 0xffff},
        {7426, 0x7fff},
        {7441, 0x0000},
        {7441, 0x0000},
        {7441, 0x0000},
        {7441, 0x0000},
        {7441, 0x0000},
        {7441, 0x0000},
        {7441, 0x0000},
        {7441, 0x0000},
        {7441, 0x002b},
};

class U2GB {
private:
    Unibytes getUnicodeChar(char *str);

    String toGB2312(Unibytes wc);

public:
    // an alias of from()
    String get(String utf8_str);
    // convert from utf8 to gb2312
    String from(String utf8_str);
};

extern U2GB GB;

#endif /* UTF8_TO_GB2312_H */
