# OpenMenuOS Documentation Index

Welcome to the OpenMenuOS documentation! Choose the resource that best fits your needs:

## 📚 Documentation Files

### 🚀 [Getting Started (README.md)](README.md)
**Perfect for:** Arduino IDE users, quick setup  
**Contains:** Installation guide, basic usage, hardware setup, key features overview

### 🔧 [Complete API Reference (api.md)](api.md)  
**Perfect for:** Developers, detailed implementation  
**Contains:** All classes, methods, parameters, return values, and advanced configurations

### 💡 [Code Examples (examples.md)](examples.md)
**Perfect for:** Learning by example, common patterns  
**Contains:** Ready-to-use code snippets, real-world implementations, best practices

## 🎯 Quick Navigation

### New to OpenMenuOS?
1. Start with [README.md](README.md) for basic setup
2. Try the examples in [examples.md](examples.md)
3. Reference [api.md](api.md) for advanced features

### Looking for specific features?
- **Popup System**: [README.md](README.md#popupmanager-system) → [api.md](api.md#popupmanager-class)
- **Menu Creation**: [examples.md](examples.md#menu-examples) → [api.md](api.md#screen-classes)
- **Settings Management**: [examples.md](examples.md#settings-examples) → [api.md](api.md#settings-system)
- **Input Handling**: [examples.md](examples.md#input-handling-examples) → [api.md](api.md#input-configuration)
- **Custom Screens**: [examples.md](examples.md#custom-screen-examples) → [api.md](api.md#customscreen)

### Common Tasks
- **First Setup**: [README.md](README.md#quick-start)
- **Add Popups**: [examples.md](examples.md#popup-examples)
- **Create Menus**: [examples.md](examples.md#menu-examples)
- **Handle Settings**: [examples.md](examples.md#settings-examples)
- **Troubleshooting**: [README.md](README.md#troubleshooting)

## 🔍 Search Tips

### In Arduino IDE:
- Use `Ctrl+F` to search within documentation files
- Look for `###` headings for specific topics
- Code examples are in \`\`\`cpp blocks

### Key Search Terms:
- `PopupManager` - For popup/dialog functionality
- `MenuScreen` - For menu creation
- `SettingsScreen` - For settings management  
- `CustomScreen` - For custom drawing
- `setupButtons` - For input configuration
- `begin()` - For initialization

## 📋 File Descriptions

| File | Purpose | Best For |
|------|---------|----------|
| `README.md` | Quick start guide with Arduino IDE focus | Beginners, quick reference |
| `api.md` | Complete API documentation | Developers, detailed implementation |
| `examples.md` | Practical code examples and patterns | Learning, common use cases |
| `index.md` | This navigation guide | Finding the right documentation |

## 🆘 Need Help?

1. **Check Troubleshooting**: [README.md](README.md#troubleshooting)
2. **Browse Examples**: [examples.md](examples.md)
3. **Search API Docs**: [api.md](api.md)
4. **GitHub Issues**: [Report bugs or ask questions](https://github.com/The-Young-Maker/OpenMenuOS/issues)

## 📄 License & Credits

**License**: MIT License - Free for personal and commercial use  
**Author**: The Young Maker  
**Version**: 3.1.0  
**GitHub**: https://github.com/The-Young-Maker/OpenMenuOS

---

**Happy coding with OpenMenuOS! 🎉**
