/*
  Party Hard menu example using GEM library.

  Sprites of the animation frames used in the example.
  
  Additional info (including the breadboard view) available on GitHub:
  https://github.com/Spirik/GEM
  
  This example code is in the public domain.
*/

#define partyFrame1_width  128
#define partyFrame1_height 64
static const unsigned char partyFrame1_bits [] U8X8_PROGMEM = {
  0x00, 0x00, 0x00, 0x90, 0x4C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xE4, 0x00, 0x00, 0x00, 
  0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 
  0xA4, 0x01, 0x00, 0x00, 0x16, 0xFF, 0x0F, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x98, 0x34, 0x01, 0x00, 0x00, 0xDE, 0x05, 0xF9, 0x03, 
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x14, 0x01, 0x00, 0x84, 
  0x7F, 0x00, 0x80, 0x0E, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 
  0x14, 0x01, 0x00, 0xC6, 0x37, 0x00, 0x00, 0x90, 0x0D, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xC8, 0x1F, 0x01, 0x30, 0x4A, 0x2B, 0xFC, 0x05, 0xE0, 
  0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x10, 0x01, 0x28, 0x6A, 
  0xFF, 0xFF, 0x7F, 0x80, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0x10, 0x01, 0x28, 0x1A, 0xEF, 0x55, 0xFF, 0xC1, 0x0F, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0x1C, 0x01, 0x24, 0x11, 0x77, 0xDB, 0xF6, 0x67, 
  0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x07, 0x01, 0x44, 0xE1, 
  0xFF, 0x7E, 0xDF, 0xFE, 0xE7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0x03, 0x01, 0x42, 0x82, 0xFF, 0xFB, 0x5F, 0xBD, 0x87, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0x01, 0x01, 0xC2, 0x05, 0x28, 0x00, 0xFA, 0xFE, 
  0x86, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x01, 0x01, 0x05, 
  0x00, 0x00, 0xE0, 0x79, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0x01, 0x01, 0x03, 0x06, 0x00, 0x00, 0x00, 0xD7, 0x07, 0x02, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x18, 0x81, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0xFC, 
  0x0F, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x80, 0x00, 0x06, 0x00, 
  0x00, 0x00, 0x40, 0x50, 0x0F, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 
  0xC0, 0x00, 0x04, 0x00, 0x00, 0x00, 0x60, 0xE0, 0x1F, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x04, 0x00, 0x00, 0x00, 0x50, 0x80, 
  0x3F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x38, 0x00, 0x0C, 0x00, 
  0x00, 0x00, 0x98, 0x00, 0x77, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x08, 0x00, 0x28, 0x00, 0x00, 0x00, 0x8E, 0x00, 0x7E, 0x10, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x18, 0x00, 0x58, 0x00, 0x00, 0x00, 0x81, 0x00, 
  0xEC, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x10, 0x00, 0x90, 0x03, 
  0x00, 0xF8, 0x00, 0x01, 0xD8, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x10, 0x00, 0x10, 0x1E, 0xF7, 0x1F, 0x00, 0x02, 0xD0, 0x10, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x10, 0x00, 0x08, 0xFB, 0x1D, 0x00, 0x80, 0x03, 
  0x80, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x10, 0x00, 0x38, 0x71, 
  0x00, 0x02, 0x50, 0x02, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x10, 0x00, 0xF8, 0xC1, 0x07, 0x26, 0x7D, 0x0C, 0x00, 0x23, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x10, 0x00, 0x88, 0x01, 0x02, 0xFC, 0x0F, 0x18, 
  0xC0, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x10, 0x00, 0x26, 0x03, 
  0x38, 0x58, 0x01, 0xF0, 0xDF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x30, 0x00, 0xC6, 0x05, 0x2F, 0x00, 0x00, 0x04, 0xB5, 0x21, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x30, 0x00, 0xE2, 0x9C, 0x43, 0x0C, 0x00, 0x83, 
  0xF8, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0x00, 0x32, 0xF2, 
  0x00, 0x18, 0xC0, 0x43, 0xD8, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x20, 0x00, 0x1A, 0x48, 0x00, 0x70, 0x79, 0x40, 0xD8, 0x40, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x20, 0x00, 0x6E, 0x66, 0x18, 0xF0, 0x0F, 0x80, 
  0xFC, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0x00, 0xF6, 0x20, 
  0x77, 0x9C, 0x0D, 0x40, 0xE4, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x20, 0x00, 0xFE, 0xC0, 0xC5, 0x80, 0x08, 0x80, 0xA7, 0x41, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x20, 0x00, 0xFF, 0x60, 0x84, 0xC1, 0x08, 0x07, 
  0x9D, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0x00, 0x7F, 0x50, 
  0x84, 0x43, 0x9C, 0x0F, 0x96, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x60, 0x80, 0x3D, 0x50, 0x84, 0x02, 0xBC, 0x0F, 0x92, 0x44, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x60, 0x80, 0x3D, 0x78, 0x84, 0x02, 0xFE, 0x0F, 
  0x92, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x80, 0x09, 0xD8, 
  0x8C, 0x03, 0xFE, 0x0F, 0x93, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x40, 0x80, 0x00, 0x94, 0x7B, 0x02, 0xFC, 0x07, 0x91, 0x44, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x40, 0x80, 0x00, 0x04, 0x11, 0x00, 0xF8, 0x03, 
  0x91, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x80, 0x01, 0x80, 
  0x10, 0x00, 0xF0, 0x01, 0x91, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x40, 0x80, 0x01, 0x00, 0x00, 0x00, 0xE0, 0xC0, 0x89, 0x44, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x01, 0x00, 0x00, 0x00, 0x40, 0x60, 
  0x49, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x03, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0x49, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x40, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x20, 0x49, 0x44, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0x49, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x06, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0xD9, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x40, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x20, 0xF9, 0x45, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x30, 
  0x01, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x60, 0x00, 0x32, 0x00, 
  0x00, 0x00, 0x00, 0x30, 0x01, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0xE0, 0x01, 0x61, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x41, 0x44, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x20, 0xBF, 0xC3, 0x01, 0x00, 0x00, 0x00, 0x17, 
  0x21, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xF0, 0x80, 0x03, 
  0x00, 0x00, 0xC0, 0x13, 0x38, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x00, 0xC0, 0x01, 0x1E, 0x00, 0x00, 0x7E, 0x10, 0x08, 0x44, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x03, 0x80, 0x05, 0xF0, 0x01, 0xE0, 0x0F, 0x10, 
  0x08, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x1E, 0x80, 
  0xFF, 0x7F, 0x00, 0x20, 0x0C, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x3C, 0x00, 0xF0, 0x00, 0x70, 0x19, 0x00, 0x20, 0x0C, 0x42, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x80, 0x0B, 0x10, 0x08, 0x00, 0x60, 
  0x08, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x0E, 
  0x1C, 0x0C, 0x00, 0xC0, 0x80, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x0F, 0x00, 0x30, 0x04, 0x06, 0x00, 0x80, 0xC3, 0x80, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x60, 0x07, 0x06, 0x00, 0x00, 
  0xAE, 0x80, 0x00, 0x00
};

#define partyFrame2_width  128
#define partyFrame2_height 64
static const unsigned char partyFrame2_bits [] U8X8_PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x11, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x27, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x25, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x80, 0x24, 0x11, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xC1, 0xFF, 0x07, 0x30, 0x80, 
  0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x79, 
  0x01, 0xFC, 0x71, 0x80, 0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xB0, 0x0F, 0x00, 0x00, 0x7F, 0x80, 0x64, 0x11, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x00, 0xD8, 0x80, 
  0xF4, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB3, 0xF3, 
  0xFF, 0x01, 0xF8, 0x80, 0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0xC0, 0x7E, 0xFF, 0xFF, 0x0F, 0xEC, 0xC1, 0x04, 0x10, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x72, 0x6F, 0x5D, 0x7F, 0xDE, 0xC2, 
  0x04, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xB2, 0xDF, 
  0xF3, 0xFD, 0xEF, 0x4C, 0x84, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x80, 0x29, 0xFA, 0xF7, 0xBF, 0xAA, 0x77, 0x48, 0x60, 0x10, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x80, 0x2C, 0xFC, 0xBF, 0xFF, 0xEF, 0x6D, 0x50, 
  0x60, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x58, 0x80, 0x02, 
  0x80, 0xBF, 0x7B, 0x60, 0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x60, 0xF0, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x40, 0x30, 0x08, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x7F, 0x40, 
  0x30, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3B, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xFF, 0x80, 0x20, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x81, 0x01, 0x06, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x19, 0x00, 0x00, 0x00, 0x00, 0x04, 0xB8, 0x03, 
  0x0F, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x79, 0x00, 0x00, 0x00, 
  0x00, 0x0B, 0x70, 0x07, 0x18, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 
  0x49, 0x00, 0x00, 0x00, 0x80, 0x09, 0xE0, 0x06, 0xB8, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xB0, 0xC9, 0x00, 0x00, 0x00, 0x60, 0x08, 0xC0, 0x0D, 
  0x7C, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xCC, 0x01, 0x00, 0x00, 
  0x38, 0x10, 0x00, 0x0F, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 
  0x4C, 0x27, 0x00, 0x00, 0x06, 0x10, 0x00, 0x18, 0xCE, 0x1E, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x90, 0x4C, 0xF8, 0x00, 0xF8, 0x01, 0x20, 0x00, 0x60, 
  0xCC, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x6C, 0xE0, 0xD7, 0x07, 
  0x00, 0x78, 0x00, 0x20, 0x1C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 
  0xE4, 0x21, 0x17, 0x00, 0x00, 0xCF, 0x00, 0x18, 0xFC, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x98, 0x34, 0x27, 0xFC, 0xC0, 0xF4, 0x03, 0x01, 0x1C, 
  0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xB4, 0x3B, 0x40, 0xC0, 
  0x7F, 0x00, 0xEE, 0x1B, 0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 
  0x9C, 0x30, 0x00, 0x02, 0x04, 0x80, 0x10, 0x1F, 0x08, 0x06, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xC8, 0xDF, 0x54, 0x40, 0x07, 0x00, 0x40, 0x10, 0x1B, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xD0, 0x88, 0xB1, 0x84, 
  0x01, 0x30, 0x18, 0x1B, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0x70, 0x4C, 0x3F, 0x00, 0x03, 0x3C, 0x08, 0x1F, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0x7C, 0x43, 0x0F, 0x00, 0xFE, 0x07, 0x08, 0x1F, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xC6, 0x81, 0x09, 0x00, 
  0xFE, 0x01, 0xC8, 0x19, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0xC3, 0x0E, 0xC4, 0x87, 0x11, 0x01, 0x70, 0x30, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0xC1, 0x1E, 0xB0, 0x1C, 0x10, 0xE1, 0x30, 0x20, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xE1, 0x1F, 0x8C, 0x30, 
  0x98, 0xF3, 0x01, 0x67, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0xE1, 0x1F, 0x84, 0x70, 0x88, 0xF7, 0x01, 0x69, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x18, 0xE1, 0x0F, 0x0E, 0x51, 0xC0, 0xFF, 0x81, 0x61, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xA0, 0x07, 0x0A, 0x51, 
  0xC0, 0xFF, 0x01, 0x60, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 
  0xA0, 0x03, 0x8E, 0x71, 0x80, 0xFF, 0x80, 0x63, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x60, 0x30, 0x01, 0xFB, 0x0F, 0x00, 0x7F, 0x00, 0x60, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x38, 0x80, 0x31, 0x06, 
  0x00, 0x3E, 0x00, 0x20, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0x28, 0x00, 0x20, 0x00, 0x00, 0x1C, 0x00, 0x30, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0x28, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x18, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x68, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x0F, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x03, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xD8, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x30, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0x90, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x90, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0x06, 0x00, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0x10, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x07, 0x06, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0x10, 0x06, 0x00, 0x00, 0x00, 0x80, 0x01, 0xC0, 
  0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x10, 0x1E, 0x00, 0x00, 
  0x00, 0xF0, 0x00, 0x70, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0x30, 0x7C, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x1C, 0x00, 0x03, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0x30, 0xC4, 0x01, 0x00, 0x80, 0x0F, 0x00, 0x07, 
  0xC0, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x30, 0x8C, 0x1F, 0x00, 
  0xFC, 0x01, 0xC0, 0x01, 0x70, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0x30, 0x08, 0xF8, 0xFF, 0xDF, 0x00, 0x70, 0x00, 0x1C, 0x0C, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0x20, 0x08, 0x00, 0x94, 0x81, 0x00, 0x0C, 0x00, 
  0x07, 0x18, 0x00, 0x00
};

#define partyFrame3_width  128
#define partyFrame3_height 64
static const unsigned char partyFrame3_bits [] U8X8_PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x11, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x25, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x80, 0x24, 0x11, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x64, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x3C, 0xF8, 0xFF, 0x00, 0x06, 0x80, 0xF4, 0x13, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x2F, 0x80, 0x3F, 0x0E, 0x80, 
  0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF6, 0x01, 
  0x00, 0xE0, 0x0F, 0xC0, 0x04, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x1B, 0xC0, 0x04, 0x10, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x76, 0xFE, 0x3F, 0x00, 0x1F, 0x40, 
  0x84, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xEF, 0xFF, 
  0xFF, 0x81, 0x3D, 0x40, 0x60, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x44, 0xEE, 0xAD, 0xEB, 0xCF, 0x5B, 0x40, 0x60, 0x10, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xC0, 0x44, 0xF6, 0x7B, 0xBE, 0xFF, 0x9D, 0x41, 
  0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x45, 0xFF, 0xFE, 
  0x57, 0xF5, 0x0E, 0x41, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x90, 0x85, 0xFF, 0xF7, 0xFF, 0xBD, 0x0D, 0x42, 0x30, 0x0C, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x50, 0x00, 0xF0, 0x77, 0x0F, 0x84, 
  0x20, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x1E, 0x00, 0x00, 
  0x00, 0xFF, 0x07, 0x88, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x04, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x0F, 0x08, 0x0F, 0x02, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x1F, 0x10, 
  0x18, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
  0x00, 0x80, 0x3D, 0x20, 0xB8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x03, 0x00, 0x00, 0x00, 0x80, 0x00, 0x77, 0x20, 0x7C, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0x00, 0x60, 0x01, 0xEE, 0x60, 
  0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x09, 0x00, 0x00, 0x00, 
  0x30, 0x01, 0xDC, 0x40, 0xCE, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0x19, 0x00, 0x00, 0x00, 0x0C, 0x01, 0xB8, 0x41, 0xCC, 0x0E, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0x39, 0x00, 0x00, 0x00, 0x07, 0x02, 0xE0, 0x81, 
  0x1C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xE9, 0x04, 0x00, 0xC0, 
  0x00, 0x02, 0x00, 0x83, 0xFC, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB0, 
  0x0D, 0x1F, 0x00, 0x3F, 0x00, 0x04, 0x00, 0x8C, 0x08, 0x02, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x90, 0x0C, 0xFC, 0xFA, 0x00, 0x00, 0x0F, 0x00, 0x84, 
  0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x3C, 0xE4, 0x02, 0x00, 
  0xE0, 0x19, 0x00, 0x83, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 
  0xE4, 0x84, 0x1F, 0x98, 0x7E, 0x20, 0x80, 0x83, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x98, 0x74, 0x07, 0x08, 0xF8, 0x0F, 0xC0, 0x7D, 0x83, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC8, 0x13, 0x06, 0x40, 0x80, 
  0x00, 0x10, 0xE2, 0x83, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 
  0x98, 0x0A, 0xE8, 0x00, 0x00, 0x08, 0x62, 0x83, 0x09, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0x18, 0x31, 0x96, 0x30, 0x00, 0x06, 0x63, 0x03, 
  0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x8C, 0xE9, 0x07, 0x60, 
  0x80, 0x07, 0xE1, 0x03, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0x6E, 0xE8, 0x01, 0xC0, 0xFF, 0x00, 0xE1, 0x03, 0x09, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0x3A, 0x30, 0x01, 0xC0, 0x3F, 0x00, 0x39, 0x03, 
  0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xDB, 0x81, 0xF8, 0x30, 
  0x22, 0x00, 0x0E, 0x06, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0xD9, 0x03, 0x96, 0x03, 0x22, 0x1C, 0x06, 0x04, 0x09, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0xFD, 0x83, 0x11, 0x06, 0x73, 0x3E, 0xE0, 0x0C, 
  0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xFD, 0x83, 0x10, 0x0E, 
  0xF1, 0x3E, 0x20, 0x0D, 0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
  0xFC, 0xC1, 0x21, 0x0A, 0xF8, 0x3F, 0x30, 0x0C, 0x0A, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x30, 0xF4, 0x40, 0x21, 0x0A, 0xF8, 0x3F, 0x00, 0x0C, 
  0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x74, 0xC0, 0x31, 0x0E, 
  0xF0, 0x1F, 0x70, 0x0C, 0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0x24, 0x60, 0xFF, 0x01, 0xE0, 0x0F, 0x00, 0x0C, 0x09, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0x04, 0x30, 0xC6, 0x00, 0xC0, 0x07, 0x00, 0x04, 
  0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x04, 0x00, 0x04, 0x00, 
  0x80, 0x03, 0x00, 0x06, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0x04, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03, 0x09, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x0C, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xEC, 0x81, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x80, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 
  0x0C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x03, 0x80, 0x07, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0x30, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xC0, 0x01, 0x06, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0x70, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x70, 
  0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x70, 0x00, 0x00, 0x00, 
  0x00, 0x60, 0x00, 0x1C, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0xD0, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x07, 0xC0, 0x01, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0xD0, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xC0, 0x01, 
  0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x90, 0x0F, 0x00, 0x00, 
  0x80, 0x07, 0x70, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
  0xB0, 0x38, 0x00, 0x00, 0xF0, 0x01, 0x1C, 0x00, 0x07, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0xA0, 0xF1, 0x03, 0x80, 0x3F, 0x00, 0x03, 0xC0, 
  0x01, 0x00, 0x00, 0x00
};

#define partyFrame4_width  128
#define partyFrame4_height 64
static const unsigned char partyFrame4_bits [] U8X8_PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x68, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x2C, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x11, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x11, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x25, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xF0, 
  0xFF, 0x01, 0x0C, 0x80, 0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x78, 0x5E, 0x00, 0x7F, 0x1C, 0x80, 0x24, 0x11, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x03, 0x00, 0xC0, 0x1F, 0x80, 
  0x24, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 
  0x00, 0x00, 0x36, 0x80, 0x64, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xEC, 0xFC, 0x7F, 0x00, 0x3E, 0x80, 0xF4, 0x13, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xDF, 0xFF, 0xFF, 0x03, 0x7B, 0x80, 
  0x04, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0xDD, 0x5B, 
  0xD7, 0x9F, 0xB7, 0xC0, 0x04, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x40, 0x64, 0xEC, 0xF7, 0x7C, 0xFF, 0x3B, 0xC3, 0x04, 0x10, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x60, 0xC4, 0xFF, 0xFD, 0xAF, 0xEA, 0x1D, 0x42, 
  0x84, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB3, 0x04, 0xFE, 0xEF, 
  0xFF, 0x7B, 0x1B, 0x44, 0x60, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x97, 0x05, 0xA0, 0x00, 0xE0, 0xEF, 0x1E, 0x48, 0x60, 0x10, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xC0, 0x15, 0x0B, 0x00, 0x00, 0x00, 0xFE, 0x0F, 0x50, 
  0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x0D, 0x1E, 0x00, 0x00, 
  0x00, 0xF0, 0x1F, 0x50, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0x0D, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x50, 0x30, 0x0C, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xB0, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7B, 0x90, 
  0x20, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB0, 0x04, 0x00, 0x00, 0x00, 
  0x00, 0x01, 0xEE, 0xA0, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 
  0x1C, 0x00, 0x00, 0x00, 0xC0, 0x02, 0xDC, 0x21, 0x0F, 0x02, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x90, 0x18, 0x00, 0x00, 0x00, 0x60, 0x02, 0xB8, 0x61, 
  0x18, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x3C, 0x00, 0x00, 0x00, 
  0x18, 0x02, 0x70, 0x43, 0xB8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 
  0x74, 0x00, 0x00, 0x00, 0x0E, 0x04, 0xC0, 0x43, 0x7C, 0x07, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x98, 0xD4, 0x09, 0x00, 0x80, 0x01, 0x04, 0x80, 0x81, 
  0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x14, 0x3E, 0x00, 0x7E, 
  0x00, 0x08, 0x00, 0x83, 0xCE, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC8, 
  0x1F, 0xF8, 0xF5, 0x01, 0x00, 0x1E, 0x00, 0x8C, 0xCC, 0x0E, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x48, 0x70, 0xC8, 0x05, 0x00, 0xC0, 0x13, 0x00, 0x84, 
  0x1C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xC0, 0x09, 0x3F, 0x30, 
  0xFD, 0x20, 0x00, 0x84, 0xFC, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0xEC, 0x0E, 0x10, 0xF0, 0x1F, 0x20, 0x80, 0x87, 0x08, 0x02, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0x26, 0x0C, 0x80, 0x00, 0x01, 0xC0, 0xFD, 0x87, 
  0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x33, 0x15, 0xD0, 0x01, 
  0x00, 0x10, 0xC2, 0x86, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0x31, 0x62, 0x2C, 0x61, 0x00, 0x0C, 0xC2, 0x86, 0x09, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0x19, 0xD3, 0x0F, 0xC0, 0x00, 0x0F, 0xC2, 0x07, 
  0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xD9, 0xD0, 0x03, 0x80, 
  0xFF, 0x01, 0xC2, 0x07, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
  0x71, 0x60, 0x02, 0x80, 0x7F, 0x00, 0x72, 0x06, 0x09, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x18, 0xB2, 0x03, 0xF1, 0x61, 0x44, 0x00, 0x1C, 0x0C, 
  0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xB2, 0x07, 0x2C, 0x07, 
  0x44, 0x38, 0x0C, 0x08, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 
  0xF8, 0x07, 0x23, 0x0C, 0xE6, 0x7C, 0xC0, 0x19, 0x09, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0xF8, 0x07, 0x21, 0x1C, 0xE2, 0x7D, 0x40, 0x1A, 
  0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xF8, 0x83, 0x43, 0x14, 
  0xF0, 0x7F, 0x60, 0x18, 0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0xE8, 0x81, 0x42, 0x14, 0xF0, 0x7F, 0x00, 0x18, 0x0A, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0xE8, 0x80, 0x63, 0x1C, 0xE0, 0x3F, 0xE0, 0x18, 
  0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x48, 0xC0, 0xFE, 0x03, 
  0xC0, 0x1F, 0x00, 0x18, 0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0x08, 0x60, 0x8C, 0x01, 0x80, 0x0F, 0x00, 0x08, 0x09, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0x08, 0x00, 0x08, 0x00, 0x00, 0x07, 0x00, 0x0C, 
  0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x08, 0x00, 0x00, 0x00, 
  0x00, 0x02, 0x00, 0x06, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x09, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0x83, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x18, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xF8, 0x80, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x80, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x68, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x03, 0x80, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x0C, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0xD0, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x80, 
  0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x90, 0x01, 0x00, 0x00, 
  0x00, 0x60, 0x00, 0xE0, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0x90, 0x07, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x38, 0x00, 0x02, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0x10, 0x1F, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x06, 
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x71, 0x00, 0x00, 
  0xE0, 0x03, 0x80, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0x10, 0xE3, 0x07, 0x00, 0x7F, 0x00, 0xF0, 0x00, 0x30, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0x10, 0x02, 0xFE, 0xFF, 0x37, 0x00, 0x1E, 0x00, 
  0x0F, 0x00, 0x00, 0x00
};

#define partyFrame5_width  128
#define partyFrame5_height 64
static const unsigned char partyFrame5_bits [] U8X8_PROGMEM = {
  0x00, 0x00, 0x00, 0x90, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xE4, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 
  0xA4, 0x01, 0x00, 0xC0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x98, 0x34, 0x01, 0x00, 0xC0, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x14, 0x01, 0x00, 0x60, 
  0xF1, 0xFF, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 
  0x14, 0x01, 0x00, 0xE0, 0x5D, 0x90, 0x3F, 0x30, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xC8, 0x1F, 0x01, 0x40, 0xF8, 0x07, 0x00, 0xE8, 0x70, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x10, 0x01, 0x60, 0x7C, 
  0x03, 0x00, 0x00, 0xD9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0x10, 0x01, 0xA3, 0xB4, 0xC2, 0x5F, 0x00, 0xDE, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0x1C, 0x81, 0xA2, 0xF6, 0xFF, 0xFF, 0x07, 0xD8, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x07, 0x81, 0xA2, 0xF1, 
  0x5E, 0xF5, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0x03, 0x41, 0x12, 0x71, 0xB7, 0x6D, 0x7F, 0xF6, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x08, 0x01, 0x41, 0x14, 0xFE, 0xEF, 0xF7, 0xED, 0x7F, 
  0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x21, 0x24, 0xF8, 
  0xBF, 0xFF, 0xD5, 0x7B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
  0x01, 0x21, 0x5C, 0x80, 0x02, 0xA0, 0xEF, 0x6F, 0x18, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x18, 0x81, 0x10, 0x50, 0x00, 0x00, 0x00, 0x9E, 0x37, 
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x80, 0x30, 0x60, 0x00, 
  0x00, 0x00, 0x70, 0x7D, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 
  0xC0, 0x20, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x60, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x04, 0xF5, 
  0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x38, 0x40, 0x00, 0x00, 
  0x00, 0x00, 0x06, 0xFE, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x05, 0xF8, 0x83, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x18, 0xC0, 0x00, 0x00, 0x00, 0x80, 0x09, 0x70, 
  0x87, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x10, 0x80, 0x02, 0x00, 
  0x00, 0xE0, 0x08, 0xE0, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x10, 0x80, 0x05, 0x00, 0x00, 0x10, 0x08, 0xC0, 0x8E, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x10, 0x00, 0x39, 0x00, 0x80, 0x0F, 0x10, 0x80, 
  0x0D, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x10, 0x00, 0xE1, 0x71, 
  0xFF, 0x01, 0x20, 0x00, 0x0D, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x10, 0x80, 0xB0, 0xDF, 0x01, 0x00, 0x38, 0x00, 0x38, 0x01, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x10, 0x80, 0x13, 0x07, 0x20, 0x00, 0x25, 0x00, 
  0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x10, 0x80, 0x1F, 0x7C, 
  0x60, 0xD2, 0xC7, 0x00, 0x30, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x30, 0x80, 0x18, 0x20, 0xC0, 0xFF, 0x80, 0x01, 0x1C, 0x06, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x30, 0x60, 0x32, 0x80, 0x83, 0x15, 0x00, 0xFF, 
  0x0D, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0x60, 0x5C, 0xF0, 
  0x02, 0x00, 0x40, 0x50, 0x1B, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x20, 0x20, 0xCE, 0x39, 0xC4, 0x00, 0x30, 0x88, 0x1F, 0x02, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x20, 0x20, 0x23, 0x0F, 0x80, 0x01, 0x3C, 0x84, 
  0x1D, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0xA0, 0x81, 0x04, 
  0x00, 0x97, 0x07, 0x84, 0xED, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x20, 0xE0, 0x66, 0x86, 0x01, 0xFF, 0x00, 0xC8, 0xAF, 0x05, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x20, 0x60, 0x0F, 0x72, 0xC7, 0xD9, 0x00, 0x44, 
  0x9C, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0xE0, 0x0F, 0x5C, 
  0x0C, 0x88, 0x00, 0x78, 0x96, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x60, 0xF0, 0x0F, 0x46, 0x18, 0x8C, 0x70, 0x10, 0x92, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x60, 0xF0, 0x07, 0x45, 0x38, 0xC4, 0xF9, 0x00, 
  0x92, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0xD8, 0x03, 0x45, 
  0x28, 0xC0, 0xFB, 0x00, 0x93, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x40, 0xD8, 0x83, 0x47, 0x28, 0xE0, 0xFF, 0x00, 0x91, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x40, 0x98, 0x80, 0xCD, 0x38, 0xE0, 0xFF, 0x00, 
  0x91, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x08, 0x40, 0xB9, 
  0x27, 0xC0, 0x7F, 0x00, 0x91, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x40, 0x08, 0x40, 0x10, 0x01, 0x80, 0x3F, 0xC0, 0x89, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x40, 0x18, 0x00, 0x08, 0x01, 0x00, 0x1F, 0x60, 
  0x49, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x18, 0x00, 0x00, 
  0x00, 0x00, 0x0E, 0x20, 0x49, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x40, 0x10, 0x00, 0x00, 0x00, 0x00, 0x04, 0x20, 0x49, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x40, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
  0x49, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x30, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x30, 0xD9, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xF9, 0x05, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x40, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 
  0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x60, 0xC0, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x36, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0xE0, 0x81, 0x01, 0x00, 0x00, 0x00, 0x00, 0x13, 0x41, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x20, 0xBF, 0x03, 0x00, 0x00, 0x00, 0x00, 0x11, 
  0x21, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xF0, 0x06, 0x00, 
  0x00, 0x00, 0xC0, 0x10, 0x38, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x00, 0xC0, 0x19, 0x00, 0x00, 0x00, 0x70, 0x10, 0x08, 0x04, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x03, 0x80, 0x35, 0x00, 0x00, 0x00, 0x3E, 0x10, 
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0xDE, 0x01, 
  0x00, 0xE0, 0x01, 0x20, 0x0C, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x3C, 0x00, 0xF0, 0x1E, 0x00, 0xFE, 0x00, 0x20, 0x0C, 0x02, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x80, 0xFB, 0xFF, 0x07, 0x00, 0x60, 
  0x08, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x0E, 
  0x97, 0x01, 0x00, 0xC0, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x0F, 0x00, 0x30, 0x81, 0x00, 0x00, 0x80, 0xC3, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x60, 0xC1, 0x00, 0x00, 0x00, 
  0xAE, 0x00, 0x00, 0x00
};

// Splash is the custom type used internally in GEM library for convenient way of storing XBM graphics of Splash screen
const Splash partyFrame1 = {partyFrame1_width, partyFrame1_height, partyFrame1_bits};
const Splash partyFrame2 = {partyFrame2_width, partyFrame2_height, partyFrame2_bits};
const Splash partyFrame3 = {partyFrame3_width, partyFrame3_height, partyFrame3_bits};
const Splash partyFrame4 = {partyFrame4_width, partyFrame4_height, partyFrame4_bits};
const Splash partyFrame5 = {partyFrame5_width, partyFrame5_height, partyFrame5_bits};

const Splash frames[] = {partyFrame1, partyFrame2, partyFrame3, partyFrame4, partyFrame5};
