/**
 **************************************************
 *
 * @file        Soldered-OpenAI-Library
 * @brief       Header file that contains function prototypes
 *              for the LLM class
 *
 * @copyright   GNU General Public License v3.0
 * @authors     Josip Šimun Kuči @ soldered.com
 ***************************************************/
#pragma once
#include "Prompts.h"
#include "base64.h"
#include "string.h"
#include <Arduino.h>
#include <ArduinoJson.h>
#include <HTTPClient.h>
#include <WiFiClientSecure.h>

class LLM
{
  public:
    LLM(const char *key, const char *model, unsigned int maxTokens = 300);

    // Basic text response
    String ask(const String &prompt);

    // Yes/No response
    bool askYesNo(const String &prompt);

    // Multiple choice classification
    String classify(const String &prompt, const String labels[], size_t labelCount);

    // Send an image alongside a text prompt
    String askImage(uint8_t *buffer, int bufferLength, const String &prompt);

    // Generate an image
    String generateImage(const String &prompt, const String &resolution = "1024x1024",
                         const String &imageFormat = "png", const String &quality = "standard",
                         const String &style = "natural");

    // Change the max amount of tokens to be consumed by the LLM
    void changeMaxTokenCount(unsigned int tokens);

    // Changes
    void changeModel(const char *model);

    // Create a speech prompt
    String askAudio(const uint8_t *audioBuffer, size_t audioLength, const String &format, const String &prompt);


  private:
    const char *_api;
    const char *_key;
    const char *_model;
    unsigned int _maxTokens;

    String sendToOpenAI(const String &prompt, bool echoChoices = false, const String labels[] = nullptr,
                        size_t labelCount = 0);
};
