# Soldered OpenAI Arduino library

[![Make docs and publish to GitHub Pages](https://github.com/SolderedElectronics/Soldered-OpenAI-Library/actions/workflows/make_docs.yml/badge.svg?branch=dev)](https://github.com/SolderedElectronics/Soldered-OpenAI-Library/actions/workflows/make_docs.yml)
[![Arduino Library Manager Compatibility](https://github.com/SolderedElectronics/Soldered-OpenAI-Library/actions/workflows/arduino_lint.yml/badge.svg?branch=dev)](https://github.com/SolderedElectronics/Soldered-OpenAI-Library/actions/workflows/arduino_lint.yml)

This Arduino library brings powerful artificial intelligence capabilities to microcontrollers, enabling seamless integration with OpenAI's GPT models for natural language processing and computer vision tasks. The library transforms your ESP32 into an intelligent device that can understand text, analyze images, and make smart decisions through simple API calls.

Key Features & Capabilities

- **Text-based AI interactions** - Ask questions, get detailed responses, and have conversations with GPT models
- **Smart classification systems** - Perform yes/no decisions or multi-choice classification for IoT applications
- **Computer vision integration** - Capture images with cameras and get AI-powered descriptions and analysis
- **Image generation** - Generate images using a text prompt which can then be accessed via URL
- **Speech prompts** - Send base64 encoded audio data which can be processed by an OpenAI API, which returns a text response
- **Resource-efficient design** - Optimized for embedded systems with memory management and configurable token limits
- **Easy-to-use API** - Simple methods that abstract complex HTTP communications and JSON processing
Perfect for creating smart security systems, interactive assistants, educational tools, or any project that benefits from AI-powered decision making and natural language understanding at the edge!

### Repository Contents

- **/src** - source files for the library (.h & .cpp)
- **/src/Prompts.h** - User configurable suffixes used in prompts
- **/examples** - examples for using the library
- **_other_** - _keywords_ file highlights function words in your IDE, _library.properties_ enables implementation with Arduino Library Manager.


### Documentation

Access The documentation for our products [here](https://soldered.com/documentation/).


### About Soldered

<img src="https://raw.githubusercontent.com/SolderedElectronics/Soldered-OpenAI-Library/dev/extras/Soldered-logo-color.png" alt="soldered-logo" width="500"/>

At Soldered, we design and manufacture a wide selection of electronic products to help you turn your ideas into acts and bring you one step closer to your final project. Our products are intented for makers and crafted in-house by our experienced team in Osijek, Croatia. We believe that sharing is a crucial element for improvement and innovation, and we work hard to stay connected with all our makers regardless of their skill or experience level. Therefore, all our products are open-source. Finally, we always have your back. If you face any problem concerning either your shopping experience or your electronics project, our team will help you deal with it, offering efficient customer service and cost-free technical support anytime. Some of those might be useful for you:

- [Web Store](https://www.soldered.com/shop)
- [Tutorials & Projects](https://soldered.com/learn)
- [Community & Technical support](https://soldered.com/community)


### Open-source license

Soldered invests vast amounts of time into hardware & software for these products, which are all open-source. Please support future development by buying one of our products.

Check license details in the LICENSE file. Long story short, use these open-source files for any purpose you want to, as long as you apply the same open-source licence to it and disclose the original source. No warranty - all designs in this repository are distributed in the hope that they will be useful, but without any warranty. They are provided "AS IS", therefore without warranty of any kind, either expressed or implied. The entire quality and performance of what you do with the contents of this repository are your responsibility. In no event, Soldered (TAVU) will be liable for your damages, losses, including any general, special, incidental or consequential damage arising out of the use or inability to use the contents of this repository.

## Have fun!

And thank you from your fellow makers at Soldered Electronics.
