/**
 **************************************************
 *
 * @file        epdPmicDefs.h
 * @brief       Header file with all TPS651851 register defines.
 *
 *
 * @copyright   GNU General Public License v3.0
 * @authors     Borna Biro for soldered.com
 ***************************************************/

// TPS651851 PMIC I2C Address
#define TPS_PMIC_ADDR 0x68

// TPS651851 Registers
#define TPS651851_TMST_VALUE 0x00
#define TPS651851_ENABLE     0x01
#define TPS651851_VADJ       0x02
#define TPS651851_VCOM1      0x03
#define TPS651851_VCOM2      0x04
#define TPS651851_INT_EN1    0x05
#define TPS651851_INT_EN2    0x06
#define TPS651851_INT1       0x07
#define TPS651851_INT2       0x08
#define TPS651851_UPSEQ0     0x09
#define TPS651851_UPSEQ1     0x0A
#define TPS651851_DWNSEQ0    0x0B
#define TPS651851_DWNSEQ1    0x0C
#define TPS651851_TMST1      0x0D
#define TPS651851_TMST2      0x0E
#define TPS651851_PG         0x0F
#define TPS651851_REVID      0x10

// Power up sequence defines
#define TPS651851_VDDH_UPSEQ_1 0b00000000
#define TPS651851_VDDH_UPSEQ_2 0b01000000
#define TPS651851_VDDH_UPSEQ_3 0b10000000
#define TPS651851_VDDH_UPSEQ_4 0b11000000

#define TPS651851_VPOS_UPSEQ_1 0b00000000
#define TPS651851_VPOS_UPSEQ_2 0b00010000
#define TPS651851_VPOS_UPSEQ_3 0b00100000
#define TPS651851_VPOS_UPSEQ_4 0b00110000

#define TPS651851_VEE_UPSEQ_1 0b00000000
#define TPS651851_VEE_UPSEQ_2 0b00000100
#define TPS651851_VEE_UPSEQ_3 0b00001000
#define TPS651851_VEE_UPSEQ_4 0b00001100

#define TPS651851_VNEG_UPSEQ_1 0b00000000
#define TPS651851_VNEG_UPSEQ_2 0b00000001
#define TPS651851_VNEG_UPSEQ_3 0b00000010
#define TPS651851_VNEG_UPSEQ_4 0b00000011

// Power down sequence defines
#define TPS651851_VDDH_DWNSEQ_1 0b00000000
#define TPS651851_VDDH_DWNSEQ_2 0b01000000
#define TPS651851_VDDH_DWNSEQ_3 0b10000000
#define TPS651851_VDDH_DWNSEQ_4 0b11000000

#define TPS651851_VPOS_DWNSEQ_1 0b00000000
#define TPS651851_VPOS_DWNSEQ_2 0b00010000
#define TPS651851_VPOS_DWNSEQ_3 0b00100000
#define TPS651851_VPOS_DWNSEQ_4 0b00110000

#define TPS651851_VEE_DWNSEQ_1 0b00000000
#define TPS651851_VEE_DWNSEQ_2 0b00000100
#define TPS651851_VEE_DWNSEQ_3 0b00001000
#define TPS651851_VEE_DWNSEQ_4 0b00001100

#define TPS651851_VNEG_DWNSEQ_1 0b00000000
#define TPS651851_VNEG_DWNSEQ_2 0b00000001
#define TPS651851_VNEG_DWNSEQ_3 0b00000010
#define TPS651851_VNEG_DWNSEQ_4 0b00000011

// Power up delay defines
#define TPS651851_UPSEQ_STB3_STB4_3MS  0b00000000
#define TPS651851_UPSEQ_STB3_STB4_6MS  0b01000000
#define TPS651851_UPSEQ_STB3_STB4_9MS  0b10000000
#define TPS651851_UPSEQ_STB3_STB4_12MS 0b11000000

#define TPS651851_UPSEQ_STB2_STB3_3MS  0b00000000
#define TPS651851_UPSEQ_STB2_STB3_6MS  0b00010000
#define TPS651851_UPSEQ_STB2_STB3_9MS  0b00100000
#define TPS651851_UPSEQ_STB2_STB3_12MS 0b00110000

#define TPS651851_UPSEQ_STB1_STB2_3MS  0b00000000
#define TPS651851_UPSEQ_STB1_STB2_6MS  0b00000100
#define TPS651851_UPSEQ_STB1_STB2_9MS  0b00001000
#define TPS651851_UPSEQ_STB1_STB2_12MS 0b00001100

#define TPS651851_UPSEQ_STB0_STB1_3MS  0b00000000
#define TPS651851_UPSEQ_STB0_STB1_6MS  0b00000001
#define TPS651851_UPSEQ_STB0_STB1_9MS  0b00000010
#define TPS651851_UPSEQ_STB0_STB1_12MS 0b00000011

// Power down delay defines
#define TPS651851_DWNSEQ_STB3_STB4_6MS  0b00000000
#define TPS651851_DWNSEQ_STB3_STB4_12MS 0b01000000
#define TPS651851_DWNSEQ_STB3_STB4_24MS 0b10000000
#define TPS651851_DWNSEQ_STB3_STB4_48MS 0b11000000

#define TPS651851_DWNSEQ_STB2_STB3_6MS  0b00000000
#define TPS651851_DWNSEQ_STB2_STB3_12MS 0b00010000
#define TPS651851_DWNSEQ_STB2_STB3_24MS 0b00100000
#define TPS651851_DWNSEQ_STB2_STB3_48MS 0b00110000

#define TPS651851_DWNSEQ_STB1_STB2_6MS  0b00000000
#define TPS651851_DWNSEQ_STB1_STB2_12MS 0b00000100
#define TPS651851_DWNSEQ_STB1_STB2_24MS 0b00001000
#define TPS651851_DWNSEQ_STB1_STB2_48MS 0b00001100

#define TPS651851_DWNSEQ_STB0_STB1_3MS 0b00000000
#define TPS651851_DWNSEQ_STB0_STB1_6MS 0b00000010

#define TPS651851_DWNSEQ_DLY_MUL_1  0b00000000
#define TPS651851_DWNSEQ_DLY_MUL_16 0b00000010

// TPS651851 Interrupt Enable defines.
// NOTE: Two Interrupt registers are merged together.
#define TPS651851_INT_EN_DTX_EN       0b0000000000000001
#define TPS651851_INT_EN_TSD_EN       0b0000000000000010
#define TPS651851_INT_EN_HOT_EN       0b0000000000000100
#define TPS651851_INT_EN_TMST_HOT_EN  0b0000000000001000
#define TPS651851_INT_EN_TMST_COLD_EN 0b0000000000010000
#define TPS651851_INT_EN_UVLO_EN      0b0000000000100000
#define TPS651851_INT_EN_ACQC_EN      0b0000000001000000
#define TPS651851_INT_EN_PRGC_EN      0b0000000010000000
#define TPS651851_INT_EN_VBUVEN       0b0000000100000000
#define TPS651851_INT_EN_VDDHUVEN     0b0000001000000000
#define TPS651851_INT_EN_VNUV_EN      0b0000010000000000
#define TPS651851_INT_EN_VPOSUVEN     0b0000100000000000
#define TPS651851_INT_EN_VEEUVEN      0b0001000000000000
#define TPS651851_INT_EN_VCOMFEN      0b0010000000000000
#define TPS651851_INT_EN_VNEGUVEN     0b0100000000000000
#define TPS651851_INT_EN_EOCEN        0b1000000000000000

// TPS615851 Interrupt Status Registers.
// NOTE: Two Interrupt registers are merged together.
#define TPS651851_INT_STATUS_DTX_EN       0b0000000000000001
#define TPS651851_INT_STATUS_TSD_EN       0b0000000000000010
#define TPS651851_INT_STATUS_HOT_EN       0b0000000000000100
#define TPS651851_INT_STATUS_TMST_HOT_EN  0b0000000000001000
#define TPS651851_INT_STATUS_TMST_COLD_EN 0b0000000000010000
#define TPS651851_INT_STATUS_UVLO_EN      0b0000000000100000
#define TPS651851_INT_STATUS_ACQC_EN      0b0000000001000000
#define TPS651851_INT_STATUS_PRGC_EN      0b0000000010000000
#define TPS651851_INT_STATUS_VBUVEN       0b0000000100000000
#define TPS651851_INT_STATUS_VDDHUVEN     0b0000001000000000
#define TPS651851_INT_STATUS_VNUV_EN      0b0000010000000000
#define TPS651851_INT_STATUS_VPOSUVEN     0b0000100000000000
#define TPS651851_INT_STATUS_VEEUVEN      0b0001000000000000
#define TPS651851_INT_STATUS_VCOMFEN      0b0010000000000000
#define TPS651851_INT_STATUS_VNEGUVEN     0b0100000000000000
#define TPS651851_INT_STATUS_EOCEN        0b1000000000000000

// Voltage adjusment register.
#define TPS651851_VADJ_VSET_15000 0b00000011
#define TPS651851_VADJ_VSET_14750 0b00000100
#define TPS651851_VADJ_VSET_14500 0b00000101
#define TPS651851_VADJ_VSET_14250 0b00000110

// Default power goood flag - indicating all rails are ready.
#define TPS651851_PWR_GOOD_OK 0b11111010