/*
 * pq_print.h
 *
 * Print functions for Plaquette.
 *
 * (c) 2015 Sofian Audry        :: info(@)sofianaudry(.)com
 * (c) 2015 Thomas O Fredericks :: tof(@)t-o-f(.)info
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PQ_PRINT_H_
#define PQ_PRINT_H_

#include "pq_globals.h"

#if (defined(ARDUINO) && ARDUINO >= 100) || defined(EPOXY_DUINO)
#include <Arduino.h>
#else
#include <WProgram.h>
#endif

namespace pq {

// Platform-dependent typedef for PlaquetteSerialType.
#if defined(ARDUINO_ARCH_AVR)
  #if defined(USBCON)
    typedef Serial_ PlaquetteSerialType;  // Leonardo, Micro (USB CDC)
  #else
    typedef HardwareSerial PlaquetteSerialType;  // Uno, Mega, Nano
  #endif
#elif defined(ARDUINO_ARCH_ESP32) || defined(ARDUINO_ARCH_ESP8266)
  typedef HardwareSerial PlaquetteSerialType;
#elif defined(ARDUINO_ARCH_SAMD)
  typedef Uart PlaquetteSerialType;
#elif defined(EPOXY_DUINO)
  typedef StdioSerial PlaquetteSerialType;
#else
  typedef HardwareSerial PlaquetteSerialType;  // Fallback
#endif

// Starts console.
void consoleBegin();
void consoleBegin(unsigned long baudRate);

/// Sets the output device for console output.
void consoleOutput(Print& console);
void consoleOutput(PlaquetteSerialType& console);
void consoleOutput(PlaquetteSerialType& console, unsigned long baudRate);
void consoleOutput(unsigned long baudRate);

// Print functions.

size_t print(const __FlashStringHelper *);
size_t print(const String &);
size_t print(const char[]);
size_t print(char);
size_t print(unsigned char, int = DEC);
size_t print(int, int = DEC);
size_t print(unsigned int, int = DEC);
size_t print(long, int = DEC);
size_t print(unsigned long, int = DEC);
size_t print(double, int = 2);
size_t print(const Printable&);

size_t println(const __FlashStringHelper *);
size_t println(const String &s);
size_t println(const char[]);
size_t println(char);
size_t println(unsigned char, int = DEC);
size_t println(int, int = DEC);
size_t println(unsigned int, int = DEC);
size_t println(long, int = DEC);
size_t println(unsigned long, int = DEC);
size_t println(double, int = 2);
size_t println(const Printable&);
size_t println(void);

} // namespace pq

#endif
