### Changelog

All notable changes to this project will be documented in this file. Dates are displayed in UTC.

Generated by [`auto-changelog`](https://github.com/CookPete/auto-changelog).

#### [v0.8.3](https://github.com/SofaPirate/Plaquette/compare/v0.8.2...v0.8.3)

> 16 December 2025

- New naming conventions for serial monitor / console. [`eff3399`](https://github.com/SofaPirate/Plaquette/commit/eff339999d214fda07101e6cfc703dc361c0010b)
- Added new options to change the serial object and baudrate associated with the global print() functions. [`96dd7b4`](https://github.com/SofaPirate/Plaquette/commit/96dd7b4f77ee19e245653c28f76ce82ca305a419)
- Adjustments for print functions allowing the change of default serial object. [`d49c195`](https://github.com/SofaPirate/Plaquette/commit/d49c195961a2400bb2ba70db316698376e85bd98)

#### [v0.8.2](https://github.com/SofaPirate/Plaquette/compare/v0.8.1...v0.8.2)

> 2 December 2025

- Renamed randomize() to jitter() (closes #151). [`#151`](https://github.com/SofaPirate/Plaquette/issues/151)
- In-depth refactoring of moving filters. [`28d9b1c`](https://github.com/SofaPirate/Plaquette/commit/28d9b1c1474f060850b28dddb116abc74a4867ca)
- Finished refactor of filters. [`fe0a102`](https://github.com/SofaPirate/Plaquette/commit/fe0a102f1b5f36e46f4640fc63d7045e335973b0)
- Added support for range presets (priors) in exponential moving filters. [`4026f07`](https://github.com/SofaPirate/Plaquette/commit/4026f07070512997a0eaa0f980aa6776a270ae36)

#### [v0.8.1](https://github.com/SofaPirate/Plaquette/compare/v0.8.0...v0.8.1)

> 6 November 2025

- Added GitHub issue templates. [`83af5c7`](https://github.com/SofaPirate/Plaquette/commit/83af5c75617a5b2bcc57ee268e673c25439d52ad)
- Added draft instructions for contributing (besides coding standards). [`428e038`](https://github.com/SofaPirate/Plaquette/commit/428e038380c0b7674ed972dd58fd05fd7a32e2a1)
- Removed script. [`fec6b62`](https://github.com/SofaPirate/Plaquette/commit/fec6b6227573ea4009a1c56cb4b8aecdac0f4e92)

#### [v0.8.0](https://github.com/SofaPirate/Plaquette/compare/v0.7.0...v0.8.0)

> 20 September 2025

- Implemented non-blocking step (closes #129). [`#129`](https://github.com/SofaPirate/Plaquette/issues/129)
- Allow detachment of servo motors (closes #95). [`#95`](https://github.com/SofaPirate/Plaquette/issues/95)
- Renamed phaseTime to phase32 and fixed to fixed32 (closes #139). [`#139`](https://github.com/SofaPirate/Plaquette/issues/139)
- Added pq_math.h file replacing macro math functions (closes #73). [`#73`](https://github.com/SofaPirate/Plaquette/issues/73)
- Removed Doxyfile at top level. [`c8f9c2d`](https://github.com/SofaPirate/Plaquette/commit/c8f9c2dfdde2788765f225d9ce7c9442d873f1c7)
- Added Doxygen file [`abbe813`](https://github.com/SofaPirate/Plaquette/commit/abbe8138a93296fb10d5d77760b88f822c906fbf)
- Complete refactor Metronome and AbstractWave to inherit from common class AbstractOscillator. [`71ad53c`](https://github.com/SofaPirate/Plaquette/commit/71ad53cc8ddbd4852d764a22291fea06de41cc93)

#### [v0.7.0](https://github.com/SofaPirate/Plaquette/compare/v0.6.5...v0.7.0)

> 7 April 2025

- Major update implementing support for multiple Plaquette environments (closes #70 !) [`#70`](https://github.com/SofaPirate/Plaquette/issues/70)
- Changed begin() and step() function to take Engine& parameter passed by parent. [`ca0acf7`](https://github.com/SofaPirate/Plaquette/commit/ca0acf72e55a8e57e3541f52c9d81d295c9ceecb)
- Renamed main() to primary() for default/main engine. [`a5a8876`](https://github.com/SofaPirate/Plaquette/commit/a5a88761acc32d48e3a3e38d42f127eec416979d)
- Added multi engines example. [`4a22994`](https://github.com/SofaPirate/Plaquette/commit/4a2299418242ae957985c8e174b1950f1b97f490)

#### [v0.6.5](https://github.com/SofaPirate/Plaquette/compare/v0.6.4...v0.6.5)

> 2 March 2025

- Provide functions to directly read or write to analog/digital pins (closes #128) [`#128`](https://github.com/SofaPirate/Plaquette/issues/128)
- Deprecated SOURCE and SINK in favor of DIRECT and INVERTED (closes #85). [`#85`](https://github.com/SofaPirate/Plaquette/issues/85)
- Apply effect of digital/analog write only during step() (closes #86). [`#86`](https://github.com/SofaPirate/Plaquette/issues/86)
- Added updated() / onUpdate() functions to StreamIn (closes #122). [`#122`](https://github.com/SofaPirate/Plaquette/issues/122)
- Prevent microseconds 70 hours overflow (closes #125). [`#125`](https://github.com/SofaPirate/Plaquette/issues/125)
- Major rework of waves using fixed-point computation with added resolution on sine waves (closes #101). [`#101`](https://github.com/SofaPirate/Plaquette/issues/101)
- Added state change bools and events to SquareWave. [`5d4de8c`](https://github.com/SofaPirate/Plaquette/commit/5d4de8c8d6d4b4b1a34489cf6269e82b6ff3f5ff)
- Used computational tricks to improve performance of sine wave calculation. [`5425402`](https://github.com/SofaPirate/Plaquette/commit/5425402444e2b51fa36f0805463081d8266b3f26)
- Expanded and adjusted credits. [`054e584`](https://github.com/SofaPirate/Plaquette/commit/054e5844881163f771e178ceccef200bcbee784a)

#### [v0.6.4](https://github.com/SofaPirate/Plaquette/compare/v0.6.3...v0.6.4)

> 28 January 2025

- Implemented global solution for Plaquette singleton management (closts #124, ref #47 and #48). [`6b547b8`](https://github.com/SofaPirate/Plaquette/commit/6b547b8dc3c1a953463ebf4453f0f7047fd9025f)
- Fixed calculation of NORMALIZER_DEFAULT_MEAN2 which was erroneous + do not rely on macro sq() to avoid compilation problems on some platforms. [`f88f890`](https://github.com/SofaPirate/Plaquette/commit/f88f890d0b55c5f5da04ca6f994633bac591ab65)
- Updated to version 0.6.4. [`1007380`](https://github.com/SofaPirate/Plaquette/commit/10073804baaa16aa383040d9986845c3811b9df0)

#### [v0.6.3](https://github.com/SofaPirate/Plaquette/compare/v0.6.2...v0.6.3)

> 27 January 2025

- Adjustments to guide. [`a57df0d`](https://github.com/SofaPirate/Plaquette/commit/a57df0dc2c2c02170255082eefae19818b2e3ca8)
- Rewrote last section of "Why Plaquette". [`15fd088`](https://github.com/SofaPirate/Plaquette/commit/15fd08874ccb1a0b7130733d4939bd1cd3e387b8)
- Improved computation of moving average with a more accurate version of alpha estimation and update function. [`9b531fd`](https://github.com/SofaPirate/Plaquette/commit/9b531fd44f541a1b72a3b5339283c4a3d2f646dc)

#### [v0.6.2](https://github.com/SofaPirate/Plaquette/compare/v0.6.1...v0.6.2)

> 17 January 2025

- Editing of timing_basics. [`73ca4ef`](https://github.com/SofaPirate/Plaquette/commit/73ca4efa102a3faa2bae46ecd02af48724289b75)
- Added information about circuit and link to input_output section in the section about regularizing signals. [`9391f3a`](https://github.com/SofaPirate/Plaquette/commit/9391f3a916823777932562a4a50f8865b861fd35)
- Added onFinish() events to Alarm and Ramp. [`09c9c3e`](https://github.com/SofaPirate/Plaquette/commit/09c9c3ee1d14e6a9bf259fad8d80854bc2541131)

#### [v0.6.1](https://github.com/SofaPirate/Plaquette/compare/v0.6.0...v0.6.1)

> 14 January 2025

- Removed PqServo.h from defaults (PqExtra.h) to avoid problems when library Servo is not included. [`770a064`](https://github.com/SofaPirate/Plaquette/commit/770a064468c1bea9e83312c5d8af31838ac8f7b8)
- Include PqServo stuff only of Servo.h exists. [`1e79515`](https://github.com/SofaPirate/Plaquette/commit/1e7951541629920218715d7f6e5e8973dbd7d620)
- Moved warning in AnalogIn reference. [`6ad2f24`](https://github.com/SofaPirate/Plaquette/commit/6ad2f24b40479fb7d3d53150c67f574f7a842a51)

#### [v0.6.0](https://github.com/SofaPirate/Plaquette/compare/v0.5.0...v0.6.0)

> 7 January 2025

- Added support for event-based triggers (closes #79). [`#79`](https://github.com/SofaPirate/Plaquette/issues/79)
- Add options to control playback of Waves (closes #87). [`#87`](https://github.com/SofaPirate/Plaquette/issues/87)
- Fixed problem with PEAK_MIN detection (closes #80). [`#80`](https://github.com/SofaPirate/Plaquette/issues/80)
- - Merge class Unit and Node (closes #106) [`#106`](https://github.com/SofaPirate/Plaquette/issues/106) [`#92`](https://github.com/SofaPirate/Plaquette/issues/92)
- Adjusted API of Chronometer (closes #92). [`#92`](https://github.com/SofaPirate/Plaquette/issues/92)
- Removed Timer in favor of Alarm and Ramp (closes #98). [`#98`](https://github.com/SofaPirate/Plaquette/issues/98)
- Add width() to SineOsc (closes #119). [`#119`](https://github.com/SofaPirate/Plaquette/issues/119)
- Deprecate dutyCycle() in favor of width() for SquareOsc (closes #111). [`#111`](https://github.com/SofaPirate/Plaquette/issues/111)
- Renamed *Osc types to *Wave (closes #120) and renamed TriOsc to TriWave (closes #121). [`#120`](https://github.com/SofaPirate/Plaquette/issues/120) [`#121`](https://github.com/SofaPirate/Plaquette/issues/121)
- Deprecated start() in favor of go() in ramps and added a speed mode (closes #112). [`#112`](https://github.com/SofaPirate/Plaquette/issues/112)
- Fixed issue with zero or more-than-once per step calls to put() for Normalizer and MinMaxScaler (untested) (rel to #115 and closes #116). [`#116`](https://github.com/SofaPirate/Plaquette/issues/116)
- Added CHANGELOG.md generated using auto-changelog. [`7e9721c`](https://github.com/SofaPirate/Plaquette/commit/7e9721c69c61e71fb3e351f10f2cf8a79c75f66d)
- Added a Chronometer class to keep track of time. [`b90c5d9`](https://github.com/SofaPirate/Plaquette/commit/b90c5d9868f21e7be8100708fcadef76350e6106)
- Majour rewrite of Getting Started section. [`881b73e`](https://github.com/SofaPirate/Plaquette/commit/881b73e404990e8e274acd95d92fe9b9327c3a62)

#### [v0.5.0](https://github.com/SofaPirate/Plaquette/compare/v0.4.5...v0.5.0)

> 19 March 2024

- Added file ArrayList.h from the ArrayList Arduino library. [`fdf96f1`](https://github.com/SofaPirate/Plaquette/commit/fdf96f1e6aa7c1bfc0a63b629eca0dea1e5b1259)
- Refactoring and integration of digital fixtures. [`4305c14`](https://github.com/SofaPirate/Plaquette/commit/4305c148b4db69fdc2313e0039f72e5947c4538e)
- Introducing HybridArrayList class to manage static/dynamic arrays. [`6fe6ebe`](https://github.com/SofaPirate/Plaquette/commit/6fe6ebe21146c38bd588025ad00164a038076db5)

#### [v0.4.5](https://github.com/SofaPirate/Plaquette/compare/v0.4.4...v0.4.5)

> 5 February 2023

- Added a WRAP option to map*() functions. [`457bc99`](https://github.com/SofaPirate/Plaquette/commit/457bc992649257f92a064eca2a5c112d8a255a1d)
- Rewrite conversions in map*() in a more modular way. [`5d94e93`](https://github.com/SofaPirate/Plaquette/commit/5d94e935d87307dcb02f9c9ef8f56206a603af3a)
- Use double instead of float for wrap functions & changed wrap for wrap01. [`9767ccc`](https://github.com/SofaPirate/Plaquette/commit/9767ccc32fa84570e6fd310be3ee663beadcfa3f)

#### [v0.4.4](https://github.com/SofaPirate/Plaquette/compare/v0.4.3...v0.4.4)

> 24 January 2023

- Changed type of functions returning Node& to void for Osc and Metro adjustments (closes #68). [`#68`](https://github.com/SofaPirate/Plaquette/issues/68)
- Renamed pq::Chrono to Chronometer to avoid confusion (closes #69). [`#69`](https://github.com/SofaPirate/Plaquette/issues/69)
- Run compile and test actions only upon source code changes enhancement (closes #66). [`#66`](https://github.com/SofaPirate/Plaquette/issues/66)
- Rewrote and fixed issues with wrap() functions. [`e282c13`](https://github.com/SofaPirate/Plaquette/commit/e282c131005fef1a5a65228bd5e62a5e2ad96e81)
- More fixes to spell check. [`70c8b78`](https://github.com/SofaPirate/Plaquette/commit/70c8b78450110f382063435b7d4a780e6f6a257a)
- Added unit tests for functions and added test for wrap() methods. [`cbc502c`](https://github.com/SofaPirate/Plaquette/commit/cbc502cbcba610674e0824f95e1d727a666807e0)

#### [v0.4.3](https://github.com/SofaPirate/Plaquette/compare/v0.4.2...v0.4.3)

> 8 January 2023

- Allow changing mode after construction (closes #60). [`#60`](https://github.com/SofaPirate/Plaquette/issues/60)
- Renamed DIGITAL_INPUT_PULLUP for DIGITAL_PULLUP and made it non-default (closes #49). [`#49`](https://github.com/SofaPirate/Plaquette/issues/49)
- Changed default pullup settings of DigitalIn which was confusing when not using a pushbutton (closes #49). [`#49`](https://github.com/SofaPirate/Plaquette/issues/49)
- Removed Thresholder (replaced by PeakDetector). [`2bd0392`](https://github.com/SofaPirate/Plaquette/commit/2bd03922618077fa3a6232b934788d6f977c3235)
- Typos and translation refinement [`61dea7a`](https://github.com/SofaPirate/Plaquette/commit/61dea7a6baf6bea28de8c01d21ac9c6eb686360a)
- Added different GitHub workflow actions. [`0f4ae66`](https://github.com/SofaPirate/Plaquette/commit/0f4ae6657360b5f7c2f01a9648b2614f764d881c)

#### [v0.4.2](https://github.com/SofaPirate/Plaquette/compare/v0.4.1...v0.4.2)

> 27 November 2022

- Integrated some easing functions and corresponding fastmath functions (untested). [`5474335`](https://github.com/SofaPirate/Plaquette/commit/547433576b8b903ededae2c6505b0706f425fdd9)
- Cosmetic change to follow coding standards. [`983f6af`](https://github.com/SofaPirate/Plaquette/commit/983f6af46451ac0de2e03ab5a2bb8e35a5f760b5)
- Removed the lerp() function which is a duplicate of mapFrom01(). [`fe0ed70`](https://github.com/SofaPirate/Plaquette/commit/fe0ed709471281ef8c9a699b5d428155bac59ca9)

#### [v0.4.1](https://github.com/SofaPirate/Plaquette/compare/v0.4.0...v0.4.1)

> 4 November 2022

- Added clamping of values to Normalizer. [`1648ffd`](https://github.com/SofaPirate/Plaquette/commit/1648ffd4526aa53bda890f659a86134d13bae408)
- Renamed stddev to stdDev. [`d12bc27`](https://github.com/SofaPirate/Plaquette/commit/d12bc27308e20d89230bffbc170a2da9376d83a9)
- Moved variables in MovingAverage.h to the bottom of the class. [`268dc09`](https://github.com/SofaPirate/Plaquette/commit/268dc0951aaac4a6fa4e026b41d5109a985884eb)

#### [v0.4.0](https://github.com/SofaPirate/Plaquette/compare/v0.3...v0.4.0)

> 29 October 2022

- Use integer instead of float for phaseTime computations (closes #57). [`#57`](https://github.com/SofaPirate/Plaquette/issues/57)
- Integrated a new Alarm class and made Alarm, TImer and Ramp all subclasses of Node or DigitalNode (closes #53). [`#53`](https://github.com/SofaPirate/Plaquette/issues/53)
- Derive all oscillation-based units from Osc class. [`60ed317`](https://github.com/SofaPirate/Plaquette/commit/60ed317f986b3c6f068df9cd090cba4c456f9388)
- Added license file. [`4cb5c0c`](https://github.com/SofaPirate/Plaquette/commit/4cb5c0c8b42a0efe00a3f9992a59470861b6a1f1)
- New PeakDetector class. [`a8d6919`](https://github.com/SofaPirate/Plaquette/commit/a8d69197fb6a11a2a2458ac66768d43bb6844f13)

#### [v0.3](https://github.com/SofaPirate/Plaquette/compare/v0.2.6...v0.3)

> 6 September 2022

- ave all filters share a common superclass for time window management (closes #56). [`#56`](https://github.com/SofaPirate/Plaquette/issues/56)
- Change time() for timeWindow() (closes #40). [`#40`](https://github.com/SofaPirate/Plaquette/issues/40)
- Simplified the class hierarchy. [`bc678f1`](https://github.com/SofaPirate/Plaquette/commit/bc678f165824039092ed2dde7fb252b285cb0516)
- Moved and expanded Plaquette features into new section. [`b88dbf1`](https://github.com/SofaPirate/Plaquette/commit/b88dbf1b4792b4c7566157b6cff2605e21d5a5f1)
- Removed Stats and SimpleStats. [`0acc9b0`](https://github.com/SofaPirate/Plaquette/commit/0acc9b05a454bcef50c168ec86fb88a14cb84734)

#### [v0.2.6](https://github.com/SofaPirate/Plaquette/compare/v0.2.5...v0.2.6)

> 19 July 2021

- Fixed small type issue that caused compilation errors on Wemos boards. [`c3592a1`](https://github.com/SofaPirate/Plaquette/commit/c3592a13d7a6f932094bc71643303e2e0cf5a63c)
- Set base duty cycle of blink to 10% [`888feba`](https://github.com/SofaPirate/Plaquette/commit/888feba3bdf55ea423f06e43356259fb1fbb0c70)
- Changed version to 0.2.6 instead (cause 0.2.5.1 is not supported). [`bf7cf5a`](https://github.com/SofaPirate/Plaquette/commit/bf7cf5ab7a1e201b019fc33477843a1250ab55ef)

#### [v0.2.5](https://github.com/SofaPirate/Plaquette/compare/v0.2.4...v0.2.5)

> 25 November 2019

- Added function beginSerial() which allows one to restart serial with different baudrate. [`e6fef81`](https://github.com/SofaPirate/Plaquette/commit/e6fef81cef611e2aa8925185409d9a72dfe89363)
- Fixed problem introduced by latest changes to make things compatible with Teensy -- which broke compatibility with other boards. [`c7ed0d9`](https://github.com/SofaPirate/Plaquette/commit/c7ed0d9927ccd09aef2a67a21dc13d4ba93ad6ee)
- New version: 0.2.5. [`e7eb96a`](https://github.com/SofaPirate/Plaquette/commit/e7eb96a23bedc5c08af6f9fd2c41ecf4cefde7d4)

#### [v0.2.4](https://github.com/SofaPirate/Plaquette/compare/v0.2.3...v0.2.4)

> 25 November 2019

- Fixed problem appearing on Teensy by adding PlaquetteEnv singleton function (closes #47). [`#47`](https://github.com/SofaPirate/Plaquette/issues/47)
- Commented PqServo.h appropriately. [`6c0d452`](https://github.com/SofaPirate/Plaquette/commit/6c0d452683c3a5d6a3231ddc4ac1243df7e2d6e8)
- Used LED_BUILTIN in all examples involving builtin LED. [`08ab0f8`](https://github.com/SofaPirate/Plaquette/commit/08ab0f8fbb5f2ba8d950fd87cef18ba50ebb8021)
- New version 0.2.4. [`6db3ff4`](https://github.com/SofaPirate/Plaquette/commit/6db3ff4aea360bdf6202381fae23b217e3039ede)

#### [v0.2.3](https://github.com/SofaPirate/Plaquette/compare/v0.2.2...v0.2.3)

> 18 November 2019

- Re-define operator float() for PqAnalogUnit (closes #46). [`#46`](https://github.com/SofaPirate/Plaquette/issues/46)
- Revert "Experimental feature: array support (#45)." [`658da3e`](https://github.com/SofaPirate/Plaquette/commit/658da3ea8fead4e527dd48fd62b5bb0773e45ed0)
- Experimental feature: array support (#45). [`a63314a`](https://github.com/SofaPirate/Plaquette/commit/a63314a65250a3e9af246a82f845d1a1d78e4f3a)
- Removed BlinkOsc folder. [`d73f3ac`](https://github.com/SofaPirate/Plaquette/commit/d73f3acf13c75092535d7e18c7a5fc776f8f2c7f)

#### [v0.2.2](https://github.com/SofaPirate/Plaquette/compare/v0.2.1...v0.2.2)

> 11 November 2019

- Make appropriate use of samplePeriod() in oscillators to compute next value (fixes #41). [`#41`](https://github.com/SofaPirate/Plaquette/issues/41)
- Re-factored / reorganized the examples and added many (untested). [`7545a1e`](https://github.com/SofaPirate/Plaquette/commit/7545a1e665a3c939e4cd182ad5a41921f242ea94)
- - Many cleanups. [`f0875e0`](https://github.com/SofaPirate/Plaquette/commit/f0875e0b5cacd9932555a83ffb3c021c50a5fb7b)
- Added samplePeriod() function. [`0c9bc72`](https://github.com/SofaPirate/Plaquette/commit/0c9bc726a33ed8d7000a2c5f91044b602bc497ba)

#### [v0.2.1](https://github.com/SofaPirate/Plaquette/compare/v0.2...v0.2.1)

> 5 November 2019

- Turned Plaquette into a singleton (closes #25). [`#25`](https://github.com/SofaPirate/Plaquette/issues/25)
- Add access functions to oscillators (closes #21). [`#21`](https://github.com/SofaPirate/Plaquette/issues/21)
- Added namespace "pq" to be used in PlaquetteLib (closes #26). [`#26`](https://github.com/SofaPirate/Plaquette/issues/26)
- Added falling() and rising() to all DigitalIn objects (closes #6) (untested). [`#6`](https://github.com/SofaPirate/Plaquette/issues/6)
- Reviewed names to specify time windows (smoothings) (closes #24). [`#24`](https://github.com/SofaPirate/Plaquette/issues/24)
- Allow specification of smoothing / averaging factor in terms of seconds rather than "alpha" (closes #15). [`#15`](https://github.com/SofaPirate/Plaquette/issues/15)
- Reimplemented phase-correct code for TriOsc / SineOsc + Support for amplitude and phase (closes #20). [`#20`](https://github.com/SofaPirate/Plaquette/issues/20)
- Fix: use common time reference in step() (closes #19). [`#19`](https://github.com/SofaPirate/Plaquette/issues/19)
- Merged everything with latest version. [`43d05bc`](https://github.com/SofaPirate/Plaquette/commit/43d05bcd081c6e770a9b4d7a5089002a25ea68f7)
- Removed old PqExtra.* files that had been reintroduced by error. [`e576357`](https://github.com/SofaPirate/Plaquette/commit/e5763572b053d759c4313d640f9fb26329750958)
- Integrated timing generators. [`42d068c`](https://github.com/SofaPirate/Plaquette/commit/42d068c6eafc438da6224a4eb50016e5e6fbe49b)

#### [v0.2](https://github.com/SofaPirate/Plaquette/compare/v0.1.7...v0.2)

> 27 January 2019

- Ramp [`3641b56`](https://github.com/SofaPirate/Plaquette/commit/3641b56c89b22606b495ede8e0793deeaba50c2f)
- Thresholder [`a8fc2fa`](https://github.com/SofaPirate/Plaquette/commit/a8fc2fa545f9e045282e4bd320e0aa9287ad6632)
- TriOsc [`b3eb09f`](https://github.com/SofaPirate/Plaquette/commit/b3eb09f51d626dcf530e19ec5f3c86cdbbdf42c7)

#### [v0.1.7](https://github.com/SofaPirate/Plaquette/compare/v0.1.6...v0.1.7)

> 5 May 2018

- Forbid assignations using operator= (closes #17). [`#17`](https://github.com/SofaPirate/Plaquette/issues/17)
- Added descriptions of the dot & pipe operators. [`2aec0bf`](https://github.com/SofaPirate/Plaquette/commit/2aec0bf0800821052da14b76000fcce8ca0092c5)
- Fix compatibility issues with ESP8266. [`0369a6d`](https://github.com/SofaPirate/Plaquette/commit/0369a6d8d79882bcfac51acad99ce79eb963cb34)
- New version: 0.1.7 [`fcc7e25`](https://github.com/SofaPirate/Plaquette/commit/fcc7e258693bc29d0f29cb2defe358bbe9ff072b)

#### [v0.1.6](https://github.com/SofaPirate/Plaquette/compare/v0.1.5...v0.1.6)

> 23 February 2018

- Added lerp() function. [`ef061db`](https://github.com/SofaPirate/Plaquette/commit/ef061db0cfeef0d3c1322b4821d1b0ae71827b2e)
- Added missing keywords. [`7a0a73b`](https://github.com/SofaPirate/Plaquette/commit/7a0a73b37b6506eebc2fdde706235d08fe8333b2)
- Fix in stats classes: get() function is non-const. [`6b93bef`](https://github.com/SofaPirate/Plaquette/commit/6b93befc110b6d41bcaf6d3f5bb0714e30539a2d)

#### [v0.1.5](https://github.com/SofaPirate/Plaquette/compare/v0.1.4...v0.1.5)

> 12 February 2018

- Added new class Tween (linear easing). Tested. [`ce8e9d2`](https://github.com/SofaPirate/Plaquette/commit/ce8e9d20c5d0cadd7c02cc52e7fc2f311ac8cab3)
- Replaced NotesAndWarning with Sphinx-styled notes and warnings. [`89660f6`](https://github.com/SofaPirate/Plaquette/commit/89660f6775f4d0aca8f11379c6eaac1a112436f6)
- Fixed base files (ready for 0.1.5). [`1d8aa64`](https://github.com/SofaPirate/Plaquette/commit/1d8aa646e8f275fe9b93da3f5295fe9da4b13cf5)

#### [v0.1.4](https://github.com/SofaPirate/Plaquette/compare/v0.1.3...v0.1.4)

> 6 February 2018

- Renamed map & random related (kept mapTo/From01 for now until decision is made) (related to #10). [`e741abb`](https://github.com/SofaPirate/Plaquette/commit/e741abbbd3d4e5b3812abe61da068432e314dc5b)
- Made update() functions of oscillators more efficient. [`9a6c63f`](https://github.com/SofaPirate/Plaquette/commit/9a6c63f49a4e5039467c96a2e7280da31cb8f0f7)
- Cleanup. [`086c235`](https://github.com/SofaPirate/Plaquette/commit/086c235ffbc7ce3a6f98c7f73c3528c1ed7ccccf)

#### [v0.1.3](https://github.com/SofaPirate/Plaquette/compare/v0.1.2...v0.1.3)

> 4 February 2018

- Added doxygen-style comments in mapFloat methods. [`6396540`](https://github.com/SofaPirate/Plaquette/commit/63965409252ebd414ecb8d9a0ad0e3c92824004b)
- Clarifications in random functions. [`fd07719`](https://github.com/SofaPirate/Plaquette/commit/fd07719eae253ec587bae26843f461277bf37c01)
- Update keywords. [`69caf12`](https://github.com/SofaPirate/Plaquette/commit/69caf12c436d9f7ab3336b611fb7bca073227da5)

#### [v0.1.2](https://github.com/SofaPirate/Plaquette/compare/v0.1.1...v0.1.2)

> 4 February 2018

- Fixed comments in core classes to make it doxygen-correct. [`1077552`](https://github.com/SofaPirate/Plaquette/commit/10775527f8dab066427ea61145038f91d94ecc0d)
- Removed precision param from StreamOut constructor. [`486cdf4`](https://github.com/SofaPirate/Plaquette/commit/486cdf47472508e688c629c44f4a8baa4f9396ec)
- Cosmetic fix. [`61a1225`](https://github.com/SofaPirate/Plaquette/commit/61a12255a22f42193430ddb8d47deeb783d70e4e)

#### [v0.1.1](https://github.com/SofaPirate/Plaquette/compare/v0.1...v0.1.1)

> 1 February 2018

- Fixed bug in oscillator classes: changing period in real-time messed with phase. [`365c704`](https://github.com/SofaPirate/Plaquette/commit/365c70443f6e9374c3d57b9483dd8cd623f77e19)
- Ignore site-related elements. [`a2747f6`](https://github.com/SofaPirate/Plaquette/commit/a2747f654f26b22a7da1637d9f4139dd9f2f0398)
- Fixed some repetitive code. [`84384d0`](https://github.com/SofaPirate/Plaquette/commit/84384d05eee37c39d4afddeafb98c231df747ae3)

#### v0.1

> 12 January 2018

- Use correct separator in keywords.txt [`#1`](https://github.com/SofaPirate/Plaquette/pull/1)
- Initial commit [`df8ed40`](https://github.com/SofaPirate/Plaquette/commit/df8ed403950753bfa3f99b4cff5816ad945e31db)
- Fixes in implicit cast operators and shift operators to prevent compilation errors. [`86bcb23`](https://github.com/SofaPirate/Plaquette/commit/86bcb234924ca2941444f181aaf040003e20e5cf)
- Created two new types of normalizer: "simple" and "min-max". [`e098c21`](https://github.com/SofaPirate/Plaquette/commit/e098c21c7fc6c60e6c231f3ac041e0a26de04cb2)
