# Plaquette Code of Conduct

Plaquette is an open-source software library that brings together artists, makers, researchers, and
developers interested in creative computation. This Code of Conduct outlines the standards we expect from
everyone who interacts with the Plaquette project (through its code, documentation, or discussions) to
help us build a respectful and inclusive environment as the community grows.

This document is adapted from the [Contributor Covenant v3.0](https://www.contributor-covenant.org/version/3/0/code_of_conduct.html)
and expresses how we want to collaborate around the Plaquette project.

---

## Our Standards

We strive to create an environment where everyone feels welcome and supported, regardless of age, gender
identity or expression, sexual orientation, disability, neurodivergence, physical appearance, body size,
ethnicity, nationality, religion (or lack thereof), or social status and background.

Examples of positive behavior include:
- Being respectful and considerate in both technical and creative discussions.
- Welcoming new ideas, experiments, and perspectives.
- Offering constructive feedback instead of personal criticism.
- Acknowledging and valuing the work of others.

Unacceptable behavior includes:
- Harassment, discrimination, or exclusionary jokes.
- Intimidation or sustained disruption of community spaces.
- Dismissive or hostile comments about others’ identities, skills, or work.
- Sharing others’ private information without consent.

---

## Our Responsibilities

Project maintainers are responsible for clarifying and enforcing this Code of Conduct.
They may take any appropriate action to maintain a safe, respectful environment, including moderating
comments, closing discussions, or restricting participation.

---

## Scope

This Code of Conduct applies across all Plaquette spaces:
- The [GitHub repository](https://github.com/SofaPirate/Plaquette) (issues, pull requests, discussions,
  and comments)
- Any related online or in-person events organized under the Plaquette name

---

## Reporting

If you experience or witness behavior that violates this Code, please let the maintainers know through
GitHub by contacting them directly.

All reports will be reviewed promptly and handled with care and confidentiality.
