### Changelog

All notable changes to this project will be documented in this file. Dates are displayed in UTC.

Generated by [`auto-changelog`](https://github.com/CookPete/auto-changelog).

#### [v0.6.0](https://github.com/SofaPirate/Plaquette/compare/v0.5.0...v0.6.0)

- Added support for event-based triggers (closes #79). [`#79`](https://github.com/SofaPirate/Plaquette/issues/79)
- Add options to control playback of Waves (closes #87). [`#87`](https://github.com/SofaPirate/Plaquette/issues/87)
- Fixed problem with PEAK_MIN detection (closes #80). [`#80`](https://github.com/SofaPirate/Plaquette/issues/80)
- Merge class Unit and Node (closes #106) [`#106`](https://github.com/SofaPirate/Plaquette/issues/106) [`#92`](https://github.com/SofaPirate/Plaquette/issues/92)
- Adjusted API of Chronometer (closes #92). [`#92`](https://github.com/SofaPirate/Plaquette/issues/92)
- Removed Timer in favor of Alarm and Ramp (closes #98). [`#98`](https://github.com/SofaPirate/Plaquette/issues/98)
- Add width() to SineOsc (closes #119). [`#119`](https://github.com/SofaPirate/Plaquette/issues/119)
- Deprecate dutyCycle() in favor of width() for SquareOsc (closes #111). [`#111`](https://github.com/SofaPirate/Plaquette/issues/111)
- Renamed *Osc types to *Wave (closes #120) and renamed TriOsc to TriWave (closes #121). [`#120`](https://github.com/SofaPirate/Plaquette/issues/120) [`#121`](https://github.com/SofaPirate/Plaquette/issues/121)
- Deprecated start() in favor of go() in ramps and added a speed mode (closes #112). [`#112`](https://github.com/SofaPirate/Plaquette/issues/112)
- Fixed issue with zero or more-than-once per step calls to put() for Normalizer and MinMaxScaler (untested) (rel to #115 and closes #116). [`#116`](https://github.com/SofaPirate/Plaquette/issues/116)
- Improved documentation for shiftBy() (closes #108). [`#108`](https://github.com/SofaPirate/Plaquette/issues/108)
- Added a Chronometer class to keep track of time. [`b90c5d9`](https://github.com/SofaPirate/Plaquette/commit/b90c5d9868f21e7be8100708fcadef76350e6106)
- Majour rewrite of Getting Started section. [`881b73e`](https://github.com/SofaPirate/Plaquette/commit/881b73e404990e8e274acd95d92fe9b9327c3a62)
- Created new examples for Ramp. [`22bf625`](https://github.com/SofaPirate/Plaquette/commit/22bf6257ffaa104f460affe215a1b72137d19f62)

#### [v0.5.0](https://github.com/SofaPirate/Plaquette/compare/v0.4.5...v0.5.0)

> 19 March 2024

- Added file ArrayList.h from the ArrayList Arduino library. [`fdf96f1`](https://github.com/SofaPirate/Plaquette/commit/fdf96f1e6aa7c1bfc0a63b629eca0dea1e5b1259)
- Refactoring and integration of digital fixtures. [`4305c14`](https://github.com/SofaPirate/Plaquette/commit/4305c148b4db69fdc2313e0039f72e5947c4538e)
- Introducing HybridArrayList class to manage static/dynamic arrays. [`6fe6ebe`](https://github.com/SofaPirate/Plaquette/commit/6fe6ebe21146c38bd588025ad00164a038076db5)

#### [v0.4.5](https://github.com/SofaPirate/Plaquette/compare/v0.4.4...v0.4.5)

> 5 February 2023

- Added documentation for wrap functions. [`ae77f6e`](https://github.com/SofaPirate/Plaquette/commit/ae77f6e5c95717dcf962256f7af6693fe3fbe78f)
- Added a WRAP option to map*() functions. [`457bc99`](https://github.com/SofaPirate/Plaquette/commit/457bc992649257f92a064eca2a5c112d8a255a1d)
- Rewrite conversions in map*() in a more modular way. [`5d94e93`](https://github.com/SofaPirate/Plaquette/commit/5d94e935d87307dcb02f9c9ef8f56206a603af3a)

#### [v0.4.4](https://github.com/SofaPirate/Plaquette/compare/v0.4.3...v0.4.4)

> 24 January 2023

- Changed type of functions returning Node& to void for Osc and Metro adjustments (closes #68). [`#68`](https://github.com/SofaPirate/Plaquette/issues/68)
- Renamed pq::Chrono to Chronometer to avoid confusion (closes #69). [`#69`](https://github.com/SofaPirate/Plaquette/issues/69)
- Run compile and test actions only upon source code changes enhancement (closes #66). [`#66`](https://github.com/SofaPirate/Plaquette/issues/66)
- Rewrote and fixed issues with wrap() functions. [`e282c13`](https://github.com/SofaPirate/Plaquette/commit/e282c131005fef1a5a65228bd5e62a5e2ad96e81)
- More fixes to spell check. [`70c8b78`](https://github.com/SofaPirate/Plaquette/commit/70c8b78450110f382063435b7d4a780e6f6a257a)
- Added unit tests for functions and added test for wrap() methods. [`cbc502c`](https://github.com/SofaPirate/Plaquette/commit/cbc502cbcba610674e0824f95e1d727a666807e0)

#### [v0.4.3](https://github.com/SofaPirate/Plaquette/compare/v0.4.2...v0.4.3)

> 8 January 2023

- Bump certifi from 2022.6.15 to 2022.12.7 in /docs [`#59`](https://github.com/SofaPirate/Plaquette/pull/59)
- Allow changing mode after construction (closes #60). [`#60`](https://github.com/SofaPirate/Plaquette/issues/60)
- Renamed DIGITAL_INPUT_PULLUP for DIGITAL_PULLUP and made it non-default (closes #49). [`#49`](https://github.com/SofaPirate/Plaquette/issues/49)
- Changed default pullup settings of DigitalIn which was confusing when not using a pushbutton (closes #49). [`#49`](https://github.com/SofaPirate/Plaquette/issues/49)
- Removed Thresholder (replaced by PeakDetector). [`2bd0392`](https://github.com/SofaPirate/Plaquette/commit/2bd03922618077fa3a6232b934788d6f977c3235)
- Typos and translation refinement [`61dea7a`](https://github.com/SofaPirate/Plaquette/commit/61dea7a6baf6bea28de8c01d21ac9c6eb686360a)
- Added different GitHub workflow actions. [`0f4ae66`](https://github.com/SofaPirate/Plaquette/commit/0f4ae6657360b5f7c2f01a9648b2614f764d881c)

#### [v0.4.2](https://github.com/SofaPirate/Plaquette/compare/v0.4.1...v0.4.2)

> 27 November 2022

- Integrated some easing functions and corresponding fastmath functions (untested). [`5474335`](https://github.com/SofaPirate/Plaquette/commit/547433576b8b903ededae2c6505b0706f425fdd9)
- Cosmetic change to follow coding standards. [`983f6af`](https://github.com/SofaPirate/Plaquette/commit/983f6af46451ac0de2e03ab5a2bb8e35a5f760b5)
- Removed the lerp() function which is a duplicate of mapFrom01(). [`fe0ed70`](https://github.com/SofaPirate/Plaquette/commit/fe0ed709471281ef8c9a699b5d428155bac59ca9)

#### [v0.4.1](https://github.com/SofaPirate/Plaquette/compare/v0.4.0...v0.4.1)

> 4 November 2022

- Added clamping of values to Normalizer. [`1648ffd`](https://github.com/SofaPirate/Plaquette/commit/1648ffd4526aa53bda890f659a86134d13bae408)
- Improved the documentation wrt PeakDetector. [`fcbd1d1`](https://github.com/SofaPirate/Plaquette/commit/fcbd1d14fee483d1cd8ff9d77621d014806c0538)
- Updated documentation wrt latest changes in Normalizer and PeakDetector. [`9db5da6`](https://github.com/SofaPirate/Plaquette/commit/9db5da63cd3407f243267119263aaf9a32b99ff9)

#### [v0.4.0](https://github.com/SofaPirate/Plaquette/compare/v0.3...v0.4.0)

> 29 October 2022

- Use integer instead of float for phaseTime computations (closes #57). [`#57`](https://github.com/SofaPirate/Plaquette/issues/57)
- Integrated a new Alarm class and made Alarm, TImer and Ramp all subclasses of Node or DigitalNode (closes #53). [`#53`](https://github.com/SofaPirate/Plaquette/issues/53)
- Derive all oscillation-based units from Osc class. [`60ed317`](https://github.com/SofaPirate/Plaquette/commit/60ed317f986b3c6f068df9cd090cba4c456f9388)
- Added license file. [`4cb5c0c`](https://github.com/SofaPirate/Plaquette/commit/4cb5c0c8b42a0efe00a3f9992a59470861b6a1f1)
- Updated documentation of PeakDetector with new image. [`e3089f9`](https://github.com/SofaPirate/Plaquette/commit/e3089f9e467cae3e870f859a2f947eb3d410ba17)

#### [v0.3](https://github.com/SofaPirate/Plaquette/compare/v0.2.6...v0.3)

> 6 September 2022

- ave all filters share a common superclass for time window management (closes #56). [`#56`](https://github.com/SofaPirate/Plaquette/issues/56)
- Change time() for timeWindow() (closes #40). [`#40`](https://github.com/SofaPirate/Plaquette/issues/40)
- Added all image files of documentation. [`76c836b`](https://github.com/SofaPirate/Plaquette/commit/76c836b63cd98cf7c1581f8282f1e38928273820)
- Simplified the class hierarchy. [`bc678f1`](https://github.com/SofaPirate/Plaquette/commit/bc678f165824039092ed2dde7fb252b285cb0516)
- Reorganized documentation introduction. [`ef0e1aa`](https://github.com/SofaPirate/Plaquette/commit/ef0e1aadd93bc28d678aea7d15db4de3a38c060c)

#### [v0.2.6](https://github.com/SofaPirate/Plaquette/compare/v0.2.5...v0.2.6)

> 19 July 2021

- Fixed small type issue that caused compilation errors on Wemos boards. [`c3592a1`](https://github.com/SofaPirate/Plaquette/commit/c3592a13d7a6f932094bc71643303e2e0cf5a63c)
- Set base duty cycle of blink to 10% [`888feba`](https://github.com/SofaPirate/Plaquette/commit/888feba3bdf55ea423f06e43356259fb1fbb0c70)
- Changed version to 0.2.6 instead (cause 0.2.5.1 is not supported). [`bf7cf5a`](https://github.com/SofaPirate/Plaquette/commit/bf7cf5ab7a1e201b019fc33477843a1250ab55ef)

#### [v0.2.5](https://github.com/SofaPirate/Plaquette/compare/v0.2.4...v0.2.5)

> 25 November 2019

- Added function beginSerial() which allows one to restart serial with different baudrate. [`e6fef81`](https://github.com/SofaPirate/Plaquette/commit/e6fef81cef611e2aa8925185409d9a72dfe89363)
- Fixed problem introduced by latest changes to make things compatible with Teensy -- which broke compatibility with other boards. [`c7ed0d9`](https://github.com/SofaPirate/Plaquette/commit/c7ed0d9927ccd09aef2a67a21dc13d4ba93ad6ee)
- New version: 0.2.5. [`e7eb96a`](https://github.com/SofaPirate/Plaquette/commit/e7eb96a23bedc5c08af6f9fd2c41ecf4cefde7d4)

#### [v0.2.4](https://github.com/SofaPirate/Plaquette/compare/v0.2.3...v0.2.4)

> 25 November 2019

- Fixed problem appearing on Teensy by adding PlaquetteEnv singleton function (closes #47). [`#47`](https://github.com/SofaPirate/Plaquette/issues/47)
- Integrated both servo and continuous servo motors in doc. [`10c91a3`](https://github.com/SofaPirate/Plaquette/commit/10c91a357e6ff46aca0fe151979e0bedc878b8c3)
- Commented PqServo.h appropriately. [`6c0d452`](https://github.com/SofaPirate/Plaquette/commit/6c0d452683c3a5d6a3231ddc4ac1243df7e2d6e8)
- Used LED_BUILTIN in all examples involving builtin LED. [`08ab0f8`](https://github.com/SofaPirate/Plaquette/commit/08ab0f8fbb5f2ba8d950fd87cef18ba50ebb8021)

#### [v0.2.3](https://github.com/SofaPirate/Plaquette/compare/v0.2.2...v0.2.3)

> 18 November 2019

- Re-define operator float() for PqAnalogUnit (closes #46). [`#46`](https://github.com/SofaPirate/Plaquette/issues/46)
- Added ServoOut to the doc. [`4257f4e`](https://github.com/SofaPirate/Plaquette/commit/4257f4e0bc5ea6ecd67123aaa66d15f3869476d7)
- Added #include &lt;Plaquette.h&gt; to examples in the doc. [`2b6126f`](https://github.com/SofaPirate/Plaquette/commit/2b6126f391e82615390fb73e2197dee4f8b45ca2)
- Revert "Experimental feature: array support (#45)." [`658da3e`](https://github.com/SofaPirate/Plaquette/commit/658da3ea8fead4e527dd48fd62b5bb0773e45ed0)

#### [v0.2.2](https://github.com/SofaPirate/Plaquette/compare/v0.2.1...v0.2.2)

> 11 November 2019

- Make appropriate use of samplePeriod() in oscillators to compute next value (fixes #41). [`#41`](https://github.com/SofaPirate/Plaquette/issues/41)
- Re-factored / reorganized the examples and added many (untested). [`7545a1e`](https://github.com/SofaPirate/Plaquette/commit/7545a1e665a3c939e4cd182ad5a41921f242ea94)
- - Many cleanups. [`f0875e0`](https://github.com/SofaPirate/Plaquette/commit/f0875e0b5cacd9932555a83ffb3c021c50a5fb7b)
- Added descriptions to all examples in documentation. [`d200df2`](https://github.com/SofaPirate/Plaquette/commit/d200df267f1f07b23c62d6fee47a088964b92573)

#### [v0.2.1](https://github.com/SofaPirate/Plaquette/compare/v0.2...v0.2.1)

> 5 November 2019

- Turned Plaquette into a singleton (closes #25). [`#25`](https://github.com/SofaPirate/Plaquette/issues/25)
- Add access functions to oscillators (closes #21). [`#21`](https://github.com/SofaPirate/Plaquette/issues/21)
- Added namespace "pq" to be used in PlaquetteLib (closes #26). [`#26`](https://github.com/SofaPirate/Plaquette/issues/26)
- Added falling() and rising() to all DigitalIn objects (closes #6) (untested). [`#6`](https://github.com/SofaPirate/Plaquette/issues/6)
- Reviewed names to specify time windows (smoothings) (closes #24). [`#24`](https://github.com/SofaPirate/Plaquette/issues/24)
- Allow specification of smoothing / averaging factor in terms of seconds rather than "alpha" (closes #15). [`#15`](https://github.com/SofaPirate/Plaquette/issues/15)
- Reimplemented phase-correct code for TriOsc / SineOsc + Support for amplitude and phase (closes #20). [`#20`](https://github.com/SofaPirate/Plaquette/issues/20)
- Fix: use common time reference in step() (closes #19). [`#19`](https://github.com/SofaPirate/Plaquette/issues/19)
- Merged everything with latest version. [`43d05bc`](https://github.com/SofaPirate/Plaquette/commit/43d05bcd081c6e770a9b4d7a5089002a25ea68f7)
- Removed old PqExtra.* files that had been reintroduced by error. [`e576357`](https://github.com/SofaPirate/Plaquette/commit/e5763572b053d759c4313d640f9fb26329750958)
- Integrated timing generators. [`42d068c`](https://github.com/SofaPirate/Plaquette/commit/42d068c6eafc438da6224a4eb50016e5e6fbe49b)

#### [v0.2](https://github.com/SofaPirate/Plaquette/compare/v0.1.7...v0.2)

> 27 January 2019

- Ramp [`3641b56`](https://github.com/SofaPirate/Plaquette/commit/3641b56c89b22606b495ede8e0793deeaba50c2f)
- Thresholder [`a8fc2fa`](https://github.com/SofaPirate/Plaquette/commit/a8fc2fa545f9e045282e4bd320e0aa9287ad6632)
- TriOsc [`b3eb09f`](https://github.com/SofaPirate/Plaquette/commit/b3eb09f51d626dcf530e19ec5f3c86cdbbdf42c7)

#### [v0.1.7](https://github.com/SofaPirate/Plaquette/compare/v0.1.6...v0.1.7)

> 5 May 2018

- Forbid assignations using operator= (closes #17). [`#17`](https://github.com/SofaPirate/Plaquette/issues/17)
- Updated documentation with new style [`47f7bf8`](https://github.com/SofaPirate/Plaquette/commit/47f7bf8c4f13a0435bf7cbefdd3f94ba7eec3fd7)
- Added descriptions of the dot & pipe operators. [`2aec0bf`](https://github.com/SofaPirate/Plaquette/commit/2aec0bf0800821052da14b76000fcce8ca0092c5)
- Integrated explanatory images/graphics for signals/units. [`3936095`](https://github.com/SofaPirate/Plaquette/commit/39360954eab9e678b159d398fe3b4f96fb6cd1e9)

#### [v0.1.6](https://github.com/SofaPirate/Plaquette/compare/v0.1.5...v0.1.6)

> 23 February 2018

- Updated doc. [`dda3bcb`](https://github.com/SofaPirate/Plaquette/commit/dda3bcbfa6d28b2ab896bc98c7b5cdbc592eafec)
- Added lerp() function. [`ef061db`](https://github.com/SofaPirate/Plaquette/commit/ef061db0cfeef0d3c1322b4821d1b0ae71827b2e)
- Added missing keywords. [`7a0a73b`](https://github.com/SofaPirate/Plaquette/commit/7a0a73b37b6506eebc2fdde706235d08fe8333b2)

#### [v0.1.5](https://github.com/SofaPirate/Plaquette/compare/v0.1.4...v0.1.5)

> 12 February 2018

- Reimplemented Tween as Ramp and documented everything. [`c14e34e`](https://github.com/SofaPirate/Plaquette/commit/c14e34ec3ba370ee72731f359eb9db5498c1c8de)
- Added new class Tween (linear easing). Tested. [`ce8e9d2`](https://github.com/SofaPirate/Plaquette/commit/ce8e9d20c5d0cadd7c02cc52e7fc2f311ac8cab3)
- Added documentation for ramp. [`ebad8d2`](https://github.com/SofaPirate/Plaquette/commit/ebad8d276c7e6044efe808b0010181b0f5bbf9ae)

#### [v0.1.4](https://github.com/SofaPirate/Plaquette/compare/v0.1.3...v0.1.4)

> 6 February 2018

- Renamed map & random related (kept mapTo/From01 for now until decision is made) (related to #10). [`e741abb`](https://github.com/SofaPirate/Plaquette/commit/e741abbbd3d4e5b3812abe61da068432e314dc5b)
- Made update() functions of oscillators more efficient. [`9a6c63f`](https://github.com/SofaPirate/Plaquette/commit/9a6c63f49a4e5039467c96a2e7280da31cb8f0f7)
- Cleanup. [`086c235`](https://github.com/SofaPirate/Plaquette/commit/086c235ffbc7ce3a6f98c7f73c3528c1ed7ccccf)

#### [v0.1.3](https://github.com/SofaPirate/Plaquette/compare/v0.1.2...v0.1.3)

> 4 February 2018

- Integrated changes for documentation. [`db4084a`](https://github.com/SofaPirate/Plaquette/commit/db4084a359db303e913e2469e0937718d18e21e4)
- Added doxygen-style comments in mapFloat methods. [`6396540`](https://github.com/SofaPirate/Plaquette/commit/63965409252ebd414ecb8d9a0ad0e3c92824004b)
- Clarifications in random functions. [`fd07719`](https://github.com/SofaPirate/Plaquette/commit/fd07719eae253ec587bae26843f461277bf37c01)

#### [v0.1.2](https://github.com/SofaPirate/Plaquette/compare/v0.1.1...v0.1.2)

> 4 February 2018

- Integrated core files for documentation based on Sphinx/Doxygen/Breathe. [`84c9f37`](https://github.com/SofaPirate/Plaquette/commit/84c9f37a261f05591f629fadade6d890129c1d47)
- Made multiple adjustments to documentation. [`a1056df`](https://github.com/SofaPirate/Plaquette/commit/a1056dff79f4f2a604bd5d3ba3999db0ed13168a)
- Update documentation for filters. [`f82ad67`](https://github.com/SofaPirate/Plaquette/commit/f82ad678633d0520c79ef7a8e4d1b5f9ad24196b)

#### [v0.1.1](https://github.com/SofaPirate/Plaquette/compare/v0.1...v0.1.1)

> 1 February 2018

- Fixed bug in oscillator classes: changing period in real-time messed with phase. [`365c704`](https://github.com/SofaPirate/Plaquette/commit/365c70443f6e9374c3d57b9483dd8cd623f77e19)
- Ignore site-related elements. [`a2747f6`](https://github.com/SofaPirate/Plaquette/commit/a2747f654f26b22a7da1637d9f4139dd9f2f0398)
- Fixed some repetitive code. [`84384d0`](https://github.com/SofaPirate/Plaquette/commit/84384d05eee37c39d4afddeafb98c231df747ae3)

#### v0.1

> 12 January 2018

- Use correct separator in keywords.txt [`#1`](https://github.com/SofaPirate/Plaquette/pull/1)
- First pass in refactoring code: [`799faee`](https://github.com/SofaPirate/Plaquette/commit/799faee489f155a9b8197d9eade73fb6399d4626)
- Initial commit [`df8ed40`](https://github.com/SofaPirate/Plaquette/commit/df8ed403950753bfa3f99b4cff5816ad945e31db)
- Fixes in implicit cast operators and shift operators to prevent compilation errors. [`86bcb23`](https://github.com/SofaPirate/Plaquette/commit/86bcb234924ca2941444f181aaf040003e20e5cf)
