/*!
    Inputs change detect example for Sequent Microsystems HALL Current Sensor DAQ 8-Layer Stackable HAT for Raspberry Pi
    -->https://sequentmicrosystems.com/products/hall-current-sensor-daq-stackable-hat-for-raspberry-pi
    Requirments: Any arduino card with I2C, HALL Current Sensor DAQ 8-Layer Stackable HAT from Sequent Microsystems

    Method 1:
      Connect I2C bus, 5V and GND from Arduino card to HALL Current Sensor DAQ 8-Layer Stackable HAT, pin map below
     SIGNAL  CONNECTOR    SIGNAL\n
      ---------------------------
           -- 1|O O| 2--  +5V
   I2C SDA -- 3|O O| 4--  +5V
   I2C SCL -- 5|O O| 6--  GND
           -- 7|O O| 8--
       GND -- 9|O O|10--
           --11|O O|12--
           --13|O O|14--  GND
           --15|O O|16--
           --17|O O|18--
           --19|O O|20--  GND
           --21|O O|22--
           --23|O O|24--
       GND --25|O O|26--
           --27|O O|28--
           --29|O O|30--  GND
           --31|O O|32--
           --33|O O|34--  GND
           --35|O O|36--
           --37|O O|38--
       GND --39|O O|40--

    Method 2:
    Use sequent Microsystems Uno, Nano, Teensy,Feather, ESP32 Raspberry Pi Replacement Kit with prefered arduino processor
    -->https://sequentmicrosystems.com/collections/accessories/products/raspberry-pi-replacement-card

    Method 3:
     Use Sequent Microsysstems ESP32 Pi replacement connected directly with the Sixteen LV Digital Inputs card.
     Set the board type to DOIT ESP32 DEVKIT V1: Tool >> Board >> ESP32 Arduino >> DOIT ESP32 DEVKIT V1
     -->https://sequentmicrosystems.com/collections/all-io-cards/products/esp32-pi-low-cost-replacement-for-raspberry-pi
*/
#include "SM_8CRT.h"

SM_8CRT card(0);// HALL Current Sensor DAQ HAT with stack level 0 (no jumpers installed)

void setup() {
  Serial.begin(115200);
  delay(2000);

  if (card.begin() )
  {
    Serial.print("HALL Current Sensor DAQ 8-Layer Stackable HAT for Raspberry Pi detected\n");
  }
  else
  {
    Serial.print("HALL Current Sensor DAQ 8-Layer Stackable HAT for Raspberry Pi NOT detected!\n");
  }
}


void loop() {
  static unsigned long updateMillis = 0;

  if (card.isAlive() && (millis() - updateMillis > 1000))
  {
    updateMillis = millis();
    float ret = card.readRMS(1); // read the RMS current on input 1
    Serial.printf("Channel 1 RMS current %0.2f A\n", ret);
  }
  // clap the sensor on the wire, make shure the power is off so the current is zero, then type "zero" word in the serial monitor
  if (Serial.available() > 0) {
    String command = Serial.readString();
    command.trim();
    if (command == "zero")
    {
      if (card.zero(1))
      {
        Serial.print("Offset set for channel 1\n");
      }
      else
      {
        Serial.print("Fail to set the offset for channel 1!\n");
      }
    }
  }
}
