# Sequent-8crt-Library
Arduino library for Sequent Microsystems [HALL Current Sensor DAQ 8-Layer Stackable HAT for Raspberry Pi](https://sequentmicrosystems.com/products/hall-current-sensor-daq-stackable-hat-for-raspberry-pi)


## Install
### Library manager
Go to **Tools**>>**Manage Libraries..** menu and search for *SM_8CRT* and click install 
### Manual install
To download click <>Code > [Download ZIP](https://github.com/SequentMicrosystems/Sequent-8crt-Library/archive/refs/heads/main.zip) button from the main [page](https://github.com/SequentMicrosystems/Sequent-16univin-Library), rename the uncompressed folder to "SM_16univin" 
and copy to the libraries subdirectory of your sketchbook directory ("This PC > Documents > Arduino > libraries" for a Windows PC
 or "Home > arduino > libraries" on Linux PC). Now launch the Arduino environment. If you open the Sketch > Include Library menu, you should see Sequent 16univin inside. 
 The library will be compiled with sketches that use it. Open an arduino sketch, go to File > Examples > Seqquent 16univin > and chose your example to run.

## Usage
There are three ways to control the HALL Current Sensor DAQ 8-Layer Stackable HAT from the Arduino environment.

### Method 1: Using any Arduino controller
You can use this method with any Arduino card with an I2C port by connecting I2C-SDA, I2C-SCL, +5V and GND, as shown in the following table.
      
| SIGNAL | PIN# |CONN| PIN# | SIGNAL|
|---|---|---|---|---|
| | --1 | O - O | 2-- |  +5V | 
| I2C-SDA | --3| O - O | 4-- |  +5V |
| I2C-SCL |-- 5|O - O| 6--|  GND |
|  |-- 7|O - O| 8--||
| GND |-- 9|O - O|10--||
| |--11|O - O|12--||
| |--13|O - O|14--| GND|
| |--15|O - O|16--||
||--17|O - O|18--||
||--19|O - O|20--|  GND|
||--21|O - O|22--||
||--23|O - O|24--||
|GND |--25|O - O|26--||
||--27|O - O|28--||
||--29|O - O|30--|  GND|
||--31|O - O|32--||
||--33|O - O|34--|  GND|
||--35|O - O|36--||
||--37|O - O|38--||
|GND |--39|O - O|40--||
 
### Method 2: Using the SM Arduino Raspberry Pi Replacement Kit
Sequent Microsystems [Arduino Uno, Nano, Teensy, Feather or ESP32 Raspberry Pi Replacement Kit](https://sequentmicrosystems.com/products/raspberry-pi-replacement-card) is an inexpensive adapter which can be used to control any of our HATs using Uno, Nano, Teensy, Feather or ESP32. Plug the Home Automation HAT into the 40 pin connector of the adapter and write your Arduino software.

### Method 3: Using the SM ESP32-Pi Raspberry Pi Alternative Card
ESP32-Pi is a Raspberry Pi alternate solution which can control directly the Sexteen Universal Inputs HAT.
In your sketchbook set the board type to DOIT ESP32 DEVKIT V1: Tool >> Board >> ESP32 Arduino >> DOIT ESP32 DEVKIT V1

## Functions prototypes
	
/*!
	 * @brief Class constructor.
	 */
	SM_8CRT(uint8_t stack = 0);

	/*!
	 * @brief Check card presence
	 * @return Returns true is successful
	 */
	bool begin();

	/*!
	 * @brief Return card existance status
	 * @return Returns true if card is present
	 */
	bool isAlive();
	/*!
	 * @brief Read current for one input channel.
	 * @param channel [1..8]
	 * @return momentary current in A
	 */
	float read(uint8_t channel);

	/*!
	 * @brief Read RMS current for one input channel.
	 * @param channel [1..8]
	 * @return RMS current in A
	 */
	float readRMS(uint8_t channel);
	
	
	/*!
	 * @brief Turn on or Off one led
	 * @param led The led number 1..8
	 * @param val The new state true = on, false = off
	 * @return true if succeed, false else
	 */
	bool writeLED(uint8_t led, bool val);

	/*!
	 * @brief Turn on or Off all leds
	 * @param val All 8 led's state as a bitmap
	 * @return true if succeed, false else
	 */
	bool writeLED(uint8_t val);
	
	
	/*!
	 * @brief Set the sensor current range or full scale.
	 * @param channel [1..8]
	 * @param range [2..300]
	 * @return true if success false elese
	 */
	bool writeRange(uint8_t channel, int range);
	
	/*!
	 * @brief Get the sensor current range or full scale.
	 * @param channel [1..8]
	 * @return senzor range
	 */
	int readRange(uint8_t channel);
	
		
	/*!
	 * @brief Set the RTC.
	 * @param m month
	 * @param d day
	 * @param y year
	 * @param h hour
	 * @param mi minutes
	 * @param s seconds
	 * @return true if success false elese
	 */
	bool writeRTC(int m, int d, int y, int h, int mi, int s);
	
	
	/*!
	 * @brief Get the RTC time and date.
	 * @param m month
	 * @param d day
	 * @param y year
	 * @param h hour
	 * @param mi minutes
	 * @param s seconds
	 * @return true if success false elese
	 */
	bool readRTC(int* m, int* d, int* y, int* h, int* mi, int* s);
	