#ifndef _SGP4X_H_
#define _SGP4X_H_

#include "ISensor.h"
#include "SensirionI2CSgp41.h"
#include "Sensirion_UPT_Core.h"

namespace sensirion::upt::i2c_autodetect{

class Sgp41 : public ISensor {
  public:
    explicit Sgp41(TwoWire& wire, uint16_t address);
    uint16_t start() override;
    uint16_t measureAndWrite(MeasurementList& measurements,
                             const unsigned long timeStamp) override;
    uint16_t initializationStep() override;
    DeviceType getDeviceType() const override;
    core::MetaData getMetaData() const override;
    size_t getNumberOfDataPoints() const override;
    uint8_t getI2CAddress() const override;
    unsigned long getMinimumMeasurementIntervalMs() const override;

    // Typical: 10s
    unsigned long getInitializationIntervalMs() const override;
    void* getDriver() override;

    // Typical measurement interval: 1s
    long readyStateDecayTimeMs() const override;

    bool probe() override;

  private:
    TwoWire& mWire;
    SensirionI2CSgp41 mDriver;
    uint16_t mAddress;
    core::MetaData mMetadata;
    uint16_t _defaultRh = 0x8000;
    uint16_t _defaultT = 0x6666;
};
} // namespace sensirion::upt::i2c_autodetect $

#endif /* _SGP4X_H_ */
