/*
 * Copyright (c) 2022, Sensirion AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of Sensirion AG nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef DOWNLOAD_H
#define DOWNLOAD_H

#include "ByteArray.h"
#include "Sample.h"

namespace sensirion::upt::ble_server {

static constexpr size_t DOWNLOAD_PACKET_SIZE_BYTES = 20;

class DownloadHeader : public ByteArray<DOWNLOAD_PACKET_SIZE_BYTES> {
public:
  void setDownloadSampleType(uint16_t type);

  void setIntervalMilliSeconds(uint32_t interval);

  void setAgeOfLatestSampleMilliSeconds(uint32_t age);

  void setDownloadSampleCount(uint16_t count);
};

class DownloadPacket : public ByteArray<DOWNLOAD_PACKET_SIZE_BYTES> {
public:
  void setDownloadSequenceNumber(uint16_t number);

  void writeSample(const Sample &sample, size_t sampleSize, size_t position);

  void writeSampleByte(uint8_t byte, size_t positionInSampleData);
};

enum DownloadState { INACTIVE = 0, START = 1, DOWNLOADING = 2, COMPLETED = 3 };

} // namespace sensirion::upt::ble_server

#endif /* DOWNLOAD_H */