/*
 * THIS FILE IS AUTOMATICALLY GENERATED
 *
 * Generator:     sensirion-driver-generator 1.3.4
 * Product:       sps30
 * Model-Version: 1.0.2
 */
/*
 * Copyright (c) 2025, Sensirion AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of Sensirion AG nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "SensirionUartSps30.h"
#include <Arduino.h>

// make sure that we use the proper definition of NO_ERROR
#ifdef NO_ERROR
#undef NO_ERROR
#endif
#define NO_ERROR 0

static uint8_t communication_buffer[44] = {0};

SensirionUartSps30::SensirionUartSps30() {
}

int16_t SensirionUartSps30::wakeUpSequence() {
    int16_t localError = 0;
    localError = wakeUpCommunication();
    if (localError != NO_ERROR) {
        return localError;
    }
    localError = wakeUp();
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionUartSps30::startMeasurement(
    SPS30OutputFormat measurementOutputFormat) {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 14);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 14);
    localError = txFrame.begin(0x0, SPS30_SHDLC_ADDR, 2);
    localError |= txFrame.addUInt16(measurementOutputFormat);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    return NO_ERROR;
}

int16_t SensirionUartSps30::stopMeasurement() {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 10);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 10);
    localError = txFrame.begin(0x1, SPS30_SHDLC_ADDR, 0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    return NO_ERROR;
}

int16_t SensirionUartSps30::readMeasurementValuesUint16(
    uint16_t& mc1p0, uint16_t& mc2p5, uint16_t& mc4p0, uint16_t& mc10p0,
    uint16_t& nc0p5, uint16_t& nc1p0, uint16_t& nc2p5, uint16_t& nc4p0,
    uint16_t& nc10p0, uint16_t& typicalParticleSize) {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 24);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 24);
    localError = txFrame.begin(0x3, SPS30_SHDLC_ADDR, 0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    localError |= rxFrame.getUInt16(mc1p0);
    localError |= rxFrame.getUInt16(mc2p5);
    localError |= rxFrame.getUInt16(mc4p0);
    localError |= rxFrame.getUInt16(mc10p0);
    localError |= rxFrame.getUInt16(nc0p5);
    localError |= rxFrame.getUInt16(nc1p0);
    localError |= rxFrame.getUInt16(nc2p5);
    localError |= rxFrame.getUInt16(nc4p0);
    localError |= rxFrame.getUInt16(nc10p0);
    localError |= rxFrame.getUInt16(typicalParticleSize);
    return localError;
}

int16_t SensirionUartSps30::readMeasurementValuesFloat(
    float& mc1p0, float& mc2p5, float& mc4p0, float& mc10p0, float& nc0p5,
    float& nc1p0, float& nc2p5, float& nc4p0, float& nc10p0,
    float& typicalParticleSize) {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 44);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 44);
    localError = txFrame.begin(0x3, SPS30_SHDLC_ADDR, 0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    localError |= rxFrame.getFloat(mc1p0);
    localError |= rxFrame.getFloat(mc2p5);
    localError |= rxFrame.getFloat(mc4p0);
    localError |= rxFrame.getFloat(mc10p0);
    localError |= rxFrame.getFloat(nc0p5);
    localError |= rxFrame.getFloat(nc1p0);
    localError |= rxFrame.getFloat(nc2p5);
    localError |= rxFrame.getFloat(nc4p0);
    localError |= rxFrame.getFloat(nc10p0);
    localError |= rxFrame.getFloat(typicalParticleSize);
    return localError;
}

int16_t SensirionUartSps30::sleep() {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 10);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 10);
    localError = txFrame.begin(0x10, SPS30_SHDLC_ADDR, 0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    return NO_ERROR;
}

int16_t SensirionUartSps30::wakeUpCommunication() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 10);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 10);
    localError = txFrame.begin(0xff, SPS30_SHDLC_ADDR, 0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    SensirionShdlcCommunication::sendAndReceiveFrame(*_serial, txFrame, rxFrame,
                                                     (uint32_t)50 * 1000);
    return NO_ERROR;
}

int16_t SensirionUartSps30::wakeUp() {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 10);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 10);
    localError = txFrame.begin(0x11, SPS30_SHDLC_ADDR, 0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    return NO_ERROR;
}

int16_t SensirionUartSps30::startFanCleaning() {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 10);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 10);
    localError = txFrame.begin(0x56, SPS30_SHDLC_ADDR, 0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    return NO_ERROR;
}

int16_t
SensirionUartSps30::readAutoCleaningInterval(uint32_t& autoCleaningInterval) {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 12);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 12);
    localError = txFrame.begin(0x80, SPS30_SHDLC_ADDR, 1);
    localError |= txFrame.addUInt8(0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    localError |= rxFrame.getUInt32(autoCleaningInterval);
    return localError;
}

int16_t
SensirionUartSps30::writeAutoCleaningInterval(uint32_t autoCleaningInterval) {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 20);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 20);
    localError = txFrame.begin(0x80, SPS30_SHDLC_ADDR, 5);
    localError |= txFrame.addUInt8(0);
    localError |= txFrame.addUInt32(autoCleaningInterval);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    return NO_ERROR;
}

int16_t SensirionUartSps30::readProductType(int8_t productType[],
                                            uint16_t productTypeSize) {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 13);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 13);
    localError = txFrame.begin(0xd0, SPS30_SHDLC_ADDR, 1);
    localError |= txFrame.addUInt8(0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    localError |= rxFrame.getBytes((uint8_t*)productType, productTypeSize);
    return localError;
}

int16_t SensirionUartSps30::readSerialNumber(int8_t serialNumber[],
                                             uint16_t serialNumberSize) {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 36);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 36);
    localError = txFrame.begin(0xd0, SPS30_SHDLC_ADDR, 1);
    localError |= txFrame.addUInt8(3);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    localError |= rxFrame.getBytes((uint8_t*)serialNumber, serialNumberSize);
    return localError;
}

int16_t SensirionUartSps30::readVersion(
    uint8_t& firmwareMajorVersion, uint8_t& firmwareMinorVersion,
    uint8_t& reserved1, uint8_t& hardwareRevision, uint8_t& reserved2,
    uint8_t& shdlcMajorVersion, uint8_t& shdlcMinorVersion) {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 11);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 11);
    localError = txFrame.begin(0xd1, SPS30_SHDLC_ADDR, 0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    localError |= rxFrame.getUInt8(firmwareMajorVersion);
    localError |= rxFrame.getUInt8(firmwareMinorVersion);
    localError |= rxFrame.getUInt8(reserved1);
    localError |= rxFrame.getUInt8(hardwareRevision);
    localError |= rxFrame.getUInt8(reserved2);
    localError |= rxFrame.getUInt8(shdlcMajorVersion);
    localError |= rxFrame.getUInt8(shdlcMinorVersion);
    return localError;
}

int16_t
SensirionUartSps30::readDeviceStatusRegister(bool clearStatusRegister,
                                             uint32_t& deviceStatusRegister,
                                             uint8_t& reserved) {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 12);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 12);
    localError = txFrame.begin(0xd2, SPS30_SHDLC_ADDR, 1);
    localError |= txFrame.addBool(clearStatusRegister);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    localError |= rxFrame.getUInt32(deviceStatusRegister);
    localError |= rxFrame.getUInt8(reserved);
    return localError;
}

int16_t SensirionUartSps30::deviceReset() {

    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionShdlcTxFrame txFrame(buffer_ptr, 10);
    SensirionShdlcRxFrame rxFrame(buffer_ptr, 10);
    localError = txFrame.begin(0xd3, SPS30_SHDLC_ADDR, 0);
    localError |= txFrame.finish();
    if (localError) {
        return localError;
    }
    localError = SensirionShdlcCommunication::sendAndReceiveFrame(
        *_serial, txFrame, rxFrame, (uint32_t)50 * 1000);
    if (localError) {
        return localError;
    }
    return NO_ERROR;
}

void SensirionUartSps30::begin(Stream& serial) {
    _serial = &serial;
}
