/*
 * THIS FILE IS AUTOMATICALLY GENERATED
 *
 * Generator:     sensirion-driver-generator 1.2.0
 * Product:       sfx6xxx
 * Model-Version: 2.3.1
 */
/*
 * Copyright (c) 2025, Sensirion AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of Sensirion AG nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "SensirionI2cSfx6xxx.h"
#include <Arduino.h>

// make sure that we use the proper definition of NO_ERROR
#ifdef NO_ERROR
#undef NO_ERROR
#endif
#define NO_ERROR 0

static uint8_t communication_buffer[18] = {0};

SensirionI2cSfx6xxx::SensirionI2cSfx6xxx() {
}

float SensirionI2cSfx6xxx::signalTemperature(int16_t temperatureRaw) {
    float temperature = 0.0;
    temperature = temperatureRaw / 200.0;
    return temperature;
}

float SensirionI2cSfx6xxx::signalFlow(int16_t flowRaw, int16_t flowScaleFactor,
                                      int16_t flowOffset) {
    float flow = 0.0;
    float scaleFactor = (float)(flowScaleFactor);
    flow = ((float)(flowRaw) - (float)(flowOffset)) / scaleFactor;
    return flow;
}

int16_t SensirionI2cSfx6xxx::signalRawFlow(float flow, int16_t flowScaleFactor,
                                           int16_t flowOffset) {
    int16_t rawFlow = 0;
    rawFlow = (int16_t)((int)(flow * flowScaleFactor) + flowOffset);
    return rawFlow;
}

int16_t SensirionI2cSfx6xxx::getGasCalibration(
    uint16_t measurementCommand, int16_t& flowScaleFactor, int16_t& flowOffset,
    SFx6xxxFlowUnitT& flowUnit, int16_t& fullScaleFlow, uint16_t& gasId) {
    int16_t localError = 0;
    localError = prepareReadGasCalibration(measurementCommand);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError = readGasCalibration(flowScaleFactor, flowOffset, flowUnit,
                                    fullScaleFlow, gasId);
    return localError;
}

int16_t SensirionI2cSfx6xxx::startO2ContinuousMeasurement() {
    SFx6xxxFlowUnitT flowUnitField = {flowUnitField.value = 0u};
    int16_t localError = 0;
    localError = getGasCalibration(
        SFX6XXX_START_O2_CONTINUOUS_MEASUREMENT_CMD_ID, _flowScaleFactor,
        _flowOffset, flowUnitField, _fullFlow, _gasId);
    if (localError != NO_ERROR) {
        return localError;
    }
    _flowUnit = (uint16_t)(flowUnitField.value);
    localError = llstartO2ContinuousMeasurement();
    return localError;
}

int16_t SensirionI2cSfx6xxx::startAirContinuousMeasurement() {
    SFx6xxxFlowUnitT flowUnitField = {flowUnitField.value = 0u};
    int16_t localError = 0;
    localError = getGasCalibration(
        SFX6XXX_START_AIR_CONTINUOUS_MEASUREMENT_CMD_ID, _flowScaleFactor,
        _flowOffset, flowUnitField, _fullFlow, _gasId);
    if (localError != NO_ERROR) {
        return localError;
    }
    _flowUnit = (uint16_t)(flowUnitField.value);
    localError = llstartAirContinuousMeasurement();
    return localError;
}

int16_t SensirionI2cSfx6xxx::startCo2ContinuousMeasurement() {
    SFx6xxxFlowUnitT flowUnitField = {flowUnitField.value = 0u};
    int16_t localError = 0;
    localError = getGasCalibration(
        SFX6XXX_START_CO2_CONTINUOUS_MEASUREMENT_CMD_ID, _flowScaleFactor,
        _flowOffset, flowUnitField, _fullFlow, _gasId);
    if (localError != NO_ERROR) {
        return localError;
    }
    _flowUnit = (uint16_t)(flowUnitField.value);
    localError = llstartCo2ContinuousMeasurement();
    return localError;
}

int16_t SensirionI2cSfx6xxx::startN2oContinuousMeasurement() {
    SFx6xxxFlowUnitT flowUnitField = {flowUnitField.value = 0u};
    int16_t localError = 0;
    localError = getGasCalibration(
        SFX6XXX_START_N2O_CONTINUOUS_MEASUREMENT_CMD_ID, _flowScaleFactor,
        _flowOffset, flowUnitField, _fullFlow, _gasId);
    if (localError != NO_ERROR) {
        return localError;
    }
    _flowUnit = (uint16_t)(flowUnitField.value);
    localError = llstartN2oContinuousMeasurement();
    return localError;
}

int16_t SensirionI2cSfx6xxx::startArContinuousMeasurement() {
    SFx6xxxFlowUnitT flowUnitField = {flowUnitField.value = 0u};
    int16_t localError = 0;
    localError = getGasCalibration(
        SFX6XXX_START_AR_CONTINUOUS_MEASUREMENT_CMD_ID, _flowScaleFactor,
        _flowOffset, flowUnitField, _fullFlow, _gasId);
    if (localError != NO_ERROR) {
        return localError;
    }
    _flowUnit = (uint16_t)(flowUnitField.value);
    localError = llstartArContinuousMeasurement();
    return localError;
}

int16_t SensirionI2cSfx6xxx::startO2InAirContinuousMeasurement(
    uint16_t volumeFraction) {
    SFx6xxxFlowUnitT flowUnitField = {flowUnitField.value = 0u};
    int16_t localError = 0;
    localError = getGasCalibration(
        SFX6XXX_START_O2_IN_AIR_CONTINUOUS_MEASUREMENT_CMD_ID, _flowScaleFactor,
        _flowOffset, flowUnitField, _fullFlow, _gasId);
    if (localError != NO_ERROR) {
        return localError;
    }
    _flowUnit = (uint16_t)(flowUnitField.value);
    localError = llstartO2InAirContinuousMeasurement(volumeFraction);
    return localError;
}

int16_t
SensirionI2cSfx6xxx::startRawThermalConductivityContinuousMeasurement() {
    SFx6xxxFlowUnitT flowUnitField = {flowUnitField.value = 0u};
    int16_t localError = 0;
    localError = getGasCalibration(
        SFX6XXX_START_RAW_THERMAL_CONDUCTIVITY_CONTINUOUS_MEASUREMENT_CMD_ID,
        _flowScaleFactor, _flowOffset, flowUnitField, _fullFlow, _gasId);
    if (localError != NO_ERROR) {
        return localError;
    }
    _flowUnit = (uint16_t)(flowUnitField.value);
    localError = llstartRawThermalConductivityContinuousMeasurement();
    return localError;
}

int16_t
SensirionI2cSfx6xxx::readMeasurementDataRaw(int16_t& arg0,
                                            SFx6xxxStatusWordT& aStatusWord) {
    int16_t flowRaw = 0;
    int16_t reserved = 0;
    SFx6xxxStatusWordT status = {status.value = 0u};
    int16_t localError = 0;
    localError = llreadMeasurementData(flowRaw, reserved, status);
    if (localError != NO_ERROR) {
        return localError;
    }
    arg0 = flowRaw;
    aStatusWord = status;
    return localError;
}

int16_t
SensirionI2cSfx6xxx::readMeasurementData(float& aFlow,
                                         SFx6xxxStatusWordT& aStatusWord) {
    int16_t rawFlow = 0;
    SFx6xxxStatusWordT statusWord = {statusWord.value = 0u};
    int16_t localError = 0;
    localError = readMeasurementDataRaw(rawFlow, statusWord);
    if (localError != NO_ERROR) {
        return localError;
    }
    aFlow =
        SensirionI2cSfx6xxx::signalFlow(rawFlow, _flowScaleFactor, _flowOffset);
    aStatusWord = statusWord;
    return localError;
}

int16_t SensirionI2cSfx6xxx::readFlowRaw(int16_t& arg0) {
    int16_t flowRaw = 0;
    int16_t localError = 0;
    localError = llreadFlow(flowRaw);
    if (localError != NO_ERROR) {
        return localError;
    }
    arg0 = flowRaw;
    ;
    return localError;
}

int16_t SensirionI2cSfx6xxx::readFlow(float& aFlow) {
    int16_t rawFlow = 0;
    int16_t localError = 0;
    localError = readFlowRaw(rawFlow);
    if (localError != NO_ERROR) {
        return localError;
    }
    aFlow =
        SensirionI2cSfx6xxx::signalFlow(rawFlow, _flowScaleFactor, _flowOffset);

    return localError;
}

int16_t SensirionI2cSfx6xxx::readRawTemperature(int16_t& arg0) {
    int16_t rawTemperature = 0;
    int16_t localError = 0;
    localError = getRawTemperature(rawTemperature);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError = resetPointerToMeasurementBuffer();
    if (localError != NO_ERROR) {
        return localError;
    }
    arg0 = rawTemperature;
    ;
    return localError;
}

int16_t SensirionI2cSfx6xxx::readTemperature(float& aTemperature) {
    int16_t rawTemperature = 0;
    int16_t localError = 0;
    localError = readRawTemperature(rawTemperature);
    if (localError != NO_ERROR) {
        return localError;
    }
    aTemperature = SensirionI2cSfx6xxx::signalTemperature(rawTemperature);

    return localError;
}

int16_t SensirionI2cSfx6xxx::updateSetpoint(float flow) {
    int16_t rawFlow = 0;
    int16_t localError = 0;
    rawFlow =
        SensirionI2cSfx6xxx::signalRawFlow(flow, _flowScaleFactor, _flowOffset);
    localError = llupdateSetpoint(rawFlow);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError = resetPointerToMeasurementBuffer();
    return localError;
}

int16_t SensirionI2cSfx6xxx::readProductIdentifier(uint32_t& productIdentifier,
                                                   uint64_t& serialNumber) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0xe102, buffer_ptr, 18);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    SensirionI2CRxFrame rxFrame(buffer_ptr, 18);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 18,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |= rxFrame.getUInt32(productIdentifier);
    localError |= rxFrame.getInteger((uint8_t*)&serialNumber, LongInteger, 8);
    return localError;
}

int16_t SensirionI2cSfx6xxx::resetPointerToMeasurementBuffer() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0xe000, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfx6xxx::llupdateSetpoint(int16_t setpoint) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0xf054, buffer_ptr, 5);
    localError |= txFrame.addInt16(setpoint);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfx6xxx::updateInitStep(uint16_t initStep) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0xe1b9, buffer_ptr, 5);
    localError |= txFrame.addUInt16(initStep);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfx6xxx::updateCustomerGain(uint16_t customerGain) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0xe1b2, buffer_ptr, 5);
    localError |= txFrame.addUInt16(customerGain);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfx6xxx::llstartO2ContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3603, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(12);
    return localError;
}

int16_t SensirionI2cSfx6xxx::llstartAirContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3608, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(12);
    return localError;
}

int16_t SensirionI2cSfx6xxx::llstartCo2ContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3615, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(12);
    return localError;
}

int16_t SensirionI2cSfx6xxx::llstartN2oContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x361e, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(12);
    return localError;
}

int16_t SensirionI2cSfx6xxx::llstartArContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3624, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(12);
    return localError;
}

int16_t
SensirionI2cSfx6xxx::llstartRawThermalConductivityContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3624, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(50);
    return localError;
}

int16_t SensirionI2cSfx6xxx::llstartO2InAirContinuousMeasurement(
    uint16_t volumeFraction) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3650, buffer_ptr, 5);
    localError |= txFrame.addUInt16(volumeFraction);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(12);
    return localError;
}

int16_t SensirionI2cSfx6xxx::stopContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3ff9, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(1);
    return localError;
}

int16_t
SensirionI2cSfx6xxx::llreadMeasurementData(int16_t& flow, int16_t& reserved,
                                           SFx6xxxStatusWordT& statusWord) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CRxFrame rxFrame(buffer_ptr, 9);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 9,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |= rxFrame.getInt16(flow);
    localError |= rxFrame.getInt16(reserved);
    localError |= rxFrame.getUInt16(statusWord.value);
    return localError;
}

int16_t SensirionI2cSfx6xxx::llreadFlow(int16_t& flow) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CRxFrame rxFrame(buffer_ptr, 3);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 3,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |= rxFrame.getInt16(flow);
    return localError;
}

int16_t SensirionI2cSfx6xxx::getRawTemperature(int16_t& temperature) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0xe102, buffer_ptr, 3);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    SensirionI2CRxFrame rxFrame(buffer_ptr, 3);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 3,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |= rxFrame.getInt16(temperature);
    return localError;
}

int16_t SensirionI2cSfx6xxx::forceOpenValve() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3fe4, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfx6xxx::resetForceOpenValve() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3f65, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfx6xxx::forceCloseValve() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3fef, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfx6xxx::resetForceCloseValve() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3f6e, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfx6xxx::updateGasConcentration(uint16_t volumeFraction) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0xe17d, buffer_ptr, 5);
    localError |= txFrame.addUInt16(volumeFraction);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t
SensirionI2cSfx6xxx::prepareReadGasCalibration(uint16_t measurementCommand) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3661, buffer_ptr, 5);
    localError |= txFrame.addUInt16(measurementCommand);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfx6xxx::readGasCalibration(int16_t& flowScaleFactor,
                                                int16_t& flowOffset,
                                                SFx6xxxFlowUnitT& flowUnit,
                                                int16_t& fullScaleFlow,
                                                uint16_t& gasId) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0xe151, buffer_ptr, 15);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    SensirionI2CRxFrame rxFrame(buffer_ptr, 15);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 15,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |= rxFrame.getInt16(flowScaleFactor);
    localError |= rxFrame.getInt16(flowOffset);
    localError |= rxFrame.getUInt16(flowUnit.value);
    localError |= rxFrame.getInt16(fullScaleFlow);
    localError |= rxFrame.getUInt16(gasId);
    return localError;
}

int16_t SensirionI2cSfx6xxx::enableRawFlowValues() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3fde, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfx6xxx::disableRawFlowValues() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3f5f, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

void SensirionI2cSfx6xxx::begin(TwoWire& i2cBus, uint8_t i2cAddress) {
    _i2cBus = &i2cBus;
    _i2cAddress = i2cAddress;
}
