/*
 * THIS FILE IS AUTOMATICALLY GENERATED
 *
 * Generator:     sensirion-driver-generator 1.3.4
 * Product:       sfm3505
 * Model-Version: 1.1.0
 */
/*
 * Copyright (c) 2025, Sensirion AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of Sensirion AG nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SENSIRIONI2CSFM3505_H
#define SENSIRIONI2CSFM3505_H

#include <SensirionCore.h>
#include <Wire.h>

#define SFM3505_I2C_ADDR_2E 0x2e

typedef enum {
    SFM3505_START_CONTINUOUS_MEASUREMENT_CMD_ID = 0x3603,
    SFM3505_START_CONTINUOUS_MEASUREMENT_WITH_FILTER_CMD_ID = 0x3603,
    SFM3505_STOP_CONTINUOUS_MEASUREMENT_CMD_ID = 0x3ff9,
    SFM3505_CONFIGURE_AVERAGING_CMD_ID = 0x364d,
    SFM3505_READ_PRODUCT_IDENTIFIER_CMD_ID = 0x365b,
} SFM3505CmdId;

typedef enum {
    SFM3505_FILTER_OPTIONS_T63_1MS = 33601,
    SFM3505_FILTER_OPTIONS_T63_3MS = 50961,
    SFM3505_FILTER_OPTIONS_T63_5MS = 56105,
    SFM3505_FILTER_OPTIONS_T63_10MS = 60527,
} SFM3505FilterOptions;

class SensirionI2cSfm3505 {
  public:
    SensirionI2cSfm3505();
    /**
     * @brief Initializes the SFM3505 class.
     *
     * @param i2cBus Arduino stream object to be used for communication.
     */
    void begin(TwoWire& i2cBus, uint8_t i2cAddress);

    /**
     * @brief Read measurement data and apply appropriate scaling.
     *
     * @param[out] aAirFlow This signal represents the measured Air flow in slm
     * (at 20°C and 1013.25hPa). It is scaled with the corresponding scaling
     * factor and offset.
     * @param[out] aO2Flow This signal represents the measured O2 flow in slm
     * (at 20°C and 1013.25hPa). It is scaled with the corresponding scaling
     * factor and offset.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readAllMeasurementData(float& aAirFlow, float& aO2Flow);

    /**
     * @brief Read measurement data without scaling.
     *
     * @param[out] aAirFlowRaw This raw signal represents the measured Air flow
     * as returned by the sensor. The result needs to be scaled to obtain slm.
     * @param[out] aO2FlowRaw This raw signal represents the measured O2 flow as
     * returned by the sensor. The result needs to be scaled to obtain slm.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readAllMeasurementDataNoFloat(uint32_t& aAirFlowRaw,
                                          uint32_t& aO2FlowRaw);

    /**
     * @brief Read only the air flow measurement data.
     *
     * @param[out] aAirFlow This signal represents the measured Air flow in slm
     * (at 20°C and 1013.25hPa). It is scaled with the corresponding scaling
     * factor and offset.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readAirMeasurementData(float& aAirFlow);

    /**
     * @brief Read only the air flow measurement data and does not apply
     * scaling.
     *
     * @param[out] aAirFlowRaw This raw signal represents the measured Air flow
     * as returned by the sensor. The result needs to be scaled to obtain slm.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readAirMeasurementDataNoFloat(uint32_t& aAirFlowRaw);

    /**
     * @brief Start continuous measurement
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t startContinuousMeasurement();

    /**
     * @brief Start continuous measurement with custom filter
     *
     * @param[in] aFilter Low pass filter configuration.
     *
     * @return error_code 0 on success, an error code otherwise.
     *
     * Example:
     * --------
     *
     * @code{.cpp}
     *
     *     int16_t localError = 0;
     *     localError = sensor.startContinuousMeasurementWithFilter(50961);
     *     if (localError != NO_ERROR) {
     *         return;
     *     }
     *
     * @endcode
     *
     */
    int16_t startContinuousMeasurementWithFilter(uint16_t aFilter);

    /**
     * @brief Read out the full data from the sensor.
     *
     * @param[out] allFlowBytesRaw Air-calibrated flow signal and O2-calibrated
     * flow signal read from the sensor as Bytes
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readAllMeasurementDataRaw(uint8_t allFlowBytesRaw[],
                                      uint16_t allFlowBytesRawSize);

    /**
     * @brief Read out the air flow from the sensor.
     *
     * @param[out] airFlowBytesRaw Air-calibrated flow signal read from the
     * sensor as Bytes.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readAirMeasurementDataRaw(uint8_t airFlowBytesRaw[],
                                      uint16_t airFlowBytesRawSize);

    /**
     * @brief This transfer stops the continuous measurement and puts the sensor
     * in idle mode.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t stopContinuousMeasurement();

    /**
     * @brief Configures the sensor's averaging mode.
     *
     * @param[in] averageWindow Average window configuration value.
     *
     * @return error_code 0 on success, an error code otherwise.
     *
     * Example:
     * --------
     *
     * @code{.cpp}
     *
     *     int16_t localError = 0;
     *     localError = sensor.configureAveraging(2);
     *     if (localError != NO_ERROR) {
     *         return;
     *     }
     *
     * @endcode
     *
     */
    int16_t configureAveraging(uint16_t averageWindow);

    /**
     * @brief Reads the product identifier and serial number
     *
     * @param[out] productIdentifier 32-bit unique product and revision number
     * @param[out] serialNumber 64 bit unique serial number of the device
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readProductIdentifier(uint32_t& productIdentifier,
                                  uint64_t& serialNumber);

    /**
     * @brief signalAirFlow
     *
     * @param[in] flowBytesRaw
     *
     * @return This signal represents the measured Air flow in slm (at 20°C and
     * 1013.25hPa). It is scaled with the corresponding scaling factor and
     * offset.
     */
    static float signalAirFlow(const uint8_t* flowBytesRaw);

    /**
     * @brief signalO2Flow
     *
     * @param[in] flowBytesRaw
     *
     * @return This signal represents the measured O2 flow in slm (at 20°C and
     * 1013.25hPa). It is scaled with the corresponding scaling factor and
     * offset.
     */
    static float signalO2Flow(const uint8_t* flowBytesRaw);

    /**
     * @brief signalO2FlowRaw
     *
     * @param[in] flowBytesRaw
     *
     * @return This raw signal represents the measured O2 flow as returned by
     * the sensor. The result needs to be scaled to obtain slm.
     */
    static uint32_t signalO2FlowRaw(const uint8_t* flowBytesRaw);

    /**
     * @brief signalAirFlowRaw
     *
     * @param[in] flowBytesRaw
     *
     * @return This raw signal represents the measured Air flow as returned by
     * the sensor. The result needs to be scaled to obtain slm.
     */
    static uint32_t signalAirFlowRaw(const uint8_t* flowBytesRaw);

  private:
    TwoWire* _i2cBus = nullptr;
    uint8_t _i2cAddress = 0;
};

#endif  // SENSIRIONI2CSFM3505_H