/*
 * THIS FILE IS AUTOMATICALLY GENERATED
 *
 * Generator:     sensirion-driver-generator 1.3.4
 * Product:       sfm3505
 * Model-Version: 1.1.0
 */
/*
 * Copyright (c) 2025, Sensirion AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of Sensirion AG nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "SensirionI2cSfm3505.h"
#include <Arduino.h>

// make sure that we use the proper definition of NO_ERROR
#ifdef NO_ERROR
#undef NO_ERROR
#endif
#define NO_ERROR 0

static uint8_t communication_buffer[18] = {0};

SensirionI2cSfm3505::SensirionI2cSfm3505() {
}

float SensirionI2cSfm3505::signalAirFlow(const uint8_t* flowBytesRaw) {
    int32_t flowRaw = 0;
    float airFlow = 0.0;
    flowRaw =
        (flowBytesRaw[0] << 16) | (flowBytesRaw[1] << 8) | flowBytesRaw[2];
    airFlow = ((float)(flowRaw)-8388608) / 25600;
    return airFlow;
}

float SensirionI2cSfm3505::signalO2Flow(const uint8_t* flowBytesRaw) {
    int32_t flowRaw = 0;
    float o2Flow = 0.0;
    flowRaw =
        (flowBytesRaw[3] << 16) | (flowBytesRaw[4] << 8) | flowBytesRaw[5];
    o2Flow = ((float)(flowRaw)-8388608) / 25600;
    return o2Flow;
}

uint32_t SensirionI2cSfm3505::signalO2FlowRaw(const uint8_t* flowBytesRaw) {
    uint32_t o2FlowRaw = 0;
    o2FlowRaw = (uint32_t)((flowBytesRaw[3] << 16) | (flowBytesRaw[4] << 8) |
                           flowBytesRaw[5]);
    return o2FlowRaw;
}

uint32_t SensirionI2cSfm3505::signalAirFlowRaw(const uint8_t* flowBytesRaw) {
    uint32_t airFlowRaw = 0;
    airFlowRaw = (uint32_t)((flowBytesRaw[0] << 16) | (flowBytesRaw[1] << 8) |
                            flowBytesRaw[2]);
    return airFlowRaw;
}

int16_t SensirionI2cSfm3505::readAllMeasurementData(float& aAirFlow,
                                                    float& aO2Flow) {
    uint8_t flowBytesRaw[6] = {0};
    int16_t localError = 0;
    localError = readAllMeasurementDataRaw(flowBytesRaw, 6);
    if (localError != NO_ERROR) {
        return localError;
    }
    aAirFlow = SensirionI2cSfm3505::signalAirFlow((uint8_t*)(flowBytesRaw));
    aO2Flow = SensirionI2cSfm3505::signalO2Flow((uint8_t*)(flowBytesRaw));
    return localError;
}

int16_t
SensirionI2cSfm3505::readAllMeasurementDataNoFloat(uint32_t& aAirFlowRaw,
                                                   uint32_t& aO2FlowRaw) {
    uint8_t flowBytesRaw[6] = {0};
    int16_t localError = 0;
    localError = readAllMeasurementDataRaw(flowBytesRaw, 6);
    if (localError != NO_ERROR) {
        return localError;
    }
    aAirFlowRaw =
        SensirionI2cSfm3505::signalAirFlowRaw((uint8_t*)(flowBytesRaw));
    aO2FlowRaw = SensirionI2cSfm3505::signalO2FlowRaw((uint8_t*)(flowBytesRaw));
    return localError;
}

int16_t SensirionI2cSfm3505::readAirMeasurementData(float& aAirFlow) {
    uint8_t flowBytesRaw[4] = {0};
    int16_t localError = 0;
    localError = readAirMeasurementDataRaw(flowBytesRaw, 4);
    if (localError != NO_ERROR) {
        return localError;
    }
    aAirFlow = SensirionI2cSfm3505::signalAirFlow((uint8_t*)(flowBytesRaw));

    return localError;
}

int16_t
SensirionI2cSfm3505::readAirMeasurementDataNoFloat(uint32_t& aAirFlowRaw) {
    uint8_t flowBytesRaw[4] = {0};
    int16_t localError = 0;
    localError = readAirMeasurementDataRaw(flowBytesRaw, 4);
    if (localError != NO_ERROR) {
        return localError;
    }
    aAirFlowRaw =
        SensirionI2cSfm3505::signalAirFlowRaw((uint8_t*)(flowBytesRaw));

    return localError;
}

int16_t SensirionI2cSfm3505::startContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3603, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(4);
    return localError;
}

int16_t
SensirionI2cSfm3505::startContinuousMeasurementWithFilter(uint16_t aFilter) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3603, buffer_ptr, 5);
    localError |= txFrame.addUInt16(aFilter);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(4);
    return localError;
}

int16_t
SensirionI2cSfm3505::readAllMeasurementDataRaw(uint8_t allFlowBytesRaw[],
                                               uint16_t allFlowBytesRawSize) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CRxFrame rxFrame(buffer_ptr, 9);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 9,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |=
        rxFrame.getBytes((uint8_t*)allFlowBytesRaw, allFlowBytesRawSize);
    return localError;
}

int16_t
SensirionI2cSfm3505::readAirMeasurementDataRaw(uint8_t airFlowBytesRaw[],
                                               uint16_t airFlowBytesRawSize) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CRxFrame rxFrame(buffer_ptr, 6);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 6,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |=
        rxFrame.getBytes((uint8_t*)airFlowBytesRaw, airFlowBytesRawSize);
    return localError;
}

int16_t SensirionI2cSfm3505::stopContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3ff9, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfm3505::configureAveraging(uint16_t averageWindow) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x364d, buffer_ptr, 5);
    localError |= txFrame.addUInt16(averageWindow);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfm3505::readProductIdentifier(uint32_t& productIdentifier,
                                                   uint64_t& serialNumber) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x365b, buffer_ptr, 18);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    SensirionI2CRxFrame rxFrame(buffer_ptr, 18);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 18,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |= rxFrame.getUInt32(productIdentifier);
    localError |= rxFrame.getInteger((uint8_t*)&serialNumber, LongInteger, 8);
    return localError;
}

void SensirionI2cSfm3505::begin(TwoWire& i2cBus, uint8_t i2cAddress) {
    _i2cBus = &i2cBus;
    _i2cAddress = i2cAddress;
}
