/*
 * THIS FILE IS AUTOMATICALLY GENERATED
 *
 * Generator:     sensirion-driver-generator 1.1.2
 * Product:       sfm3304
 * Model-Version: 1.0.0
 */
/*
 * Copyright (c) 2025, Sensirion AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of Sensirion AG nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SENSIRIONI2CSFM3304_H
#define SENSIRIONI2CSFM3304_H

#include <SensirionCore.h>
#include <Wire.h>

#define SFM3304_I2C_ADDR_2E 0x2e

typedef enum {
    SFM3304_START_CONTINUOUS_MEASUREMENT_CMD_ID = 0x3603,
    SFM3304_START_CONTINUOUS_MEASUREMENT_WITH_FILTER_CMD_ID = 0x3603,
    SFM3304_STOP_CONTINUOUS_MEASUREMENT_CMD_ID = 0x3ff9,
    SFM3304_CONFIGURE_AVERAGING_CMD_ID = 0x366a,
    SFM3304_READ_SCALE_OFFSET_UNIT_CMD_ID = 0x3661,
    SFM3304_ENTER_SLEEP_CMD_ID = 0x3677,
    SFM3304_EXIT_SLEEP_CMD_ID = 0x0,
    SFM3304_READ_PRODUCT_IDENTIFIER_CMD_ID = 0xe102,
} SFM3304CmdId;

typedef enum {
    SFM3304_ERROR_CODE_I2C_ERROR = 0,
    SFM3304_ERROR_CODE_TIMEOUT = 1,
} SFM3304ErrorCodeT;

typedef enum {
    SFM3304_FILTER_OPTIONS_T63_1MS = 33601,
    SFM3304_FILTER_OPTIONS_T63_3MS = 50961,
    SFM3304_FILTER_OPTIONS_T63_5MS = 56105,
    SFM3304_FILTER_OPTIONS_T63_10MS = 60527,
} SFM3304FilterOptions;

typedef union {
    struct {
        uint16_t nrOfAverages : 9;
        uint16_t commandArgumentReception : 1;
        uint16_t avgModeFlag : 1;
        uint16_t expSmoothingFlag : 1;
        uint16_t commandId : 4;
    };
    uint16_t value;
} SFM3304StatusWordT;

typedef union {
    struct {
        uint16_t prefix : 4;
        uint16_t timeBase : 4;
        uint16_t unit : 5;
    };
    uint16_t value;
} SFM3304FlowUnitT;

class SensirionI2cSfm3304 {
  public:
    SensirionI2cSfm3304();
    /**
     * @brief Initializes the SFM3304 class.
     *
     * @param i2cBus Arduino stream object to be used for communication.
     */
    void begin(TwoWire& i2cBus, uint8_t i2cAddress);

    /**
     * @brief Read measurement data and apply appropriate scaling.
     *
     * @param[out] aFlow This signal represents the measured flow in slm (at
     * 20°C and 1013.25hPa). It is scaled with the corresponding scaling factor
     * and offset.
     * @param[out] aTemperature Measured temperature in degrees Celsius. The raw
     * value is scaled appropriately.
     * @param[out] aStatusWord
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readMeasurementData(float& aFlow, float& aTemperature,
                                SFM3304StatusWordT& aStatusWord);

    /**
     * @brief Read only the flow measurement data.
     *
     * @param[out] aFlow This signal represents the measured flow in slm (at
     * 20°C and 1013.25hPa). It is scaled with the corresponding scaling factor
     * and offset.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readMeasurementFlow(float& aFlow);

    /**
     * @brief Start continuous measurement
     *
     * The sensor starts measuring both flow and temperature and provides a
     * status word. All three measurement results can be read out through one
     * single I2C read when the continuous measurement is running. This command
     * uses the default low pass filter settin with a T63 of 3ms. To configure
     * different low pass filter, use the specific method.
     *
     * @note The first measurement result will be available after 4ms. Small
     * accuracy deviations (few % of reading) can occur during the first 50ms
     * (including the 4ms)
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t startContinuousMeasurement();

    /**
     * @brief Start continuous measurement with custom filter
     *
     * The sensor starts measuring both flow and temperature and provides a
     * status word. All three measurement results can be read out through one
     * single I2C read when the continuous measurement is running.
     *
     * @param[in] aFilter Filter setting for low pass filter on flow
     * measurement. You can configure a time constant T63 by passing an integer
     * from the following options: 1ms -> 33601, 3ms (default) -> 50961, 5ms ->
     * 56105, 10ms
     * -> 60527
     *
     * @note The first measurement result will be available after 4ms. Small
     * accuracy deviations (few % of reading) can occur during the first 50ms
     * (including the 4ms).
     *
     * @return error_code 0 on success, an error code otherwise.
     *
     * Example:
     * --------
     *
     * @code{.cpp}
     *
     *     int16_t localError = 0;
     *     localError = sensor.startContinuousMeasurementWithFilter(50961);
     *     if (localError != NO_ERROR) {
     *         return;
     *     }
     *
     * @endcode
     *
     */
    int16_t startContinuousMeasurementWithFilter(uint16_t aFilter);

    /**
     * @brief Read out the data from the sensor.
     *
     * After a start continuous measurement command, the measurement results can
     * be read out continuously with this command. The temperature and the
     * consecutive bytes do not need to be read out (every time). The read
     * sequence can be aborted by a NACK and a STOP condition.
     *
     * @param[out] flow Calibrated flow signal. Convert to gas flow in slm by
     * (value
     * - offset) / scale
     * @param[out] temperature Calibrated temperature. Convert to degrees
     * celsius by value / 200.
     * @param[out] statusWord Gives information about the measurement command
     * that is currently running. A detailed description can be found in the
     * data sheet.
     *
     * @note The first measurement result will be available after 4ms. Small
     * accuracy deviations (few % of reading) can occur during the first 50ms
     * (including the 4ms)
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readMeasurementDataRaw(int16_t& flow, int16_t& temperature,
                                   SFM3304StatusWordT& statusWord);

    /**
     * @brief Read out only flow measurement from the sensor.
     *
     * @param[out] flow Calibrated flow signal read from the sensor.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readMeasurementFlowRaw(int16_t& flow);

    /**
     * @brief This transfer stops the continuous measurement and puts the sensor
     * in idle mode.
     *
     * This command stops the continuous measurement and puts the sensor in idle
     * mode. After it receives the stop command, the sensor needs up to 0.5ms to
     * power down the heater, enter idle mode and be receptive for a new
     * command.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t stopContinuousMeasurement();

    /**
     * @brief Configures the sensor's averaging mode.
     *
     * This command configures the sensor’s averaging mode:
     *   * N=0 (default): average-until-read mode
     *   * 1≤N≤128: fixed-N averaging mode. N is the number of internal
     * measurements that are averaged for one returned measurement value (i.e.
     * the average over N flow samples, where N = CmdArgument, c.f. Sec. 3). The
     * configured averaging mode will be used for flow measurements until a
     * reset or re-execution of this command is performed. After a reset,
     * averaging is set to fixed-N averaging mode with N = 2. The highest
     * averaging number allowed is 128. If a higher number is used in the
     * command argument, it will be overruled by the maximal value of 128
     * samples to average. If no averaging is desired, set N to 1.
     *
     * @param[in] averageWindow Average window configuration value.
     *
     * @return error_code 0 on success, an error code otherwise.
     *
     * Example:
     * --------
     *
     * @code{.cpp}
     *
     *     int16_t localError = 0;
     *     localError = sensor.configureAveraging(2);
     *     if (localError != NO_ERROR) {
     *         return;
     *     }
     *
     * @endcode
     *
     */
    int16_t configureAveraging(uint16_t averageWindow);

    /**
     * @brief This command provides the actually used scale factor and offset of
     * the sensor.
     *
     * This command provides the scale factor and offset to convert flow
     * readings into physical units. The scale factor and offset are specific to
     * the calibrated gas and its corresponding lookup table used for the flow
     * measurement. Therefore, the gas needs to be specified in the command
     * argument by the command code of the corresponding start continuous
     * measurement.
     *
     * @param[in] commandCode For the SFM3304-xxx-D the only calibrated gas is
     * air, the command argument is 0x3603.
     * @param[out] flowScaleFactor Scale factor used by the sensor.
     * @param[out] flowOffset Offset used by the sensor.
     * @param[out] flowUnit Applicable flow unit.
     *
     * @note For the SFM3304-xxx-D, the flow unit is a fixed value 0x0148 and
     * corresponds to slm: standard liter per minute at 20°C and 1013.25 hPa
     * pressure
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readScaleOffsetUnit(uint16_t commandCode, int16_t& flowScaleFactor,
                                int16_t& flowOffset,
                                SFM3304FlowUnitT& flowUnit);

    /**
     * @brief Enters sleep mode
     *
     * In sleep mode the sensor uses a minimum amount of power. The mode can
     * only be entered from idle mode, i.e. when the sensor is not performing
     * measurements. This mode is particularly useful for battery operated
     * devices. To minimize the current in this mode, the complexity of the
     * sleep mode circuit has been reduced as much as possible, which is mainly
     * reflected by the way the sensor exits the sleep mode. In sleep mode the
     * sensor cannot be soft reset.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t enterSleep();

    /**
     * @brief Exits from sleep mode
     *
     * The sensor exits the sleep mode and enters the idle mode when it receives
     * the valid I2C address and a write bit (‘0’). Note that the I2C address is
     * not acknowledged. It is necessary to poll the sensor to see whether the
     * sensor has received the address and has woken up. This should take
     * typically 16ms.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t exitSleep();

    /**
     * @brief This command reads product identifier and the serial number.
     *
     * This command allows to read product identifier and the serial number. The
     * command can only be executed from the idle mode, i.e. when the sensor is
     * not performing measurements.
     *
     * @param[out] productIdentifier 32-bit unique product and revision number.
     * The number is listed in Table 13 below. Note that the last 8 bits are the
     * revision number.
     * @param[out] serialNumber 64-bit unique serial number in the format of an
     * unsigned long integer. The serial number can be converted from binary
     * into decimal, whereby in decimal it has the following format: yywwxxxxxx,
     * where: yy: last 2 digits of calibration year, ww: calibration week,
     * xxxxxx: unique 6-digit sequential number within the calibration week.
     *
     * @return error_code 0 on success, an error code otherwise.
     */
    int16_t readProductIdentifier(uint32_t& productIdentifier,
                                  uint64_t& serialNumber);

    /**
     * @brief signalTemperature
     *
     * @param[in] temperatureRaw
     *
     * @return Measured temperature in degrees Celsius. The raw value is scaled
     * appropriately.
     */
    static float signalTemperature(int16_t temperatureRaw);

    /**
     * @brief signalFlow
     *
     * @param[in] flowRaw
     *
     * @return This signal represents the measured flow in slm (at 20°C and
     * 1013.25hPa). It is scaled with the corresponding scaling factor and
     * offset.
     */
    static float signalFlow(int16_t flowRaw);

  private:
    TwoWire* _i2cBus = nullptr;
    uint8_t _i2cAddress = 0;
};

#endif  // SENSIRIONI2CSFM3304_H