/*
 * THIS FILE IS AUTOMATICALLY GENERATED
 *
 * Generator:     sensirion-driver-generator 1.1.2
 * Product:       sfm3304
 * Model-Version: 1.0.0
 */
/*
 * Copyright (c) 2025, Sensirion AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of Sensirion AG nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "SensirionI2cSfm3304.h"
#include <Arduino.h>

// make sure that we use the proper definition of NO_ERROR
#ifdef NO_ERROR
#undef NO_ERROR
#endif
#define NO_ERROR 0

static uint8_t communication_buffer[18] = {0};

SensirionI2cSfm3304::SensirionI2cSfm3304() {
}

float SensirionI2cSfm3304::signalTemperature(int16_t temperatureRaw) {
    float temperature = 0.0;
    temperature = temperatureRaw / 200.0;
    return temperature;
}

float SensirionI2cSfm3304::signalFlow(int16_t flowRaw) {
    float flow = 0.0;
    flow = flowRaw / 120.0;
    return flow;
}

int16_t
SensirionI2cSfm3304::readMeasurementData(float& aFlow, float& aTemperature,
                                         SFM3304StatusWordT& aStatusWord) {
    int16_t rawFlow = 0;
    int16_t rawTemp = 0;
    SFM3304StatusWordT status = {status.value = 0u};
    int16_t localError = 0;
    localError = readMeasurementDataRaw(rawFlow, rawTemp, status);
    if (localError != NO_ERROR) {
        return localError;
    }
    aFlow = SensirionI2cSfm3304::signalFlow(rawFlow);
    aTemperature = SensirionI2cSfm3304::signalTemperature(rawTemp);
    aStatusWord = status;
    return localError;
}

int16_t SensirionI2cSfm3304::readMeasurementFlow(float& aFlow) {
    int16_t rawFlow = 0;
    int16_t localError = 0;
    localError = readMeasurementFlowRaw(rawFlow);
    if (localError != NO_ERROR) {
        return localError;
    }
    aFlow = SensirionI2cSfm3304::signalFlow(rawFlow);

    return localError;
}

int16_t SensirionI2cSfm3304::startContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3603, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(4);
    return localError;
}

int16_t
SensirionI2cSfm3304::startContinuousMeasurementWithFilter(uint16_t aFilter) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3603, buffer_ptr, 5);
    localError |= txFrame.addUInt16(aFilter);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    delay(4);
    return localError;
}

int16_t
SensirionI2cSfm3304::readMeasurementDataRaw(int16_t& flow, int16_t& temperature,
                                            SFM3304StatusWordT& statusWord) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CRxFrame rxFrame(buffer_ptr, 9);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 9,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |= rxFrame.getInt16(flow);
    localError |= rxFrame.getInt16(temperature);
    localError |= rxFrame.getUInt16(statusWord.value);
    return localError;
}

int16_t SensirionI2cSfm3304::readMeasurementFlowRaw(int16_t& flow) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CRxFrame rxFrame(buffer_ptr, 3);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 3,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |= rxFrame.getInt16(flow);
    return localError;
}

int16_t SensirionI2cSfm3304::stopContinuousMeasurement() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3ff9, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfm3304::configureAveraging(uint16_t averageWindow) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x366a, buffer_ptr, 5);
    localError |= txFrame.addUInt16(averageWindow);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfm3304::readScaleOffsetUnit(uint16_t commandCode,
                                                 int16_t& flowScaleFactor,
                                                 int16_t& flowOffset,
                                                 SFM3304FlowUnitT& flowUnit) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3661, buffer_ptr, 9);
    localError |= txFrame.addUInt16(commandCode);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    SensirionI2CRxFrame rxFrame(buffer_ptr, 9);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 9,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |= rxFrame.getInt16(flowScaleFactor);
    localError |= rxFrame.getInt16(flowOffset);
    localError |= rxFrame.getUInt16(flowUnit.value);
    return localError;
}

int16_t SensirionI2cSfm3304::enterSleep() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0x3677, buffer_ptr, 2);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    return localError;
}

int16_t SensirionI2cSfm3304::exitSleep() {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt8Command(0x0, buffer_ptr, 2);
    SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    delay(2);
    return localError;
}

int16_t SensirionI2cSfm3304::readProductIdentifier(uint32_t& productIdentifier,
                                                   uint64_t& serialNumber) {
    int16_t localError = NO_ERROR;
    uint8_t* buffer_ptr = communication_buffer;
    SensirionI2CTxFrame txFrame =
        SensirionI2CTxFrame::createWithUInt16Command(0xe102, buffer_ptr, 18);
    localError =
        SensirionI2CCommunication::sendFrame(_i2cAddress, txFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    SensirionI2CRxFrame rxFrame(buffer_ptr, 18);
    localError = SensirionI2CCommunication::receiveFrame(_i2cAddress, 18,
                                                         rxFrame, *_i2cBus);
    if (localError != NO_ERROR) {
        return localError;
    }
    localError |= rxFrame.getUInt32(productIdentifier);
    localError |= rxFrame.getInteger((uint8_t*)&serialNumber, LongInteger, 8);
    return localError;
}

void SensirionI2cSfm3304::begin(TwoWire& i2cBus, uint8_t i2cAddress) {
    _i2cBus = &i2cBus;
    _i2cAddress = i2cAddress;
}
