# Sensirion I²C SFM3304 Arduino Library

This is the Sensirion SFM3304 library for Arduino allowing you to
communicate with a SFM3304 sensor over I²C.

<img src="images/SFM3304.png" width="300px">

Click [here](https://sensirion.com/products/catalog/SFM3304-D) to learn more about the Sensirion SFM3304 sensor.



The default I²C address of [SFM3304](https://sensirion.com/products/catalog/SFM3304-D) is **0x2E**.



## Installation of the library

This library can be installed using the Arduino Library manager:
Start the [Arduino IDE](http://www.arduino.cc/en/main/software) and open
the Library Manager via

`Sketch` ➔ `Include Library` ➔ `Manage Libraries...`

Search for the `Sensirion I2C SFM3304` library in the `Filter
your search...` field and install it by clicking the `install` button.

If you cannot find it in the library manager, download the latest release as .zip file
and add it to your [Arduino IDE](http://www.arduino.cc/en/main/software) via

`Sketch` ➔ `Include Library` ➔ `Add .ZIP Library...`

Don't forget to **install the dependencies** listed below the same way via library
manager or `Add .ZIP Library`

#### Dependencies
* [Sensirion Core](https://github.com/Sensirion/arduino-core)

## Connect the sensor

Use the following pin description to connect your SFM3304 to the standard I²C bus of your Arduino board:

<img src="images/Pinout-SFM3304.png" width="300px">

| *Pin* | *Cable Color* | *Name* | *Description*  | *Comments* |
|-------|---------------|:------:|----------------|------------|
| 1 |  | NC | Do not connect | Ground for the heater
| 2 | red | VDD | Supply Voltage | 3.15V to 3.45V
| 3 | yellow | SCL | I2C: Serial clock input |
| 4 | black | GND | Ground |
| 5 | green | SDA | I2C: Serial data input / output |
| 6 |  | NC | Do not connect | Supply voltage to the heater




The recommended voltage is 3.3V.

### Board specific wiring
You will find pinout schematics for recommended board models below:



<details><summary>Arduino Uno</summary>
<p>

| *SFM3304* | *SFM3304 Pin* | *Cable Color* | *Board Pin* |
| :---: | --- | --- | --- |
| VDD | 2 | red | 3.3V |
| SCL | 3 | yellow | D19/SCL |
| GND | 4 | black | GND |
| SDA | 5 | green | D18/SDA |



<img src="images/Arduino-Uno-Rev3-i2c-pinout-3.3V.png" width="600px">
</p>
</details>




<details><summary>Arduino Nano</summary>
<p>

| *SFM3304* | *SFM3304 Pin* | *Cable Color* | *Board Pin* |
| :---: | --- | --- | --- |
| VDD | 2 | red | 3.3V |
| SCL | 3 | yellow | A5 |
| GND | 4 | black | GND |
| SDA | 5 | green | A4 |



<img src="images/Arduino-Nano-i2c-pinout-3.3V.png" width="600px">
</p>
</details>




<details><summary>Arduino Micro</summary>
<p>

| *SFM3304* | *SFM3304 Pin* | *Cable Color* | *Board Pin* |
| :---: | --- | --- | --- |
| VDD | 2 | red | 3.3V |
| SCL | 3 | yellow | ~D3/SCL |
| GND | 4 | black | GND |
| SDA | 5 | green | D2/SDA |



<img src="images/Arduino-Micro-i2c-pinout-3.3V.png" width="600px">
</p>
</details>




<details><summary>Arduino Mega 2560</summary>
<p>

| *SFM3304* | *SFM3304 Pin* | *Cable Color* | *Board Pin* |
| :---: | --- | --- | --- |
| VDD | 2 | red | 3.3V |
| SCL | 3 | yellow | D21/SCL |
| GND | 4 | black | GND |
| SDA | 5 | green | D20/SDA |



<img src="images/Arduino-Mega-2560-Rev3-i2c-pinout-3.3V.png" width="600px">
</p>
</details>




<details><summary>ESP32 DevKitC</summary>
<p>

| *SFM3304* | *SFM3304 Pin* | *Cable Color* | *Board Pin* |
| :---: | --- | --- | --- |
| VDD | 2 | red | 3V3 |
| SCL | 3 | yellow | GPIO 22 |
| GND | 4 | black | GND |
| SDA | 5 | green | GPIO 21 |



<img src="images/esp32-devkitc-i2c-pinout-3.3V.png" width="600px">
</p>
</details>



## Quick Start

1. Install the libraries and dependencies according to [Installation of the library](#installation-of-the-library)

2. Connect the SFM3304 sensor to your Arduino as explained in [Connect the sensor](#connect-the-sensor)

3. Open the `exampleUsage` sample project within the Arduino IDE:

   `File` ➔ `Examples` ➔ `Sensirion I2C SFM3304` ➔ `exampleUsage`



5. Click the `Upload` button in the Arduino IDE or `Sketch` ➔ `Upload`

4. When the upload process has finished, open the `Serial Monitor` or `Serial
   Plotter` via the `Tools` menu to observe the measurement values. Note that
   the `Baud Rate` in the used tool has to be set to `115200 baud`.

## Contributing

**Contributions are welcome!**

This Sensirion library uses
[`clang-format`](https://releases.llvm.org/download.html) to standardize the
formatting of all our `.cpp` and `.h` files. Make sure your contributions are
formatted accordingly:

The `-i` flag will apply the format changes to the files listed.

```bash
clang-format -i src/*.cpp src/*.h
```

Note that differences from this formatting will result in a failed build until
they are fixed.
:

## License

See [LICENSE](LICENSE).