## How to contribute to Seeed Software

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/Seeed-Studio/Seeed_Arduino_SSCMA/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/Seeed-Studio/Seeed_Arduino_SSCMA/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

* If possible, use the relevant bug report templates to create the issue. Simply copy the content of the appropriate template into a .md file, make the necessary changes to demonstrate the issue, and **paste the content into the issue description**:
  * [**Bug** issues](https://github.com/Seeed-Studio/Seeed_Arduino_SSCMA/blob/master/.github/ISSUE_TEMPLATE/bug_report.md)
  * [**feature** issues](https://github.com/Seeed-Studio/Seeed_Arduino_SSCMA/blob/master/.github/ISSUE_TEMPLATE/feature_request.md)
  * [**custom** for other issues](https://github.com/Seeed-Studio/Seeed_Arduino_SSCMA/blob/master/.github/ISSUE_TEMPLATE/custom.md)


#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

* Before submitting, please read the [Contributing to Seeed Software](https://github.com/Seeed-Studio/Seeed_Arduino_SSCMA/blob/master/CONTRIBUTING.md) guide to know more about coding conventions and benchmarks.

#### **Did you fix whitespace, format code, or make a purely cosmetic patch?**

Changes that are cosmetic in nature and do not add anything substantial to the stability, functionality, or testability of Software will generally not be accepted .
#### **Do you intend to add a new feature or change an existing one?**

* Suggest  you mailing our administrator(zuobaozhu@gmail.com) first and start writing code.

* Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.


#### **Do you want to contribute to the Seeed documentation?**

* Please read [Contributing to the Seeed Documentation](https://github.com/Seeed-Studio/wiki-documents/blob/master/README.md).

Seeed Software is a volunteer effort. We encourage you to pitch in and join [the team](https://github.com/Seeed-Studio)!

Thanks! :heart: :heart: :heart:

Seeed Software Team
