#include "QZSSDCX.h"

// Message Typeの文字列を返す
const char* DCXDecoder::get_message_type_str(int message_type) {
  if (message_type == 0) {
    return "Test";
  } else if (message_type == 1) {
    return "Alert";
  } else if (message_type == 2) {
    return "Update";
  }
  return "All Clear";
}

const char* DCXDecoder::get_message_type_str_ja(int message_type) {
  if (message_type == 0) {
    return "テスト";
  } else if (message_type == 1) {
    return "警報";
  } else if (message_type == 2) {
    return "更新";
  }
  return "全解除";
}

// Country/Region Nameの文字列を返す
const char* DCXDecoder::get_country_region_name_str(int country_region_name) {
  switch (country_region_name) {
    case 111:
      return "Japan";
    default:
      return "outside Japan";
  }
}

const char* DCXDecoder::get_country_region_name_str_ja(int country_region_name) {
  switch (country_region_name) {
    case 111:
      return "日本";
    default:
      return "海外";
  }
}

// Provider Identifier コードに対応する日本のプロバイダー名を返す関数
const char* DCXDecoder::get_provider_name_japan(int provider_id) {
  switch (provider_id) {
    case 1: return "一般財団法人マルチメディア振興センター(FMMC)";
    case 2: return "消防庁(FDMA)";
    case 3: return "関連省庁";
    case 4: return "自治体";
    default: return "不明";
  }
}

// Hazard Category and Type コードに対応する文字列を返す関数
const char* DCXDecoder::get_hazard_category_and_type(int hazard_code) {
  switch (hazard_code) {
    case 0: return "not used";
    case 1: return "CBRNE - Air strike";
    case 2: return "CBRNE - Attack on IT systems";
    case 3: return "CBRNE - Attack with nuclear weapons";
    case 4: return "CBRNE - Biological hazard";
    case 5: return "CBRNE - Chemical hazard";
    case 6: return "CBRNE - Explosive hazard";
    case 7: return "CBRNE - Meteorite impact";
    case 8: return "CBRNE - Missile attack";
    case 9: return "CBRNE - Nuclear hazard";
    case 10: return "CBRNE - Nuclear power station accident";
    case 11: return "CBRNE - Radiological hazard";
    case 12: return "CBRNE - Satellite/space re-entry debris";
    case 13: return "CBRNE - Siren test";
    case 14: return "ENVIRONMENT - Acid rain";
    case 15: return "ENVIRONMENT - Air pollution";
    case 16: return "ENVIRONMENT - Contaminated drinking water";
    case 17: return "ENVIRONMENT - Gas leak";
    case 18: return "ENVIRONMENT - Marine pollution";
    case 19: return "ENVIRONMENT - Noise pollution";
    case 20: return "ENVIRONMENT - Plague of insects";
    case 21: return "ENVIRONMENT - River pollution";
    case 22: return "ENVIRONMENT - Suspended dust";
    case 23: return "ENVIRONMENT - UV radiation";
    case 24: return "FIRE - Conflagration";
    case 25: return "FIRE - Fire brigade deployment";
    case 26: return "FIRE - Fire gases";
    case 27: return "FIRE - Forest fire";
    case 28: return "FIRE - Fumes";
    case 29: return "FIRE - Odour nuisance";
    case 30: return "FIRE - Risk of fire";
    case 31: return "FIRE - Structure fire / Industrial fire";
    case 32: return "GEO - Ash fall";
    case 33: return "GEO - Avalanche risk";
    case 34: return "GEO - Crack in the ground/sinkhole";
    case 35: return "GEO - Debris flow";
    case 36: return "GEO - Earthquake";
    case 37: return "GEO - Geomagnetic or solar storm";
    case 38: return "GEO - Glacial ice avalanche";
    case 39: return "GEO - Landslide";
    case 40: return "GEO - Lava flow";
    case 41: return "GEO - Pyroclastic flow";
    case 42: return "GEO - Snowdrifts";
    case 43: return "GEO - Tidal wave";
    case 44: return "GEO - Tsunami";
    case 45: return "GEO - Volcanic mud flow";
    case 46: return "GEO - Volcano eruption";
    case 47: return "GEO - Wind/wave/storm surge";
    case 48: return "HEALTH - Epizootic";
    case 49: return "HEALTH - Food safety alert";
    case 50: return "HEALTH - Health hazard";
    case 51: return "HEALTH - Pandemic";
    case 52: return "HEALTH - Pest infestation";
    case 53: return "HEALTH - Risk of infection";
    case 54: return "INFRASTRUCTURE - Building collapse";
    case 55: return "INFRASTRUCTURE - Emergency number outage";
    case 56: return "INFRASTRUCTURE - Gas supply outage";
    case 57: return "INFRASTRUCTURE - Outage of IT systems";
    case 58: return "INFRASTRUCTURE - Power outage";
    case 59: return "INFRASTRUCTURE - Raw sewage";
    case 60: return "INFRASTRUCTURE - Telephone line outage";
    case 61: return "MET - Black Ice";
    case 62: return "MET - Coastal flooding";
    case 63: return "MET - Cold wave";
    case 64: return "MET - Derecho";
    case 65: return "MET - Drought";
    case 66: return "MET - Dust storm";
    case 67: return "MET - Floating ice / icebergs";
    case 68: return "MET - Flood";
    case 69: return "MET - Fog";
    case 70: return "MET - Hail";
    case 71: return "MET - Heat wave";
    case 72: return "MET - Lightning";
    case 73: return "MET - Pollens";
    case 74: return "MET - Rainfall";
    case 75: return "MET - Snow storm / blizzard";
    case 76: return "MET - Snowfall";
    case 77: return "MET - Storm or thunderstorm";
    case 78: return "MET - Thawing";
    case 79: return "MET - Tornado";
    case 80: return "MET - Tropical cyclone (hurricane)";
    case 81: return "MET - Wind chill/frost";
    case 82: return "MET - Tropical cyclone (typhoon)";
    case 83: return "RESCUE - Dam failure or bursting of a dam";
    case 84: return "RESCUE - Dike failure or bursting of a dike";
    case 85: return "RESCUE - Explosive ordnance disposal";
    case 86: return "RESCUE - Factory accident";
    case 87: return "RESCUE - Mine hazard";
    case 88: return "SAFETY - Bomb/ammunition discovery";
    case 89: return "SAFETY - Demonstration";
    case 90: return "SAFETY - Hazardous material accident";
    case 91: return "SAFETY - Life Threatening situation";
    case 92: return "SAFETY - Major event";
    case 93: return "SAFETY - Missing person/abduction";
    case 94: return "SAFETY - Risk of explosion";
    case 95: return "SAFETY - Safety warning";
    case 96: return "SAFETY - Undefined flying object";
    case 97: return "SAFETY - Unidentified animal";
    case 98: return "SECURITY - Chemical attack";
    case 99: return "SECURITY - Guerrilla attack";
    case 100: return "SECURITY - Hijack";
    case 101: return "SECURITY - Shooting or danger due to weapons";
    case 102: return "SECURITY - Special forces attack";
    case 103: return "SECURITY - Terrorism";
    case 104: return "TRANSPORT - Aircraft crash";
    case 105: return "TRANSPORT - Bridge collapse";
    case 106: return "TRANSPORT - Dangerous goods accident";
    case 107: return "TRANSPORT - Inland waterway transport accident";
    case 108: return "TRANSPORT - Nautical disaster/Maritime/Marine Security";
    case 109: return "TRANSPORT - Oil spill";
    case 110: return "TRANSPORT - Road traffic incident";
    case 111: return "TRANSPORT - Train/rail accident";
    case 112: return "TRANSPORT - Tunnel accident";
    case 113: return "OTHER - Test alert";
    default: return "Unknown";
  }
}

// Hazard Category and Type コードに対応する文字列を返す関数
const char* DCXDecoder::get_hazard_category_and_type_ja(int hazard_code) {
  switch (hazard_code) {
    case 0: return "（未使用）";
    case 1: return "CBRNE - 空爆";
    case 2: return "CBRNE - ITシステムへの攻撃";
    case 3: return "CBRNE - 核兵器による攻撃";
    case 4: return "CBRNE - 生物災害";
    case 5: return "CBRNE - 化学災害";
    case 6: return "CBRNE - 爆発物の危険";
    case 7: return "CBRNE - 隕石の衝突";
    case 8: return "CBRNE - ミサイル攻撃";
    case 9: return "CBRNE - 核災害";
    case 10: return "CBRNE - 原子力発電所の事故";
    case 11: return "CBRNE - 放射線災害";
    case 12: return "CBRNE - 衛星/宇宙再突入の破片";
    case 13: return "CBRNE - サイレンのテスト";
    case 14: return "環境 - 酸性雨";
    case 15: return "環境 - 大気汚染";
    case 16: return "環境 - 汚染された飲料水";
    case 17: return "環境 - ガス漏れ";
    case 18: return "環境 - 海洋汚染";
    case 19: return "環境 - 騒音公害";
    case 20: return "環境 - 昆虫の大量発生";
    case 21: return "環境 - 河川汚染";
    case 22: return "環境 - 浮遊粉塵";
    case 23: return "環境 - 紫外線";
    case 24: return "火災 - 大火災";
    case 25: return "火災 - 消防隊の出動";
    case 26: return "火災 - 火災ガス";
    case 27: return "火災 - 森林火災";
    case 28: return "火災 - 煙";
    case 29: return "火災 - 悪臭被害";
    case 30: return "火災 - 火災のリスク";
    case 31: return "火災 - 構造火災 / 工場火災";
    case 32: return "地質 - 火山灰降下";
    case 33: return "地質 - 雪崩のリスク";
    case 34: return "地質 - 地割れ / 陥没穴";
    case 35: return "地質 - 土砂流";
    case 36: return "地質 - 地震";
    case 37: return "地質 - 地磁気嵐 / 太陽嵐";
    case 38: return "地質 - 氷河の氷崩れ";
    case 39: return "地質 - 地すべり";
    case 40: return "地質 - 溶岩流";
    case 41: return "地質 - 火砕流";
    case 42: return "地質 - 吹きだまり";
    case 43: return "地質 - 高波";
    case 44: return "地質 - 津波";
    case 45: return "地質 - 火山泥流";
    case 46: return "地質 - 火山の噴火";
    case 47: return "地質 - 強風 / 波 / 高潮";
    case 48: return "健康  - 家畜伝染病";
    case 49: return "健康  - 食品安全警報";
    case 50: return "健康  - 健康被害";
    case 51: return "健康  - パンデミック";
    case 52: return "健康  - 害虫の大量発生";
    case 53: return "健康  - 感染のリスク";
    case 54: return "インフラ - 建物の倒壊";
    case 55: return "インフラ - 緊急番号の不通";
    case 56: return "インフラ - ガス供給停止";
    case 57: return "インフラ - ITシステムの停止";
    case 58: return "インフラ - 停電";
    case 59: return "インフラ - 未処理汚水";
    case 60: return "インフラ - 電話回線の不通";
    case 61: return "気象 - ブラックアイス";
    case 62: return "気象 - 沿岸の洪水";
    case 63: return "気象 - 寒波";
    case 64: return "気象 - ダレチョ（強風性雷雨）";
    case 65: return "気象 - 干ばつ";
    case 66: return "気象 - 砂嵐";
    case 67: return "気象 - 流氷 / 氷山";
    case 68: return "気象 - 洪水";
    case 69: return "気象 - 霧";
    case 70: return "気象 - 雹";
    case 71: return "気象 - 熱波";
    case 72: return "気象 - 雷";
    case 73: return "気象 - 花粉";
    case 74: return "気象 - 降雨";
    case 75: return "気象 - 吹雪";
    case 76: return "気象 - 降雪";
    case 77: return "気象 - 嵐または雷雨";
    case 78: return "気象 - 雪解け";
    case 79: return "気象 - 竜巻";
    case 80: return "気象 - 熱帯低気圧（ハリケーン）";
    case 81: return "気象 - 風冷え / 霜";
    case 82: return "気象 - 熱帯低気圧（台風）";
    case 83: return "救助 - ダムの破損または決壊";
    case 84: return "救助 - 堤防の破損または決壊";
    case 85: return "救助 - 爆発物処理";
    case 86: return "救助 - 工場事故";
    case 87: return "救助 - 鉱山の危険";
    case 88: return "安全性 - 爆弾 / 弾薬の発見";
    case 89: return "安全性 - デモ活動";
    case 90: return "安全性 - 有害物質の事故";
    case 91: return "安全性 - 生命の危機的状況";
    case 92: return "安全性 - 大規模イベント";
    case 93: return "安全性 - 行方不明者 / 誘拐";
    case 94: return "安全性 - 爆発のリスク";
    case 95: return "安全性 - 安全性警告";
    case 96: return "安全性 - 未確認飛行物体";
    case 97: return "安全性 - 未確認動物";
    case 98: return "治安 - 化学攻撃";
    case 99: return "治安 - ゲリラ攻撃";
    case 100: return "治安 - ハイジャック";
    case 101: return "治安 - 銃撃または武器による危険";
    case 102: return "治安 - 特殊部隊の攻撃";
    case 103: return "治安 - テロ";
    case 104: return "輸送 - 航空機の墜落";
    case 105: return "輸送 - 橋の崩落";
    case 106: return "輸送 - 危険物の事故";
    case 107: return "輸送 - 内陸水運事故";
    case 108: return "輸送 - 海上災害 / 船舶の安全";
    case 109: return "輸送 - 石油流出";
    case 110: return "輸送 - 道路交通事故";
    case 111: return "輸送 - 列車 / 鉄道事故";
    case 112: return "輸送 - トンネル事故";
    case 113: return "その他 - 警報のテスト";
    default: return "不明";
  }
}

// Severity に対応する文字列を返す関数
const char* DCXDecoder::get_severity_str(int severity) {
  switch (severity) {
    case 1: return "Moderate - Possible threat to life or property";
    case 2: return "Severe - Significant threat to life or property";
    case 3: return "Extreme - Extraordinary threat to life or property";
    default: return "Unknown";
  }
}

const char* DCXDecoder::get_severity_str_ja(int severity) {
  switch (severity) {
    case 1: return "中程度 - 生命または財産への可能性のある脅威";
    case 2: return "深刻 - 生命または財産への重大な脅威";
    case 3: return "極端 - 生命または財産への非常に重大な脅威";
    default: return "不明";
  }
}

const char* DCXDecoder::get_hazard_onset_week_number_str_ja(int week_number) {
  switch (week_number) {
    case 0: return "今週";
    case 1: return "来週";
    default: return "不明";
  }
}

const char* DCXDecoder::get_hazard_onset_tow_str(int tow) {
  const char weekstr[][16] = {
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday",
    "Sunday",
  };
  if (tow == 0) {
    return "";
  }
  static char buf[64];
  tow = tow - 1;
  int week = tow / (60 * 24);
  int hour = (tow / 60) % 24;
  int min = tow % 60;
  snprintf(buf, sizeof(buf), "%s %02d:%02d", weekstr[week], hour, min);
  return buf;
}

const char* DCXDecoder::get_hazard_onset_tow_str_ja(int tow) {
  const char weekstr[][16] = {
    "月曜日",
    "火曜日",
    "水曜日",
    "木曜日",
    "金曜日",
    "土曜日",
    "日曜日",
  };
  if (tow == 0) {
    return "";
  }
  static char buf[64];
  // JSTにする？
  // tow = tow - 1 + 9 * 60;
  // tow = tow % (24 * 60 * 7);
  tow -= 1;
  int week = tow / (60 * 24);
  int hour = (tow / 60) % 24;
  int min = tow % 60;
  snprintf(buf, sizeof(buf), "%s %02d:%02d UTC", weekstr[week], hour, min);
  return buf;
}

const char* DCXDecoder::get_hazard_duration_str_ja(int duration) {
  switch (duration) {
    case 1: return "継続時間 < 6時間";
    case 2: return "6時間 <= 継続時間 < 12時間";
    case 3: return "12時間 <= 継続時間 < 24時間";
    default: return "不明";
  }
}

// Municipality codeに対応する地域コードの文字列を返す関数
const char* DCXDecoder::get_municipality_code_japan(int code) {
  // 標準地域コード https://www.soumu.go.jp/toukei_toukatsu/index/seido/9-5.htm
  switch (code) {
    case 1000: return "北海道";
    case 1100: return "北海道札幌市";
    case 1101: return "北海道札幌市中央区";
    case 1102: return "北海道札幌市北区";
    case 1103: return "北海道札幌市東区";
    case 1104: return "北海道札幌市白石区";
    case 1105: return "北海道札幌市豊平区";
    case 1106: return "北海道札幌市南区";
    case 1107: return "北海道札幌市西区";
    case 1108: return "北海道札幌市厚別区";
    case 1109: return "北海道札幌市手稲区";
    case 1110: return "北海道札幌市清田区";
    case 1202: return "北海道函館市";
    case 1203: return "北海道小樽市";
    case 1204: return "北海道旭川市";
    case 1205: return "北海道室蘭市";
    case 1206: return "北海道釧路市";
    case 1207: return "北海道帯広市";
    case 1208: return "北海道北見市";
    case 1209: return "北海道夕張市";
    case 1210: return "北海道岩見沢市";
    case 1211: return "北海道網走市";
    case 1212: return "北海道留萌市";
    case 1213: return "北海道苫小牧市";
    case 1214: return "北海道稚内市";
    case 1215: return "北海道美唄市";
    case 1216: return "北海道芦別市";
    case 1217: return "北海道江別市";
    case 1218: return "北海道赤平市";
    case 1219: return "北海道紋別市";
    case 1220: return "北海道士別市";
    case 1221: return "北海道名寄市";
    case 1222: return "北海道三笠市";
    case 1223: return "北海道根室市";
    case 1224: return "北海道千歳市";
    case 1225: return "北海道滝川市";
    case 1226: return "北海道砂川市";
    case 1227: return "北海道歌志内市";
    case 1228: return "北海道深川市";
    case 1229: return "北海道富良野市";
    case 1230: return "北海道登別市";
    case 1231: return "北海道恵庭市";
    case 1233: return "北海道伊達市";
    case 1234: return "北海道北広島市";
    case 1235: return "北海道石狩市";
    case 1236: return "北海道北斗市";
    case 1300: return "北海道石狩振興局";
    case 1303: return "北海道石狩振興局当別町";
    case 1304: return "北海道石狩振興局新篠津村";
    case 1330: return "北海道渡島総合振興局";
    case 1331: return "北海道渡島総合振興局松前町";
    case 1332: return "北海道渡島総合振興局福島町";
    case 1333: return "北海道渡島総合振興局知内町";
    case 1334: return "北海道渡島総合振興局木古内町";
    case 1337: return "北海道渡島総合振興局七飯町";
    case 1343: return "北海道渡島総合振興局鹿部町";
    case 1345: return "北海道渡島総合振興局森町";
    case 1346: return "北海道渡島総合振興局八雲町";
    case 1347: return "北海道渡島総合振興局長万部町";
    case 1360: return "北海道檜山振興局";
    case 1361: return "北海道檜山振興局江差町";
    case 1362: return "北海道檜山振興局上ノ国町";
    case 1363: return "北海道檜山振興局厚沢部町";
    case 1364: return "北海道檜山振興局乙部町";
    case 1367: return "北海道檜山振興局奥尻町";
    case 1370: return "北海道檜山振興局今金町";
    case 1371: return "北海道檜山振興局せたな町";
    case 1390: return "北海道後志総合振興局";
    case 1391: return "北海道後志総合振興局島牧村";
    case 1392: return "北海道後志総合振興局寿都町";
    case 1393: return "北海道後志総合振興局黒松内町";
    case 1394: return "北海道後志総合振興局蘭越町";
    case 1395: return "北海道後志総合振興局ニセコ町";
    case 1396: return "北海道後志総合振興局真狩村";
    case 1397: return "北海道後志総合振興局留寿都村";
    case 1398: return "北海道後志総合振興局喜茂別町";
    case 1399: return "北海道後志総合振興局京極町";
    case 1400: return "北海道後志総合振興局倶知安町";
    case 1401: return "北海道後志総合振興局共和町";
    case 1402: return "北海道後志総合振興局岩内町";
    case 1403: return "北海道後志総合振興局泊村";
    case 1404: return "北海道後志総合振興局神恵内村";
    case 1405: return "北海道後志総合振興局積丹町";
    case 1406: return "北海道後志総合振興局古平町";
    case 1407: return "北海道後志総合振興局仁木町";
    case 1408: return "北海道後志総合振興局余市町";
    case 1409: return "北海道後志総合振興局赤井川村";
    case 1420: return "北海道空知総合振興局";
    case 1423: return "北海道空知総合振興局南幌町";
    case 1424: return "北海道空知総合振興局奈井江町";
    case 1425: return "北海道空知総合振興局上砂川町";
    case 1427: return "北海道空知総合振興局由仁町";
    case 1428: return "北海道空知総合振興局長沼町";
    case 1429: return "北海道空知総合振興局栗山町";
    case 1430: return "北海道空知総合振興局月形町";
    case 1431: return "北海道空知総合振興局浦臼町";
    case 1432: return "北海道空知総合振興局新十津川町";
    case 1433: return "北海道空知総合振興局妹背牛町";
    case 1434: return "北海道空知総合振興局秩父別町";
    case 1436: return "北海道空知総合振興局雨竜町";
    case 1437: return "北海道空知総合振興局北竜町";
    case 1438: return "北海道空知総合振興局沼田町";
    case 1450: return "北海道上川総合振興局";
    case 1452: return "北海道上川総合振興局鷹栖町";
    case 1453: return "北海道上川総合振興局東神楽町";
    case 1454: return "北海道上川総合振興局当麻町";
    case 1455: return "北海道上川総合振興局比布町";
    case 1456: return "北海道上川総合振興局愛別町";
    case 1457: return "北海道上川総合振興局上川町";
    case 1458: return "北海道上川総合振興局東川町";
    case 1459: return "北海道上川総合振興局美瑛町";
    case 1460: return "北海道上川総合振興局上富良野町";
    case 1461: return "北海道上川総合振興局中富良野町";
    case 1462: return "北海道上川総合振興局南富良野町";
    case 1463: return "北海道上川総合振興局占冠村";
    case 1464: return "北海道上川総合振興局和寒町";
    case 1465: return "北海道上川総合振興局剣淵町";
    case 1468: return "北海道上川総合振興局下川町";
    case 1469: return "北海道上川総合振興局美深町";
    case 1470: return "北海道上川総合振興局音威子府村";
    case 1471: return "北海道上川総合振興局中川町";
    case 1472: return "北海道上川総合振興局幌加内町";
    case 1480: return "北海道留萌振興局";
    case 1481: return "北海道留萌振興局増毛町";
    case 1482: return "北海道留萌振興局小平町";
    case 1483: return "北海道留萌振興局苫前町";
    case 1484: return "北海道留萌振興局羽幌町";
    case 1485: return "北海道留萌振興局初山別村";
    case 1486: return "北海道留萌振興局遠別町";
    case 1487: return "北海道留萌振興局天塩町";
    case 1510: return "北海道宗谷総合振興局";
    case 1511: return "北海道宗谷総合振興局猿払村";
    case 1512: return "北海道宗谷総合振興局浜頓別町";
    case 1513: return "北海道宗谷総合振興局中頓別町";
    case 1514: return "北海道宗谷総合振興局枝幸町";
    case 1516: return "北海道宗谷総合振興局豊富町";
    case 1517: return "北海道宗谷総合振興局礼文町";
    case 1518: return "北海道宗谷総合振興局利尻町";
    case 1519: return "北海道宗谷総合振興局利尻富士町";
    case 1520: return "北海道宗谷総合振興局幌延町";
    case 1540: return "北海道オホーツク総合振興局";
    case 1543: return "北海道オホーツク総合振興局美幌町";
    case 1544: return "北海道オホーツク総合振興局津別町";
    case 1545: return "北海道オホーツク総合振興局斜里町";
    case 1546: return "北海道オホーツク総合振興局清里町";
    case 1547: return "北海道オホーツク総合振興局小清水町";
    case 1549: return "北海道オホーツク総合振興局訓子府町";
    case 1550: return "北海道オホーツク総合振興局置戸町";
    case 1552: return "北海道オホーツク総合振興局佐呂間町";
    case 1555: return "北海道オホーツク総合振興局遠軽町";
    case 1559: return "北海道オホーツク総合振興局湧別町";
    case 1560: return "北海道オホーツク総合振興局滝上町";
    case 1561: return "北海道オホーツク総合振興局興部町";
    case 1562: return "北海道オホーツク総合振興局西興部村";
    case 1563: return "北海道オホーツク総合振興局雄武町";
    case 1564: return "北海道オホーツク総合振興局大空町";
    case 1570: return "北海道胆振総合振興局";
    case 1571: return "北海道胆振総合振興局豊浦町";
    case 1575: return "北海道胆振総合振興局壮瞥町";
    case 1578: return "北海道胆振総合振興局白老町";
    case 1581: return "北海道胆振総合振興局厚真町";
    case 1584: return "北海道胆振総合振興局洞爺湖町";
    case 1585: return "北海道胆振総合振興局安平町";
    case 1586: return "北海道胆振総合振興局むかわ町";
    case 1600: return "北海道日高振興局";
    case 1601: return "北海道日高振興局日高町";
    case 1602: return "北海道日高振興局平取町";
    case 1604: return "北海道日高振興局新冠町";
    case 1607: return "北海道日高振興局浦河町";
    case 1608: return "北海道日高振興局様似町";
    case 1609: return "北海道日高振興局えりも町";
    case 1610: return "北海道日高振興局新ひだか町";
    case 1630: return "北海道十勝総合振興局";
    case 1631: return "北海道十勝総合振興局音更町";
    case 1632: return "北海道十勝総合振興局士幌町";
    case 1633: return "北海道十勝総合振興局上士幌町";
    case 1634: return "北海道十勝総合振興局鹿追町";
    case 1635: return "北海道十勝総合振興局新得町";
    case 1636: return "北海道十勝総合振興局清水町";
    case 1637: return "北海道十勝総合振興局芽室町";
    case 1638: return "北海道十勝総合振興局中札内村";
    case 1639: return "北海道十勝総合振興局更別村";
    case 1641: return "北海道十勝総合振興局大樹町";
    case 1642: return "北海道十勝総合振興局広尾町";
    case 1643: return "北海道十勝総合振興局幕別町";
    case 1644: return "北海道十勝総合振興局池田町";
    case 1645: return "北海道十勝総合振興局豊頃町";
    case 1646: return "北海道十勝総合振興局本別町";
    case 1647: return "北海道十勝総合振興局足寄町";
    case 1648: return "北海道十勝総合振興局陸別町";
    case 1649: return "北海道十勝総合振興局浦幌町";
    case 1660: return "北海道釧路総合振興局";
    case 1661: return "北海道釧路総合振興局釧路町";
    case 1662: return "北海道釧路総合振興局厚岸町";
    case 1663: return "北海道釧路総合振興局浜中町";
    case 1664: return "北海道釧路総合振興局標茶町";
    case 1665: return "北海道釧路総合振興局弟子屈町";
    case 1667: return "北海道釧路総合振興局鶴居村";
    case 1668: return "北海道釧路総合振興局白糠町";
    case 1690: return "北海道根室振興局";
    case 1691: return "北海道根室振興局別海町";
    case 1692: return "北海道根室振興局中標津町";
    case 1693: return "北海道根室振興局標津町";
    case 1694: return "北海道根室振興局羅臼町";
    case 1695: return "北海道根室振興局色丹村";
    case 1696: return "北海道根室振興局泊村";
    case 1697: return "北海道根室振興局留夜別村";
    case 1698: return "北海道根室振興局留別村";
    case 1699: return "北海道根室振興局紗那村";
    case 1700: return "北海道根室振興局蘂取村";
    case 2000: return "青森県";
    case 2201: return "青森県青森市";
    case 2202: return "青森県弘前市";
    case 2203: return "青森県八戸市";
    case 2204: return "青森県黒石市";
    case 2205: return "青森県五所川原市";
    case 2206: return "青森県十和田市";
    case 2207: return "青森県三沢市";
    case 2208: return "青森県むつ市";
    case 2209: return "青森県つがる市";
    case 2210: return "青森県平川市";
    case 2300: return "青森県東津軽郡";
    case 2301: return "青森県東津軽郡平内町";
    case 2303: return "青森県東津軽郡今別町";
    case 2304: return "青森県東津軽郡蓬田村";
    case 2307: return "青森県東津軽郡外ヶ浜町";
    case 2320: return "青森県西津軽郡";
    case 2321: return "青森県西津軽郡鰺ヶ沢町";
    case 2323: return "青森県西津軽郡深浦町";
    case 2340: return "青森県中津軽郡";
    case 2343: return "青森県中津軽郡西目屋村";
    case 2360: return "青森県南津軽郡";
    case 2361: return "青森県南津軽郡藤崎町";
    case 2362: return "青森県南津軽郡大鰐町";
    case 2367: return "青森県南津軽郡田舎館村";
    case 2380: return "青森県北津軽郡";
    case 2381: return "青森県北津軽郡板柳町";
    case 2384: return "青森県北津軽郡鶴田町";
    case 2387: return "青森県北津軽郡中泊町";
    case 2400: return "青森県上北郡";
    case 2401: return "青森県上北郡野辺地町";
    case 2402: return "青森県上北郡七戸町";
    case 2405: return "青森県上北郡六戸町";
    case 2406: return "青森県上北郡横浜町";
    case 2408: return "青森県上北郡東北町";
    case 2411: return "青森県上北郡六ヶ所村";
    case 2412: return "青森県上北郡おいらせ町";
    case 2420: return "青森県下北郡";
    case 2423: return "青森県下北郡大間町";
    case 2424: return "青森県下北郡東通村";
    case 2425: return "青森県下北郡風間浦村";
    case 2426: return "青森県下北郡佐井村";
    case 2440: return "青森県三戸郡";
    case 2441: return "青森県三戸郡三戸町";
    case 2442: return "青森県三戸郡五戸町";
    case 2443: return "青森県三戸郡田子町";
    case 2445: return "青森県三戸郡南部町";
    case 2446: return "青森県三戸郡階上町";
    case 2450: return "青森県三戸郡新郷村";
    case 3000: return "岩手県";
    case 3201: return "岩手県盛岡市";
    case 3202: return "岩手県宮古市";
    case 3203: return "岩手県大船渡市";
    case 3205: return "岩手県花巻市";
    case 3206: return "岩手県北上市";
    case 3207: return "岩手県久慈市";
    case 3208: return "岩手県遠野市";
    case 3209: return "岩手県一関市";
    case 3210: return "岩手県陸前高田市";
    case 3211: return "岩手県釜石市";
    case 3213: return "岩手県二戸市";
    case 3214: return "岩手県八幡平市";
    case 3215: return "岩手県奥州市";
    case 3216: return "岩手県滝沢市";
    case 3300: return "岩手県岩手郡";
    case 3301: return "岩手県岩手郡雫石町";
    case 3302: return "岩手県岩手郡葛巻町";
    case 3303: return "岩手県岩手郡岩手町";
    case 3320: return "岩手県紫波郡";
    case 3321: return "岩手県紫波郡紫波町";
    case 3322: return "岩手県紫波郡矢巾町";
    case 3360: return "岩手県和賀郡";
    case 3366: return "岩手県和賀郡西和賀町";
    case 3380: return "岩手県胆沢郡";
    case 3381: return "岩手県胆沢郡金ケ崎町";
    case 3400: return "岩手県西磐井郡";
    case 3402: return "岩手県西磐井郡平泉町";
    case 3440: return "岩手県気仙郡";
    case 3441: return "岩手県気仙郡住田町";
    case 3460: return "岩手県上閉伊郡";
    case 3461: return "岩手県上閉伊郡大槌町";
    case 3480: return "岩手県下閉伊郡";
    case 3482: return "岩手県下閉伊郡山田町";
    case 3483: return "岩手県下閉伊郡岩泉町";
    case 3484: return "岩手県下閉伊郡田野畑村";
    case 3485: return "岩手県下閉伊郡普代村";
    case 3500: return "岩手県九戸郡";
    case 3501: return "岩手県九戸郡軽米町";
    case 3503: return "岩手県九戸郡野田村";
    case 3506: return "岩手県九戸郡九戸村";
    case 3507: return "岩手県九戸郡洋野町";
    case 3520: return "岩手県二戸郡";
    case 3524: return "岩手県二戸郡一戸町";
    case 4000: return "宮城県";
    case 4100: return "宮城県仙台市";
    case 4101: return "宮城県仙台市青葉区";
    case 4102: return "宮城県仙台市宮城野区";
    case 4103: return "宮城県仙台市若林区";
    case 4104: return "宮城県仙台市太白区";
    case 4105: return "宮城県仙台市泉区";
    case 4202: return "宮城県石巻市";
    case 4203: return "宮城県塩竈市";
    case 4205: return "宮城県気仙沼市";
    case 4206: return "宮城県白石市";
    case 4207: return "宮城県名取市";
    case 4208: return "宮城県角田市";
    case 4209: return "宮城県多賀城市";
    case 4211: return "宮城県岩沼市";
    case 4212: return "宮城県登米市";
    case 4213: return "宮城県栗原市";
    case 4214: return "宮城県東松島市";
    case 4215: return "宮城県大崎市";
    case 4216: return "宮城県富谷市";
    case 4300: return "宮城県刈田郡";
    case 4301: return "宮城県刈田郡蔵王町";
    case 4302: return "宮城県刈田郡七ヶ宿町";
    case 4320: return "宮城県柴田郡";
    case 4321: return "宮城県柴田郡大河原町";
    case 4322: return "宮城県柴田郡村田町";
    case 4323: return "宮城県柴田郡柴田町";
    case 4324: return "宮城県柴田郡川崎町";
    case 4340: return "宮城県伊具郡";
    case 4341: return "宮城県伊具郡丸森町";
    case 4360: return "宮城県亘理郡";
    case 4361: return "宮城県亘理郡亘理町";
    case 4362: return "宮城県亘理郡山元町";
    case 4400: return "宮城県宮城郡";
    case 4401: return "宮城県宮城郡松島町";
    case 4404: return "宮城県宮城郡七ヶ浜町";
    case 4406: return "宮城県宮城郡利府町";
    case 4420: return "宮城県黒川郡";
    case 4421: return "宮城県黒川郡大和町";
    case 4422: return "宮城県黒川郡大郷町";
    case 4424: return "宮城県黒川郡大衡村";
    case 4440: return "宮城県加美郡";
    case 4444: return "宮城県加美郡色麻町";
    case 4445: return "宮城県加美郡加美町";
    case 4500: return "宮城県遠田郡";
    case 4501: return "宮城県遠田郡涌谷町";
    case 4505: return "宮城県遠田郡美里町";
    case 4580: return "宮城県牡鹿郡";
    case 4581: return "宮城県牡鹿郡女川町";
    case 4600: return "宮城県本吉郡";
    case 4606: return "宮城県本吉郡南三陸町";
    case 5000: return "秋田県";
    case 5201: return "秋田県秋田市";
    case 5202: return "秋田県能代市";
    case 5203: return "秋田県横手市";
    case 5204: return "秋田県大館市";
    case 5206: return "秋田県男鹿市";
    case 5207: return "秋田県湯沢市";
    case 5209: return "秋田県鹿角市";
    case 5210: return "秋田県由利本荘市";
    case 5211: return "秋田県潟上市";
    case 5212: return "秋田県大仙市";
    case 5213: return "秋田県北秋田市";
    case 5214: return "秋田県にかほ市";
    case 5215: return "秋田県仙北市";
    case 5300: return "秋田県鹿角郡";
    case 5303: return "秋田県鹿角郡小坂町";
    case 5320: return "秋田県北秋田郡";
    case 5327: return "秋田県北秋田郡上小阿仁村";
    case 5340: return "秋田県山本郡";
    case 5346: return "秋田県山本郡藤里町";
    case 5348: return "秋田県山本郡三種町";
    case 5349: return "秋田県山本郡八峰町";
    case 5360: return "秋田県南秋田郡";
    case 5361: return "秋田県南秋田郡五城目町";
    case 5363: return "秋田県南秋田郡八郎潟町";
    case 5366: return "秋田県南秋田郡井川町";
    case 5368: return "秋田県南秋田郡大潟村";
    case 5420: return "秋田県仙北郡";
    case 5434: return "秋田県仙北郡美郷町";
    case 5460: return "秋田県雄勝郡";
    case 5463: return "秋田県雄勝郡羽後町";
    case 5464: return "秋田県雄勝郡東成瀬村";
    case 6000: return "山形県";
    case 6201: return "山形県山形市";
    case 6202: return "山形県米沢市";
    case 6203: return "山形県鶴岡市";
    case 6204: return "山形県酒田市";
    case 6205: return "山形県新庄市";
    case 6206: return "山形県寒河江市";
    case 6207: return "山形県上山市";
    case 6208: return "山形県村山市";
    case 6209: return "山形県長井市";
    case 6210: return "山形県天童市";
    case 6211: return "山形県東根市";
    case 6212: return "山形県尾花沢市";
    case 6213: return "山形県南陽市";
    case 6300: return "山形県東村山郡";
    case 6301: return "山形県東村山郡山辺町";
    case 6302: return "山形県東村山郡中山町";
    case 6320: return "山形県西村山郡";
    case 6321: return "山形県西村山郡河北町";
    case 6322: return "山形県西村山郡西川町";
    case 6323: return "山形県西村山郡朝日町";
    case 6324: return "山形県西村山郡大江町";
    case 6340: return "山形県北村山郡";
    case 6341: return "山形県北村山郡大石田町";
    case 6360: return "山形県最上郡";
    case 6361: return "山形県最上郡金山町";
    case 6362: return "山形県最上郡最上町";
    case 6363: return "山形県最上郡舟形町";
    case 6364: return "山形県最上郡真室川町";
    case 6365: return "山形県最上郡大蔵村";
    case 6366: return "山形県最上郡鮭川村";
    case 6367: return "山形県最上郡戸沢村";
    case 6380: return "山形県東置賜郡";
    case 6381: return "山形県東置賜郡高畠町";
    case 6382: return "山形県東置賜郡川西町";
    case 6400: return "山形県西置賜郡";
    case 6401: return "山形県西置賜郡小国町";
    case 6402: return "山形県西置賜郡白鷹町";
    case 6403: return "山形県西置賜郡飯豊町";
    case 6420: return "山形県東田川郡";
    case 6426: return "山形県東田川郡三川町";
    case 6428: return "山形県東田川郡庄内町";
    case 6460: return "山形県飽海郡";
    case 6461: return "山形県飽海郡遊佐町";
    case 7000: return "福島県";
    case 7201: return "福島県福島市";
    case 7202: return "福島県会津若松市";
    case 7203: return "福島県郡山市";
    case 7204: return "福島県いわき市";
    case 7205: return "福島県白河市";
    case 7207: return "福島県須賀川市";
    case 7208: return "福島県喜多方市";
    case 7209: return "福島県相馬市";
    case 7210: return "福島県二本松市";
    case 7211: return "福島県田村市";
    case 7212: return "福島県南相馬市";
    case 7213: return "福島県伊達市";
    case 7214: return "福島県本宮市";
    case 7300: return "福島県伊達郡";
    case 7301: return "福島県伊達郡桑折町";
    case 7303: return "福島県伊達郡国見町";
    case 7308: return "福島県伊達郡川俣町";
    case 7320: return "福島県安達郡";
    case 7322: return "福島県安達郡大玉村";
    case 7340: return "福島県岩瀬郡";
    case 7342: return "福島県岩瀬郡鏡石町";
    case 7344: return "福島県岩瀬郡天栄村";
    case 7360: return "福島県南会津郡";
    case 7362: return "福島県南会津郡下郷町";
    case 7364: return "福島県南会津郡檜枝岐村";
    case 7367: return "福島県南会津郡只見町";
    case 7368: return "福島県南会津郡南会津町";
    case 7400: return "福島県耶麻郡";
    case 7402: return "福島県耶麻郡北塩原村";
    case 7405: return "福島県耶麻郡西会津町";
    case 7407: return "福島県耶麻郡磐梯町";
    case 7408: return "福島県耶麻郡猪苗代町";
    case 7420: return "福島県河沼郡";
    case 7421: return "福島県河沼郡会津坂下町";
    case 7422: return "福島県河沼郡湯川村";
    case 7423: return "福島県河沼郡柳津町";
    case 7440: return "福島県大沼郡";
    case 7444: return "福島県大沼郡三島町";
    case 7445: return "福島県大沼郡金山町";
    case 7446: return "福島県大沼郡昭和村";
    case 7447: return "福島県大沼郡会津美里町";
    case 7460: return "福島県西白河郡";
    case 7461: return "福島県西白河郡西郷村";
    case 7464: return "福島県西白河郡泉崎村";
    case 7465: return "福島県西白河郡中島村";
    case 7466: return "福島県西白河郡矢吹町";
    case 7480: return "福島県東白川郡";
    case 7481: return "福島県東白川郡棚倉町";
    case 7482: return "福島県東白川郡矢祭町";
    case 7483: return "福島県東白川郡塙町";
    case 7484: return "福島県東白川郡鮫川村";
    case 7500: return "福島県石川郡";
    case 7501: return "福島県石川郡石川町";
    case 7502: return "福島県石川郡玉川村";
    case 7503: return "福島県石川郡平田村";
    case 7504: return "福島県石川郡浅川町";
    case 7505: return "福島県石川郡古殿町";
    case 7520: return "福島県田村郡";
    case 7521: return "福島県田村郡三春町";
    case 7522: return "福島県田村郡小野町";
    case 7540: return "福島県双葉郡";
    case 7541: return "福島県双葉郡広野町";
    case 7542: return "福島県双葉郡楢葉町";
    case 7543: return "福島県双葉郡富岡町";
    case 7544: return "福島県双葉郡川内村";
    case 7545: return "福島県双葉郡大熊町";
    case 7546: return "福島県双葉郡双葉町";
    case 7547: return "福島県双葉郡浪江町";
    case 7548: return "福島県双葉郡葛尾村";
    case 7560: return "福島県相馬郡";
    case 7561: return "福島県相馬郡新地町";
    case 7564: return "福島県相馬郡飯舘村";
    case 8000: return "茨城県";
    case 8201: return "茨城県水戸市";
    case 8202: return "茨城県日立市";
    case 8203: return "茨城県土浦市";
    case 8204: return "茨城県古河市";
    case 8205: return "茨城県石岡市";
    case 8207: return "茨城県結城市";
    case 8208: return "茨城県龍ケ崎市";
    case 8210: return "茨城県下妻市";
    case 8211: return "茨城県常総市";
    case 8212: return "茨城県常陸太田市";
    case 8214: return "茨城県高萩市";
    case 8215: return "茨城県北茨城市";
    case 8216: return "茨城県笠間市";
    case 8217: return "茨城県取手市";
    case 8219: return "茨城県牛久市";
    case 8220: return "茨城県つくば市";
    case 8221: return "茨城県ひたちなか市";
    case 8222: return "茨城県鹿嶋市";
    case 8223: return "茨城県潮来市";
    case 8224: return "茨城県守谷市";
    case 8225: return "茨城県常陸大宮市";
    case 8226: return "茨城県那珂市";
    case 8227: return "茨城県筑西市";
    case 8228: return "茨城県坂東市";
    case 8229: return "茨城県稲敷市";
    case 8230: return "茨城県かすみがうら市";
    case 8231: return "茨城県桜川市";
    case 8232: return "茨城県神栖市";
    case 8233: return "茨城県行方市";
    case 8234: return "茨城県鉾田市";
    case 8235: return "茨城県つくばみらい市";
    case 8236: return "茨城県小美玉市";
    case 8300: return "茨城県東茨城郡";
    case 8302: return "茨城県東茨城郡茨城町";
    case 8309: return "茨城県東茨城郡大洗町";
    case 8310: return "茨城県東茨城郡城里町";
    case 8340: return "茨城県那珂郡";
    case 8341: return "茨城県那珂郡東海村";
    case 8360: return "茨城県久慈郡";
    case 8364: return "茨城県久慈郡大子町";
    case 8440: return "茨城県稲敷郡";
    case 8442: return "茨城県稲敷郡美浦村";
    case 8443: return "茨城県稲敷郡阿見町";
    case 8447: return "茨城県稲敷郡河内町";
    case 8520: return "茨城県結城郡";
    case 8521: return "茨城県結城郡八千代町";
    case 8540: return "茨城県猿島郡";
    case 8542: return "茨城県猿島郡五霞町";
    case 8546: return "茨城県猿島郡境町";
    case 8560: return "茨城県北相馬郡";
    case 8564: return "茨城県北相馬郡利根町";
    case 9000: return "栃木県";
    case 9201: return "栃木県宇都宮市";
    case 9202: return "栃木県足利市";
    case 9203: return "栃木県栃木市";
    case 9204: return "栃木県佐野市";
    case 9205: return "栃木県鹿沼市";
    case 9206: return "栃木県日光市";
    case 9208: return "栃木県小山市";
    case 9209: return "栃木県真岡市";
    case 9210: return "栃木県大田原市";
    case 9211: return "栃木県矢板市";
    case 9213: return "栃木県那須塩原市";
    case 9214: return "栃木県さくら市";
    case 9215: return "栃木県那須烏山市";
    case 9216: return "栃木県下野市";
    case 9300: return "栃木県河内郡";
    case 9301: return "栃木県河内郡上三川町";
    case 9340: return "栃木県芳賀郡";
    case 9342: return "栃木県芳賀郡益子町";
    case 9343: return "栃木県芳賀郡茂木町";
    case 9344: return "栃木県芳賀郡市貝町";
    case 9345: return "栃木県芳賀郡芳賀町";
    case 9360: return "栃木県下都賀郡";
    case 9361: return "栃木県下都賀郡壬生町";
    case 9364: return "栃木県下都賀郡野木町";
    case 9380: return "栃木県塩谷郡";
    case 9384: return "栃木県塩谷郡塩谷町";
    case 9386: return "栃木県塩谷郡高根沢町";
    case 9400: return "栃木県那須郡";
    case 9407: return "栃木県那須郡那須町";
    case 9411: return "栃木県那須郡那珂川町";
    case 10000: return "群馬県";
    case 10201: return "群馬県前橋市";
    case 10202: return "群馬県高崎市";
    case 10203: return "群馬県桐生市";
    case 10204: return "群馬県伊勢崎市";
    case 10205: return "群馬県太田市";
    case 10206: return "群馬県沼田市";
    case 10207: return "群馬県館林市";
    case 10208: return "群馬県渋川市";
    case 10209: return "群馬県藤岡市";
    case 10210: return "群馬県富岡市";
    case 10211: return "群馬県安中市";
    case 10212: return "群馬県みどり市";
    case 10340: return "群馬県北群馬郡";
    case 10344: return "群馬県北群馬郡榛東村";
    case 10345: return "群馬県北群馬郡吉岡町";
    case 10360: return "群馬県多野郡";
    case 10366: return "群馬県多野郡上野村";
    case 10367: return "群馬県多野郡神流町";
    case 10380: return "群馬県甘楽郡";
    case 10382: return "群馬県甘楽郡下仁田町";
    case 10383: return "群馬県甘楽郡南牧村";
    case 10384: return "群馬県甘楽郡甘楽町";
    case 10420: return "群馬県吾妻郡";
    case 10421: return "群馬県吾妻郡中之条町";
    case 10424: return "群馬県吾妻郡長野原町";
    case 10425: return "群馬県吾妻郡嬬恋村";
    case 10426: return "群馬県吾妻郡草津町";
    case 10428: return "群馬県吾妻郡高山村";
    case 10429: return "群馬県吾妻郡東吾妻町";
    case 10440: return "群馬県利根郡";
    case 10443: return "群馬県利根郡片品村";
    case 10444: return "群馬県利根郡川場村";
    case 10448: return "群馬県利根郡昭和村";
    case 10449: return "群馬県利根郡みなかみ町";
    case 10460: return "群馬県佐波郡";
    case 10464: return "群馬県佐波郡玉村町";
    case 10520: return "群馬県邑楽郡";
    case 10521: return "群馬県邑楽郡板倉町";
    case 10522: return "群馬県邑楽郡明和町";
    case 10523: return "群馬県邑楽郡千代田町";
    case 10524: return "群馬県邑楽郡大泉町";
    case 10525: return "群馬県邑楽郡邑楽町";
    case 11000: return "埼玉県";
    case 11100: return "埼玉県さいたま市";
    case 11101: return "埼玉県さいたま市西区";
    case 11102: return "埼玉県さいたま市北区";
    case 11103: return "埼玉県さいたま市大宮区";
    case 11104: return "埼玉県さいたま市見沼区";
    case 11105: return "埼玉県さいたま市中央区";
    case 11106: return "埼玉県さいたま市桜区";
    case 11107: return "埼玉県さいたま市浦和区";
    case 11108: return "埼玉県さいたま市南区";
    case 11109: return "埼玉県さいたま市緑区";
    case 11110: return "埼玉県さいたま市岩槻区";
    case 11201: return "埼玉県川越市";
    case 11202: return "埼玉県熊谷市";
    case 11203: return "埼玉県川口市";
    case 11206: return "埼玉県行田市";
    case 11207: return "埼玉県秩父市";
    case 11208: return "埼玉県所沢市";
    case 11209: return "埼玉県飯能市";
    case 11210: return "埼玉県加須市";
    case 11211: return "埼玉県本庄市";
    case 11212: return "埼玉県東松山市";
    case 11214: return "埼玉県春日部市";
    case 11215: return "埼玉県狭山市";
    case 11216: return "埼玉県羽生市";
    case 11217: return "埼玉県鴻巣市";
    case 11218: return "埼玉県深谷市";
    case 11219: return "埼玉県上尾市";
    case 11221: return "埼玉県草加市";
    case 11222: return "埼玉県越谷市";
    case 11223: return "埼玉県蕨市";
    case 11224: return "埼玉県戸田市";
    case 11225: return "埼玉県入間市";
    case 11227: return "埼玉県朝霞市";
    case 11228: return "埼玉県志木市";
    case 11229: return "埼玉県和光市";
    case 11230: return "埼玉県新座市";
    case 11231: return "埼玉県桶川市";
    case 11232: return "埼玉県久喜市";
    case 11233: return "埼玉県北本市";
    case 11234: return "埼玉県八潮市";
    case 11235: return "埼玉県富士見市";
    case 11237: return "埼玉県三郷市";
    case 11238: return "埼玉県蓮田市";
    case 11239: return "埼玉県坂戸市";
    case 11240: return "埼玉県幸手市";
    case 11241: return "埼玉県鶴ヶ島市";
    case 11242: return "埼玉県日高市";
    case 11243: return "埼玉県吉川市";
    case 11245: return "埼玉県ふじみ野市";
    case 11246: return "埼玉県白岡市";
    case 11300: return "埼玉県北足立郡";
    case 11301: return "埼玉県北足立郡伊奈町";
    case 11320: return "埼玉県入間郡";
    case 11324: return "埼玉県入間郡三芳町";
    case 11326: return "埼玉県入間郡毛呂山町";
    case 11327: return "埼玉県入間郡越生町";
    case 11340: return "埼玉県比企郡";
    case 11341: return "埼玉県比企郡滑川町";
    case 11342: return "埼玉県比企郡嵐山町";
    case 11343: return "埼玉県比企郡小川町";
    case 11346: return "埼玉県比企郡川島町";
    case 11347: return "埼玉県比企郡吉見町";
    case 11348: return "埼玉県比企郡鳩山町";
    case 11349: return "埼玉県比企郡ときがわ町";
    case 11360: return "埼玉県秩父郡";
    case 11361: return "埼玉県秩父郡横瀬町";
    case 11362: return "埼玉県秩父郡皆野町";
    case 11363: return "埼玉県秩父郡長瀞町";
    case 11365: return "埼玉県秩父郡小鹿野町";
    case 11369: return "埼玉県秩父郡東秩父村";
    case 11380: return "埼玉県児玉郡";
    case 11381: return "埼玉県児玉郡美里町";
    case 11383: return "埼玉県児玉郡神川町";
    case 11385: return "埼玉県児玉郡上里町";
    case 11400: return "埼玉県大里郡";
    case 11408: return "埼玉県大里郡寄居町";
    case 11440: return "埼玉県南埼玉郡";
    case 11442: return "埼玉県南埼玉郡宮代町";
    case 11460: return "埼玉県北葛飾郡";
    case 11464: return "埼玉県北葛飾郡杉戸町";
    case 11465: return "埼玉県北葛飾郡松伏町";
    case 12000: return "千葉県";
    case 12100: return "千葉県千葉市";
    case 12101: return "千葉県千葉市中央区";
    case 12102: return "千葉県千葉市花見川区";
    case 12103: return "千葉県千葉市稲毛区";
    case 12104: return "千葉県千葉市若葉区";
    case 12105: return "千葉県千葉市緑区";
    case 12106: return "千葉県千葉市美浜区";
    case 12202: return "千葉県銚子市";
    case 12203: return "千葉県市川市";
    case 12204: return "千葉県船橋市";
    case 12205: return "千葉県館山市";
    case 12206: return "千葉県木更津市";
    case 12207: return "千葉県松戸市";
    case 12208: return "千葉県野田市";
    case 12210: return "千葉県茂原市";
    case 12211: return "千葉県成田市";
    case 12212: return "千葉県佐倉市";
    case 12213: return "千葉県東金市";
    case 12215: return "千葉県旭市";
    case 12216: return "千葉県習志野市";
    case 12217: return "千葉県柏市";
    case 12218: return "千葉県勝浦市";
    case 12219: return "千葉県市原市";
    case 12220: return "千葉県流山市";
    case 12221: return "千葉県八千代市";
    case 12222: return "千葉県我孫子市";
    case 12223: return "千葉県鴨川市";
    case 12224: return "千葉県鎌ケ谷市";
    case 12225: return "千葉県君津市";
    case 12226: return "千葉県富津市";
    case 12227: return "千葉県浦安市";
    case 12228: return "千葉県四街道市";
    case 12229: return "千葉県袖ケ浦市";
    case 12230: return "千葉県八街市";
    case 12231: return "千葉県印西市";
    case 12232: return "千葉県白井市";
    case 12233: return "千葉県富里市";
    case 12234: return "千葉県南房総市";
    case 12235: return "千葉県匝瑳市";
    case 12236: return "千葉県香取市";
    case 12237: return "千葉県山武市";
    case 12238: return "千葉県いすみ市";
    case 12239: return "千葉県大網白里市";
    case 12320: return "千葉県印旛郡";
    case 12322: return "千葉県印旛郡酒々井町";
    case 12329: return "千葉県印旛郡栄町";
    case 12340: return "千葉県香取郡";
    case 12342: return "千葉県香取郡神崎町";
    case 12347: return "千葉県香取郡多古町";
    case 12349: return "千葉県香取郡東庄町";
    case 12400: return "千葉県山武郡";
    case 12403: return "千葉県山武郡九十九里町";
    case 12409: return "千葉県山武郡芝山町";
    case 12410: return "千葉県山武郡横芝光町";
    case 12420: return "千葉県長生郡";
    case 12421: return "千葉県長生郡一宮町";
    case 12422: return "千葉県長生郡睦沢町";
    case 12423: return "千葉県長生郡長生村";
    case 12424: return "千葉県長生郡白子町";
    case 12426: return "千葉県長生郡長柄町";
    case 12427: return "千葉県長生郡長南町";
    case 12440: return "千葉県夷隅郡";
    case 12441: return "千葉県夷隅郡大多喜町";
    case 12443: return "千葉県夷隅郡御宿町";
    case 12460: return "千葉県安房郡";
    case 12463: return "千葉県安房郡鋸南町";
    case 13000: return "東京都";
    case 13100: return "東京都特別区部";
    case 13101: return "東京都千代田区";
    case 13102: return "東京都中央区";
    case 13103: return "東京都港区";
    case 13104: return "東京都新宿区";
    case 13105: return "東京都文京区";
    case 13106: return "東京都台東区";
    case 13107: return "東京都墨田区";
    case 13108: return "東京都江東区";
    case 13109: return "東京都品川区";
    case 13110: return "東京都目黒区";
    case 13111: return "東京都大田区";
    case 13112: return "東京都世田谷区";
    case 13113: return "東京都渋谷区";
    case 13114: return "東京都中野区";
    case 13115: return "東京都杉並区";
    case 13116: return "東京都豊島区";
    case 13117: return "東京都北区";
    case 13118: return "東京都荒川区";
    case 13119: return "東京都板橋区";
    case 13120: return "東京都練馬区";
    case 13121: return "東京都足立区";
    case 13122: return "東京都葛飾区";
    case 13123: return "東京都江戸川区";
    case 13201: return "東京都八王子市";
    case 13202: return "東京都立川市";
    case 13203: return "東京都武蔵野市";
    case 13204: return "東京都三鷹市";
    case 13205: return "東京都青梅市";
    case 13206: return "東京都府中市";
    case 13207: return "東京都昭島市";
    case 13208: return "東京都調布市";
    case 13209: return "東京都町田市";
    case 13210: return "東京都小金井市";
    case 13211: return "東京都小平市";
    case 13212: return "東京都日野市";
    case 13213: return "東京都東村山市";
    case 13214: return "東京都国分寺市";
    case 13215: return "東京都国立市";
    case 13218: return "東京都福生市";
    case 13219: return "東京都狛江市";
    case 13220: return "東京都東大和市";
    case 13221: return "東京都清瀬市";
    case 13222: return "東京都東久留米市";
    case 13223: return "東京都武蔵村山市";
    case 13224: return "東京都多摩市";
    case 13225: return "東京都稲城市";
    case 13227: return "東京都羽村市";
    case 13228: return "東京都あきる野市";
    case 13229: return "東京都西東京市";
    case 13300: return "東京都西多摩郡";
    case 13303: return "東京都西多摩郡瑞穂町";
    case 13305: return "東京都西多摩郡日の出町";
    case 13307: return "東京都西多摩郡檜原村";
    case 13308: return "東京都西多摩郡奥多摩町";
    case 13360: return "東京都大島支庁";
    case 13361: return "東京都大島支庁大島町";
    case 13362: return "東京都大島支庁利島村";
    case 13363: return "東京都大島支庁新島村";
    case 13364: return "東京都大島支庁神津島村";
    case 13380: return "東京都三宅支庁";
    case 13381: return "東京都三宅支庁三宅村";
    case 13382: return "東京都三宅支庁御蔵島村";
    case 13400: return "東京都八丈支庁";
    case 13401: return "東京都八丈支庁八丈町";
    case 13402: return "東京都八丈支庁青ヶ島村";
    case 13420: return "東京都小笠原支庁";
    case 13421: return "東京都小笠原支庁小笠原村";
    case 14000: return "神奈川県";
    case 14100: return "神奈川県横浜市";
    case 14101: return "神奈川県横浜市鶴見区";
    case 14102: return "神奈川県横浜市神奈川区";
    case 14103: return "神奈川県横浜市西区";
    case 14104: return "神奈川県横浜市中区";
    case 14105: return "神奈川県横浜市南区";
    case 14106: return "神奈川県横浜市保土ケ谷区";
    case 14107: return "神奈川県横浜市磯子区";
    case 14108: return "神奈川県横浜市金沢区";
    case 14109: return "神奈川県横浜市港北区";
    case 14110: return "神奈川県横浜市戸塚区";
    case 14111: return "神奈川県横浜市港南区";
    case 14112: return "神奈川県横浜市旭区";
    case 14113: return "神奈川県横浜市緑区";
    case 14114: return "神奈川県横浜市瀬谷区";
    case 14115: return "神奈川県横浜市栄区";
    case 14116: return "神奈川県横浜市泉区";
    case 14117: return "神奈川県横浜市青葉区";
    case 14118: return "神奈川県横浜市都筑区";
    case 14130: return "神奈川県川崎市";
    case 14131: return "神奈川県川崎市川崎区";
    case 14132: return "神奈川県川崎市幸区";
    case 14133: return "神奈川県川崎市中原区";
    case 14134: return "神奈川県川崎市高津区";
    case 14135: return "神奈川県川崎市多摩区";
    case 14136: return "神奈川県川崎市宮前区";
    case 14137: return "神奈川県川崎市麻生区";
    case 14150: return "神奈川県相模原市";
    case 14151: return "神奈川県相模原市緑区";
    case 14152: return "神奈川県相模原市中央区";
    case 14153: return "神奈川県相模原市南区";
    case 14201: return "神奈川県横須賀市";
    case 14203: return "神奈川県平塚市";
    case 14204: return "神奈川県鎌倉市";
    case 14205: return "神奈川県藤沢市";
    case 14206: return "神奈川県小田原市";
    case 14207: return "神奈川県茅ヶ崎市";
    case 14208: return "神奈川県逗子市";
    case 14210: return "神奈川県三浦市";
    case 14211: return "神奈川県秦野市";
    case 14212: return "神奈川県厚木市";
    case 14213: return "神奈川県大和市";
    case 14214: return "神奈川県伊勢原市";
    case 14215: return "神奈川県海老名市";
    case 14216: return "神奈川県座間市";
    case 14217: return "神奈川県南足柄市";
    case 14218: return "神奈川県綾瀬市";
    case 14300: return "神奈川県三浦郡";
    case 14301: return "神奈川県三浦郡葉山町";
    case 14320: return "神奈川県高座郡";
    case 14321: return "神奈川県高座郡寒川町";
    case 14340: return "神奈川県中郡";
    case 14341: return "神奈川県中郡大磯町";
    case 14342: return "神奈川県中郡二宮町";
    case 14360: return "神奈川県足柄上郡";
    case 14361: return "神奈川県足柄上郡中井町";
    case 14362: return "神奈川県足柄上郡大井町";
    case 14363: return "神奈川県足柄上郡松田町";
    case 14364: return "神奈川県足柄上郡山北町";
    case 14366: return "神奈川県足柄上郡開成町";
    case 14380: return "神奈川県足柄下郡";
    case 14382: return "神奈川県足柄下郡箱根町";
    case 14383: return "神奈川県足柄下郡真鶴町";
    case 14384: return "神奈川県足柄下郡湯河原町";
    case 14400: return "神奈川県愛甲郡";
    case 14401: return "神奈川県愛甲郡愛川町";
    case 14402: return "神奈川県愛甲郡清川村";
    case 15000: return "新潟県";
    case 15100: return "新潟県新潟市";
    case 15101: return "新潟県新潟市北区";
    case 15102: return "新潟県新潟市東区";
    case 15103: return "新潟県新潟市中央区";
    case 15104: return "新潟県新潟市江南区";
    case 15105: return "新潟県新潟市秋葉区";
    case 15106: return "新潟県新潟市南区";
    case 15107: return "新潟県新潟市西区";
    case 15108: return "新潟県新潟市西蒲区";
    case 15202: return "新潟県長岡市";
    case 15204: return "新潟県三条市";
    case 15205: return "新潟県柏崎市";
    case 15206: return "新潟県新発田市";
    case 15208: return "新潟県小千谷市";
    case 15209: return "新潟県加茂市";
    case 15210: return "新潟県十日町市";
    case 15211: return "新潟県見附市";
    case 15212: return "新潟県村上市";
    case 15213: return "新潟県燕市";
    case 15216: return "新潟県糸魚川市";
    case 15217: return "新潟県妙高市";
    case 15218: return "新潟県五泉市";
    case 15222: return "新潟県上越市";
    case 15223: return "新潟県阿賀野市";
    case 15224: return "新潟県佐渡市";
    case 15225: return "新潟県魚沼市";
    case 15226: return "新潟県南魚沼市";
    case 15227: return "新潟県胎内市";
    case 15300: return "新潟県北蒲原郡";
    case 15307: return "新潟県北蒲原郡聖籠町";
    case 15340: return "新潟県西蒲原郡";
    case 15342: return "新潟県西蒲原郡弥彦村";
    case 15360: return "新潟県南蒲原郡";
    case 15361: return "新潟県南蒲原郡田上町";
    case 15380: return "新潟県東蒲原郡";
    case 15385: return "新潟県東蒲原郡阿賀町";
    case 15400: return "新潟県三島郡";
    case 15405: return "新潟県三島郡出雲崎町";
    case 15460: return "新潟県南魚沼郡";
    case 15461: return "新潟県南魚沼郡湯沢町";
    case 15480: return "新潟県中魚沼郡";
    case 15482: return "新潟県中魚沼郡津南町";
    case 15500: return "新潟県刈羽郡";
    case 15504: return "新潟県刈羽郡刈羽村";
    case 15580: return "新潟県岩船郡";
    case 15581: return "新潟県岩船郡関川村";
    case 15586: return "新潟県岩船郡粟島浦村";
    case 16000: return "富山県";
    case 16201: return "富山県富山市";
    case 16202: return "富山県高岡市";
    case 16204: return "富山県魚津市";
    case 16205: return "富山県氷見市";
    case 16206: return "富山県滑川市";
    case 16207: return "富山県黒部市";
    case 16208: return "富山県砺波市";
    case 16209: return "富山県小矢部市";
    case 16210: return "富山県南砺市";
    case 16211: return "富山県射水市";
    case 16320: return "富山県中新川郡";
    case 16321: return "富山県中新川郡舟橋村";
    case 16322: return "富山県中新川郡上市町";
    case 16323: return "富山県中新川郡立山町";
    case 16340: return "富山県下新川郡";
    case 16342: return "富山県下新川郡入善町";
    case 16343: return "富山県下新川郡朝日町";
    case 17000: return "石川県";
    case 17201: return "石川県金沢市";
    case 17202: return "石川県七尾市";
    case 17203: return "石川県小松市";
    case 17204: return "石川県輪島市";
    case 17205: return "石川県珠洲市";
    case 17206: return "石川県加賀市";
    case 17207: return "石川県羽咋市";
    case 17209: return "石川県かほく市";
    case 17210: return "石川県白山市";
    case 17211: return "石川県能美市";
    case 17212: return "石川県野々市市";
    case 17320: return "石川県能美郡";
    case 17324: return "石川県能美郡川北町";
    case 17360: return "石川県河北郡";
    case 17361: return "石川県河北郡津幡町";
    case 17365: return "石川県河北郡内灘町";
    case 17380: return "石川県羽咋郡";
    case 17384: return "石川県羽咋郡志賀町";
    case 17386: return "石川県羽咋郡宝達志水町";
    case 17400: return "石川県鹿島郡";
    case 17407: return "石川県鹿島郡中能登町";
    case 17460: return "石川県鳳珠郡";
    case 17461: return "石川県鳳珠郡穴水町";
    case 17463: return "石川県鳳珠郡能登町";
    case 18000: return "福井県";
    case 18201: return "福井県福井市";
    case 18202: return "福井県敦賀市";
    case 18204: return "福井県小浜市";
    case 18205: return "福井県大野市";
    case 18206: return "福井県勝山市";
    case 18207: return "福井県鯖江市";
    case 18208: return "福井県あわら市";
    case 18209: return "福井県越前市";
    case 18210: return "福井県坂井市";
    case 18320: return "福井県吉田郡";
    case 18322: return "福井県吉田郡永平寺町";
    case 18380: return "福井県今立郡";
    case 18382: return "福井県今立郡池田町";
    case 18400: return "福井県南条郡";
    case 18404: return "福井県南条郡南越前町";
    case 18420: return "福井県丹生郡";
    case 18423: return "福井県丹生郡越前町";
    case 18440: return "福井県三方郡";
    case 18442: return "福井県三方郡美浜町";
    case 18480: return "福井県大飯郡";
    case 18481: return "福井県大飯郡高浜町";
    case 18483: return "福井県大飯郡おおい町";
    case 18500: return "福井県三方上中郡";
    case 18501: return "福井県三方上中郡若狭町";
    case 19000: return "山梨県";
    case 19201: return "山梨県甲府市";
    case 19202: return "山梨県富士吉田市";
    case 19204: return "山梨県都留市";
    case 19205: return "山梨県山梨市";
    case 19206: return "山梨県大月市";
    case 19207: return "山梨県韮崎市";
    case 19208: return "山梨県南アルプス市";
    case 19209: return "山梨県北杜市";
    case 19210: return "山梨県甲斐市";
    case 19211: return "山梨県笛吹市";
    case 19212: return "山梨県上野原市";
    case 19213: return "山梨県甲州市";
    case 19214: return "山梨県中央市";
    case 19340: return "山梨県西八代郡";
    case 19346: return "山梨県西八代郡市川三郷町";
    case 19360: return "山梨県南巨摩郡";
    case 19364: return "山梨県南巨摩郡早川町";
    case 19365: return "山梨県南巨摩郡身延町";
    case 19366: return "山梨県南巨摩郡南部町";
    case 19368: return "山梨県南巨摩郡富士川町";
    case 19380: return "山梨県中巨摩郡";
    case 19384: return "山梨県中巨摩郡昭和町";
    case 19420: return "山梨県南都留郡";
    case 19422: return "山梨県南都留郡道志村";
    case 19423: return "山梨県南都留郡西桂町";
    case 19424: return "山梨県南都留郡忍野村";
    case 19425: return "山梨県南都留郡山中湖村";
    case 19429: return "山梨県南都留郡鳴沢村";
    case 19430: return "山梨県南都留郡富士河口湖町";
    case 19440: return "山梨県北都留郡";
    case 19442: return "山梨県北都留郡小菅村";
    case 19443: return "山梨県北都留郡丹波山村";
    case 20000: return "長野県";
    case 20201: return "長野県長野市";
    case 20202: return "長野県松本市";
    case 20203: return "長野県上田市";
    case 20204: return "長野県岡谷市";
    case 20205: return "長野県飯田市";
    case 20206: return "長野県諏訪市";
    case 20207: return "長野県須坂市";
    case 20208: return "長野県小諸市";
    case 20209: return "長野県伊那市";
    case 20210: return "長野県駒ヶ根市";
    case 20211: return "長野県中野市";
    case 20212: return "長野県大町市";
    case 20213: return "長野県飯山市";
    case 20214: return "長野県茅野市";
    case 20215: return "長野県塩尻市";
    case 20217: return "長野県佐久市";
    case 20218: return "長野県千曲市";
    case 20219: return "長野県東御市";
    case 20220: return "長野県安曇野市";
    case 20300: return "長野県南佐久郡";
    case 20303: return "長野県南佐久郡小海町";
    case 20304: return "長野県南佐久郡川上村";
    case 20305: return "長野県南佐久郡南牧村";
    case 20306: return "長野県南佐久郡南相木村";
    case 20307: return "長野県南佐久郡北相木村";
    case 20309: return "長野県南佐久郡佐久穂町";
    case 20320: return "長野県北佐久郡";
    case 20321: return "長野県北佐久郡軽井沢町";
    case 20323: return "長野県北佐久郡御代田町";
    case 20324: return "長野県北佐久郡立科町";
    case 20340: return "長野県小県郡";
    case 20349: return "長野県小県郡青木村";
    case 20350: return "長野県小県郡長和町";
    case 20360: return "長野県諏訪郡";
    case 20361: return "長野県諏訪郡下諏訪町";
    case 20362: return "長野県諏訪郡富士見町";
    case 20363: return "長野県諏訪郡原村";
    case 20380: return "長野県上伊那郡";
    case 20382: return "長野県上伊那郡辰野町";
    case 20383: return "長野県上伊那郡箕輪町";
    case 20384: return "長野県上伊那郡飯島町";
    case 20385: return "長野県上伊那郡南箕輪村";
    case 20386: return "長野県上伊那郡中川村";
    case 20388: return "長野県上伊那郡宮田村";
    case 20400: return "長野県下伊那郡";
    case 20402: return "長野県下伊那郡松川町";
    case 20403: return "長野県下伊那郡高森町";
    case 20404: return "長野県下伊那郡阿南町";
    case 20407: return "長野県下伊那郡阿智村";
    case 20409: return "長野県下伊那郡平谷村";
    case 20410: return "長野県下伊那郡根羽村";
    case 20411: return "長野県下伊那郡下條村";
    case 20412: return "長野県下伊那郡売木村";
    case 20413: return "長野県下伊那郡天龍村";
    case 20414: return "長野県下伊那郡泰阜村";
    case 20415: return "長野県下伊那郡喬木村";
    case 20416: return "長野県下伊那郡豊丘村";
    case 20417: return "長野県下伊那郡大鹿村";
    case 20420: return "長野県木曽郡";
    case 20422: return "長野県木曽郡上松町";
    case 20423: return "長野県木曽郡南木曽町";
    case 20425: return "長野県木曽郡木祖村";
    case 20429: return "長野県木曽郡王滝村";
    case 20430: return "長野県木曽郡大桑村";
    case 20432: return "長野県木曽郡木曽町";
    case 20440: return "長野県東筑摩郡";
    case 20446: return "長野県東筑摩郡麻績村";
    case 20448: return "長野県東筑摩郡生坂村";
    case 20450: return "長野県東筑摩郡山形村";
    case 20451: return "長野県東筑摩郡朝日村";
    case 20452: return "長野県東筑摩郡筑北村";
    case 20480: return "長野県北安曇郡";
    case 20481: return "長野県北安曇郡池田町";
    case 20482: return "長野県北安曇郡松川村";
    case 20485: return "長野県北安曇郡白馬村";
    case 20486: return "長野県北安曇郡小谷村";
    case 20520: return "長野県埴科郡";
    case 20521: return "長野県埴科郡坂城町";
    case 20540: return "長野県上高井郡";
    case 20541: return "長野県上高井郡小布施町";
    case 20543: return "長野県上高井郡高山村";
    case 20560: return "長野県下高井郡";
    case 20561: return "長野県下高井郡山ノ内町";
    case 20562: return "長野県下高井郡木島平村";
    case 20563: return "長野県下高井郡野沢温泉村";
    case 20580: return "長野県上水内郡";
    case 20583: return "長野県上水内郡信濃町";
    case 20588: return "長野県上水内郡小川村";
    case 20590: return "長野県上水内郡飯綱町";
    case 20600: return "長野県下水内郡";
    case 20602: return "長野県下水内郡栄村";
    case 21000: return "岐阜県";
    case 21201: return "岐阜県岐阜市";
    case 21202: return "岐阜県大垣市";
    case 21203: return "岐阜県高山市";
    case 21204: return "岐阜県多治見市";
    case 21205: return "岐阜県関市";
    case 21206: return "岐阜県中津川市";
    case 21207: return "岐阜県美濃市";
    case 21208: return "岐阜県瑞浪市";
    case 21209: return "岐阜県羽島市";
    case 21210: return "岐阜県恵那市";
    case 21211: return "岐阜県美濃加茂市";
    case 21212: return "岐阜県土岐市";
    case 21213: return "岐阜県各務原市";
    case 21214: return "岐阜県可児市";
    case 21215: return "岐阜県山県市";
    case 21216: return "岐阜県瑞穂市";
    case 21217: return "岐阜県飛騨市";
    case 21218: return "岐阜県本巣市";
    case 21219: return "岐阜県郡上市";
    case 21220: return "岐阜県下呂市";
    case 21221: return "岐阜県海津市";
    case 21300: return "岐阜県羽島郡";
    case 21302: return "岐阜県羽島郡岐南町";
    case 21303: return "岐阜県羽島郡笠松町";
    case 21340: return "岐阜県養老郡";
    case 21341: return "岐阜県養老郡養老町";
    case 21360: return "岐阜県不破郡";
    case 21361: return "岐阜県不破郡垂井町";
    case 21362: return "岐阜県不破郡関ケ原町";
    case 21380: return "岐阜県安八郡";
    case 21381: return "岐阜県安八郡神戸町";
    case 21382: return "岐阜県安八郡輪之内町";
    case 21383: return "岐阜県安八郡安八町";
    case 21400: return "岐阜県揖斐郡";
    case 21401: return "岐阜県揖斐郡揖斐川町";
    case 21403: return "岐阜県揖斐郡大野町";
    case 21404: return "岐阜県揖斐郡池田町";
    case 21420: return "岐阜県本巣郡";
    case 21421: return "岐阜県本巣郡北方町";
    case 21500: return "岐阜県加茂郡";
    case 21501: return "岐阜県加茂郡坂祝町";
    case 21502: return "岐阜県加茂郡富加町";
    case 21503: return "岐阜県加茂郡川辺町";
    case 21504: return "岐阜県加茂郡七宗町";
    case 21505: return "岐阜県加茂郡八百津町";
    case 21506: return "岐阜県加茂郡白川町";
    case 21507: return "岐阜県加茂郡東白川村";
    case 21520: return "岐阜県可児郡";
    case 21521: return "岐阜県可児郡御嵩町";
    case 21600: return "岐阜県大野郡";
    case 21604: return "岐阜県大野郡白川村";
    case 22000: return "静岡県";
    case 22100: return "静岡県静岡市";
    case 22101: return "静岡県静岡市葵区";
    case 22102: return "静岡県静岡市駿河区";
    case 22103: return "静岡県静岡市清水区";
    case 22130: return "静岡県浜松市";
    case 22138: return "静岡県浜松市中央区";
    case 22139: return "静岡県浜松市浜名区";
    case 22140: return "静岡県浜松市天竜区";
    case 22203: return "静岡県沼津市";
    case 22205: return "静岡県熱海市";
    case 22206: return "静岡県三島市";
    case 22207: return "静岡県富士宮市";
    case 22208: return "静岡県伊東市";
    case 22209: return "静岡県島田市";
    case 22210: return "静岡県富士市";
    case 22211: return "静岡県磐田市";
    case 22212: return "静岡県焼津市";
    case 22213: return "静岡県掛川市";
    case 22214: return "静岡県藤枝市";
    case 22215: return "静岡県御殿場市";
    case 22216: return "静岡県袋井市";
    case 22219: return "静岡県下田市";
    case 22220: return "静岡県裾野市";
    case 22221: return "静岡県湖西市";
    case 22222: return "静岡県伊豆市";
    case 22223: return "静岡県御前崎市";
    case 22224: return "静岡県菊川市";
    case 22225: return "静岡県伊豆の国市";
    case 22226: return "静岡県牧之原市";
    case 22300: return "静岡県賀茂郡";
    case 22301: return "静岡県賀茂郡東伊豆町";
    case 22302: return "静岡県賀茂郡河津町";
    case 22304: return "静岡県賀茂郡南伊豆町";
    case 22305: return "静岡県賀茂郡松崎町";
    case 22306: return "静岡県賀茂郡西伊豆町";
    case 22320: return "静岡県田方郡";
    case 22325: return "静岡県田方郡函南町";
    case 22340: return "静岡県駿東郡";
    case 22341: return "静岡県駿東郡清水町";
    case 22342: return "静岡県駿東郡長泉町";
    case 22344: return "静岡県駿東郡小山町";
    case 22420: return "静岡県榛原郡";
    case 22424: return "静岡県榛原郡吉田町";
    case 22429: return "静岡県榛原郡川根本町";
    case 22460: return "静岡県周智郡";
    case 22461: return "静岡県周智郡森町";
    case 23000: return "愛知県";
    case 23100: return "愛知県名古屋市";
    case 23101: return "愛知県名古屋市千種区";
    case 23102: return "愛知県名古屋市東区";
    case 23103: return "愛知県名古屋市北区";
    case 23104: return "愛知県名古屋市西区";
    case 23105: return "愛知県名古屋市中村区";
    case 23106: return "愛知県名古屋市中区";
    case 23107: return "愛知県名古屋市昭和区";
    case 23108: return "愛知県名古屋市瑞穂区";
    case 23109: return "愛知県名古屋市熱田区";
    case 23110: return "愛知県名古屋市中川区";
    case 23111: return "愛知県名古屋市港区";
    case 23112: return "愛知県名古屋市南区";
    case 23113: return "愛知県名古屋市守山区";
    case 23114: return "愛知県名古屋市緑区";
    case 23115: return "愛知県名古屋市名東区";
    case 23116: return "愛知県名古屋市天白区";
    case 23201: return "愛知県豊橋市";
    case 23202: return "愛知県岡崎市";
    case 23203: return "愛知県一宮市";
    case 23204: return "愛知県瀬戸市";
    case 23205: return "愛知県半田市";
    case 23206: return "愛知県春日井市";
    case 23207: return "愛知県豊川市";
    case 23208: return "愛知県津島市";
    case 23209: return "愛知県碧南市";
    case 23210: return "愛知県刈谷市";
    case 23211: return "愛知県豊田市";
    case 23212: return "愛知県安城市";
    case 23213: return "愛知県西尾市";
    case 23214: return "愛知県蒲郡市";
    case 23215: return "愛知県犬山市";
    case 23216: return "愛知県常滑市";
    case 23217: return "愛知県江南市";
    case 23219: return "愛知県小牧市";
    case 23220: return "愛知県稲沢市";
    case 23221: return "愛知県新城市";
    case 23222: return "愛知県東海市";
    case 23223: return "愛知県大府市";
    case 23224: return "愛知県知多市";
    case 23225: return "愛知県知立市";
    case 23226: return "愛知県尾張旭市";
    case 23227: return "愛知県高浜市";
    case 23228: return "愛知県岩倉市";
    case 23229: return "愛知県豊明市";
    case 23230: return "愛知県日進市";
    case 23231: return "愛知県田原市";
    case 23232: return "愛知県愛西市";
    case 23233: return "愛知県清須市";
    case 23234: return "愛知県北名古屋市";
    case 23235: return "愛知県弥富市";
    case 23236: return "愛知県みよし市";
    case 23237: return "愛知県あま市";
    case 23238: return "愛知県長久手市";
    case 23300: return "愛知県愛知郡";
    case 23302: return "愛知県愛知郡東郷町";
    case 23340: return "愛知県西春日井郡";
    case 23342: return "愛知県西春日井郡豊山町";
    case 23360: return "愛知県丹羽郡";
    case 23361: return "愛知県丹羽郡大口町";
    case 23362: return "愛知県丹羽郡扶桑町";
    case 23420: return "愛知県海部郡";
    case 23424: return "愛知県海部郡大治町";
    case 23425: return "愛知県海部郡蟹江町";
    case 23427: return "愛知県海部郡飛島村";
    case 23440: return "愛知県知多郡";
    case 23441: return "愛知県知多郡阿久比町";
    case 23442: return "愛知県知多郡東浦町";
    case 23445: return "愛知県知多郡南知多町";
    case 23446: return "愛知県知多郡美浜町";
    case 23447: return "愛知県知多郡武豊町";
    case 23500: return "愛知県額田郡";
    case 23501: return "愛知県額田郡幸田町";
    case 23560: return "愛知県北設楽郡";
    case 23561: return "愛知県北設楽郡設楽町";
    case 23562: return "愛知県北設楽郡東栄町";
    case 23563: return "愛知県北設楽郡豊根村";
    case 24000: return "三重県";
    case 24201: return "三重県津市";
    case 24202: return "三重県四日市市";
    case 24203: return "三重県伊勢市";
    case 24204: return "三重県松阪市";
    case 24205: return "三重県桑名市";
    case 24207: return "三重県鈴鹿市";
    case 24208: return "三重県名張市";
    case 24209: return "三重県尾鷲市";
    case 24210: return "三重県亀山市";
    case 24211: return "三重県鳥羽市";
    case 24212: return "三重県熊野市";
    case 24214: return "三重県いなべ市";
    case 24215: return "三重県志摩市";
    case 24216: return "三重県伊賀市";
    case 24300: return "三重県桑名郡";
    case 24303: return "三重県桑名郡木曽岬町";
    case 24320: return "三重県員弁郡";
    case 24324: return "三重県員弁郡東員町";
    case 24340: return "三重県三重郡";
    case 24341: return "三重県三重郡菰野町";
    case 24343: return "三重県三重郡朝日町";
    case 24344: return "三重県三重郡川越町";
    case 24440: return "三重県多気郡";
    case 24441: return "三重県多気郡多気町";
    case 24442: return "三重県多気郡明和町";
    case 24443: return "三重県多気郡大台町";
    case 24460: return "三重県度会郡";
    case 24461: return "三重県度会郡玉城町";
    case 24470: return "三重県度会郡度会町";
    case 24471: return "三重県度会郡大紀町";
    case 24472: return "三重県度会郡南伊勢町";
    case 24540: return "三重県北牟婁郡";
    case 24543: return "三重県北牟婁郡紀北町";
    case 24560: return "三重県南牟婁郡";
    case 24561: return "三重県南牟婁郡御浜町";
    case 24562: return "三重県南牟婁郡紀宝町";
    case 25000: return "滋賀県";
    case 25201: return "滋賀県大津市";
    case 25202: return "滋賀県彦根市";
    case 25203: return "滋賀県長浜市";
    case 25204: return "滋賀県近江八幡市";
    case 25206: return "滋賀県草津市";
    case 25207: return "滋賀県守山市";
    case 25208: return "滋賀県栗東市";
    case 25209: return "滋賀県甲賀市";
    case 25210: return "滋賀県野洲市";
    case 25211: return "滋賀県湖南市";
    case 25212: return "滋賀県高島市";
    case 25213: return "滋賀県東近江市";
    case 25214: return "滋賀県米原市";
    case 25380: return "滋賀県蒲生郡";
    case 25383: return "滋賀県蒲生郡日野町";
    case 25384: return "滋賀県蒲生郡竜王町";
    case 25420: return "滋賀県愛知郡";
    case 25425: return "滋賀県愛知郡愛荘町";
    case 25440: return "滋賀県犬上郡";
    case 25441: return "滋賀県犬上郡豊郷町";
    case 25442: return "滋賀県犬上郡甲良町";
    case 25443: return "滋賀県犬上郡多賀町";
    case 26000: return "京都府";
    case 26100: return "京都府京都市";
    case 26101: return "京都府京都市北区";
    case 26102: return "京都府京都市上京区";
    case 26103: return "京都府京都市左京区";
    case 26104: return "京都府京都市中京区";
    case 26105: return "京都府京都市東山区";
    case 26106: return "京都府京都市下京区";
    case 26107: return "京都府京都市南区";
    case 26108: return "京都府京都市右京区";
    case 26109: return "京都府京都市伏見区";
    case 26110: return "京都府京都市山科区";
    case 26111: return "京都府京都市西京区";
    case 26201: return "京都府福知山市";
    case 26202: return "京都府舞鶴市";
    case 26203: return "京都府綾部市";
    case 26204: return "京都府宇治市";
    case 26205: return "京都府宮津市";
    case 26206: return "京都府亀岡市";
    case 26207: return "京都府城陽市";
    case 26208: return "京都府向日市";
    case 26209: return "京都府長岡京市";
    case 26210: return "京都府八幡市";
    case 26211: return "京都府京田辺市";
    case 26212: return "京都府京丹後市";
    case 26213: return "京都府南丹市";
    case 26214: return "京都府木津川市";
    case 26300: return "京都府乙訓郡";
    case 26303: return "京都府乙訓郡大山崎町";
    case 26320: return "京都府久世郡";
    case 26322: return "京都府久世郡久御山町";
    case 26340: return "京都府綴喜郡";
    case 26343: return "京都府綴喜郡井手町";
    case 26344: return "京都府綴喜郡宇治田原町";
    case 26360: return "京都府相楽郡";
    case 26364: return "京都府相楽郡笠置町";
    case 26365: return "京都府相楽郡和束町";
    case 26366: return "京都府相楽郡精華町";
    case 26367: return "京都府相楽郡南山城村";
    case 26400: return "京都府船井郡";
    case 26407: return "京都府船井郡京丹波町";
    case 26460: return "京都府与謝郡";
    case 26463: return "京都府与謝郡伊根町";
    case 26465: return "京都府与謝郡与謝野町";
    case 27000: return "大阪府";
    case 27100: return "大阪府大阪市";
    case 27102: return "大阪府大阪市都島区";
    case 27103: return "大阪府大阪市福島区";
    case 27104: return "大阪府大阪市此花区";
    case 27106: return "大阪府大阪市西区";
    case 27107: return "大阪府大阪市港区";
    case 27108: return "大阪府大阪市大正区";
    case 27109: return "大阪府大阪市天王寺区";
    case 27111: return "大阪府大阪市浪速区";
    case 27113: return "大阪府大阪市西淀川区";
    case 27114: return "大阪府大阪市東淀川区";
    case 27115: return "大阪府大阪市東成区";
    case 27116: return "大阪府大阪市生野区";
    case 27117: return "大阪府大阪市旭区";
    case 27118: return "大阪府大阪市城東区";
    case 27119: return "大阪府大阪市阿倍野区";
    case 27120: return "大阪府大阪市住吉区";
    case 27121: return "大阪府大阪市東住吉区";
    case 27122: return "大阪府大阪市西成区";
    case 27123: return "大阪府大阪市淀川区";
    case 27124: return "大阪府大阪市鶴見区";
    case 27125: return "大阪府大阪市住之江区";
    case 27126: return "大阪府大阪市平野区";
    case 27127: return "大阪府大阪市北区";
    case 27128: return "大阪府大阪市中央区";
    case 27140: return "大阪府堺市";
    case 27141: return "大阪府堺市堺区";
    case 27142: return "大阪府堺市中区";
    case 27143: return "大阪府堺市東区";
    case 27144: return "大阪府堺市西区";
    case 27145: return "大阪府堺市南区";
    case 27146: return "大阪府堺市北区";
    case 27147: return "大阪府堺市美原区";
    case 27202: return "大阪府岸和田市";
    case 27203: return "大阪府豊中市";
    case 27204: return "大阪府池田市";
    case 27205: return "大阪府吹田市";
    case 27206: return "大阪府泉大津市";
    case 27207: return "大阪府高槻市";
    case 27208: return "大阪府貝塚市";
    case 27209: return "大阪府守口市";
    case 27210: return "大阪府枚方市";
    case 27211: return "大阪府茨木市";
    case 27212: return "大阪府八尾市";
    case 27213: return "大阪府泉佐野市";
    case 27214: return "大阪府富田林市";
    case 27215: return "大阪府寝屋川市";
    case 27216: return "大阪府河内長野市";
    case 27217: return "大阪府松原市";
    case 27218: return "大阪府大東市";
    case 27219: return "大阪府和泉市";
    case 27220: return "大阪府箕面市";
    case 27221: return "大阪府柏原市";
    case 27222: return "大阪府羽曳野市";
    case 27223: return "大阪府門真市";
    case 27224: return "大阪府摂津市";
    case 27225: return "大阪府高石市";
    case 27226: return "大阪府藤井寺市";
    case 27227: return "大阪府東大阪市";
    case 27228: return "大阪府泉南市";
    case 27229: return "大阪府四條畷市";
    case 27230: return "大阪府交野市";
    case 27231: return "大阪府大阪狭山市";
    case 27232: return "大阪府阪南市";
    case 27300: return "大阪府三島郡";
    case 27301: return "大阪府三島郡島本町";
    case 27320: return "大阪府豊能郡";
    case 27321: return "大阪府豊能郡豊能町";
    case 27322: return "大阪府豊能郡能勢町";
    case 27340: return "大阪府泉北郡";
    case 27341: return "大阪府泉北郡忠岡町";
    case 27360: return "大阪府泉南郡";
    case 27361: return "大阪府泉南郡熊取町";
    case 27362: return "大阪府泉南郡田尻町";
    case 27366: return "大阪府泉南郡岬町";
    case 27380: return "大阪府南河内郡";
    case 27381: return "大阪府南河内郡太子町";
    case 27382: return "大阪府南河内郡河南町";
    case 27383: return "大阪府南河内郡千早赤阪村";
    case 28000: return "兵庫県";
    case 28100: return "兵庫県神戸市";
    case 28101: return "兵庫県神戸市東灘区";
    case 28102: return "兵庫県神戸市灘区";
    case 28105: return "兵庫県神戸市兵庫区";
    case 28106: return "兵庫県神戸市長田区";
    case 28107: return "兵庫県神戸市須磨区";
    case 28108: return "兵庫県神戸市垂水区";
    case 28109: return "兵庫県神戸市北区";
    case 28110: return "兵庫県神戸市中央区";
    case 28111: return "兵庫県神戸市西区";
    case 28201: return "兵庫県姫路市";
    case 28202: return "兵庫県尼崎市";
    case 28203: return "兵庫県明石市";
    case 28204: return "兵庫県西宮市";
    case 28205: return "兵庫県洲本市";
    case 28206: return "兵庫県芦屋市";
    case 28207: return "兵庫県伊丹市";
    case 28208: return "兵庫県相生市";
    case 28209: return "兵庫県豊岡市";
    case 28210: return "兵庫県加古川市";
    case 28212: return "兵庫県赤穂市";
    case 28213: return "兵庫県西脇市";
    case 28214: return "兵庫県宝塚市";
    case 28215: return "兵庫県三木市";
    case 28216: return "兵庫県高砂市";
    case 28217: return "兵庫県川西市";
    case 28218: return "兵庫県小野市";
    case 28219: return "兵庫県三田市";
    case 28220: return "兵庫県加西市";
    case 28221: return "兵庫県丹波篠山市";
    case 28222: return "兵庫県養父市";
    case 28223: return "兵庫県丹波市";
    case 28224: return "兵庫県南あわじ市";
    case 28225: return "兵庫県朝来市";
    case 28226: return "兵庫県淡路市";
    case 28227: return "兵庫県宍粟市";
    case 28228: return "兵庫県加東市";
    case 28229: return "兵庫県たつの市";
    case 28300: return "兵庫県川辺郡";
    case 28301: return "兵庫県川辺郡猪名川町";
    case 28360: return "兵庫県多可郡";
    case 28365: return "兵庫県多可郡多可町";
    case 28380: return "兵庫県加古郡";
    case 28381: return "兵庫県加古郡稲美町";
    case 28382: return "兵庫県加古郡播磨町";
    case 28440: return "兵庫県神崎郡";
    case 28442: return "兵庫県神崎郡市川町";
    case 28443: return "兵庫県神崎郡福崎町";
    case 28446: return "兵庫県神崎郡神河町";
    case 28460: return "兵庫県揖保郡";
    case 28464: return "兵庫県揖保郡太子町";
    case 28480: return "兵庫県赤穂郡";
    case 28481: return "兵庫県赤穂郡上郡町";
    case 28500: return "兵庫県佐用郡";
    case 28501: return "兵庫県佐用郡佐用町";
    case 28580: return "兵庫県美方郡";
    case 28585: return "兵庫県美方郡香美町";
    case 28586: return "兵庫県美方郡新温泉町";
    case 29000: return "奈良県";
    case 29201: return "奈良県奈良市";
    case 29202: return "奈良県大和高田市";
    case 29203: return "奈良県大和郡山市";
    case 29204: return "奈良県天理市";
    case 29205: return "奈良県橿原市";
    case 29206: return "奈良県桜井市";
    case 29207: return "奈良県五條市";
    case 29208: return "奈良県御所市";
    case 29209: return "奈良県生駒市";
    case 29210: return "奈良県香芝市";
    case 29211: return "奈良県葛城市";
    case 29212: return "奈良県宇陀市";
    case 29320: return "奈良県山辺郡";
    case 29322: return "奈良県山辺郡山添村";
    case 29340: return "奈良県生駒郡";
    case 29342: return "奈良県生駒郡平群町";
    case 29343: return "奈良県生駒郡三郷町";
    case 29344: return "奈良県生駒郡斑鳩町";
    case 29345: return "奈良県生駒郡安堵町";
    case 29360: return "奈良県磯城郡";
    case 29361: return "奈良県磯城郡川西町";
    case 29362: return "奈良県磯城郡三宅町";
    case 29363: return "奈良県磯城郡田原本町";
    case 29380: return "奈良県宇陀郡";
    case 29385: return "奈良県宇陀郡曽爾村";
    case 29386: return "奈良県宇陀郡御杖村";
    case 29400: return "奈良県高市郡";
    case 29401: return "奈良県高市郡高取町";
    case 29402: return "奈良県高市郡明日香村";
    case 29420: return "奈良県北葛城郡";
    case 29424: return "奈良県北葛城郡上牧町";
    case 29425: return "奈良県北葛城郡王寺町";
    case 29426: return "奈良県北葛城郡広陵町";
    case 29427: return "奈良県北葛城郡河合町";
    case 29440: return "奈良県吉野郡";
    case 29441: return "奈良県吉野郡吉野町";
    case 29442: return "奈良県吉野郡大淀町";
    case 29443: return "奈良県吉野郡下市町";
    case 29444: return "奈良県吉野郡黒滝村";
    case 29446: return "奈良県吉野郡天川村";
    case 29447: return "奈良県吉野郡野迫川村";
    case 29449: return "奈良県吉野郡十津川村";
    case 29450: return "奈良県吉野郡下北山村";
    case 29451: return "奈良県吉野郡上北山村";
    case 29452: return "奈良県吉野郡川上村";
    case 29453: return "奈良県吉野郡東吉野村";
    case 30000: return "和歌山県";
    case 30201: return "和歌山県和歌山市";
    case 30202: return "和歌山県海南市";
    case 30203: return "和歌山県橋本市";
    case 30204: return "和歌山県有田市";
    case 30205: return "和歌山県御坊市";
    case 30206: return "和歌山県田辺市";
    case 30207: return "和歌山県新宮市";
    case 30208: return "和歌山県紀の川市";
    case 30209: return "和歌山県岩出市";
    case 30300: return "和歌山県海草郡";
    case 30304: return "和歌山県海草郡紀美野町";
    case 30340: return "和歌山県伊都郡";
    case 30341: return "和歌山県伊都郡かつらぎ町";
    case 30343: return "和歌山県伊都郡九度山町";
    case 30344: return "和歌山県伊都郡高野町";
    case 30360: return "和歌山県有田郡";
    case 30361: return "和歌山県有田郡湯浅町";
    case 30362: return "和歌山県有田郡広川町";
    case 30366: return "和歌山県有田郡有田川町";
    case 30380: return "和歌山県日高郡";
    case 30381: return "和歌山県日高郡美浜町";
    case 30382: return "和歌山県日高郡日高町";
    case 30383: return "和歌山県日高郡由良町";
    case 30390: return "和歌山県日高郡印南町";
    case 30391: return "和歌山県日高郡みなべ町";
    case 30392: return "和歌山県日高郡日高川町";
    case 30400: return "和歌山県西牟婁郡";
    case 30401: return "和歌山県西牟婁郡白浜町";
    case 30404: return "和歌山県西牟婁郡上富田町";
    case 30406: return "和歌山県西牟婁郡すさみ町";
    case 30420: return "和歌山県東牟婁郡";
    case 30421: return "和歌山県東牟婁郡那智勝浦町";
    case 30422: return "和歌山県東牟婁郡太地町";
    case 30424: return "和歌山県東牟婁郡古座川町";
    case 30427: return "和歌山県東牟婁郡北山村";
    case 30428: return "和歌山県東牟婁郡串本町";
    case 31000: return "鳥取県";
    case 31201: return "鳥取県鳥取市";
    case 31202: return "鳥取県米子市";
    case 31203: return "鳥取県倉吉市";
    case 31204: return "鳥取県境港市";
    case 31300: return "鳥取県岩美郡";
    case 31302: return "鳥取県岩美郡岩美町";
    case 31320: return "鳥取県八頭郡";
    case 31325: return "鳥取県八頭郡若桜町";
    case 31328: return "鳥取県八頭郡智頭町";
    case 31329: return "鳥取県八頭郡八頭町";
    case 31360: return "鳥取県東伯郡";
    case 31364: return "鳥取県東伯郡三朝町";
    case 31370: return "鳥取県東伯郡湯梨浜町";
    case 31371: return "鳥取県東伯郡琴浦町";
    case 31372: return "鳥取県東伯郡北栄町";
    case 31380: return "鳥取県西伯郡";
    case 31384: return "鳥取県西伯郡日吉津村";
    case 31386: return "鳥取県西伯郡大山町";
    case 31389: return "鳥取県西伯郡南部町";
    case 31390: return "鳥取県西伯郡伯耆町";
    case 31400: return "鳥取県日野郡";
    case 31401: return "鳥取県日野郡日南町";
    case 31402: return "鳥取県日野郡日野町";
    case 31403: return "鳥取県日野郡江府町";
    case 32000: return "島根県";
    case 32201: return "島根県松江市";
    case 32202: return "島根県浜田市";
    case 32203: return "島根県出雲市";
    case 32204: return "島根県益田市";
    case 32205: return "島根県大田市";
    case 32206: return "島根県安来市";
    case 32207: return "島根県江津市";
    case 32209: return "島根県雲南市";
    case 32340: return "島根県仁多郡";
    case 32343: return "島根県仁多郡奥出雲町";
    case 32380: return "島根県飯石郡";
    case 32386: return "島根県飯石郡飯南町";
    case 32440: return "島根県邑智郡";
    case 32441: return "島根県邑智郡川本町";
    case 32448: return "島根県邑智郡美郷町";
    case 32449: return "島根県邑智郡邑南町";
    case 32500: return "島根県鹿足郡";
    case 32501: return "島根県鹿足郡津和野町";
    case 32505: return "島根県鹿足郡吉賀町";
    case 32520: return "島根県隠岐郡";
    case 32525: return "島根県隠岐郡海士町";
    case 32526: return "島根県隠岐郡西ノ島町";
    case 32527: return "島根県隠岐郡知夫村";
    case 32528: return "島根県隠岐郡隠岐の島町";
    case 33000: return "岡山県";
    case 33100: return "岡山県岡山市";
    case 33101: return "岡山県岡山市北区";
    case 33102: return "岡山県岡山市中区";
    case 33103: return "岡山県岡山市東区";
    case 33104: return "岡山県岡山市南区";
    case 33202: return "岡山県倉敷市";
    case 33203: return "岡山県津山市";
    case 33204: return "岡山県玉野市";
    case 33205: return "岡山県笠岡市";
    case 33207: return "岡山県井原市";
    case 33208: return "岡山県総社市";
    case 33209: return "岡山県高梁市";
    case 33210: return "岡山県新見市";
    case 33211: return "岡山県備前市";
    case 33212: return "岡山県瀬戸内市";
    case 33213: return "岡山県赤磐市";
    case 33214: return "岡山県真庭市";
    case 33215: return "岡山県美作市";
    case 33216: return "岡山県浅口市";
    case 33340: return "岡山県和気郡";
    case 33346: return "岡山県和気郡和気町";
    case 33420: return "岡山県都窪郡";
    case 33423: return "岡山県都窪郡早島町";
    case 33440: return "岡山県浅口郡";
    case 33445: return "岡山県浅口郡里庄町";
    case 33460: return "岡山県小田郡";
    case 33461: return "岡山県小田郡矢掛町";
    case 33580: return "岡山県真庭郡";
    case 33586: return "岡山県真庭郡新庄村";
    case 33600: return "岡山県苫田郡";
    case 33606: return "岡山県苫田郡鏡野町";
    case 33620: return "岡山県勝田郡";
    case 33622: return "岡山県勝田郡勝央町";
    case 33623: return "岡山県勝田郡奈義町";
    case 33640: return "岡山県英田郡";
    case 33643: return "岡山県英田郡西粟倉村";
    case 33660: return "岡山県久米郡";
    case 33663: return "岡山県久米郡久米南町";
    case 33666: return "岡山県久米郡美咲町";
    case 33680: return "岡山県加賀郡";
    case 33681: return "岡山県加賀郡吉備中央町";
    case 34000: return "広島県";
    case 34100: return "広島県広島市";
    case 34101: return "広島県広島市中区";
    case 34102: return "広島県広島市東区";
    case 34103: return "広島県広島市南区";
    case 34104: return "広島県広島市西区";
    case 34105: return "広島県広島市安佐南区";
    case 34106: return "広島県広島市安佐北区";
    case 34107: return "広島県広島市安芸区";
    case 34108: return "広島県広島市佐伯区";
    case 34202: return "広島県呉市";
    case 34203: return "広島県竹原市";
    case 34204: return "広島県三原市";
    case 34205: return "広島県尾道市";
    case 34207: return "広島県福山市";
    case 34208: return "広島県府中市";
    case 34209: return "広島県三次市";
    case 34210: return "広島県庄原市";
    case 34211: return "広島県大竹市";
    case 34212: return "広島県東広島市";
    case 34213: return "広島県廿日市市";
    case 34214: return "広島県安芸高田市";
    case 34215: return "広島県江田島市";
    case 34300: return "広島県安芸郡";
    case 34302: return "広島県安芸郡府中町";
    case 34304: return "広島県安芸郡海田町";
    case 34307: return "広島県安芸郡熊野町";
    case 34309: return "広島県安芸郡坂町";
    case 34360: return "広島県山県郡";
    case 34368: return "広島県山県郡安芸太田町";
    case 34369: return "広島県山県郡北広島町";
    case 34420: return "広島県豊田郡";
    case 34431: return "広島県豊田郡大崎上島町";
    case 34460: return "広島県世羅郡";
    case 34462: return "広島県世羅郡世羅町";
    case 34540: return "広島県神石郡";
    case 34545: return "広島県神石郡神石高原町";
    case 35000: return "山口県";
    case 35201: return "山口県下関市";
    case 35202: return "山口県宇部市";
    case 35203: return "山口県山口市";
    case 35204: return "山口県萩市";
    case 35206: return "山口県防府市";
    case 35207: return "山口県下松市";
    case 35208: return "山口県岩国市";
    case 35210: return "山口県光市";
    case 35211: return "山口県長門市";
    case 35212: return "山口県柳井市";
    case 35213: return "山口県美祢市";
    case 35215: return "山口県周南市";
    case 35216: return "山口県山陽小野田市";
    case 35300: return "山口県大島郡";
    case 35305: return "山口県大島郡周防大島町";
    case 35320: return "山口県玖珂郡";
    case 35321: return "山口県玖珂郡和木町";
    case 35340: return "山口県熊毛郡";
    case 35341: return "山口県熊毛郡上関町";
    case 35343: return "山口県熊毛郡田布施町";
    case 35344: return "山口県熊毛郡平生町";
    case 35500: return "山口県阿武郡";
    case 35502: return "山口県阿武郡阿武町";
    case 36000: return "徳島県";
    case 36201: return "徳島県徳島市";
    case 36202: return "徳島県鳴門市";
    case 36203: return "徳島県小松島市";
    case 36204: return "徳島県阿南市";
    case 36205: return "徳島県吉野川市";
    case 36206: return "徳島県阿波市";
    case 36207: return "徳島県美馬市";
    case 36208: return "徳島県三好市";
    case 36300: return "徳島県勝浦郡";
    case 36301: return "徳島県勝浦郡勝浦町";
    case 36302: return "徳島県勝浦郡上勝町";
    case 36320: return "徳島県名東郡";
    case 36321: return "徳島県名東郡佐那河内村";
    case 36340: return "徳島県名西郡";
    case 36341: return "徳島県名西郡石井町";
    case 36342: return "徳島県名西郡神山町";
    case 36360: return "徳島県那賀郡";
    case 36368: return "徳島県那賀郡那賀町";
    case 36380: return "徳島県海部郡";
    case 36383: return "徳島県海部郡牟岐町";
    case 36387: return "徳島県海部郡美波町";
    case 36388: return "徳島県海部郡海陽町";
    case 36400: return "徳島県板野郡";
    case 36401: return "徳島県板野郡松茂町";
    case 36402: return "徳島県板野郡北島町";
    case 36403: return "徳島県板野郡藍住町";
    case 36404: return "徳島県板野郡板野町";
    case 36405: return "徳島県板野郡上板町";
    case 36460: return "徳島県美馬郡";
    case 36468: return "徳島県美馬郡つるぎ町";
    case 36480: return "徳島県三好郡";
    case 36489: return "徳島県三好郡東みよし町";
    case 37000: return "香川県";
    case 37201: return "香川県高松市";
    case 37202: return "香川県丸亀市";
    case 37203: return "香川県坂出市";
    case 37204: return "香川県善通寺市";
    case 37205: return "香川県観音寺市";
    case 37206: return "香川県さぬき市";
    case 37207: return "香川県東かがわ市";
    case 37208: return "香川県三豊市";
    case 37320: return "香川県小豆郡";
    case 37322: return "香川県小豆郡土庄町";
    case 37324: return "香川県小豆郡小豆島町";
    case 37340: return "香川県木田郡";
    case 37341: return "香川県木田郡三木町";
    case 37360: return "香川県香川郡";
    case 37364: return "香川県香川郡直島町";
    case 37380: return "香川県綾歌郡";
    case 37386: return "香川県綾歌郡宇多津町";
    case 37387: return "香川県綾歌郡綾川町";
    case 37400: return "香川県仲多度郡";
    case 37403: return "香川県仲多度郡琴平町";
    case 37404: return "香川県仲多度郡多度津町";
    case 37406: return "香川県仲多度郡まんのう町";
    case 38000: return "愛媛県";
    case 38201: return "愛媛県松山市";
    case 38202: return "愛媛県今治市";
    case 38203: return "愛媛県宇和島市";
    case 38204: return "愛媛県八幡浜市";
    case 38205: return "愛媛県新居浜市";
    case 38206: return "愛媛県西条市";
    case 38207: return "愛媛県大洲市";
    case 38210: return "愛媛県伊予市";
    case 38213: return "愛媛県四国中央市";
    case 38214: return "愛媛県西予市";
    case 38215: return "愛媛県東温市";
    case 38340: return "愛媛県越智郡";
    case 38356: return "愛媛県越智郡上島町";
    case 38380: return "愛媛県上浮穴郡";
    case 38386: return "愛媛県上浮穴郡久万高原町";
    case 38400: return "愛媛県伊予郡";
    case 38401: return "愛媛県伊予郡松前町";
    case 38402: return "愛媛県伊予郡砥部町";
    case 38420: return "愛媛県喜多郡";
    case 38422: return "愛媛県喜多郡内子町";
    case 38440: return "愛媛県西宇和郡";
    case 38442: return "愛媛県西宇和郡伊方町";
    case 38480: return "愛媛県北宇和郡";
    case 38484: return "愛媛県北宇和郡松野町";
    case 38488: return "愛媛県北宇和郡鬼北町";
    case 38500: return "愛媛県南宇和郡";
    case 38506: return "愛媛県南宇和郡愛南町";
    case 39000: return "高知県";
    case 39201: return "高知県高知市";
    case 39202: return "高知県室戸市";
    case 39203: return "高知県安芸市";
    case 39204: return "高知県南国市";
    case 39205: return "高知県土佐市";
    case 39206: return "高知県須崎市";
    case 39208: return "高知県宿毛市";
    case 39209: return "高知県土佐清水市";
    case 39210: return "高知県四万十市";
    case 39211: return "高知県香南市";
    case 39212: return "高知県香美市";
    case 39300: return "高知県安芸郡";
    case 39301: return "高知県安芸郡東洋町";
    case 39302: return "高知県安芸郡奈半利町";
    case 39303: return "高知県安芸郡田野町";
    case 39304: return "高知県安芸郡安田町";
    case 39305: return "高知県安芸郡北川村";
    case 39306: return "高知県安芸郡馬路村";
    case 39307: return "高知県安芸郡芸西村";
    case 39340: return "高知県長岡郡";
    case 39341: return "高知県長岡郡本山町";
    case 39344: return "高知県長岡郡大豊町";
    case 39360: return "高知県土佐郡";
    case 39363: return "高知県土佐郡土佐町";
    case 39364: return "高知県土佐郡大川村";
    case 39380: return "高知県吾川郡";
    case 39386: return "高知県吾川郡いの町";
    case 39387: return "高知県吾川郡仁淀川町";
    case 39400: return "高知県高岡郡";
    case 39401: return "高知県高岡郡中土佐町";
    case 39402: return "高知県高岡郡佐川町";
    case 39403: return "高知県高岡郡越知町";
    case 39405: return "高知県高岡郡檮原町";
    case 39410: return "高知県高岡郡日高村";
    case 39411: return "高知県高岡郡津野町";
    case 39412: return "高知県高岡郡四万十町";
    case 39420: return "高知県幡多郡";
    case 39424: return "高知県幡多郡大月町";
    case 39427: return "高知県幡多郡三原村";
    case 39428: return "高知県幡多郡黒潮町";
    case 40000: return "福岡県";
    case 40100: return "福岡県北九州市";
    case 40101: return "福岡県北九州市門司区";
    case 40103: return "福岡県北九州市若松区";
    case 40105: return "福岡県北九州市戸畑区";
    case 40106: return "福岡県北九州市小倉北区";
    case 40107: return "福岡県北九州市小倉南区";
    case 40108: return "福岡県北九州市八幡東区";
    case 40109: return "福岡県北九州市八幡西区";
    case 40130: return "福岡県福岡市";
    case 40131: return "福岡県福岡市東区";
    case 40132: return "福岡県福岡市博多区";
    case 40133: return "福岡県福岡市中央区";
    case 40134: return "福岡県福岡市南区";
    case 40135: return "福岡県福岡市西区";
    case 40136: return "福岡県福岡市城南区";
    case 40137: return "福岡県福岡市早良区";
    case 40202: return "福岡県大牟田市";
    case 40203: return "福岡県久留米市";
    case 40204: return "福岡県直方市";
    case 40205: return "福岡県飯塚市";
    case 40206: return "福岡県田川市";
    case 40207: return "福岡県柳川市";
    case 40210: return "福岡県八女市";
    case 40211: return "福岡県筑後市";
    case 40212: return "福岡県大川市";
    case 40213: return "福岡県行橋市";
    case 40214: return "福岡県豊前市";
    case 40215: return "福岡県中間市";
    case 40216: return "福岡県小郡市";
    case 40217: return "福岡県筑紫野市";
    case 40218: return "福岡県春日市";
    case 40219: return "福岡県大野城市";
    case 40220: return "福岡県宗像市";
    case 40221: return "福岡県太宰府市";
    case 40223: return "福岡県古賀市";
    case 40224: return "福岡県福津市";
    case 40225: return "福岡県うきは市";
    case 40226: return "福岡県宮若市";
    case 40227: return "福岡県嘉麻市";
    case 40228: return "福岡県朝倉市";
    case 40229: return "福岡県みやま市";
    case 40230: return "福岡県糸島市";
    case 40231: return "福岡県那珂川市";
    case 40340: return "福岡県糟屋郡";
    case 40341: return "福岡県糟屋郡宇美町";
    case 40342: return "福岡県糟屋郡篠栗町";
    case 40343: return "福岡県糟屋郡志免町";
    case 40344: return "福岡県糟屋郡須恵町";
    case 40345: return "福岡県糟屋郡新宮町";
    case 40348: return "福岡県糟屋郡久山町";
    case 40349: return "福岡県糟屋郡粕屋町";
    case 40380: return "福岡県遠賀郡";
    case 40381: return "福岡県遠賀郡芦屋町";
    case 40382: return "福岡県遠賀郡水巻町";
    case 40383: return "福岡県遠賀郡岡垣町";
    case 40384: return "福岡県遠賀郡遠賀町";
    case 40400: return "福岡県鞍手郡";
    case 40401: return "福岡県鞍手郡小竹町";
    case 40402: return "福岡県鞍手郡鞍手町";
    case 40420: return "福岡県嘉穂郡";
    case 40421: return "福岡県嘉穂郡桂川町";
    case 40440: return "福岡県朝倉郡";
    case 40447: return "福岡県朝倉郡筑前町";
    case 40448: return "福岡県朝倉郡東峰村";
    case 40500: return "福岡県三井郡";
    case 40503: return "福岡県三井郡大刀洗町";
    case 40520: return "福岡県三潴郡";
    case 40522: return "福岡県三潴郡大木町";
    case 40540: return "福岡県八女郡";
    case 40544: return "福岡県八女郡広川町";
    case 40600: return "福岡県田川郡";
    case 40601: return "福岡県田川郡香春町";
    case 40602: return "福岡県田川郡添田町";
    case 40604: return "福岡県田川郡糸田町";
    case 40605: return "福岡県田川郡川崎町";
    case 40608: return "福岡県田川郡大任町";
    case 40609: return "福岡県田川郡赤村";
    case 40610: return "福岡県田川郡福智町";
    case 40620: return "福岡県京都郡";
    case 40621: return "福岡県京都郡苅田町";
    case 40625: return "福岡県京都郡みやこ町";
    case 40640: return "福岡県築上郡";
    case 40642: return "福岡県築上郡吉富町";
    case 40646: return "福岡県築上郡上毛町";
    case 40647: return "福岡県築上郡築上町";
    case 41000: return "佐賀県";
    case 41201: return "佐賀県佐賀市";
    case 41202: return "佐賀県唐津市";
    case 41203: return "佐賀県鳥栖市";
    case 41204: return "佐賀県多久市";
    case 41205: return "佐賀県伊万里市";
    case 41206: return "佐賀県武雄市";
    case 41207: return "佐賀県鹿島市";
    case 41208: return "佐賀県小城市";
    case 41209: return "佐賀県嬉野市";
    case 41210: return "佐賀県神埼市";
    case 41320: return "佐賀県神埼郡";
    case 41327: return "佐賀県神埼郡吉野ヶ里町";
    case 41340: return "佐賀県三養基郡";
    case 41341: return "佐賀県三養基郡基山町";
    case 41345: return "佐賀県三養基郡上峰町";
    case 41346: return "佐賀県三養基郡みやき町";
    case 41380: return "佐賀県東松浦郡";
    case 41387: return "佐賀県東松浦郡玄海町";
    case 41400: return "佐賀県西松浦郡";
    case 41401: return "佐賀県西松浦郡有田町";
    case 41420: return "佐賀県杵島郡";
    case 41423: return "佐賀県杵島郡大町町";
    case 41424: return "佐賀県杵島郡江北町";
    case 41425: return "佐賀県杵島郡白石町";
    case 41440: return "佐賀県藤津郡";
    case 41441: return "佐賀県藤津郡太良町";
    case 42000: return "長崎県";
    case 42201: return "長崎県長崎市";
    case 42202: return "長崎県佐世保市";
    case 42203: return "長崎県島原市";
    case 42204: return "長崎県諫早市";
    case 42205: return "長崎県大村市";
    case 42207: return "長崎県平戸市";
    case 42208: return "長崎県松浦市";
    case 42209: return "長崎県対馬市";
    case 42210: return "長崎県壱岐市";
    case 42211: return "長崎県五島市";
    case 42212: return "長崎県西海市";
    case 42213: return "長崎県雲仙市";
    case 42214: return "長崎県南島原市";
    case 42300: return "長崎県西彼杵郡";
    case 42307: return "長崎県西彼杵郡長与町";
    case 42308: return "長崎県西彼杵郡時津町";
    case 42320: return "長崎県東彼杵郡";
    case 42321: return "長崎県東彼杵郡東彼杵町";
    case 42322: return "長崎県東彼杵郡川棚町";
    case 42323: return "長崎県東彼杵郡波佐見町";
    case 42380: return "長崎県北松浦郡";
    case 42383: return "長崎県北松浦郡小値賀町";
    case 42391: return "長崎県北松浦郡佐々町";
    case 42400: return "長崎県南松浦郡";
    case 42411: return "長崎県南松浦郡新上五島町";
    case 43000: return "熊本県";
    case 43100: return "熊本県熊本市";
    case 43101: return "熊本県熊本市中央区";
    case 43102: return "熊本県熊本市東区";
    case 43103: return "熊本県熊本市西区";
    case 43104: return "熊本県熊本市南区";
    case 43105: return "熊本県熊本市北区";
    case 43202: return "熊本県八代市";
    case 43203: return "熊本県人吉市";
    case 43204: return "熊本県荒尾市";
    case 43205: return "熊本県水俣市";
    case 43206: return "熊本県玉名市";
    case 43208: return "熊本県山鹿市";
    case 43210: return "熊本県菊池市";
    case 43211: return "熊本県宇土市";
    case 43212: return "熊本県上天草市";
    case 43213: return "熊本県宇城市";
    case 43214: return "熊本県阿蘇市";
    case 43215: return "熊本県天草市";
    case 43216: return "熊本県合志市";
    case 43340: return "熊本県下益城郡";
    case 43348: return "熊本県下益城郡美里町";
    case 43360: return "熊本県玉名郡";
    case 43364: return "熊本県玉名郡玉東町";
    case 43367: return "熊本県玉名郡南関町";
    case 43368: return "熊本県玉名郡長洲町";
    case 43369: return "熊本県玉名郡和水町";
    case 43400: return "熊本県菊池郡";
    case 43403: return "熊本県菊池郡大津町";
    case 43404: return "熊本県菊池郡菊陽町";
    case 43420: return "熊本県阿蘇郡";
    case 43423: return "熊本県阿蘇郡南小国町";
    case 43424: return "熊本県阿蘇郡小国町";
    case 43425: return "熊本県阿蘇郡産山村";
    case 43428: return "熊本県阿蘇郡高森町";
    case 43432: return "熊本県阿蘇郡西原村";
    case 43433: return "熊本県阿蘇郡南阿蘇村";
    case 43440: return "熊本県上益城郡";
    case 43441: return "熊本県上益城郡御船町";
    case 43442: return "熊本県上益城郡嘉島町";
    case 43443: return "熊本県上益城郡益城町";
    case 43444: return "熊本県上益城郡甲佐町";
    case 43447: return "熊本県上益城郡山都町";
    case 43460: return "熊本県八代郡";
    case 43468: return "熊本県八代郡氷川町";
    case 43480: return "熊本県葦北郡";
    case 43482: return "熊本県葦北郡芦北町";
    case 43484: return "熊本県葦北郡津奈木町";
    case 43500: return "熊本県球磨郡";
    case 43501: return "熊本県球磨郡錦町";
    case 43505: return "熊本県球磨郡多良木町";
    case 43506: return "熊本県球磨郡湯前町";
    case 43507: return "熊本県球磨郡水上村";
    case 43510: return "熊本県球磨郡相良村";
    case 43511: return "熊本県球磨郡五木村";
    case 43512: return "熊本県球磨郡山江村";
    case 43513: return "熊本県球磨郡球磨村";
    case 43514: return "熊本県球磨郡あさぎり町";
    case 43520: return "熊本県天草郡";
    case 43531: return "熊本県天草郡苓北町";
    case 44000: return "大分県";
    case 44201: return "大分県大分市";
    case 44202: return "大分県別府市";
    case 44203: return "大分県中津市";
    case 44204: return "大分県日田市";
    case 44205: return "大分県佐伯市";
    case 44206: return "大分県臼杵市";
    case 44207: return "大分県津久見市";
    case 44208: return "大分県竹田市";
    case 44209: return "大分県豊後高田市";
    case 44210: return "大分県杵築市";
    case 44211: return "大分県宇佐市";
    case 44212: return "大分県豊後大野市";
    case 44213: return "大分県由布市";
    case 44214: return "大分県国東市";
    case 44320: return "大分県東国東郡";
    case 44322: return "大分県東国東郡姫島村";
    case 44340: return "大分県速見郡";
    case 44341: return "大分県速見郡日出町";
    case 44460: return "大分県玖珠郡";
    case 44461: return "大分県玖珠郡九重町";
    case 44462: return "大分県玖珠郡玖珠町";
    case 45000: return "宮崎県";
    case 45201: return "宮崎県宮崎市";
    case 45202: return "宮崎県都城市";
    case 45203: return "宮崎県延岡市";
    case 45204: return "宮崎県日南市";
    case 45205: return "宮崎県小林市";
    case 45206: return "宮崎県日向市";
    case 45207: return "宮崎県串間市";
    case 45208: return "宮崎県西都市";
    case 45209: return "宮崎県えびの市";
    case 45340: return "宮崎県北諸県郡";
    case 45341: return "宮崎県北諸県郡三股町";
    case 45360: return "宮崎県西諸県郡";
    case 45361: return "宮崎県西諸県郡高原町";
    case 45380: return "宮崎県東諸県郡";
    case 45382: return "宮崎県東諸県郡国富町";
    case 45383: return "宮崎県東諸県郡綾町";
    case 45400: return "宮崎県児湯郡";
    case 45401: return "宮崎県児湯郡高鍋町";
    case 45402: return "宮崎県児湯郡新富町";
    case 45403: return "宮崎県児湯郡西米良村";
    case 45404: return "宮崎県児湯郡木城町";
    case 45405: return "宮崎県児湯郡川南町";
    case 45406: return "宮崎県児湯郡都農町";
    case 45420: return "宮崎県東臼杵郡";
    case 45421: return "宮崎県東臼杵郡門川町";
    case 45429: return "宮崎県東臼杵郡諸塚村";
    case 45430: return "宮崎県東臼杵郡椎葉村";
    case 45431: return "宮崎県東臼杵郡美郷町";
    case 45440: return "宮崎県西臼杵郡";
    case 45441: return "宮崎県西臼杵郡高千穂町";
    case 45442: return "宮崎県西臼杵郡日之影町";
    case 45443: return "宮崎県西臼杵郡五ヶ瀬町";
    case 46000: return "鹿児島県";
    case 46201: return "鹿児島県鹿児島市";
    case 46203: return "鹿児島県鹿屋市";
    case 46204: return "鹿児島県枕崎市";
    case 46206: return "鹿児島県阿久根市";
    case 46208: return "鹿児島県出水市";
    case 46210: return "鹿児島県指宿市";
    case 46213: return "鹿児島県西之表市";
    case 46214: return "鹿児島県垂水市";
    case 46215: return "鹿児島県薩摩川内市";
    case 46216: return "鹿児島県日置市";
    case 46217: return "鹿児島県曽於市";
    case 46218: return "鹿児島県霧島市";
    case 46219: return "鹿児島県いちき串木野市";
    case 46220: return "鹿児島県南さつま市";
    case 46221: return "鹿児島県志布志市";
    case 46222: return "鹿児島県奄美市";
    case 46223: return "鹿児島県南九州市";
    case 46224: return "鹿児島県伊佐市";
    case 46225: return "鹿児島県姶良市";
    case 46300: return "鹿児島県鹿児島郡";
    case 46303: return "鹿児島県鹿児島郡三島村";
    case 46304: return "鹿児島県鹿児島郡十島村";
    case 46380: return "鹿児島県薩摩郡";
    case 46392: return "鹿児島県薩摩郡さつま町";
    case 46400: return "鹿児島県出水郡";
    case 46404: return "鹿児島県出水郡長島町";
    case 46440: return "鹿児島県姶良郡";
    case 46452: return "鹿児島県姶良郡湧水町";
    case 46460: return "鹿児島県曽於郡";
    case 46468: return "鹿児島県曽於郡大崎町";
    case 46480: return "鹿児島県肝属郡";
    case 46482: return "鹿児島県肝属郡東串良町";
    case 46490: return "鹿児島県肝属郡錦江町";
    case 46491: return "鹿児島県肝属郡南大隅町";
    case 46492: return "鹿児島県肝属郡肝付町";
    case 46500: return "鹿児島県熊毛郡";
    case 46501: return "鹿児島県熊毛郡中種子町";
    case 46502: return "鹿児島県熊毛郡南種子町";
    case 46505: return "鹿児島県熊毛郡屋久島町";
    case 46520: return "鹿児島県大島郡";
    case 46523: return "鹿児島県大島郡大和村";
    case 46524: return "鹿児島県大島郡宇検村";
    case 46525: return "鹿児島県大島郡瀬戸内町";
    case 46527: return "鹿児島県大島郡龍郷町";
    case 46529: return "鹿児島県大島郡喜界町";
    case 46530: return "鹿児島県大島郡徳之島町";
    case 46531: return "鹿児島県大島郡天城町";
    case 46532: return "鹿児島県大島郡伊仙町";
    case 46533: return "鹿児島県大島郡和泊町";
    case 46534: return "鹿児島県大島郡知名町";
    case 46535: return "鹿児島県大島郡与論町";
    case 47000: return "沖縄県";
    case 47201: return "沖縄県那覇市";
    case 47205: return "沖縄県宜野湾市";
    case 47207: return "沖縄県石垣市";
    case 47208: return "沖縄県浦添市";
    case 47209: return "沖縄県名護市";
    case 47210: return "沖縄県糸満市";
    case 47211: return "沖縄県沖縄市";
    case 47212: return "沖縄県豊見城市";
    case 47213: return "沖縄県うるま市";
    case 47214: return "沖縄県宮古島市";
    case 47215: return "沖縄県南城市";
    case 47300: return "沖縄県国頭郡";
    case 47301: return "沖縄県国頭郡国頭村";
    case 47302: return "沖縄県国頭郡大宜味村";
    case 47303: return "沖縄県国頭郡東村";
    case 47306: return "沖縄県国頭郡今帰仁村";
    case 47308: return "沖縄県国頭郡本部町";
    case 47311: return "沖縄県国頭郡恩納村";
    case 47313: return "沖縄県国頭郡宜野座村";
    case 47314: return "沖縄県国頭郡金武町";
    case 47315: return "沖縄県国頭郡伊江村";
    case 47320: return "沖縄県中頭郡";
    case 47324: return "沖縄県中頭郡読谷村";
    case 47325: return "沖縄県中頭郡嘉手納町";
    case 47326: return "沖縄県中頭郡北谷町";
    case 47327: return "沖縄県中頭郡北中城村";
    case 47328: return "沖縄県中頭郡中城村";
    case 47329: return "沖縄県中頭郡西原町";
    case 47340: return "沖縄県島尻郡";
    case 47348: return "沖縄県島尻郡与那原町";
    case 47350: return "沖縄県島尻郡南風原町";
    case 47353: return "沖縄県島尻郡渡嘉敷村";
    case 47354: return "沖縄県島尻郡座間味村";
    case 47355: return "沖縄県島尻郡粟国村";
    case 47356: return "沖縄県島尻郡渡名喜村";
    case 47357: return "沖縄県島尻郡南大東村";
    case 47358: return "沖縄県島尻郡北大東村";
    case 47359: return "沖縄県島尻郡伊平屋村";
    case 47360: return "沖縄県島尻郡伊是名村";
    case 47361: return "沖縄県島尻郡久米島町";
    case 47362: return "沖縄県島尻郡八重瀬町";
    case 47370: return "沖縄県宮古郡";
    case 47375: return "沖縄県宮古郡多良間村";
    case 47380: return "沖縄県八重山郡";
    case 47381: return "沖縄県八重山郡竹富町";
    case 47382: return "沖縄県八重山郡与那国町";
    default:
      return "不明な地域";
  }
}

// Prefecture Codeのビット位置に対応する日本語の都道府県名を返す関数
const char* DCXDecoder::get_prefecture_name_ja(uint64_t bit_position) {

  // ビット位置に対応する都道府県名を定義
  switch (bit_position) {
    case 47 - 1: return "北海道";
    case 46 - 1: return "青森県";
    case 45 - 1: return "岩手県";
    case 44 - 1: return "宮城県";
    case 43 - 1: return "秋田県";
    case 42 - 1: return "山形県";
    case 41 - 1: return "福島県";
    case 40 - 1: return "茨城県";
    case 39 - 1: return "栃木県";
    case 38 - 1: return "群馬県";
    case 37 - 1: return "埼玉県";
    case 36 - 1: return "千葉県";
    case 35 - 1: return "東京都";
    case 34 - 1: return "神奈川県";
    case 33 - 1: return "新潟県";
    case 32 - 1: return "富山県";
    case 31 - 1: return "石川県";
    case 30 - 1: return "福井県";
    case 29 - 1: return "山梨県";
    case 28 - 1: return "長野県";
    case 27 - 1: return "岐阜県";
    case 26 - 1: return "静岡県";
    case 25 - 1: return "愛知県";
    case 24 - 1: return "三重県";
    case 23 - 1: return "滋賀県";
    case 22 - 1: return "京都府";
    case 21 - 1: return "大阪府";
    case 20 - 1: return "兵庫県";
    case 19 - 1: return "奈良県";
    case 18 - 1: return "和歌山県";
    case 17 - 1: return "鳥取県";
    case 16 - 1: return "島根県";
    case 15 - 1: return "岡山県";
    case 14 - 1: return "広島県";
    case 13 - 1: return "山口県";
    case 12 - 1: return "徳島県";
    case 11 - 1: return "香川県";
    case 10 - 1: return "愛媛県";
    case 9 - 1: return "高知県";
    case 8 - 1: return "福岡県";
    case 7 - 1: return "佐賀県";
    case 6 - 1: return "長崎県";
    case 5 - 1: return "熊本県";
    case 4 - 1: return "大分県";
    case 3 - 1: return "宮崎県";
    case 2 - 1: return "鹿児島県";
    case 1 - 1: return "沖縄県";
    default:
      return "不明な都道府県";
  }
}

// Guidance Instruction Libraryに対応する避難行動を返す関数
const char* DCXDecoder::get_guidance_instruction_library_ja(int code) {
  switch (code) {
    case 0: return "（未指定）";
    case 1: return "直ちに命を守るための最善の行動を。";
    case 126: return "これは、DCX のテストです。";
    case 127: return "直ちに命を守るための最善の行動を。";
    case 128: return "ミサイル発射。ミサイル発射。ミサイルが発射されたものとみられます。建物の中、又は地下に避難して下さい。";
    case 129: return "ミサイル通過。ミサイル通過。先程のミサイルは通過したものとみられます。避難の呼びかけを解除します。不審なものには決して近寄らず直ちに警察や消防などに連絡して下さい。";
    case 130: return "先程のミサイルは、海に落下したものとみられます。避難の呼びかけを解除します。不審なものには決して近寄らず直ちに警察や消防などに連絡して下さい。";
    case 131: return "先程のミサイルは、我が国には飛来しないものとみられます。避難の呼びかけを解除します。";
    case 132: return "直ちに避難。直ちに避難。直ちに建物の中、又は地下に避難して下さい。ミサイルが、周辺に落下するものとみられます。直ちに避難して下さい。";
    case 133: return "先程のミサイルは、迎撃により破壊されました。ミサイルの破片の落下の可能性があります。続報を伝達しますので、引き続き屋内に避難して下さい。";
    case 134: return "ミサイル落下。ミサイル落下。ミサイルが、周辺に落下したものとみられます。続報を伝達しますので、引き続き屋内に避難して下さい。";
    case 135: return "先程のミサイルは、我が国には落下しないものとみられます。避難の呼びかけを解除します。";
    case 136: return "これは、J アラートのテストです。";
    case 255: return "直ちに命を守るための最善の行動を。";
    case 256: return "留まれ。";
    case 257: return "留まれ。頑丈なものの下/中。";
    case 258: return "留まれ。3階以上。";
    case 259: return "留まれ。地下。";
    case 260: return "留まれ。山。";
    case 261: return "留まれ。水場。";
    case 262: return "留まれ。工場等化学系を取扱う建物。";
    case 263: return "留まれ。崖等崩れやすい場所。";
    case 512: return "向かえ。";
    case 513: return "向かえ。頑丈なものの下/中。";
    case 514: return "向かえ。3階以上。";
    case 515: return "向かえ。地下。";
    case 516: return "向かえ。山。";
    case 517: return "向かえ。水場。";
    case 518: return "向かえ。工場等化学系を取扱う建物。";
    case 519: return "向かえ。崖等崩れやすい場所。";
    case 768: return "離れろ。";
    case 769: return "離れろ。頑丈なものの下/中。";
    case 770: return "離れろ。3階以上。";
    case 771: return "離れろ。地下。";
    case 772: return "離れろ。山。";
    case 773: return "離れろ。水場。";
    case 774: return "離れろ。工場等化学系を取扱う建物。";
    case 775: return "離れろ。崖等崩れやすい場所。";
    default:
      return "不明な指示";
  }
}

const char* DCXDecoder::get_evacuate_direction_type_ja(int dir) {
  switch (dir) {
    case 0:
      return "追加対象地域から退避してください。";
    case 1:
      return "追加対象地域に向かってください。";
    default:
      return "不明";
  }
}
