#pragma once
//
//    FILE: ASCII_CONTROL.h
//  AUTHOR: Rob Tillaart
//    DATE: 2020-08-26
// PURPOSE: ASCII control characters
//     URL: https://github.com/RobTillaart/RS485


#define ASCII_NUL     0x00    //  NULL char
#define ASCII_SOH     0x01    //  Start Of Header
#define ASCII_STX     0x02    //  Start of Text
#define ASCII_ETX     0x03    //  End of Text
#define ASCII_EOT     0x04    //  End of Transmission
#define ASCII_ENQ     0x05    //  ENQuiry
#define ASCII_ACK     0x06    //  ACKnowledge
#define ASCII_BEL     0x07    //  Bell
#define ASCII_BS      0x08    //  Back Space
#define ASCII_TAB     0x09    //  TAB char
#define ASCII_LF      0x0A    //  Line Feed
#define ASCII_VT      0x0B    //  Vertical TAB
#define ASCII_FF      0x0C    //  Form Feed
#define ASCII_CR      0x0D    //  Carriage Return
#define ASCII_SO      0x0E    //  Shift Out
#define ASCII_SI      0x0F    //  Shift In
#define ASCII_DLE     0x10    //  Data Link Escape
#define ASCII_DC1     0x11    //  Device Control 1
#define ASCII_DC2     0x12    //  Device Control 2
#define ASCII_DC3     0x13    //  Device Control 3
#define ASCII_DC4     0x14    //  Device Control 4
#define ASCII_NAK     0x15    //  NOT ACKnowledge
#define ASCII_SYN     0x16    //  Synchronous idle
#define ASCII_ETB     0x17    //  End of transmission block
#define ASCII_CAN     0x18    //  CANcel
#define ASCII_EM      0x19    //  End of Medium
#define ASCII_SUB     0x1A    //  Substitute
#define ASCII_ESC     0x1B    //  Escape
#define ASCII_FS      0x1C    //  File Separator
#define ASCII_GS      0x1D    //  Group Separator
#define ASCII_RS      0x1E    //  Record Separator
#define ASCII_US      0x1F    //  Unit Separator
#define ASCII_DEL     0x7F    //  DELete


//  -- END OF FILE --

