
[![Arduino CI](https://github.com/RobTillaart/Prandom/workflows/Arduino%20CI/badge.svg)](https://github.com/marketplace/actions/arduino_ci)
[![Arduino-lint](https://github.com/RobTillaart/Prandom/actions/workflows/arduino-lint.yml/badge.svg)](https://github.com/RobTillaart/Prandom/actions/workflows/arduino-lint.yml)
[![JSON check](https://github.com/RobTillaart/Prandom/actions/workflows/jsoncheck.yml/badge.svg)](https://github.com/RobTillaart/Prandom/actions/workflows/jsoncheck.yml)
[![GitHub issues](https://img.shields.io/github/issues/RobTillaart/Prandom.svg)](https://github.com/RobTillaart/Prandom/issues)

[![License: MIT](https://img.shields.io/badge/license-MIT-green.svg)](https://github.com/RobTillaart/Prandom/blob/master/LICENSE)
[![GitHub release](https://img.shields.io/github/release/RobTillaart/Prandom.svg?maxAge=3600)](https://github.com/RobTillaart/Prandom/releases)
[![PlatformIO Registry](https://badges.registry.platformio.org/packages/robtillaart/library/Prandom.svg)](https://registry.platformio.org/libraries/robtillaart/Prandom)


# Prandom

Arduino library for random number generation with Python random interface.


## Description

This library uses the Marsaglia PRNG to generate random numbers.
The numbers generated by the PRNG are good for most "hobby" applications
e.g. games or simulations.

It has different ways to seed the PRNG, which allows reseeding at any time.
This allows e.g. an exact rerun of a simulation.

See Python Random library - https://docs.python.org/3/library/random.html


### Related

- https://github.com/RobTillaart/DEVRANDOM
- https://github.com/RobTillaart/Prandom
- https://github.com/RobTillaart/randomHelpers


## Interface

```cpp
#include "Prandom.h"
```

### Constructor

- **Prandom()** create Prandom object with seed based upon micros() and millis().
- **Prandom(uint32_t s)** create Prandom object with defined seed.

### Seed

- **void seed()** seed based upon micros() and millis().
- **void seed(uint32_t s, uint32_t t = 2)** seeds for Marsaglia PRNG; need 2 seeds, but 1 will work too.

### Integer functions

- **uint32_t getrandbits(uint8_t n)** idem
- **uint32_t randrange(uint32_t stop)** randrange() does not include stop value (0..stop-1).
- **uint32_t randrange(uint32_t start, uint32_t stop, uint32_t step = 1)**
- **uint32_t randint(uint32_t start, uint32_t stop)** randint() does include stop value (start..stop).

### Real distributions

See https://docs.python.org/3/library/random.html

- **float random(const float top = 1.0)**
- **float uniform(float lo, float hi)**
- **float triangular(float lo = 0, float hi = 1.0, float mid = 0.5)**
- **float normalvariate(float mu = 0, float sigma = 1.0)**
- **float lognormvariate(float mu = 0, float sigma = 1.0)**
- **float gauss(float mu = 0, float sigma = 1.0)**
- **float expovariate(float lambda)**
- **float gammavariate(float alpha, float beta)**
- **float betavariate(float alpha, float beta)**
- **float paretovariate(float alpha)**
- **float weibullvariate(float alpha, float beta)**

### Circular distributions

- **float vonmisesvariate(float mu, float kappa = 0)** mu is mean angle in radians,
kappa is concentration parameter, 0 -> uniform.


## Future

#### Must

- improve documentation.

#### Should

- unit tests?
- follow developments in Python random library.
- add examples.

#### Could

- add more RNG's to choose from.
- CamelCase functions.

#### Wont


## Support

If you appreciate my libraries, you can support the development and maintenance.
Improve the quality of the libraries by providing issues and Pull Requests, or
donate through PayPal or GitHub sponsors.

Thank you,

