
[![Arduino CI](https://github.com/RobTillaart/PCF8575/workflows/Arduino%20CI/badge.svg)](https://github.com/marketplace/actions/arduino_ci)
[![Arduino-lint](https://github.com/RobTillaart/PCF8575/actions/workflows/arduino-lint.yml/badge.svg)](https://github.com/RobTillaart/PCF8575/actions/workflows/arduino-lint.yml)
[![JSON check](https://github.com/RobTillaart/PCF8575/actions/workflows/jsoncheck.yml/badge.svg)](https://github.com/RobTillaart/PCF8575/actions/workflows/jsoncheck.yml)
[![GitHub issues](https://img.shields.io/github/issues/RobTillaart/PCF8575.svg)](https://github.com/RobTillaart/PCF8575/issues)

[![License: MIT](https://img.shields.io/badge/license-MIT-green.svg)](https://github.com/RobTillaart/PCF8575/blob/master/LICENSE)
[![GitHub release](https://img.shields.io/github/release/RobTillaart/PCF8575.svg?maxAge=3600)](https://github.com/RobTillaart/PCF8575/releases)
[![PlatformIO Registry](https://badges.registry.platformio.org/packages/robtillaart/library/PCF8575.svg)](https://registry.platformio.org/libraries/robtillaart/PCF8575)


# PCF8575

Arduino library for PCF8575 - 16 channel I2C IO expander.


## Description

The library gives easy control over the 16 pins of the PCF8575 chips.

Base address = 0x20 + 0..7 depending on address pins A0..A2.

|  type      | address-range  |  notes                    |
|:-----------|:--------------:|:-------------------------:|
|  PCF8575   |  0x20 to 0x27  |  same range as PCF8574 !  |
|  PCF8575C  |  0x20 to 0x27  |  need pull up in input mode. See #36, to be verified.


So you can connect up to 8 PCF8575 on one I2C bus, giving access 
to 8 x 16 = 128 IO lines. 
To maximize IO lines combine 8 x PCF8575 + 8 x PCF8574A giving
128 + 64 = 192 IO lines. 
Be aware that you might need an appropriate power supply to have all of them
working properly.

The library allows to read and write both single pins or 16 pins in one call.
Be aware that the 16 bits interface actually writes 2 times 8 pins.
Furthermore some additional functions are implemented that are playful and useful.

Related to the PCF8574 8 channel IO expander library  https://github.com/RobTillaart/PCF8574.

Feedback as always is welcome.


### Interrupts intro

The PCF8575 has an interrupt output line (INT) to notify an MCU that one of the input lines has changed.
This can be used to prevent active polling of the PCF8574, which can be more efficient.

From the datasheet:

_An interrupt is generated by any rising or falling edge of the port inputs in the input mode. 
After time, (Tiv), INT is valid. Resetting and reactivating the interrupt circuit is achieved 
when data on the port is **changed to the original setting** or data is **read from**, or 
**written to**, the port that generated the interrupt. 
Resetting occurs in the read mode at the acknowledge bit after the rising edge of the SCL signal, 
or in the write mode at the acknowledge bit after the high-to-low transition of the SCL signal._

So there are three scenarios how the INT is reset.

1. pins revert to original state (lesser known).
2. read from the device (well known)
3. write to the device (well known)

This implies that polling the PCF8574 can miss an INT in scenario 1. (see #48)
In practice if you have faster polling than your signals changes this would not
be a problem. E.g. tactile switches and a polling frequency > 100 Hz will work.


### Interrupts library

The library cannot handle the PCF8575 interrupts as it has no code for it. 
The user should catch the interrupt in his own code to set a flag and can use 
the library to see which line has changed.

There is one example to show how interrupts can be handled:
- PCF8575_interrupt.ino

A more advanced interrupt handler would not set a boolean flag in the interrupt
routine but increase a counter (uint8_t or larger). 
Then it would be possible to see that:

1. an interrupt occurred. (counter > 0)
2. if one or more interrupts are not handled (counter > 1)

A minimal example that shows catching missed interrupts:

- **PCF8575_interrupt_advanced.ino**


### 0.2.0 Breaking change

Version 0.2.0 introduced a breaking change.
You cannot set the pins in **begin()** any more.
This reduces the dependency of processor dependent Wire implementations.
The user has to call **Wire.begin()** and can optionally set the Wire pins 
before calling **begin()**.


### Comparison PCF8575, PCA9671 and PCA9673

Based upon data sheets. PCA967x is a follow up replacement.

|             |  PCF8575  |  PCA9671  |  PCA9673  |  Notes  |
|:------------|:---------:|:---------:|:---------:|:-------:|
|  address    |     8     |    64     |    16     |
|  max I2C    |  400 KHz  |   1 MHz   |   1 MHz   |
|  interrupt  |   Y (1)   |     N     |   Y (1)   |  (1) = pin nr
|  reset-pin  |     N     |   Y (1)   |   Y (3)   |  (3) = pin nr
|  SW-reset   |     N     |     Y     |     Y     |  see section below.
|  deviceID   |     N     |     Y     |     Y     |  see section below.
|             |           |           |           |


### Related

16 bit port expanders

- https://github.com/RobTillaart/MCP23017_RT  I2C 16 IO lines.
- https://github.com/RobTillaart/MCP23S17  SPI 16 IO lines.
- https://github.com/RobTillaart/PCF8575  I2C 16 IO lines.
- https://github.com/RobTillaart/PCA9671  I2C 16 IO lines. - successor PCF8575


8 bit port expanders

- https://github.com/RobTillaart/MCP23008  I2C 8 IO lines.
- https://github.com/RobTillaart/MCP23S08  SPI 8 IO lines.
- https://github.com/RobTillaart/PCF8574  I2C 8 IO lines.


## I2C

The device has 8 possible addresses.

See datasheet.

### Performance

Testing showed that the PCF8575 still works at 600 KHz and failed at 800 KHz.
These values are outside the specs of the datasheet so they are not recommended.
However when performance is needed you can try to overclock the chip. 

TODO test to fill the table

| clock speed |  Read  |  Write  |  Notes              |
|:-----------:|:------:|:-------:|:--------------------|
|  100000     |        |         |  spec datasheet     |
|  200000     |        |         |                     |
|  300000     |        |         |                     |
|  400000     |        |         |  max advised speed  |
|  500000     |        |         |  not recommended    |
|  600000     |        |         |  not recommended    |
|  700000     |        |         |  not recommended    |
|  800000     | crash  |  crash  |  not recommended    |


### I2C multiplexing

Sometimes you need to control more devices than possible with the default
address range the device provides.
This is possible with an I2C multiplexer e.g. TCA9548 which creates up 
to eight channels (think of it as I2C subnets) which can use the complete 
address range of the device. 

Drawback of using a multiplexer is that it takes more administration in 
your code e.g. which device is on which channel. 
This will slow down the access, which must be taken into account when
deciding which devices are on which channel.
Also note that switching between channels will slow down other devices 
too if they are behind the multiplexer.

- https://github.com/RobTillaart/TCA9548


## Interface

```cpp
#include "PCF8575.h"
```

**PCF8575_INITIAL_VALUE** is a define that can be set compile time or before
the include of "PCF8575.h" to overrule the default value used with the 
**begin()** call.


### Constructor

- **PCF8575(uint8_t deviceAddress = 0x20, TwoWire \*wire = &Wire)** Constructor with the optional 
I2C device address, default 0x20, and the optional Wire interface as parameter.
- **bool begin(uint8_t value = PCF8575_INITIAL_VALUE)** set the initial value for the pins and masks.
Returns true if device address is visible on the I2C bus.
- **bool isConnected()** checks if the address is visible on the I2C bus.
- **bool setAddress(const uint8_t deviceAddress)** sets the device address after construction. 
Can be used to switch between PCF8575 modules runtime. Note this corrupts internal buffered values, 
so one might need to call **read16()** and/or **write16()**. 
Returns false if address is out of range 0x20..0x27 or if the address could not be found on I2C bus.
Returns true if address can be found on I2C bus.
- **uint8_t getAddress()** Returns the address set in the constructor or by **setAddress()**.


### Read and Write

- **uint16_t read16()** reads all 16 pins at once. This one does the actual reading.
- **uint8_t read(uint8_t pin)** reads a single pin; pin = 0..15.
- **uint16_t value()** returns the last read inputs again, as this information is buffered 
in the class this is faster than reread the pins.
- **void write16(uint16_t value)** writes all 16 pins at once. This one does the actual writing.
- **void write(uint8_t pin, uint8_t value)** writes a single pin; pin = 0..15; value is HIGH(1) or LOW (0).
- **uint16_t valueOut()** returns the last written data.


### Button

The **"button"** functions are to be used when you mix input and output on one IC.
It does not change / affect the pins used for output by masking these.
Typical usage is to call **setButtonMask()** once in setup as pins do not (often) change
during program execution. 

- **void setButtonMask(const uint16_t mask)** sets the (bit) mask which lines are input.
- **uint16_t getButtonMask()** returns the set buttonMask.
- **uint16_t readButton16()** use the mask set by setButtonMask to select specific input pins.
- **uint16_t readButton16(uint16_t mask)** use a specific mask to select specific input pins.
Note this can be a subset of the pins set with **setButtonMask()** if one wants to process not all.
- **uint8_t readButton(uint8_t pin)** read a singe input pin.

Background - https://github.com/RobTillaart/Arduino/issues/38


### Special

- **void toggle(uint8_t pin)** toggles a single pin.
- **void toggleMask(uint16_t mask)** toggles a selection of pins, 
if you want to invert all pins use 0xFFFF (default value).
- **void shiftRight(uint8_t n = 1)** shifts output channels n pins (default 1) pins right (e.g. LEDs ).
Fills the higher lines with zero's.
- **void shiftLeft(uint8_t n = 1)**  shifts output channels n pins (default 1) pins left (e.g. LEDs ).
Fills the lower lines with zero's.
- **void rotateRight(uint8_t n = 1)** rotates output channels to right, moving lowest line to highest line.
- **void rotateLeft(uint8_t n = 1)** rotates output channels to left, moving highest line to lowest line.
- **void reverse()** reverse the "bit pattern" of the lines, swapping pin 15 with 0, 14 with 1, 13 with 2 etc..


### Select

Some convenience wrappers.

- **void select(const uint8_t pin)** sets a single pin to HIGH, all others are set to LOW.
If pin > 15 all pins are set to LOW.
Can be used to select one of n devices.
- **void selectN(const uint8_t pin)** sets pins 0..pin to HIGH, all others are set to LOW.
If pin > 15 all pins are set to LOW.
This can typical be used to implement a VU meter.
- **void selectNone()** sets all pins to LOW.
- **void selectAll()** sets all pins to HIGH.


### Miscellaneous

- **int lastError()** returns the last error from the library. (see .h file).


## Error codes

|  name               |  value  |  description              |
|:--------------------|:-------:|:--------------------------|
|  PCF8575_OK         |  0x00   |  no error                 |
|  PCF8575_PIN_ERROR  |  0x81   |  pin number out of range  |
|  PCF8575_I2C_ERROR  |  0x82   |  I2C communication error  |


## Testing

Testing the initial library is done by Colin Mackay (thanks!).
Platforms used for testing include: Nano, ESP32 and Seeed Xiao.


## Operation

See examples.

It is advised to use pull-up or pull-down resistors so the lines have a defined state at startup.


## Future

#### Must

- improve documentation
- keep in sync with pcf8574 (as far as meaningful)

#### Should

- verify difference between PCF8575 and PCF8575C version- see #39

#### Could

- move code to .cpp
- **selectN()** could be extended to support 0..30
  - 00..15 => pin 0 .. N
  - 16..30 => pin N-15 .. 30
  - 16 ==> 0111 1111 1111 1111
  - 17 ==> 0011 1111 1111 1111
  - 18 ==> 0001 1111 1111 1111
  - 19 ==> 0000 1111 1111 1111
  - 20 ==> 0000 0111 1111 1111  etc.


#### Wont

- **value()** => **lastRead16()**

## Support

If you appreciate my libraries, you can support the development and maintenance.
Improve the quality of the libraries by providing issues and Pull Requests, or
donate through PayPal or GitHub sponsors.

Thank you,


