//
//    FILE: mcp4725_multiple_minimal.ino
//  AUTHOR: Rob Tillaart
// PURPOSE: test MCP4725 lib
//     URL: https://github.com/RobTillaart/MCP4725
//
//  simple example to control more than 2 devices over
//  a single I2C bus without multiplexer.
//  The A0 address pin is used as a SELECT pin.
//
//  One MCP4725 object is used to control 4 different devices.
//  drawback is that you can only read back the last write.
//
//  To be tested / confirmed working with hardware.


#include "Wire.h"
#include "MCP4725.h"

//  assume the 4 devices have the same A1 and A2
//  hard-coded address bits. (par 7.2 datasheet)
//  we will access all devices with as 0x63.
MCP4725 MCP(0x63);


//  connect the select pins to the A0 pins
//  of the four MCP4725's
uint8_t selectPin[4] = { 4, 5, 6, 7 };


void setup()
{
  while(!Serial);
  Serial.begin(115200);
  Serial.println(__FILE__);
  Serial.print("MCP4725_VERSION: ");
  Serial.println(MCP4725_VERSION);
  Serial.println();

  Wire.begin();

  for (int i = 0; i < 4; i++)
  {
    pinMode(selectPin[i], OUTPUT);
    digitalWrite(selectPin[i], LOW);
  }

  select(0);
  MCP.begin();
}


void select(uint8_t nr)
{
  for (int i = 0; i < 4; i++)
  {
    if (i != nr) digitalWrite(selectPin[i], LOW);
    else         digitalWrite(selectPin[i], HIGH);
  }
}


void loop()
{
  int x = analogRead(A0);  //  to create an output value.

  //  select one DAC and set the value.
  select(0);
  MCP.setValue(x);
  delay(250);

  select(1);
  MCP.setValue(x * 2);
  delay(250);

  select(2);
  MCP.setValue(x * 3);
  delay(250);

  select(3);
  MCP.setValue(x * 4);
  delay(250);
}


//  -- END OF FILE --
