#pragma once
//
//    FILE: I2C_LCD_spectrum_chars.h
//  AUTHOR: Rob.Tillaart
// VERSION: see CHANGELOG.md
// PURPOSE: Arduino library for I2C_LCD
//     URL: https://github.com/RobTillaart/I2C_LCD
//          https://maxpromer.github.io/LCD-Character-Creator/
//
//  Not all spectra are tested with examples.
//  Feedback / additions are welcome.


////////////////////////////////////
//
//  COLUMNS
//
//  WIDE == 5 pixel wide
uint8_t columnWide[8][8] =
{
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x1F },
  { 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x1F },
  { 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F },
  { 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F },
  { 0x00, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F },
  { 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F }
};

//  MEDIUM == 3 pixel wide
uint8_t columnMedium[8][8] =
{
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x0E },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x0E, 0x0E },
  { 0x00, 0x00, 0x00, 0x00, 0x0E, 0x0E, 0x0E, 0x0E },
  { 0x00, 0x00, 0x00, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
  { 0x00, 0x00, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
  { 0x00, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E },
  { 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E }
};

//  SMALL == 1 pixel wide
uint8_t columnSmall[8][8] =
{
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04 },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04 },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04 },
  { 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04 },
  { 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04 },
  { 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },
  { 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },
  { 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 }
};

//  HOLLOW == 5 pixel wide, hollow inside
uint8_t columnHollow[8][8] =
{
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x11 },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x11, 0x11 },
  { 0x00, 0x00, 0x00, 0x00, 0x1F, 0x11, 0x11, 0x11 },
  { 0x00, 0x00, 0x00, 0x1F, 0x11, 0x11, 0x11, 0x11 },
  { 0x00, 0x00, 0x1F, 0x11, 0x11, 0x11, 0x11, 0x11 },
  { 0x00, 0x1F, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
  { 0x1F, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 }
};


//  LINE == only the top line, need SPACE char for the "supporting" column.
// uint8_t columnLine[8][8] =
// {
  // { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F },
  // { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00 },
  // { 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00 },
  // { 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00 },
  // { 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00 },
  // { 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00 },
  // { 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
  // { 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }
// };



////////////////////////////////////
//
//  ROWS LEFT TO RIGHT
//
//  for the row / horizontal bar we only need 5 characters.
//  note the full filled block => lcd.special(4);
//
//  8 pixel high
uint8_t rowLeftToRight[5][8] =
{
  { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },
  { 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },
  { 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C },
  { 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E },
  { 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F }
};

//  WIDE == 6 pixel high
uint8_t rowL2RWide[5][8] =
{
  { 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00 },
  { 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00 },
  { 0x00, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x00 },
  { 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x00 },
  { 0x00, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00 }
};

//  MEDIUM == 4 pixel high
uint8_t rowL2RMedium[5][8] =
{
  { 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },
  { 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },
  { 0x00, 0x00, 0x1C, 0x1C, 0x1C, 0x1C, 0x00, 0x00 },
  { 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00 },
  { 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x1F, 0x00, 0x00 }
};

//  SMALL == 2 pixel high
uint8_t rowL2RSmall[5][8] =
{
  { 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x1E, 0x1E, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x00, 0x00, 0x00 }
};


////////////////////////////////////
//
//  ROWS RIGHT TO LEFT
//
//  8 pixel high
uint8_t rowRightToLeft[5][8] =
{
  { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
  { 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 },
  { 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },
  { 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F },
  { 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F }

};

//  WIDE == 6 pixel high
uint8_t rowR2LWide[5][8] =
{
  { 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },
  { 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00 },
  { 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00 },
  { 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x00 },
  { 0x00, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00 }
};

//  MEDIUM == 4 pixel high
uint8_t rowR2LMedium[5][8] =
{
 { 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },
 { 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00 },
 { 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x00, 0x00 },
 { 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x00 },
 { 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x1F, 0x00, 0x00 }
};

//  SMALL == 2 pixel high
uint8_t rowR2LSmall[5][8] =
{
 { 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00 },
 { 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },
 { 0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x00 },
 { 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x00 },
 { 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x00, 0x00, 0x00 }
};


////////////////////////////////////
//
//  INTENSITY
//
//  intensity can be used both as column and row
//  10 levels
//  0    => space
//  1..8 => intensity[0..7]
//  9    => char(255)
uint8_t intensity[8][8] =
{
  //  write randomizer script?
  {0x00, 0x04, 0x00, 0x08, 0x02, 0x00, 0x04, 0x00},
  {0x10, 0x04, 0x01, 0x08, 0x02, 0x10, 0x04, 0x01},
  {0x11, 0x04, 0x11, 0x09, 0x12, 0x11, 0x04, 0x11},
  {0x13, 0x04, 0x19, 0x09, 0x12, 0x13, 0x04, 0x19},
  {0x13, 0x0C, 0x1B, 0x09, 0x12, 0x1B, 0x06, 0x19},
  {0x1B, 0x0D, 0x1B, 0x0D, 0x16, 0x1B, 0x16, 0x1B},
  {0x1B, 0x1D, 0x1B, 0x0F, 0x1E, 0x1B, 0x17, 0x1B},
  {0x1F, 0x1D, 0x1F, 0x0F, 0x1E, 0x1F, 0x17, 0x1F}
};


////////////////////////////////////
//
//  EXPERIMENTAL
//
//  special L2R spectrum with underscores
//  set in the spectrumRow space to underscore
uint8_t rowLeftToRight_us[4][8] =
{
  { 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x00 },
  { 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1F, 0x00 },
  { 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1F, 0x00 },
  { 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1F, 0x00 }
};



//  -- END OF FILE --

