#pragma once
//
//    FILE: I2C_LCD_custom_chars.h
//  AUTHOR: Rob.Tillaart
// VERSION: see CHANGELOG.md
// PURPOSE: Arduino library for I2C_LCD
//     URL: https://github.com/RobTillaart/I2C_LCD
//          https://maxpromer.github.io/LCD-Character-Creator/
//
//  See examples for some more


////////////////////////////////////
//
//  Special
//

//  one-liners easier to search?
//  uint8_t paragraph[] = { 0x06, 0x09, 0x04, 0x10, 0x04, 0x12, 0x0E, 0x00 };

uint8_t paragraph[] = {
  0b00110,
  0b01001,
  0b00100,
  0b01010,
  0b00100,
  0b10010,
  0b01110,
  0b00000
};

uint8_t copyRight[] = {
  0b00000,
  0b11111,
  0b10001,
  0b10111,
  0b10111,
  0b10001,
  0b11111,
  0b00000
};


////////////////////////////////////
//
//  Math
//
uint8_t lessThan[] = {
  0b00000,
  0b00010,
  0b00100,
  0b01000,
  0b00100,
  0b00010,
  0b00000,
  0b11111
};

uint8_t moreThan[] = {
  0b00000,
  0b01000,
  0b00100,
  0b00010,
  0b00100,
  0b01000,
  0b00000,
  0b11111
};

uint8_t notEqual[] = {
  0b00000,
  0b00010,
  0b00010,
  0b11111,
  0b00100,
  0b11111,
  0b01000,
  0b01000
};

////////////////////////////////////
//
//  ARROWS
//
uint8_t doubleUP[] = {
  0b00100,
  0b01110,
  0b11111,
  0b00000,
  0b00100,
  0b01110,
  0b11111,
  0b00000
};

uint8_t doubleDOWN[] = {
  0b11111,
  0b01110,
  0b00100,
  0b00000,
  0b11111,
  0b01110,
  0b00100,
  0b00000
};

uint8_t openUP[] = {
  0b00000,
  0b00100,
  0b01010,
  0b01010,
  0b10001,
  0b10001,
  0b11111,
  0b00000
};

uint8_t openDown[] = {
  0b00000,
  0b11111,
  0b10001,
  0b10001,
  0b01010,
  0b01010,
  0b00100,
  0b00000
};

////////////////////////////////////
//
//  BRACKETS   --[]--
//
uint8_t bracketRight[] = {
  0b11100,
  0b00100,
  0b00100,
  0b00111,
  0b00100,
  0b00100,
  0b11100,
  0b00000
};

uint8_t bracketLeft[] = {
  0b00111,
  0b00100,
  0b00100,
  0b11100,
  0b00100,
  0b00100,
  0b00111,
  0b00000
};

uint8_t singleLine[] = {
  0b00000,
  0b00000,
  0b00000,
  0b11111,
  0b00000,
  0b00000,
  0b00000,
  0b00000
};

uint8_t doubleLine[] = {
  0b11111,
  0b00000,
  0b00000,
  0b00000,
  0b00000,
  0b00000,
  0b11111,
  0b00000
};


////////////////////////////////////
//
//  MIRROR DIGITS  (0 and 8 are the same)
//
uint8_t mirror_1[] =
{
  0b00100,
  0b00110,
  0b00100,
  0b00100,
  0b00100,
  0b00100,
  0b01110,
  0b00000
};

uint8_t mirror_2[] =
{
  0b01110,
  0b10001,
  0b10000,
  0b01000,
  0b00100,
  0b00010,
  0b11111,
  0b00000
};

uint8_t mirror_3[] =
{
  0b11111,
  0b01000,
  0b00100,
  0b01000,
  0b10000,
  0b10001,
  0b01110,
  0b00000
};

uint8_t mirror_4[] =
{
  0b01000,
  0b01100,
  0b01010,
  0b01001,
  0b11111,
  0b01000,
  0b01000,
  0b00000
};

uint8_t mirror_5[] =
{
  0b11111,
  0b00001,
  0b01111,
  0b10000,
  0b10000,
  0b10001,
  0b01110,
  0b00000
};

uint8_t mirror_6[] =
{
  0b01100,
  0b00010,
  0b00001,
  0b01111,
  0b10001,
  0b10001,
  0b01110,
  0b00000
};

uint8_t mirror_7[] =
{
  0b11111,
  0b10000,
  0b01000,
  0b00100,
  0b00010,
  0b00010,
  0b00010,
  0b00000
};

uint8_t mirror_9[] =
{
  0b01110,
  0b10001,
  0b10001,
  0b11100,
  0b10000,
  0b01000,
  0b00110,
  0b00000
};


////////////////////////////////////
//
//  UPSIDE DIGITS  (0 and 8 are the same)
//
uint8_t upside_1[] =
{
  0b01110,
  0b00100,
  0b00100,
  0b00100,
  0b00100,
  0b01100,
  0b00100,
  0b00000
};

uint8_t upside_2[] =
{
  0b11111,
  0b01000,
  0b00100,
  0b00010,
  0b00001,
  0b10001,
  0b01110,
  0b00000
};

uint8_t upside_3[] =
{
  0b01110,
  0b10001,
  0b00001,
  0b00010,
  0b00100,
  0b00010,
  0b11111,
  0b00000
};

uint8_t upside_4[] =
{
  0b00010,
  0b00010,
  0b11111,
  0b10010,
  0b01010,
  0b00110,
  0b00010,
  0b00000
};

uint8_t upside_5[] =
{
  0b01110,
  0b10001,
  0b00001,
  0b00001,
  0b11110,
  0b10000,
  0b11111,
  0b00000
};

uint8_t upside_6[] =
{
  0b01110,
  0b10001,
  0b10001,
  0b11110,
  0b10000,
  0b01000,
  0b00110,
  0b00000
};

uint8_t upside_7[] =
{
  0b01000,
  0b01000,
  0b01000,
  0b00100,
  0b00010,
  0b00001,
  0b11111,
  0b00000
};

uint8_t upside_9[] =
{
  0b01100,
  0b00010,
  0b00001,
  0b01111,
  0b10001,
  0b10001,
  0b01110,
  0b00000
};


////////////////////////////////////
//
//  Other
//
uint8_t OnOff[] = {
  0b00100,
  0b00100,
  0b01110,
  0b10101,
  0b10101,
  0b10001,
  0b01110,
  0b00000
};

uint8_t smiley[] = {
  0b00000,
  0b00000,
  0b01010,
  0b00000,
  0b10001,
  0b01110,
  0b00000,
  0b00000
};

uint8_t heart[] = {
  0b00000,
  0b01010,
  0b10101,
  0b10001,
  0b01010,
  0b00100,
  0b00000,
  0b00000
};

uint8_t euro[] = {
  0b00000,
  0b00111,
  0b01000,
  0b11111,
  0b01000,
  0b11111,
  0b01000,
  0b00111
};

uint8_t plusminus[] = {
  0b00000,
  0b00100,
  0b00100,
  0b11111,
  0b00100,
  0b00100,
  0b11111,
  0b00000
};


//  -- END OF FILE --

