//
//    FILE: funcGenFreeWavePlotter.ino
//  AUTHOR: Rob Tillaart
// PURPOSE: demo function generators
//     URL: https://github.com/RobTillaart/FunctionGenerator
//
//  use a Serial plotter to show the data


#include "functionGenerator.h"

funcgen gen;

//  sin(t).
int16_t arr_sin[101] =
{
  0,  627,  1253,  1873,  2486,  3090,
  3681,  4257,  4817,  5358,  5877,
  6374,  6845,  7289,  7705,  8090,
  8443,  8763,  9048,  9297,  9510,
  9685,  9822,  9921,  9980,  10000,
  9980,  9921,  9822,  9685,  9510,
  9297,  9048,  8763,  8443,  8090,
  7705,  7289,  6845,  6374,  5877,
  5358,  4817,  4257,  3681,  3090,
  2486,  1873,  1253,  627,  0,
  -627,  -1253,  -1873,  -2486,  -3090,
  -3681,  -4257,  -4817,  -5358,  -5877,
  -6374,  -6845,  -7289,  -7705,  -8090,
  -8443,  -8763,  -9048,  -9297,  -9510,
  -9685,  -9822,  -9921,  -9980,  -10000,
  -9980,  -9921,  -9822,  -9685,  -9510,
  -9297,  -9048,  -8763,  -8443,  -8090,
  -7705,  -7289,  -6845,  -6374,  -5877,
  -5358,  -4817,  -4257,  -3681,  -3090,
  -2486,  -1873,  -1253,  -627,  0,
};


//  sin(t) + 0.25 * sin(5t)
int16_t arr_two_sin[101] =
{
  0, 1120, 2178, 3117, 3891, 4472,
  4847, 5024, 5029, 4904, 4702,
  4481, 4300, 4213, 4261, 4472,
  4852, 5392, 6063, 6820, 7608,
  8366, 9033, 9554, 9886, 10000,
  9886, 9554, 9033, 8366, 7608,
  6820, 6063, 5392, 4852, 4472,
  4261, 4213, 4300, 4481, 4702,
  4904, 5029, 5024, 4847, 4472,
  3891, 3117, 2178, 1120, 0,
  -1120, -2178, -3117, -3891, -4472,
  -4847, -5024, -5029, -4904, -4702,
  -4481, -4300, -4213, -4261, -4472,
  -4852, -5392, -6063, -6820, -7608,
  -8366, -9033, -9554, -9886, -10000,
  -9886, -9554, -9033, -8366, -7608,
  -6820, -6063, -5392, -4852, -4472,
  -4261, -4213, -4300, -4481, -4702,
  -4904, -5029, -5024, -4847, -4472,
  -3891, -3117, -2178, -1120, 0,
};



void setup()
{
  Serial.begin(115200);
  //  Serial.println();
  //  Serial.println(__FILE__);
  //  Serial.println("FUNCTIONGENERATOR_LIB_VERSION: ");
  //  Serial.println(FUNCTIONGENERATOR_LIB_VERSION);
  //  Serial.println();

  gen.setAmplitude(80);
  gen.setFrequency(0.5);
  gen.setDutyCycle(50);
}


void loop()
{
  float t = millis() * 0.001;

  Serial.print(80);
  Serial.print("\t");
  Serial.print(-80);
  Serial.print("\t");
  Serial.print(gen.freeWave(t, arr_two_sin, 100));
  Serial.println();
  delay(10);
}


//  -- END OF FILE --
