# Change Log FastTrig

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/)
and this project adheres to [Semantic Versioning](http://semver.org/).


## [0.3.5] - 2026-01-15
- update GitHub actions
- minor edits

## [0.3.4] - 2025-03-23
- fix #28, prevent promotion of constants to double. Kudos to Harrison3000
- replace M_PI by a const float _PI_ to prevent promotion.
- update examples
- update readme.md (minor)
- minor edits

## [0.3.3] - 2023-11-02
- update readme.md
- update keywords.txt
- update changelog.md

## [0.3.2] - 2022-12-20
- fix changelog
- fix #25 change reference parameters to pointer
  - isincos(float f, float \*si, float \*co)
  - isincos256(uint32_t v, int \*si, int \*co);
  - fix examples

## [0.3.1] - 2022-12-18
- add hypotFast
- add examples hypotFast
- update readme.md

## [0.3.0] - 2022-12-11
- add isin256(), icos256() and isincos256() => integer math only version
- add isincos(float f, float &si, float &co) => calculate sin and cos simultaneously.
- fix rounding bug when mirroring 90° for remainder.
- add examples.
- update documentation.
- update library.properties.

----

## [0.2.1] - 2022-12-05
- add atanFast(x) => faster and less accurate than atan().
  Input range (-1..1) is fastest.
- add atan2Fast(y, x) => faster and less accurate.
  calls atanFast() + offset.
- add example to measure performance atanFast
- update readme.md
- update keywords.txt

## [0.2.0] - 2022-12-02
- merged PR #16 for ESP_IDF support
- added <stdint.h>
- added <stdbool.h>
- renamed isinTable to sinTable for readability (breaking change)
- edits code for readability
- fix itan(90) now returns NAN instead of 0.

----

## [0.1.11] - 2022-11-02
- add changelog.md
- add rp2040 to build-CI
- moved version info from readme.md to changelog
- no functional changes

## [0.1.10] - 2022-04-15
- fix #12
- split .h in .h and .cpp Needed in case of more complex projects.

## [0.1.9] - 2021-12-18
- update Arduino-CI, badges,
- update library.json
- minor edits

## [0.1.8] - 2021-08-10
- made % 180 conditional in itan() => performance gain
- added icot() cotangent.

## [0.1.7] - 2021-04-23
 -fix for PlatformIO

## [0.1.6] - 2020-12-23
- Arduino-CI + unit tests

## [0.1.5] - 2020-09-11
- fixed optimize
- new table
- added iasin() and iacos()

In (0.1.4) an error was found in the optimize algorithm, so for 0.1.5
it was ran again and accuracy improved for **isin()** and **icos()**.
However **itan()** lost a (smaller) bit.
The gain outweighs the loss and so new table is kept.

Performance has not changed.

An initial version of a reverse lookup for **iasin(val)** and **iacos(val)**
is added, as it uses the same **isintable16\[\]** interpolation table.

There is no **atan()** or **atan2()** replacement.

## [0.1.4] - 2020-09-08
- rewrite itan()
- clean up
- examples

The library (0.1.4) provides an **itan()** which improved accuracy
upon the (0.1.3) version and performance for the ESP32.
Performance on AVR (UNO) is still an issue, accuracy is OK.

## [0.1.3] - 2020-09-07
- initial release.

## [0.1.2] - 2020-09-06
- optimize 16 bit table with example sketch

## [0.1.1] - 2020-08-30
- refactor
- create a library out of it.
- itan() approximation is bad.


_eons passed_

----

## [0.1.02] - 2011-08-20
- added interpolation

## [0.1.01] - 2011-08-18
- improved tables a bit
- changed param to float

## [0.1.00] - 2011-08-18
- initial version

