//
//    FILE: dht33_test.ino
//  AUTHOR: Rob Tillaart
// PURPOSE: DHT library test sketch for DHT33 && Arduino
//     URL: https://github.com/RobTillaart/DHTlib


#include "dht.h"

dht DHT;

#define DHT33_PIN     5


void setup()
{
  Serial.begin(115200);
  Serial.println();
  Serial.println(__FILE__);
  Serial.print("DHT_LIB_VERSION: ");
  Serial.println(DHT_LIB_VERSION);
  Serial.println();

  Serial.println("Type,\tstatus,\tHumidity (%),\tTemperature (C)\tTime (us)");
}


void loop()
{
  //  READ DATA
  Serial.print("DHT33, \t");

  uint32_t start = micros();
  int chk = DHT.read33(DHT33_PIN);
  uint32_t stop = micros();

  switch (chk)
  {
  case DHTLIB_OK:
      Serial.print("OK,\t");
      break;
  case DHTLIB_ERROR_CHECKSUM:
      Serial.print("Checksum error,\t");
      break;
  case DHTLIB_ERROR_TIMEOUT:
      Serial.print("Time out error,\t");
      break;
  case DHTLIB_ERROR_CONNECT:
      Serial.print("Connect error,\t");
      break;
  case DHTLIB_ERROR_ACK_L:
      Serial.print("Ack Low error,\t");
      break;
  case DHTLIB_ERROR_ACK_H:
      Serial.print("Ack High error,\t");
      break;
  default:
      Serial.print("Unknown error,\t");
      break;
  }

  //  DISPLAY DATA
  Serial.print(DHT.humidity, 1);
  Serial.print(",\t");
  Serial.print(DHT.temperature, 1);
  Serial.print(",\t");
  Serial.print(stop - start);
  Serial.println();

  //  FOR UNO + DHT33 400ms SEEMS TO BE MINIMUM DELAY BETWEEN SENSOR READS,
  //  ADJUST TO YOUR NEEDS
  delay(1000);
}


//  -- END OF FILE --

