//
//    FILE: countdown_overflow_test.ino
//  AUTHOR: Rob Tillaart
// PURPOSE: test overflow behaviour (micros is fastest to test)
//     URL: http://forum.arduino.cc/index.php?topic=356253
//          https://github.com/RobTillaart/CountDown
//
//  note this test takes loooong!


#include "CountDown.h"

CountDown CD(CountDown::MICROS);

void setup()
{
  //  while(!Serial);  //  uncomment if needed
  Serial.begin(115200);
  Serial.println();
  Serial.println(__FILE__);
  Serial.print("COUNTDOWN_LIB_VERSION: ");
  Serial.println(COUNTDOWN_LIB_VERSION);
  Serial.println();

  //  wait for almost overflow ~70 minutes !!
  while (micros() < 4290000000UL)
  {
    Serial.println(micros());
    delay(1000);
  }
  Serial.println("----------------------");

  CD.setResolution(CountDown::MICROS);
  CD.start(1 * 60 * 1000000UL);  //  1 minute = 60 seconds
}


void loop()
{
  Serial.print("Remaining: ");
  Serial.print(CD.remaining());
  Serial.print(" ");
  Serial.println(CD.getUnits());
  delay(1000);
}


//  -- END OF FILE --
