#pragma once
//
//    FILE: acids.h
//  AUTHOR: Rob Tillaart
//    DATE: 2025-07-10
// PURPOSE: short list of chemical formulae of acids / bases
//     URL: https://github.com/RobTillaart/AtomicWeight
//
//  TODO 
//  - extend
//  - grouping?
//  - example sketch


//
//  ACID
//
#define ACETIC_ACID               "CH3COOH"
#define VINEGAR                   "CH3COOH"
#define CARBONIC_ACID             "H2CO3"
#define CHLORIC_ACID              "HClO3"
#define CHLOROUS_ACID             "HClO2"
#define FORMIC_ACID               "HCOOH"
#define HYDROBROMIC_ACID          "HBr"
#define HYDROCHLORIC_ACID         "HCl"
#define HYDROFLUORIC_ACID         "HF"
#define HYDROIODIC_ACID           "HI"
#define NITRIC_ACID               "HNO3"
#define NITROUS_ACID              "HNO2"
#define PERCHLORIC_ACID           "HClO4"
#define PHOSPHORIC_ACID           "H3PO4"
#define PHOSPHOROUS_ACID          "H3PO3"
#define SULFERIC_ACID             "H2SO4"
#define SULFEROUS_ACID            "H2SO3"


//  BASE
#define ALUMININUM_HYDROXIDE      "Al(OH)3"
#define AMMONIA                   "NH3"
#define AMMONIUM_HYDROXIDE        "NH4OH"
#define ANILINE                   "C6H5NH2"
#define BARIUM_HYDROXIDE          "Ba(OH)2"
#define CALCIUM_HYDROXIDE         "Ca(OH)2"
#define CESIUM_HYDROXIDE          "CsOH"
#define FERRIC_HYDROXIDE          "Fe(OH)3"
#define LEAD_HYDROXIDE            "Pb(OH)2"
#define LITHIUM_HYDROXIDE         "LiOH"
#define MAGNESIUM_HYDROXIDE       "Mg(OH)2"
#define METHYLAMINE               "CH3NH2"
#define POTASSIUM_HYDROXIDE       "KOH"
#define PYRIDINE                  "C5H5N"
#define RUBIDIUM_HYDROXIDE        "RbOH"
#define SODIUM_HYDROXIDE          "NaOH"
#define STRONTIUM_HYDROXIDE       "Sr(OH)2"
#define ZINC_HYDROXIDE            "Zn(OH)2"
#define BETA_MERCAPTO_ETHANOL     "HSCH2CH2OH"

//  BASE CARBONATES
#define SODIUM_BICARBONATE        "NaHCO3"
#define SODIUM_CARBONATE          "Na2CO3"
#define CALCIUM_CARBONATE         "CaCO3"


//  -- END OF FILE --

