#pragma once
//
//    FILE: minerals.h
//  AUTHOR: Rob Tillaart
//    DATE: 2024-08-12
// PURPOSE: very short list of chemical formulae of minerals
//     URL: https://github.com/RobTillaart/AtomicWeight
//

/////////////////////////////////////////////////////////////////////////
//
//  The formulae are based upon Cornelis Klein, Anthony Philpotts book
//  Earth Materials, introduction to Mineralogy and Petrology, chapter 7
//  ISBN: 978-1-316-60885-2
//
//  NOT SUPPORTED: ==> formulae commented
//  NOT SUPPORTED: Fe2+ or Fe3+    (potential,   could be ignored!)
//  NOT SUPPORTED: comma operator  (selection,   should be made explicit)
//  NOT SUPPORTED: Fe1-x           (less than 1, should be made explicit)
//
//  to be extended, 
//

//  7.5
#define ALBITE              "NaAlSi3O8"
#define ANORTHITE           "CaAl2Si2O8"
//  7.6
#define MICROLINE           "KAlSi3O8"              //  Orthoclase
//  7.7
#define QUARTZ              "SiO2"
//  7.8
#define NEPHELINE           "(Na3K)Al4(SiO4)"
#define KALSILITE           "KAlSiO4"
//  7.9
#define LEUCITE             "KAlSi2O6"
#define AEGIRINE            "NaFeSi2O6"             //  7.14
//  7.10
#define SODALITE            "Na4Al3Si3O12Cl"
//  7.11
#define ENSTATITE           "MgSiO3"                //  "(Mg1.0Fe0.0)SiO3"
#define FERROSILITE         "FeSiO3"                //  "(Mg0.5Fe0.5)SiO3"
//  7.12
#define PIGEONITE           "Ca0.25(MgFe)1.75Si2O6"
//  7.13
#define DIOPSIDE            "CaMgSi2O6"
#define WOLLASTONITE        "CaSiO3"
//  7.15
#define TREMOLITE           "Ca2Mg5Si8O22(OH)2"
//  7.16
#define MUSCOVITE           "KAl3Si3O10(OH)2"
//  7.17
#define PHOLOGOPITE         "KMg3(AlSi3O10)(OH)2"
//  7.18
//  #define BIOTITE         "K(Mg,Fe)3(AlSi3O10)(OH)2"    
//  7.19
//  #define OLIVINE         "(Mg,Fe)2SiO4"
#define FORSTERITE          "Mg2SiO4" 
#define FAYALITE            "Fe2SiO4"
//  7.20
#define ZIRCON              "ZrSiO4" 
//  7.21
//  #define TOUMALINE       "(Na,Ca,K)(Fe,Mg,Al,Mn,Li)3(Al,Fe)6(BO3)3(Si6O18)(OH)3(O,OH,F)"
//  #define SCHORL          "(NaFe3Al6(BO3)3(Si6O18)(OH)3(O,OH,F)4"
//  7.22
//  #define ALLANITE        "(Ca,Ce)2(Al,Fe++,Fe+++)3(SiO4)(Si2O7)(OH)"
//  7.23
//  #define MELITITE        "(Ca,Na)2(Mg,Al)(Si,Al)2O7"
#define AKERMANITE          "Ca2MgSi2O7"
//  7.24
#define MAGNETITE           "Fe3O4"
#define ULVOSPINEL          "Fe2TiO4"
#define ILMENITE            "FeTiO3"    //  7.27
#define SPINEL              "MgAl2O4"
//  7.25
#define CHROMITE            "FeCr2O4"
//  7.26
#define HEMATITE            "Fe2O3"
#define CORUNDUM            "Al2O3"
//  7.28
#define RUTILE              "TiO2"
//  7.29
#define URANINITE           "UO2"
//  7.30
#define PYRITE              "FeS2"
//  7.31
//  #define PYRRHOTITE      "Fe1-xS"   //  x = 0..0.2
//  7.32
#define CHALCOPYRITE        "CuFeS2"
//  7.33
//  #define APATITE         "Ca5(PO4)3(OH,F,Cl)
#define HYDROXYAPATITE      "Ca5(PO4)3(OH)"


//  P237
#define JADEITE             "NaAlSi2O6"
//  11.3
#define GOETHITE            "FeO(OH)"
//  11.4
#define KAOLINITE           "Al2Si2O5(OH)4"
//  11.5
#define CALCITE             "CaCO3"
//  11.6
#define ARAGONITE           "CaCO3"  //  same as calcite
//  11.7
#define DOLOMITE            "CaMg(CO3)2"
//  11.8
#define MAGNESITE           "MgCO3"
//  11.9
#define SIDERITE            "FeCO3"
//  11.10
#define RHODOCHROSITE       "MnCO3"
//  11.11
#define HALITE              "NaCl"
//  11.12
#define SYLVITE             "KCl"
//  11.13
#define GYPSUM              "CaSO4"   //  CaSO4*4H20
//  11.14
#define ANHYDRITE           "CaSO4"
//  11.16
#define FLUORAPATITE        "Ca5(PO4)3(F)"


//  -- END OF FILE --

