#pragma once
//
//    FILE: elements_uint16.h
//  AUTHOR: Rob Tillaart
//    DATE: 2023-04-15
// PURPOSE: list of atomic weights (scaled to uint16_t)
//          generated with generate_uint16_table.ino
//     URL: https://github.com/RobTillaart/AtomicWeight



//////////////////////////////////////////////
//
//  list of elements (scaled to uint16_t)
//  weight = weight * (1.0 / 201.3868)
//
const float ATOMIC_WEIGHT_FACTOR = (1.0 / 201.3868);

struct element
{
  char     name[3];
  uint16_t weight;
}
elements[119] =
{
  {"n", 203},
  {"H", 203},
  {"He", 806},
  {"Li", 1975},
  {"Be", 1815},
  {"B", 2177},
  {"C", 2419},
  {"N", 2821},
  {"O", 3222},
  {"F", 3826},
  {"Ne", 4064},
  {"Na", 4630},
  {"Mg", 4895},
  {"Al", 5434},
  {"Si", 5656},
  {"P", 6238},
  {"S", 6457},
  {"Cl", 7140},
  {"Ar", 8045},
  {"K", 7874},
  {"Ca", 8071},
  {"Sc", 9054},
  {"Ti", 9640},
  {"V", 10259},
  {"Cr", 10471},
  {"Mn", 11064},
  {"Fe", 11246},
  {"Co", 11868},
  {"Ni", 11820},
  {"Cu", 12797},
  {"Zn", 13173},
  {"Ga", 14041},
  {"Ge", 14629},
  {"As", 15088},
  {"Se", 15902},
  {"Br", 16092},
  {"Kr", 16876},
  {"Rb", 17212},
  {"Sr", 17646},
  {"Y", 17904},
  {"Zr", 18371},
  {"Nb", 18710},
  {"Mo", 19321},
  {"Tc", 19736},
  {"Ru", 20354},
  {"Rh", 20724},
  {"Pd", 21432},
  {"Ag", 21723},
  {"Cd", 22638},
  {"In", 23123},
  {"Sn", 23907},
  {"Sb", 24521},
  {"Te", 25697},
  {"I", 25557},
  {"Xe", 26441},
  {"Cs", 26765},
  {"Ba", 27656},
  {"La", 27974},
  {"Ce", 28218},
  {"Pr", 28377},
  {"Nd", 29048},
  {"Pm", 29201},
  {"Sm", 30281},
  {"Eu", 30604},
  {"Gd", 31668},
  {"Tb", 32005},
  {"Dy", 32725},
  {"Ho", 33215},
  {"Er", 33684},
  {"Tm", 34021},
  {"Yb", 34848},
  {"Lu", 35236},
  {"Hf", 35946},
  {"Ta", 36441},
  {"W", 37023},
  {"Re", 37500},
  {"Os", 38310},
  {"Ir", 38710},
  {"Pt", 39286},
  {"Au", 39666},
  {"Hg", 40396},
  {"Tl", 41160},
  {"Pb", 41727},
  {"Bi", 42086},
  {"Po", 42090},
  {"At", 42291},
  {"Rn", 44708},
  {"Fr", 44909},
  {"Ra", 45513},
  {"Ac", 45715},
  {"Th", 46729},
  {"Pa", 46528},
  {"U", 47936},
  {"Np", 47729},
  {"Pu", 49138},
  {"Am", 48937},
  {"Cm", 49743},
  {"Bk", 49743},
  {"Cf", 50548},
  {"Es", 50749},
  {"Fm", 51756},
  {"Md", 51958},
  {"No", 52159},
  {"Lr", 52763},
  {"Rf", 52562},
  {"Db", 52763},
  {"Sg", 53569},
  {"Bh", 53166},
  {"Hs", 55784},
  {"Mt", 53972},
  {"Ds", 56590},
  {"Rg", 54777},
  {"Cn", 57395},
  {"Nh", 57597},
  {"Fl", 58201},
  {"Mc", 58201},
  {"Lv", 59006},
  {"Ts", 59208},
  {"Og", 59208},
};


//  -- END OF FILE --

