
/*
    Copyright 2025 Picovoice Inc.

    You may not use this file except in compliance with the license. A copy of the license is located in the "LICENSE"
    file accompanying this source.

    Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
    specific language governing permissions and limitations under the License.
*/

#ifndef PV_PARAMS_H
#define PV_PARAMS_H

#include <stdint.h>

// wake-word = olá computador 
static const uint8_t KEYWORD_ARRAY[] = {
        0x2e, 0xf6, 0x12, 0xc2, 0x01, 0xf2, 0x0e, 0x7b, 0x6c, 0xba, 0x2c, 0x1b, 0xe5, 0x77, 0x12, 0xaf, 0x53, 0xfd,
        0xdc, 0x93, 0xc3, 0xfe, 0xde, 0xec, 0xf3, 0x2d, 0xc1, 0x26, 0x8e, 0x3d, 0x68, 0xfb, 0xcb, 0xe2, 0x3a, 0xc2,
        0x1a, 0xbc, 0x7d, 0x54, 0x5c, 0x6b, 0x4b, 0xc5, 0xee, 0x65, 0xb9, 0x1b, 0x3e, 0x50, 0x32, 0x6f, 0x5d, 0x56,
        0x52, 0x0d, 0x56, 0xed, 0xdf, 0xe7, 0x51, 0x68, 0x0b, 0x36, 0x0e, 0x64, 0x77, 0x1f, 0xdc, 0x03, 0x74, 0xaf,
        0x03, 0xa0, 0x2b, 0x4b, 0x9c, 0x91, 0x18, 0x56, 0x96, 0x31, 0xef, 0x7e, 0x4f, 0xe8, 0x8a, 0xfa, 0x20, 0xc4,
        0x87, 0xa4, 0x58, 0x30, 0x63, 0xa4, 0xef, 0x94, 0x20, 0x74, 0xa9, 0x87, 0x6d, 0x88, 0x77, 0x49, 0xc6, 0x0d,
        0xb2, 0x5c, 0x62, 0x88, 0x9b, 0x64, 0xd0, 0x91, 0x01, 0x6e, 0x19, 0x0e, 0x07, 0x46, 0x86, 0x0a, 0x6d, 0xe3,
        0xb0, 0x7f, 0x34, 0xbf, 0x46, 0x2b, 0x40, 0xf8, 0x46, 0x6f, 0xc6, 0x50, 0xbd, 0x18, 0xb3, 0xf1, 0x87, 0x6e,
        0xf2, 0x9f, 0x29, 0xb8, 0x09, 0xaf, 0x50, 0xf3, 0x28, 0xe7, 0xc6, 0x29, 0x0d, 0xf8, 0xd9, 0xe1, 0xe0, 0xd4,
        0xc9, 0xbb, 0xfd, 0xc7, 0xee, 0x2b, 0x27, 0x1e, 0xee, 0x89, 0x48, 0x02, 0x8b, 0x41, 0x84, 0xc6, 0xfe, 0x60,
        0xbb, 0x34, 0xee, 0xbb, 0x33, 0x81, 0x57, 0xe8, 0x8f, 0x6e, 0xde, 0x6e, 0x10, 0x30, 0x4c, 0x29, 0x88, 0x05,
        0x87, 0xef, 0x9e, 0x54, 0x99, 0xb6, 0x4d, 0x1b, 0xdf, 0xb2, 0xca, 0x9f, 0xdf, 0x89, 0x54, 0xa0, 0xde, 0x8d,
        0x63, 0xb5, 0x89, 0x82, 0x44, 0x2b, 0x66, 0x05, 0x19, 0x06, 0x59, 0x1f, 0xb3, 0xb8, 0xfd, 0xca, 0x56, 0x0f,
        0xac, 0x11, 0x2f, 0x7e, 0xb7, 0x03, 0x80, 0xff, 0xd0, 0xea, 0x0d, 0x23, 0xf2, 0xfd, 0xdf, 0xcd, 0xdd, 0x96,
        0x14, 0x85, 0xdc, 0xd9, 0x9d, 0x15, 0x23, 0xe6, 0x14, 0x0d, 0x23, 0x8f, 0xfd, 0xa5, 0xeb, 0xa0, 0x85, 0x5b,
        0xf7, 0x7f, 0x23, 0x7e, 0x26, 0x13, 0x8f, 0x8a, 0x09, 0x10, 0xf3, 0xd2, 0x23, 0x38, 0x92, 0x17, 0x18, 0x41,
        0xf8, 0x55, 0xa3, 0xf2, 0x2a, 0xce, 0xdb, 0x2d, 0xff, 0xf7, 0xf7, 0xdc, 0xd7, 0x2f, 0x01, 0x5f, 0x85, 0xb7,
        0x16, 0x55, 0x33, 0x35, 0x5f, 0xbf, 0xa9, 0xdb, 0xd3, 0x21, 0xae, 0xd3, 0x34, 0xeb, 0x29, 0xa0, 0x87, 0x56,
        0xa1, 0x66, 0x99, 0xe6, 0x31, 0x32, 0xcf, 0x15, 0xcf, 0x99, 0xa0, 0xc3, 0x37, 0x3d, 0x7f, 0xb7, 0x45, 0xc9,
        0x56, 0x09, 0xa0, 0x20, 0x2e, 0xaf, 0xc9, 0x3a, 0x6a, 0xa0, 0xe1, 0x40, 0x04, 0x74, 0x34, 0xcc, 0xcb, 0x83,
        0x16, 0x7e, 0x1c, 0x9b, 0x59, 0x14, 0x3e, 0xb9, 0x5d, 0x5d, 0xaa, 0x2f, 0x00, 0xe9, 0x40, 0xea, 0x59, 0x3b,
        0x00, 0x47, 0xc3, 0x44, 0xae, 0xc5, 0xf9, 0x71, 0xac, 0xd4, 0xcb, 0xd2, 0xa7, 0x4a, 0x37, 0xb7, 0x90, 0xb1,
        0xcc, 0x4c, 0x7f, 0x3c, 0x3c, 0x48, 0xeb, 0xfc, 0x98, 0xaa, 0x53, 0xe2, 0xd8, 0x84, 0x67, 0xfa, 0xae, 0x1d,
        0xb6, 0xdc, 0xf3, 0x58, 0x7d, 0x69, 0x1e, 0xd9, 0x53, 0xa0, 0x15, 0x12, 0x24, 0x80, 0x88, 0xcb, 0x8d, 0xde,
        0x0b, 0x0a, 0x94, 0xd2, 0x35, 0x22, 0xee, 0x58, 0x4f, 0xd2, 0xcc, 0xf5, 0x7e, 0x19, 0xa6, 0xfb, 0x3a, 0xb8,
        0x98, 0x5e, 0x36, 0xc0, 0x12, 0x57, 0x2c, 0x2d, 0x9f, 0x30, 0xab, 0x75, 0x90, 0xe2, 0x76, 0xb6, 0xf7, 0x1d,
        0xe9, 0xbb, 0x92, 0x57, 0xb3, 0x68, 0xa1, 0x99, 0x42, 0x21, 0x2f, 0x2c, 0x47, 0xd0, 0x8a, 0x03, 0x74, 0x11,
        0x4e, 0x01, 0x49, 0xd6, 0x57, 0x4e, 0xae, 0x4d, 0xb8, 0xb1, 0xff, 0x2d, 0x19, 0x37, 0xdc, 0x7c, 0x42, 0x81,
        0x84, 0xb4, 0xd7, 0xf6, 0x1f, 0x9f, 0x5c, 0xd8, 0x87, 0xe5, 0x6d, 0xa2, 0x31, 0xff, 0x9a, 0x4c, 0xdf, 0x42,
        0xe5, 0xc9, 0xe8, 0x10, 0xcc, 0xd8, 0x4e, 0x69, 0x55, 0x29, 0x18, 0x20, 0xb2, 0xd8, 0x88, 0xd6, 0xcb, 0x17,
        0xa4, 0x36, 0xe5, 0x6d, 0xd3, 0x98, 0x5d, 0xd1, 0x0d, 0xd5, 0x85, 0xe0, 0xf6, 0x2d, 0x77, 0xf6, 0xf7, 0x48,
        0x08, 0x4c, 0x5d, 0x1c, 0x62, 0x36, 0x8d, 0xf9, 0xbc, 0xdb, 0x2f, 0x82, 0x20, 0x47, 0xc1, 0x4b, 0xcd, 0x06,
        0x2d, 0x09, 0x68, 0xe5, 0x06, 0xca, 0xba, 0x4e, 0x59, 0xe8, 0x5d, 0xb5, 0xae, 0x30, 0x0f, 0x4c, 0x77, 0xf1,
        0xe8, 0x24, 0x65, 0x16, 0xe1, 0x46, 0x52, 0x46, 0x18, 0xe6
};

// context = luz_inteligente 
static const uint8_t CONTEXT_ARRAY[] = {
        0x72, 0x68, 0x69, 0x6e, 0x6f, 0x34, 0x2e, 0x30, 0x2e, 0x30, 0x00, 0x00, 0x00, 0x00, 0x70, 0x74, 0x00, 0x09,
        0x00, 0x00, 0x00, 0x70, 0x69, 0x63, 0x6f, 0x76, 0x6f, 0x69, 0x63, 0x65, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x68, 0x12, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x6f,
        0x6e, 0x74, 0x65, 0x78, 0x74, 0x3a, 0x0a, 0x20, 0x20, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
        0x6e, 0x73, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x6d, 0x75, 0x64, 0x61, 0x43, 0x6f, 0x72, 0x3a, 0x0a, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x40, 0x6d, 0x75, 0x64, 0x61, 0x20, 0x28, 0x74, 0x6f, 0x64,
        0x61, 0x2c, 0x20, 0x74, 0x6f, 0x64, 0x61, 0x73, 0x2c, 0x20, 0x61, 0x20, 0x63, 0x6f, 0x72, 0x2c, 0x20, 0x61,
        0x20, 0x63, 0x6f, 0x72, 0x20, 0x64, 0x65, 0x20, 0x74, 0x6f, 0x64, 0x61, 0x2c, 0x20, 0x61, 0x20, 0x63, 0x6f,
        0x72, 0x20, 0x64, 0x65, 0x20, 0x74, 0x6f, 0x64, 0x61, 0x73, 0x29, 0x20, 0x40, 0x6c, 0x75, 0x7a, 0x20, 0x28,
        0x61, 0x2c, 0x20, 0x65, 0x6d, 0x2c, 0x20, 0x70, 0x61, 0x72, 0x61, 0x29, 0x20, 0x24, 0x63, 0x6f, 0x72, 0x3a,
        0x63, 0x6f, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x40, 0x6d, 0x75, 0x64,
        0x61, 0x20, 0x28, 0x61, 0x20, 0x63, 0x6f, 0x72, 0x29, 0x20, 0x40, 0x6c, 0x75, 0x7a, 0x20, 0x28, 0x61, 0x2c,
        0x20, 0x65, 0x6d, 0x2c, 0x20, 0x70, 0x61, 0x72, 0x61, 0x29, 0x20, 0x24, 0x63, 0x6f, 0x72, 0x3a, 0x63, 0x6f,
        0x72, 0x20, 0x5b, 0x65, 0x6d, 0x2c, 0x20, 0x6e, 0x61, 0x2c, 0x20, 0x6e, 0x6f, 0x5d, 0x20, 0x24, 0x6c, 0x75,
        0x67, 0x61, 0x72, 0x3a, 0x6c, 0x75, 0x67, 0x61, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d,
        0x20, 0x22, 0x40, 0x6d, 0x75, 0x64, 0x61, 0x20, 0x28, 0x61, 0x20, 0x63, 0x6f, 0x72, 0x29, 0x20, 0x40, 0x6c,
        0x75, 0x7a, 0x20, 0x5b, 0x64, 0x61, 0x2c, 0x20, 0x64, 0x6f, 0x2c, 0x20, 0x65, 0x6d, 0x2c, 0x20, 0x6e, 0x61,
        0x2c, 0x20, 0x6e, 0x6f, 0x5d, 0x20, 0x24, 0x6c, 0x75, 0x67, 0x61, 0x72, 0x3a, 0x6c, 0x75, 0x67, 0x61, 0x72,
        0x20, 0x28, 0x61, 0x2c, 0x20, 0x65, 0x6d, 0x2c, 0x20, 0x70, 0x61, 0x72, 0x61, 0x29, 0x20, 0x24, 0x63, 0x6f,
        0x72, 0x3a, 0x63, 0x6f, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x6c, 0x69, 0x67, 0x75, 0x65, 0x4c, 0x75,
        0x7a, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x40, 0x6c, 0x69, 0x67, 0x75, 0x65,
        0x20, 0x28, 0x74, 0x6f, 0x64, 0x61, 0x2c, 0x20, 0x74, 0x6f, 0x64, 0x61, 0x73, 0x29, 0x20, 0x40, 0x6c, 0x75,
        0x7a, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x40, 0x6c, 0x69, 0x67, 0x75, 0x65,
        0x20, 0x40, 0x6c, 0x75, 0x7a, 0x20, 0x5b, 0x64, 0x65, 0x2c, 0x20, 0x64, 0x61, 0x2c, 0x20, 0x64, 0x6f, 0x2c,
        0x20, 0x65, 0x6d, 0x2c, 0x20, 0x6e, 0x61, 0x2c, 0x20, 0x6e, 0x6f, 0x5d, 0x20, 0x24, 0x6c, 0x75, 0x67, 0x61,
        0x72, 0x3a, 0x6c, 0x75, 0x67, 0x61, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22,
        0x40, 0x6c, 0x69, 0x67, 0x75, 0x65, 0x20, 0x28, 0x61, 0x2c, 0x20, 0x6f, 0x29, 0x20, 0x24, 0x6c, 0x75, 0x67,
        0x61, 0x72, 0x3a, 0x6c, 0x75, 0x67, 0x61, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x64, 0x65, 0x73, 0x6c,
        0x69, 0x67, 0x75, 0x65, 0x4c, 0x75, 0x7a, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22,
        0x40, 0x64, 0x65, 0x73, 0x6c, 0x69, 0x67, 0x75, 0x65, 0x20, 0x28, 0x74, 0x6f, 0x64, 0x61, 0x2c, 0x20, 0x74,
        0x6f, 0x64, 0x61, 0x73, 0x29, 0x20, 0x40, 0x6c, 0x75, 0x7a, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x2d, 0x20, 0x22, 0x40, 0x64, 0x65, 0x73, 0x6c, 0x69, 0x67, 0x75, 0x65, 0x20, 0x40, 0x6c, 0x75, 0x7a, 0x20,
        0x5b, 0x64, 0x65, 0x2c, 0x20, 0x64, 0x61, 0x2c, 0x20, 0x64, 0x6f, 0x2c, 0x20, 0x65, 0x6d, 0x2c, 0x20, 0x6e,
        0x61, 0x2c, 0x20, 0x6e, 0x6f, 0x5d, 0x20, 0x24, 0x6c, 0x75, 0x67, 0x61, 0x72, 0x3a, 0x6c, 0x75, 0x67, 0x61,
        0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x40, 0x64, 0x65, 0x73, 0x6c, 0x69,
        0x67, 0x75, 0x65, 0x20, 0x28, 0x61, 0x2c, 0x20, 0x6f, 0x29, 0x20, 0x24, 0x6c, 0x75, 0x67, 0x61, 0x72, 0x3a,
        0x6c, 0x75, 0x67, 0x61, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x3a, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x63, 0x6f, 0x72, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x62, 0x72, 0x61,
        0x6e, 0x63, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x6d, 0x61, 0x72, 0x65, 0x6c,
        0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x76, 0x65, 0x72, 0x6d, 0x65, 0x6c, 0x68, 0x6f,
        0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x7a, 0x75, 0x6c, 0x0a, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x2d, 0x20, 0x76, 0x65, 0x72, 0x64, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20,
        0x6c, 0x61, 0x72, 0x61, 0x6e, 0x6a, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x72, 0x6f,
        0x78, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x6c, 0x75, 0x67, 0x61, 0x72, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x2d, 0x20, 0x71, 0x75, 0x61, 0x72, 0x74, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d,
        0x20, 0x62, 0x61, 0x6e, 0x68, 0x65, 0x69, 0x72, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20,
        0x63, 0x6f, 0x7a, 0x69, 0x6e, 0x68, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x73, 0x61,
        0x6c, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x64, 0x6f,
        0x72, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x67, 0x75, 0x61, 0x72, 0x64, 0x61, 0x2d, 0x72,
        0x6f, 0x75, 0x70, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x72, 0x6d, 0xc3, 0xa1,
        0x72, 0x69, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x64, 0x65, 0x73, 0x70, 0x65, 0x6e,
        0x73, 0x61, 0x0a, 0x20, 0x20, 0x6d, 0x61, 0x63, 0x72, 0x6f, 0x73, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x6c,
        0x75, 0x7a, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x20, 0x6c, 0x75, 0x7a, 0x0a,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x64, 0x61, 0x20, 0x6c, 0x75, 0x7a, 0x0a, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x73, 0x20, 0x6c, 0x75, 0x7a, 0x65, 0x73, 0x0a, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x2d, 0x20, 0x64, 0x61, 0x73, 0x20, 0x6c, 0x75, 0x7a, 0x65, 0x73, 0x0a, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x2d, 0x20, 0x61, 0x20, 0x6c, 0xc3, 0xa2, 0x6d, 0x70, 0x61, 0x64, 0x61, 0x0a, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x2d, 0x20, 0x64, 0x61, 0x20, 0x6c, 0xc3, 0xa2, 0x6d, 0x70, 0x61, 0x64, 0x61, 0x0a, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x73, 0x20, 0x6c, 0xc3, 0xa2, 0x6d, 0x70, 0x61, 0x64, 0x61,
        0x73, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x64, 0x61, 0x73, 0x20, 0x6c, 0xc3, 0xa2, 0x6d,
        0x70, 0x61, 0x64, 0x61, 0x73, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x6d, 0x75, 0x64, 0x61, 0x3a, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x6d, 0x75, 0x64, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d,
        0x20, 0x6d, 0x75, 0x64, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x63, 0x6f, 0x6c, 0x6f,
        0x72, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x61, 0x0a,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x0a, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x2d, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x2d, 0x20, 0x66, 0x61, 0x7a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x66, 0x61, 0xc3, 0xa7,
        0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x6c, 0x69, 0x67, 0x75, 0x65, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x2d, 0x20, 0x6c, 0x69, 0x67, 0x75, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x6c,
        0x69, 0x67, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x63, 0x65, 0x6e, 0x64, 0x65,
        0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x6c, 0x75, 0x6d, 0x69, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x2d, 0x20, 0x61, 0x6c, 0x75, 0x6d, 0x69, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x64, 0x65, 0x73, 0x6c,
        0x69, 0x67, 0x75, 0x65, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x64, 0x65, 0x73, 0x6c,
        0x69, 0x67, 0x75, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x64, 0x65, 0x73, 0x6c, 0x69,
        0x67, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x70, 0x61, 0x67, 0x75, 0x65, 0x0a,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x70, 0x61, 0x67, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x2d, 0x20, 0x65, 0x73, 0x63, 0x75, 0x72, 0x65, 0x63, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x2d, 0x20, 0x65, 0x73, 0x63, 0x75, 0x72, 0x65, 0xc3, 0xa7, 0x61, 0x0a, 0x00, 0x00, 0x00, 0x39, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00,
        0x29, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x49, 0x00,
        0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00,
        0x6e, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x84, 0x00, 0x00, 0x00, 0x89, 0x00, 0x00, 0x00, 0x8b, 0x00,
        0x00, 0x00, 0x94, 0x00, 0x00, 0x00, 0x9b, 0x00, 0x00, 0x00, 0xa2, 0x00, 0x00, 0x00, 0xa9, 0x00, 0x00, 0x00,
        0xb2, 0x00, 0x00, 0x00, 0xba, 0x00, 0x00, 0x00, 0xc1, 0x00, 0x00, 0x00, 0xcd, 0x00, 0x00, 0x00, 0xd7, 0x00,
        0x00, 0x00, 0xe5, 0x00, 0x00, 0x00, 0xe8, 0x00, 0x00, 0x00, 0xef, 0x00, 0x00, 0x00, 0xf6, 0x00, 0x00, 0x00,
        0xfe, 0x00, 0x00, 0x00, 0x07, 0x01, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x13, 0x01, 0x00, 0x00, 0x16, 0x01,
        0x00, 0x00, 0x19, 0x01, 0x00, 0x00, 0x22, 0x01, 0x00, 0x00, 0x2c, 0x01, 0x00, 0x00, 0x30, 0x01, 0x00, 0x00,
        0x36, 0x01, 0x00, 0x00, 0x43, 0x01, 0x00, 0x00, 0x4b, 0x01, 0x00, 0x00, 0x50, 0x01, 0x00, 0x00, 0x56, 0x01,
        0x00, 0x00, 0x5b, 0x01, 0x00, 0x00, 0x60, 0x01, 0x00, 0x00, 0x63, 0x01, 0x00, 0x00, 0x66, 0x01, 0x00, 0x00,
        0x68, 0x01, 0x00, 0x00, 0x6d, 0x01, 0x00, 0x00, 0x74, 0x01, 0x00, 0x00, 0x79, 0x01, 0x00, 0x00, 0x7e, 0x01,
        0x00, 0x00, 0x84, 0x01, 0x00, 0x00, 0x89, 0x01, 0x00, 0x00, 0x8f, 0x01, 0x00, 0x00, 0x98, 0x01, 0x00, 0x00,
        0x61, 0x20, 0x63, 0x6f, 0x72, 0x20, 0x64, 0x65, 0x20, 0x74, 0x6f, 0x64, 0x61, 0x73, 0x00, 0x61, 0x20, 0x63,
        0x6f, 0x72, 0x20, 0x64, 0x65, 0x20, 0x74, 0x6f, 0x64, 0x61, 0x00, 0x61, 0x20, 0x63, 0x6f, 0x72, 0x00, 0x61,
        0x20, 0x6c, 0x75, 0x7a, 0x00, 0x61, 0x20, 0x6c, 0xc3, 0xa2, 0x6d, 0x70, 0x61, 0x64, 0x61, 0x00, 0x61, 0x63,
        0x65, 0x6e, 0x64, 0x61, 0x00, 0x61, 0x63, 0x65, 0x6e, 0x64, 0x65, 0x00, 0x61, 0x6c, 0x75, 0x6d, 0x69, 0x61,
        0x00, 0x61, 0x6c, 0x75, 0x6d, 0x69, 0x65, 0x00, 0x61, 0x6d, 0x61, 0x72, 0x65, 0x6c, 0x6f, 0x00, 0x61, 0x70,
        0x61, 0x67, 0x61, 0x00, 0x61, 0x70, 0x61, 0x67, 0x75, 0x65, 0x00, 0x61, 0x72, 0x6d, 0xc3, 0xa1, 0x72, 0x69,
        0x6f, 0x00, 0x61, 0x73, 0x20, 0x6c, 0x75, 0x7a, 0x65, 0x73, 0x00, 0x61, 0x73, 0x20, 0x6c, 0xc3, 0xa2, 0x6d,
        0x70, 0x61, 0x64, 0x61, 0x73, 0x00, 0x61, 0x7a, 0x75, 0x6c, 0x00, 0x61, 0x00, 0x62, 0x61, 0x6e, 0x68, 0x65,
        0x69, 0x72, 0x6f, 0x00, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x00, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x61, 0x00,
        0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x65, 0x00, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x64, 0x6f, 0x72, 0x00, 0x63, 0x6f,
        0x7a, 0x69, 0x6e, 0x68, 0x61, 0x00, 0x64, 0x61, 0x20, 0x6c, 0x75, 0x7a, 0x00, 0x64, 0x61, 0x20, 0x6c, 0xc3,
        0xa2, 0x6d, 0x70, 0x61, 0x64, 0x61, 0x00, 0x64, 0x61, 0x73, 0x20, 0x6c, 0x75, 0x7a, 0x65, 0x73, 0x00, 0x64,
        0x61, 0x73, 0x20, 0x6c, 0xc3, 0xa2, 0x6d, 0x70, 0x61, 0x64, 0x61, 0x73, 0x00, 0x64, 0x61, 0x00, 0x64, 0x65,
        0x66, 0x69, 0x6e, 0x61, 0x00, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x00, 0x64, 0x65, 0x73, 0x6c, 0x69, 0x67,
        0x61, 0x00, 0x64, 0x65, 0x73, 0x6c, 0x69, 0x67, 0x75, 0x65, 0x00, 0x64, 0x65, 0x73, 0x70, 0x65, 0x6e, 0x73,
        0x61, 0x00, 0x64, 0x65, 0x00, 0x64, 0x6f, 0x00, 0x65, 0x6d, 0x00, 0x65, 0x73, 0x63, 0x75, 0x72, 0x65, 0x63,
        0x65, 0x00, 0x65, 0x73, 0x63, 0x75, 0x72, 0x65, 0xc3, 0xa7, 0x61, 0x00, 0x66, 0x61, 0x7a, 0x00, 0x66, 0x61,
        0xc3, 0xa7, 0x61, 0x00, 0x67, 0x75, 0x61, 0x72, 0x64, 0x61, 0x2d, 0x72, 0x6f, 0x75, 0x70, 0x61, 0x00, 0x6c,
        0x61, 0x72, 0x61, 0x6e, 0x6a, 0x61, 0x00, 0x6c, 0x69, 0x67, 0x61, 0x00, 0x6c, 0x69, 0x67, 0x75, 0x65, 0x00,
        0x6d, 0x75, 0x64, 0x61, 0x00, 0x6d, 0x75, 0x64, 0x65, 0x00, 0x6e, 0x61, 0x00, 0x6e, 0x6f, 0x00, 0x6f, 0x00,
        0x70, 0x61, 0x72, 0x61, 0x00, 0x71, 0x75, 0x61, 0x72, 0x74, 0x6f, 0x00, 0x72, 0x6f, 0x78, 0x6f, 0x00, 0x73,
        0x61, 0x6c, 0x61, 0x00, 0x74, 0x6f, 0x64, 0x61, 0x73, 0x00, 0x74, 0x6f, 0x64, 0x61, 0x00, 0x76, 0x65, 0x72,
        0x64, 0x65, 0x00, 0x76, 0x65, 0x72, 0x6d, 0x65, 0x6c, 0x68, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
        0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x0b, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x10, 0x00,
        0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
        0x1b, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x20, 0x00,
        0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00,
        0x26, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x30, 0x00,
        0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00,
        0x36, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x00, 0x3c, 0x00,
        0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00,
        0x43, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x46, 0x00, 0x00, 0x00, 0x48, 0x00,
        0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4a, 0x00, 0x00, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00,
        0x4d, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x52, 0x00,
        0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
        0x16, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x40, 0x00,
        0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x53, 0x00, 0x00, 0x00,
        0x58, 0x00, 0x00, 0x00, 0x5d, 0x00, 0x00, 0x00, 0x62, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x6e, 0x00,
        0x00, 0x00, 0x75, 0x00, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x86, 0x00, 0x00, 0x00,
        0x8d, 0x00, 0x00, 0x00, 0x94, 0x00, 0x00, 0x00, 0x9b, 0x00, 0x00, 0x00, 0xa2, 0x00, 0x00, 0x00, 0xab, 0x00,
        0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 0xbd, 0x00, 0x00, 0x00, 0xc6, 0x00, 0x00, 0x00, 0xca, 0x00, 0x00, 0x00,
        0xce, 0x00, 0x00, 0x00, 0xcf, 0x00, 0x00, 0x00, 0xd6, 0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 0xe2, 0x00,
        0x00, 0x00, 0xe8, 0x00, 0x00, 0x00, 0xef, 0x00, 0x00, 0x00, 0xf5, 0x00, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00,
        0xff, 0x00, 0x00, 0x00, 0x07, 0x01, 0x00, 0x00, 0x0f, 0x01, 0x00, 0x00, 0x17, 0x01, 0x00, 0x00, 0x1f, 0x01,
        0x00, 0x00, 0x27, 0x01, 0x00, 0x00, 0x31, 0x01, 0x00, 0x00, 0x3b, 0x01, 0x00, 0x00, 0x45, 0x01, 0x00, 0x00,
        0x4f, 0x01, 0x00, 0x00, 0x51, 0x01, 0x00, 0x00, 0x57, 0x01, 0x00, 0x00, 0x5d, 0x01, 0x00, 0x00, 0x64, 0x01,
        0x00, 0x00, 0x6b, 0x01, 0x00, 0x00, 0x72, 0x01, 0x00, 0x00, 0x79, 0x01, 0x00, 0x00, 0x7b, 0x01, 0x00, 0x00,
        0x7d, 0x01, 0x00, 0x00, 0x7f, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x88, 0x01, 0x00, 0x00, 0x90, 0x01,
        0x00, 0x00, 0x98, 0x01, 0x00, 0x00, 0xa0, 0x01, 0x00, 0x00, 0xa3, 0x01, 0x00, 0x00, 0xa6, 0x01, 0x00, 0x00,
        0xaa, 0x01, 0x00, 0x00, 0xb5, 0x01, 0x00, 0x00, 0xbb, 0x01, 0x00, 0x00, 0xbf, 0x01, 0x00, 0x00, 0xc3, 0x01,
        0x00, 0x00, 0xc7, 0x01, 0x00, 0x00, 0xcb, 0x01, 0x00, 0x00, 0xcf, 0x01, 0x00, 0x00, 0xd1, 0x01, 0x00, 0x00,
        0xd3, 0x01, 0x00, 0x00, 0xd4, 0x01, 0x00, 0x00, 0xd8, 0x01, 0x00, 0x00, 0xde, 0x01, 0x00, 0x00, 0xe2, 0x01,
        0x00, 0x00, 0xe6, 0x01, 0x00, 0x00, 0xeb, 0x01, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0xf9, 0x01, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x05, 0x02, 0x00, 0x00, 0x19, 0x0a, 0x0e, 0x1f, 0x02, 0x07,
        0x12, 0x0e, 0x02, 0x19, 0x11, 0x19, 0x0a, 0x0e, 0x1f, 0x02, 0x07, 0x12, 0x0e, 0x02, 0x19, 0x21, 0x19, 0x0a,
        0x0e, 0x1f, 0x03, 0x07, 0x12, 0x0e, 0x02, 0x19, 0x11, 0x19, 0x0a, 0x0e, 0x1f, 0x03, 0x07, 0x12, 0x0e, 0x02,
        0x19, 0x21, 0x19, 0x0a, 0x0e, 0x1f, 0x02, 0x07, 0x12, 0x0e, 0x02, 0x19, 0x19, 0x0a, 0x0e, 0x1f, 0x03, 0x07,
        0x12, 0x0e, 0x02, 0x19, 0x19, 0x0a, 0x0e, 0x1f, 0x19, 0x0b, 0x14, 0x11, 0x19, 0x0b, 0x14, 0x21, 0x19, 0x0b,
        0x1a, 0x10, 0x19, 0x02, 0x19, 0x19, 0x11, 0x05, 0x02, 0x19, 0x19, 0x11, 0x05, 0x02, 0x07, 0x19, 0x11, 0x05,
        0x03, 0x07, 0x19, 0x0b, 0x14, 0x0c, 0x07, 0x19, 0x19, 0x0b, 0x14, 0x0c, 0x07, 0x07, 0x19, 0x0c, 0x19, 0x1f,
        0x1c, 0x0b, 0x14, 0x19, 0x10, 0x19, 0x1d, 0x19, 0x19, 0x10, 0x19, 0x1d, 0x07, 0x19, 0x1f, 0x0c, 0x19, 0x1f,
        0x07, 0x14, 0x19, 0x11, 0x0b, 0x14, 0x18, 0x07, 0x11, 0x19, 0x11, 0x0b, 0x14, 0x18, 0x07, 0x21, 0x19, 0x21,
        0x0b, 0x14, 0x18, 0x07, 0x11, 0x19, 0x21, 0x0b, 0x14, 0x18, 0x07, 0x21, 0x19, 0x11, 0x0b, 0x1a, 0x10, 0x19,
        0x02, 0x19, 0x11, 0x19, 0x11, 0x0b, 0x1a, 0x10, 0x19, 0x02, 0x19, 0x21, 0x19, 0x21, 0x0b, 0x1a, 0x10, 0x19,
        0x02, 0x19, 0x11, 0x19, 0x21, 0x0b, 0x1a, 0x10, 0x19, 0x02, 0x19, 0x21, 0x19, 0x18, 0x14, 0x0b, 0x19, 0x18,
        0x14, 0x17, 0x19, 0x01, 0x19, 0x1e, 0x04, 0x09, 0x1f, 0x14, 0x01, 0x1f, 0x19, 0x0d, 0x0a, 0x14, 0x0a, 0x0e,
        0x0b, 0x0e, 0x1f, 0x19, 0x0a, 0x0e, 0x0b, 0x1b, 0x1f, 0x07, 0x0a, 0x0e, 0x20, 0x04, 0x02, 0x0e, 0x1f, 0x0a,
        0x1b, 0x18, 0x07, 0x1e, 0x19, 0x02, 0x19, 0x0b, 0x14, 0x11, 0x02, 0x19, 0x0b, 0x14, 0x21, 0x02, 0x19, 0x0b,
        0x1a, 0x10, 0x19, 0x02, 0x19, 0x02, 0x19, 0x11, 0x0b, 0x14, 0x18, 0x07, 0x11, 0x02, 0x19, 0x11, 0x0b, 0x14,
        0x18, 0x07, 0x21, 0x02, 0x19, 0x21, 0x0b, 0x14, 0x18, 0x07, 0x11, 0x02, 0x19, 0x21, 0x0b, 0x14, 0x18, 0x07,
        0x21, 0x02, 0x19, 0x11, 0x0b, 0x1a, 0x10, 0x19, 0x02, 0x19, 0x11, 0x02, 0x19, 0x11, 0x0b, 0x1a, 0x10, 0x19,
        0x02, 0x19, 0x21, 0x02, 0x19, 0x21, 0x0b, 0x1a, 0x10, 0x19, 0x02, 0x19, 0x11, 0x02, 0x19, 0x21, 0x0b, 0x1a,
        0x10, 0x19, 0x02, 0x19, 0x21, 0x02, 0x19, 0x02, 0x04, 0x06, 0x07, 0x0d, 0x19, 0x02, 0x04, 0x06, 0x07, 0x0d,
        0x07, 0x02, 0x04, 0x18, 0x0b, 0x07, 0x1d, 0x19, 0x02, 0x04, 0x18, 0x0b, 0x07, 0x1d, 0x07, 0x02, 0x04, 0x11,
        0x10, 0x05, 0x11, 0x19, 0x02, 0x04, 0x21, 0x10, 0x05, 0x11, 0x19, 0x02, 0x07, 0x03, 0x07, 0x02, 0x14, 0x05,
        0x04, 0x11, 0x0a, 0x14, 0x1f, 0x1c, 0x11, 0x07, 0x04, 0x21, 0x0a, 0x14, 0x1f, 0x1c, 0x11, 0x07, 0x04, 0x11,
        0x0a, 0x14, 0x1f, 0x1c, 0x11, 0x19, 0x04, 0x21, 0x0a, 0x14, 0x1f, 0x1c, 0x11, 0x19, 0x06, 0x19, 0x11, 0x06,
        0x19, 0x21, 0x06, 0x19, 0x11, 0x19, 0x1d, 0x17, 0x19, 0x1f, 0x02, 0x19, 0x20, 0x0e, 0x17, 0x10, 0x19, 0x0b,
        0x19, 0x1f, 0x1a, 0x23, 0x19, 0x0b, 0x07, 0x1d, 0x19, 0x0b, 0x07, 0x1d, 0x07, 0x0c, 0x14, 0x02, 0x19, 0x0c,
        0x14, 0x02, 0x07, 0x0c, 0x14, 0x03, 0x07, 0x0d, 0x19, 0x0d, 0x14, 0x14, 0x10, 0x19, 0x1f, 0x19, 0x0a, 0x17,
        0x19, 0x1f, 0x12, 0x14, 0x20, 0x1b, 0x21, 0x14, 0x11, 0x19, 0x0b, 0x19, 0x12, 0x0e, 0x02, 0x19, 0x11, 0x12,
        0x0e, 0x02, 0x19, 0x21, 0x12, 0x0e, 0x02, 0x19, 0x16, 0x04, 0x1f, 0x02, 0x07, 0x16, 0x04, 0x1f, 0x03, 0x07,
        0x16, 0x04, 0x1f, 0x0c, 0x04, 0x22, 0x14, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x07, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x1d, 0x00,
        0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00,
        0x36, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x46, 0x00,
        0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00,
        0x33, 0x00, 0x00, 0x00, 0x37, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x11, 0x00,
        0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00,
        0x32, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
        0x04, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00,
        0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00,
        0x31, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x06, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x24, 0x00,
        0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
        0x1d, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x2d, 0x00,
        0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00,
        0x2e, 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x23, 0x00,
        0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00,
        0x2f, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
        0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
        0x0e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x12, 0x00,
        0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00,
        0x63, 0x6f, 0x72, 0x00, 0x6c, 0x75, 0x67, 0x61, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x0f, 0x00,
        0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
        0x14, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x63, 0x6f, 0x72, 0x00, 0x6c, 0x75,
        0x67, 0x61, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x1d, 0x00,
        0x00, 0x00, 0x64, 0x65, 0x73, 0x6c, 0x69, 0x67, 0x75, 0x65, 0x4c, 0x75, 0x7a, 0x00, 0x6c, 0x69, 0x67, 0x75,
        0x65, 0x4c, 0x75, 0x7a, 0x00, 0x6d, 0x75, 0x64, 0x61, 0x43, 0x6f, 0x72, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00,
        0x1c, 0x00, 0x00, 0x00, 0xac, 0x02, 0x00, 0x00, 0x5c, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00,
        0x98, 0x01, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x02, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x05, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x38, 0x01,
        0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0xc8, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 0xc8, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x28, 0x01, 0x00, 0x00, 0x14, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x4c, 0x01, 0x00, 0x00, 0x38, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x64, 0x01, 0x00, 0x00, 0x88, 0x01, 0x00, 0x00, 0x4c, 0x01,
        0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x78, 0x01, 0x00, 0x00,
        0x64, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xac, 0x01, 0x00, 0x00, 0x98, 0x01,
        0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0xc8, 0x01, 0x00, 0x00,
        0x14, 0x02, 0x00, 0x00, 0x4c, 0x02, 0x00, 0x00, 0xac, 0x01, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xdc, 0x01, 0x00, 0x00, 0xc8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0xdc, 0x01, 0x00, 0x00, 0x0c, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x28, 0x02, 0x00, 0x00, 0x14, 0x02, 0x00, 0x00,
        0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x00, 0x00, 0x28, 0x02,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0x01, 0x00, 0x00,
        0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x60, 0x02, 0x00, 0x00, 0x4c, 0x02,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x78, 0x02, 0x00, 0x00,
        0x9c, 0x02, 0x00, 0x00, 0x60, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x8c, 0x02, 0x00, 0x00, 0x78, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x60, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00,
        0xcc, 0x02, 0x00, 0x00, 0xf0, 0x02, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00, 0x4c, 0x03, 0x00, 0x00, 0xac, 0x02,
        0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xe0, 0x02, 0x00, 0x00,
        0xcc, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0x02,
        0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x00,
        0xf0, 0x02, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x18, 0x03,
        0x00, 0x00, 0x04, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xac, 0x02, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x3c, 0x03,
        0x00, 0x00, 0x28, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xac, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x7c, 0x03, 0x00, 0x00,
        0xa0, 0x03, 0x00, 0x00, 0xd8, 0x03, 0x00, 0x00, 0xfc, 0x03, 0x00, 0x00, 0x5c, 0x03, 0x00, 0x00, 0x0d, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x90, 0x03, 0x00, 0x00, 0x7c, 0x03, 0x00, 0x00,
        0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x03, 0x00, 0x00, 0x04, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xb4, 0x03, 0x00, 0x00, 0xa0, 0x03, 0x00, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xc8, 0x03, 0x00, 0x00, 0xb4, 0x03,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x03, 0x00, 0x00,
        0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xec, 0x03, 0x00, 0x00, 0xd8, 0x03,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x03, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


#endif // PV_PARAMS_H

