
/*
    Copyright 2025 Picovoice Inc.

    You may not use this file except in compliance with the license. A copy of the license is located in the "LICENSE"
    file accompanying this source.

    Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
    specific language governing permissions and limitations under the License.
*/

#ifndef PV_PARAMS_H
#define PV_PARAMS_H

#include <stdint.h>

// wake-word = bonjour ordinateur 
static const uint8_t KEYWORD_ARRAY[] = {
        0x79, 0x4b, 0x1c, 0xe9, 0x97, 0xb5, 0x83, 0xe9, 0xd6, 0x0d, 0x47, 0xdb, 0xe2, 0x27, 0x0f, 0xb2, 0x50, 0x1d,
        0x95, 0xd6, 0x83, 0xe9, 0xb7, 0x89, 0x85, 0xa0, 0x72, 0x8f, 0xe1, 0x9d, 0x63, 0x73, 0x2a, 0xb5, 0x4a, 0xe0,
        0xc4, 0x2b, 0xba, 0xc2, 0x78, 0x94, 0x7a, 0xdb, 0x84, 0x4f, 0xc5, 0x3b, 0xc8, 0x29, 0x2e, 0x98, 0x3c, 0xd9,
        0x77, 0x0a, 0xb8, 0x1d, 0xd3, 0xd3, 0x4a, 0x8a, 0xa6, 0xc5, 0x55, 0x6a, 0x86, 0xce, 0x47, 0x11, 0x0a, 0x8b,
        0x1b, 0x26, 0x34, 0x63, 0x1d, 0x3a, 0x27, 0x83, 0xb8, 0x40, 0x9e, 0x1e, 0x5c, 0x04, 0x51, 0x81, 0x59, 0xe7,
        0x20, 0xab, 0x01, 0xb7, 0xa0, 0x80, 0x6b, 0x39, 0xed, 0xa1, 0xf7, 0xdb, 0xc8, 0xbe, 0x8a, 0xed, 0xa0, 0x5c,
        0xdb, 0x01, 0x00, 0x4c, 0x52, 0x4c, 0xd1, 0xc3, 0x61, 0xfb, 0x78, 0xcd, 0xb8, 0x02, 0x27, 0x62, 0x7d, 0x16,
        0x2d, 0xd9, 0x21, 0x04, 0x92, 0x75, 0x98, 0xe5, 0xb6, 0x01, 0xea, 0xe7, 0xbe, 0x9e, 0x45, 0x83, 0xaa, 0x4b,
        0x10, 0x44, 0x6b, 0x72, 0x1e, 0x5d, 0x9d, 0x6b, 0x43, 0x57, 0x12, 0x7e, 0x37, 0x6f, 0x2d, 0x5a, 0x1b, 0xae,
        0xae, 0x08, 0xcd, 0xd6, 0xf8, 0xda, 0x0b, 0x16, 0xce, 0x89, 0x09, 0xed, 0xa0, 0xbe, 0x2c, 0x8a, 0xb9, 0x6e,
        0x7d, 0x39, 0xe8, 0x9a, 0xcb, 0xc7, 0x52, 0x55, 0xe6, 0xc4, 0x7c, 0x5e, 0xdb, 0xc4, 0x8a, 0x72, 0x1d, 0x59,
        0x7c, 0x4c, 0x3f, 0xc4, 0x12, 0x15, 0xe9, 0x79, 0x98, 0xc0, 0x49, 0x41, 0x19, 0x56, 0x07, 0x44, 0x4a, 0x9f,
        0x44, 0x5b, 0xe5, 0x55, 0x65, 0xad, 0x11, 0x27, 0x63, 0x69, 0xb7, 0x53, 0xbb, 0xc2, 0xbd, 0xfb, 0xc9, 0xd1,
        0x5c, 0x6b, 0x1d, 0xd0, 0xdf, 0x4e, 0x03, 0x21, 0xd3, 0x57, 0x00, 0x87, 0x43, 0xe7, 0x02, 0x57, 0x6f, 0x69,
        0x32, 0x00, 0x54, 0x5a, 0x04, 0x1e, 0xc2, 0xae, 0x60, 0x9d, 0xf1, 0xde, 0x75, 0x57, 0xed, 0xcc, 0xf4, 0xbc,
        0xa0, 0xed, 0xa3, 0x5e, 0x80, 0x40, 0xaf, 0xa2, 0xba, 0x4d, 0xb4, 0xe3, 0x6a, 0x03, 0x67, 0x4f, 0x81, 0xd6,
        0x9d, 0xd3, 0x0d, 0xd8, 0x56, 0x9e, 0xd0, 0x3f, 0xc6, 0x24, 0x0f, 0x25, 0xf2, 0xa9, 0x8c, 0xda, 0x15, 0x55,
        0x7b, 0xb2, 0x8a, 0xb0, 0x1f, 0xd7, 0x9f, 0x26, 0xd7, 0x84, 0x5b, 0xaa, 0x2a, 0x7d, 0xef, 0x62, 0x9e, 0xad,
        0x4f, 0x40, 0xb8, 0x67, 0x4c, 0x92, 0x78, 0xb0, 0x80, 0xa7, 0x90, 0xe4, 0x7b, 0xa6, 0xa1, 0x9f, 0xed, 0x02,
        0xca, 0xb9, 0x40, 0x68, 0xef, 0x88, 0x71, 0xea, 0x9f, 0xdd, 0x79, 0xed, 0x11, 0xcd, 0xd4, 0x7c, 0x3a, 0x04,
        0x85, 0xfc, 0x8e, 0x8d, 0x95, 0xdd, 0x62, 0x0b, 0xbd, 0xc4, 0xb6, 0x2a, 0x14, 0xe0, 0x56, 0xeb, 0x0c, 0xd6,
        0x56, 0x14, 0xee, 0xfb, 0x34, 0x61, 0x32, 0x57, 0x43, 0xf0, 0x9c, 0xf5, 0xc0, 0x41, 0x3d, 0xbf, 0x24, 0x35,
        0xa4, 0xd8, 0x38, 0x1d, 0x66, 0x14, 0xf9, 0xb3, 0x14, 0x7e, 0x41, 0xad, 0xa8, 0xc6, 0xb9, 0xe1, 0x77, 0x6c,
        0x63, 0xef, 0x53, 0x8e, 0x06, 0xab, 0xb1, 0xe2, 0x7e, 0x28, 0x0a, 0xdb, 0x13, 0xee, 0x76, 0x93, 0x94, 0x0e,
        0x98, 0xbd, 0xfd, 0xac, 0xab, 0x65, 0xfe, 0x83, 0xe8, 0x90, 0x0a, 0xaf, 0xd6, 0xa6, 0xfc, 0x64, 0x7e, 0x4c,
        0x1b, 0x7c, 0x4f, 0xc0, 0x56, 0x03, 0x7d, 0x13, 0x7c, 0x7c, 0x21, 0x4e, 0xb5, 0x00, 0x42, 0x48, 0x13, 0x96,
        0xdd, 0xa7, 0x19, 0x3d, 0x67, 0x2a, 0x9f, 0x27, 0x54, 0x8f, 0x47, 0x3c, 0x0e, 0x05, 0x83, 0x16, 0x8d, 0x20,
        0x1a, 0x5d, 0x26, 0x66, 0xc2, 0xb4, 0x83, 0xb7, 0xcc, 0x86, 0x5b, 0xd9, 0x0c, 0x8a, 0xd9, 0xeb, 0x15, 0x2a,
        0x4a, 0x05, 0x67, 0xd5, 0x49, 0xb8, 0x1a, 0x3e, 0xae, 0x80, 0x17, 0x56, 0xab, 0x86, 0x99, 0x19, 0x27, 0xb9,
        0xb1, 0xc0, 0xf5, 0x0d, 0xf8, 0xb1, 0xe5, 0xff, 0x61, 0xcb, 0x72, 0xc5, 0x3e, 0xbb, 0xc7, 0xca, 0x76, 0x5c,
        0x72, 0x6e, 0x2e, 0xbf, 0x01, 0xe5, 0x5e, 0xd0, 0xf8, 0x62, 0x5e, 0x24, 0x01, 0xd6, 0x29, 0x86, 0xe8, 0xa9,
        0x78, 0xc2, 0x1f, 0x03, 0x54, 0x62, 0xa3, 0x51, 0x32, 0xdc, 0x31, 0x9d, 0x4b, 0xfd, 0xda, 0x09, 0xed, 0x30,
        0x12, 0xaf, 0x37, 0x55, 0x22, 0x49, 0x33, 0x77, 0xac, 0xd9, 0xb6, 0x07, 0x9b, 0xbb, 0x59, 0xc2, 0xe9, 0xb8,
        0x42, 0x62, 0xc7, 0x36, 0xa3, 0x91, 0x50, 0x92, 0x7d, 0xdc, 0x33, 0xeb, 0x07, 0xa9, 0x69, 0xfa, 0xe8, 0xb9,
        0xdd, 0x4a, 0xd1, 0x4c, 0xa4, 0xf7, 0xa5, 0xfa, 0x81, 0x64, 0x53, 0xd6, 0x2e, 0x60, 0xa2, 0xfd, 0xe3, 0x23,
        0xb8, 0xca, 0x8e, 0x8b, 0x63, 0x39, 0x21, 0x9d, 0x06, 0x0f, 0x9d, 0xe2, 0xfe, 0xec, 0xe0, 0x2e, 0xe7, 0x90,
        0x54, 0xbb, 0x3f, 0x68, 0xd1, 0xb9, 0xe1, 0x8d, 0xa2, 0x99, 0x2a, 0xc9
};

// context = éclairage_intelligent 
static const uint8_t CONTEXT_ARRAY[] = {
        0x72, 0x68, 0x69, 0x6e, 0x6f, 0x34, 0x2e, 0x30, 0x2e, 0x30, 0x00, 0x00, 0x00, 0x00, 0x66, 0x72, 0x00, 0x09,
        0x00, 0x00, 0x00, 0x70, 0x69, 0x63, 0x6f, 0x76, 0x6f, 0x69, 0x63, 0x65, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xc8, 0x0b, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x6f,
        0x6e, 0x74, 0x65, 0x78, 0x74, 0x3a, 0x0a, 0x20, 0x20, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
        0x6e, 0x73, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f, 0x6c, 0x6f,
        0x72, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x4d, 0x65, 0x74, 0x73, 0x2c,
        0x20, 0x4d, 0x65, 0x74, 0x74, 0x65, 0x7a, 0x2c, 0x20, 0x41, 0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x2c, 0x20, 0x41,
        0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x7a, 0x2c, 0x20, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2c, 0x20, 0x43, 0x68,
        0x61, 0x6e, 0x67, 0x65, 0x7a, 0x5d, 0x20, 0x5b, 0x6c, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x61, 0x5d, 0x20, 0x5b,
        0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72,
        0x65, 0x5d, 0x20, 0x28, 0x65, 0x6e, 0x29, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f, 0x6c,
        0x6f, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x4d, 0x65, 0x74, 0x73,
        0x2c, 0x20, 0x4d, 0x65, 0x74, 0x74, 0x65, 0x7a, 0x2c, 0x20, 0x41, 0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x2c, 0x20,
        0x41, 0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x7a, 0x2c, 0x20, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2c, 0x20, 0x43,
        0x68, 0x61, 0x6e, 0x67, 0x65, 0x7a, 0x5d, 0x20, 0x5b, 0x6c, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x61, 0x5d, 0x20,
        0x5b, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8,
        0x72, 0x65, 0x5d, 0x20, 0x5b, 0x64, 0x75, 0x2c, 0x20, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x2c, 0x20, 0x64, 0x61,
        0x6e, 0x73, 0x20, 0x6c, 0x61, 0x2c, 0x20, 0x64, 0x61, 0x6e, 0x73, 0x20, 0x6c, 0x65, 0x5d, 0x20, 0x24, 0x6c,
        0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x28,
        0x65, 0x6e, 0x29, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x22, 0x0a,
        0x20, 0x20, 0x20, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x74, 0x61,
        0x74, 0x65, 0x4f, 0x66, 0x66, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0xc3,
        0x89, 0x74, 0x65, 0x69, 0x6e, 0x73, 0x2c, 0x20, 0xc3, 0x89, 0x74, 0x65, 0x69, 0x67, 0x6e, 0x65, 0x7a, 0x5d,
        0x20, 0x5b, 0x6c, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x61, 0x5d, 0x20, 0x5b, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8,
        0x72, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x5d, 0x22, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0xc3, 0x89, 0x74, 0x65, 0x69, 0x6e, 0x73, 0x2c, 0x20, 0xc3,
        0x89, 0x74, 0x65, 0x69, 0x67, 0x6e, 0x65, 0x7a, 0x5d, 0x20, 0x5b, 0x6c, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x61,
        0x5d, 0x20, 0x5b, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x75, 0x6d, 0x69,
        0xc3, 0xa8, 0x72, 0x65, 0x5d, 0x20, 0x5b, 0x64, 0x75, 0x2c, 0x20, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x5d, 0x20,
        0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
        0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0xc3, 0x89, 0x74, 0x65, 0x69, 0x6e,
        0x73, 0x2c, 0x20, 0xc3, 0x89, 0x74, 0x65, 0x69, 0x67, 0x6e, 0x65, 0x7a, 0x5d, 0x20, 0x5b, 0x6c, 0x65, 0x73,
        0x2c, 0x20, 0x6c, 0x61, 0x5d, 0x20, 0x5b, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x73, 0x2c, 0x20,
        0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x5d, 0x20, 0x5b, 0x64, 0x61, 0x6e, 0x73, 0x20, 0x6c, 0x61,
        0x2c, 0x20, 0x64, 0x61, 0x6e, 0x73, 0x20, 0x6c, 0x65, 0x5d, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
        0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x63,
        0x68, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x3a,
        0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x41, 0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x2c,
        0x20, 0x41, 0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x7a, 0x5d, 0x20, 0x5b, 0x6c, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x61,
        0x5d, 0x20, 0x5b, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x75, 0x6d, 0x69,
        0xc3, 0xa8, 0x72, 0x65, 0x5d, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x41,
        0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x2c, 0x20, 0x41, 0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x7a, 0x5d, 0x20, 0x5b, 0x6c,
        0x65, 0x73, 0x2c, 0x20, 0x6c, 0x61, 0x5d, 0x20, 0x5b, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x73,
        0x2c, 0x20, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x5d, 0x20, 0x5b, 0x64, 0x75, 0x2c, 0x20, 0x64,
        0x65, 0x20, 0x6c, 0x61, 0x5d, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f,
        0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b,
        0x41, 0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x2c, 0x20, 0x41, 0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x7a, 0x5d, 0x20, 0x5b,
        0x6c, 0x65, 0x73, 0x2c, 0x20, 0x6c, 0x61, 0x5d, 0x20, 0x5b, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65,
        0x73, 0x2c, 0x20, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x5d, 0x20, 0x5b, 0x64, 0x61, 0x6e, 0x73,
        0x20, 0x6c, 0x61, 0x2c, 0x20, 0x64, 0x61, 0x6e, 0x73, 0x20, 0x6c, 0x65, 0x2c, 0x20, 0x64, 0x61, 0x6e, 0x73,
        0x20, 0x6c, 0x27, 0x5d, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63,
        0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x0a, 0x20, 0x20, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x3a, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x62,
        0x6c, 0x65, 0x75, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x76, 0x65, 0x72, 0x74, 0x0a, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x6f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x2d, 0x20, 0x72, 0x6f, 0x73, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x76,
        0x69, 0x6f, 0x6c, 0x65, 0x74, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x72, 0x6f, 0x75, 0x67,
        0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x62, 0x6c, 0x61, 0x6e, 0x63, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x6a, 0x61, 0x75, 0x6e, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x6c, 0x6f,
        0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x73, 0x61,
        0x6c, 0x6c, 0x65, 0x20, 0x64, 0x65, 0x20, 0x62, 0x61, 0x69, 0x6e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x2d, 0x20, 0x74, 0x6f, 0x69, 0x6c, 0x65, 0x74, 0x74, 0x65, 0x73, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x2d, 0x20, 0x63, 0x68, 0x61, 0x6d, 0x62, 0x72, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20,
        0x63, 0x68, 0x61, 0x6d, 0x62, 0x72, 0x65, 0x20, 0xc3, 0xa0, 0x20, 0x63, 0x6f, 0x75, 0x63, 0x68, 0x65, 0x72,
        0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x65, 0x0a,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x61, 0x72, 0x64, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x63, 0x6f, 0x75, 0x6c, 0x6f, 0x69, 0x72, 0x0a, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x2d, 0x20, 0x63, 0x75, 0x69, 0x73, 0x69, 0x6e, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x2d, 0x20, 0x73, 0x61, 0x6c, 0x6c, 0x65, 0x20, 0x64, 0x65, 0x20, 0x73, 0xc3, 0xa9, 0x6a, 0x6f, 0x75, 0x72,
        0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x73, 0x61, 0x6c, 0x6f, 0x6e, 0x0a, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x2d, 0x20, 0x67, 0x61, 0x72, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x6e, 0x67, 0x65, 0x72, 0x0a,
        0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
        0x15, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x3d, 0x00,
        0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00,
        0x64, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x72, 0x00, 0x00, 0x00, 0x75, 0x00, 0x00, 0x00, 0x78, 0x00,
        0x00, 0x00, 0x85, 0x00, 0x00, 0x00, 0x8b, 0x00, 0x00, 0x00, 0x8e, 0x00, 0x00, 0x00, 0x92, 0x00, 0x00, 0x00,
        0x9c, 0x00, 0x00, 0x00, 0xa5, 0x00, 0x00, 0x00, 0xaa, 0x00, 0x00, 0x00, 0xb1, 0x00, 0x00, 0x00, 0xb8, 0x00,
        0x00, 0x00, 0xc1, 0x00, 0x00, 0x00, 0xc9, 0x00, 0x00, 0x00, 0xce, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00,
        0xe2, 0x00, 0x00, 0x00, 0xf3, 0x00, 0x00, 0x00, 0xf9, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00, 0x08, 0x01,
        0x00, 0x00, 0x0f, 0x01, 0x00, 0x00, 0x19, 0x01, 0x00, 0x00, 0x21, 0x01, 0x00, 0x00, 0x41, 0x6c, 0x6c, 0x75,
        0x6d, 0x65, 0x7a, 0x00, 0x41, 0x6c, 0x6c, 0x75, 0x6d, 0x65, 0x00, 0x62, 0x6c, 0x61, 0x6e, 0x63, 0x00, 0x62,
        0x6c, 0x65, 0x75, 0x00, 0x63, 0x68, 0x61, 0x6d, 0x62, 0x72, 0x65, 0x20, 0xc3, 0xa0, 0x20, 0x63, 0x6f, 0x75,
        0x63, 0x68, 0x65, 0x72, 0x00, 0x63, 0x68, 0x61, 0x6d, 0x62, 0x72, 0x65, 0x00, 0x43, 0x68, 0x61, 0x6e, 0x67,
        0x65, 0x7a, 0x00, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x00, 0x63, 0x6f, 0x75, 0x6c, 0x6f, 0x69, 0x72, 0x00,
        0x63, 0x75, 0x69, 0x73, 0x69, 0x6e, 0x65, 0x00, 0x64, 0x61, 0x6e, 0x73, 0x20, 0x6c, 0x27, 0x00, 0x64, 0x61,
        0x6e, 0x73, 0x20, 0x6c, 0x61, 0x00, 0x64, 0x61, 0x6e, 0x73, 0x20, 0x6c, 0x65, 0x00, 0x64, 0x65, 0x20, 0x6c,
        0x61, 0x00, 0x64, 0x75, 0x00, 0x65, 0x6e, 0x00, 0x67, 0x61, 0x72, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x6e, 0x67,
        0x65, 0x72, 0x00, 0x6a, 0x61, 0x75, 0x6e, 0x65, 0x00, 0x6c, 0x61, 0x00, 0x6c, 0x65, 0x73, 0x00, 0x6c, 0x75,
        0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x73, 0x00, 0x6c, 0x75, 0x6d, 0x69, 0xc3, 0xa8, 0x72, 0x65, 0x00, 0x4d,
        0x65, 0x74, 0x73, 0x00, 0x4d, 0x65, 0x74, 0x74, 0x65, 0x7a, 0x00, 0x6f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x00,
        0x70, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x65, 0x00, 0x70, 0x6c, 0x61, 0x63, 0x61, 0x72, 0x64, 0x00, 0x72,
        0x6f, 0x73, 0x65, 0x00, 0x72, 0x6f, 0x75, 0x67, 0x65, 0x00, 0x73, 0x61, 0x6c, 0x6c, 0x65, 0x20, 0x64, 0x65,
        0x20, 0x62, 0x61, 0x69, 0x6e, 0x00, 0x73, 0x61, 0x6c, 0x6c, 0x65, 0x20, 0x64, 0x65, 0x20, 0x73, 0xc3, 0xa9,
        0x6a, 0x6f, 0x75, 0x72, 0x00, 0x73, 0x61, 0x6c, 0x6f, 0x6e, 0x00, 0x74, 0x6f, 0x69, 0x6c, 0x65, 0x74, 0x74,
        0x65, 0x73, 0x00, 0x76, 0x65, 0x72, 0x74, 0x00, 0x76, 0x69, 0x6f, 0x6c, 0x65, 0x74, 0x00, 0xc3, 0x89, 0x74,
        0x65, 0x69, 0x67, 0x6e, 0x65, 0x7a, 0x00, 0xc3, 0x89, 0x74, 0x65, 0x69, 0x6e, 0x73, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00,
        0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x09, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00,
        0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
        0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x16, 0x00,
        0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00,
        0x1b, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00,
        0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00,
        0x24, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09, 0x00,
        0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00,
        0x22, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00,
        0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00,
        0x44, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x53, 0x00,
        0x00, 0x00, 0x59, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00,
        0x69, 0x00, 0x00, 0x00, 0x6e, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x7a, 0x00,
        0x00, 0x00, 0x81, 0x00, 0x00, 0x00, 0x8b, 0x00, 0x00, 0x00, 0x8f, 0x00, 0x00, 0x00, 0x95, 0x00, 0x00, 0x00,
        0x98, 0x00, 0x00, 0x00, 0x9d, 0x00, 0x00, 0x00, 0xa2, 0x00, 0x00, 0x00, 0xa5, 0x00, 0x00, 0x00, 0x01, 0x0b,
        0x16, 0x0c, 0x05, 0x01, 0x0b, 0x16, 0x0c, 0x03, 0x0b, 0x02, 0x03, 0x0b, 0x18, 0x23, 0x02, 0x03, 0x22, 0x1d,
        0x01, 0x0a, 0x13, 0x23, 0x05, 0x23, 0x02, 0x03, 0x22, 0x1d, 0x23, 0x02, 0x24, 0x05, 0x23, 0x02, 0x24, 0x0a,
        0x13, 0x0b, 0x15, 0x01, 0x22, 0x0a, 0x20, 0x08, 0x17, 0x08, 0x0d, 0x04, 0x02, 0x0b, 0x1a, 0x04, 0x02, 0x0b,
        0x01, 0x04, 0x02, 0x0b, 0x1a, 0x04, 0x1a, 0x0b, 0x01, 0x04, 0x16, 0x02, 0x07, 0x01, 0x22, 0x04, 0x0c, 0x02,
        0x24, 0x05, 0x24, 0x0e, 0x0d, 0x0b, 0x01, 0x0b, 0x05, 0x0b, 0x16, 0x0c, 0x09, 0x1e, 0x22, 0x0b, 0x16, 0x0c,
        0x09, 0x1e, 0x22, 0x0c, 0x1e, 0x0c, 0x05, 0x12, 0x05, 0x1c, 0x22, 0x02, 0x24, 0x10, 0x02, 0x04, 0x22, 0x08,
        0x10, 0x0b, 0x01, 0x0a, 0x01, 0x22, 0x22, 0x0e, 0x17, 0x22, 0x13, 0x24, 0x11, 0x01, 0x0b, 0x04, 0x1a, 0x03,
        0x1f, 0x11, 0x01, 0x0b, 0x04, 0x1a, 0x11, 0x05, 0x24, 0x13, 0x22, 0x11, 0x01, 0x0b, 0x0f, 0x12, 0x15, 0x01,
        0x0b, 0x1e, 0x12, 0x14, 0x1e, 0x22, 0x14, 0x09, 0x1c, 0x0b, 0x1e, 0x05, 0x12, 0x05, 0x21, 0x05, 0x05, 0x12,
        0x1f, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x13, 0x00,
        0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
        0x25, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00,
        0x1c, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00,
        0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00,
        0x1a, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x20, 0x00,
        0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x07, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x0e, 0x00,
        0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00,
        0x23, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0f, 0x00,
        0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
        0x14, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x63, 0x6f,
        0x6c, 0x6f, 0x72, 0x00, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x10, 0x00,
        0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
        0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x00,
        0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x33, 0x00,
        0x00, 0x00, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x00, 0x63, 0x68, 0x61, 0x6e,
        0x67, 0x65, 0x4c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x00, 0x63, 0x68,
        0x61, 0x6e, 0x67, 0x65, 0x4c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00,
        0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0xf4, 0x00, 0x00, 0x00, 0x54, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x1c, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00,
        0x30, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x60, 0x00,
        0x00, 0x00, 0x84, 0x00, 0x00, 0x00, 0x94, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xa8, 0x00, 0x00, 0x00, 0x94, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0xe4, 0x00, 0x00, 0x00, 0xa8, 0x00,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00,
        0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x09, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0xf4, 0x00,
        0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x1c, 0x01, 0x00, 0x00,
        0x08, 0x01, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x30, 0x01,
        0x00, 0x00, 0x1c, 0x01, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0x44, 0x01, 0x00, 0x00, 0x30, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0x68, 0x01, 0x00, 0x00, 0x54, 0x01, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x7c, 0x01, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x90, 0x01, 0x00, 0x00, 0x7c, 0x01, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xa4, 0x01, 0x00, 0x00, 0x90, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


#endif // PV_PARAMS_H

